/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.panel;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDColorChooser;
import com.kingdee.bos.ctrl.swing.KDFontChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.chart.panel.NumberAxisPropertyEditPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.FontDisplayField;
import org.jfree.ui.InsetsChooserPanel;
import org.jfree.ui.InsetsTextField;
import org.jfree.ui.PaintSample;

public class AxisPropertyEditPanel
extends KDPanel
implements ActionListener {
    public static final long serialVersionUID = 1001001001L;
    private JTextField label;
    private Font labelFont;
    private PaintSample labelPaintSample;
    private JTextField labelFontField;
    private Font tickLabelFont;
    private JTextField tickLabelFontField;
    private PaintSample tickLabelPaintSample;
    private KDPanel slot1;
    private KDPanel slot2;
    private KDCheckBox showTickLabelsCheckBox;
    private KDCheckBox showTickMarksCheckBox;
    private InsetsTextField tickLabelInsetsTextField;
    private InsetsTextField labelInsetsTextField;
    private Insets tickLabelInsets;
    private Insets labelInsets;
    private KDTabbedPane otherTabs;

    public static AxisPropertyEditPanel getInstance(Axis axis) {
        if (axis != null) {
            if (axis instanceof NumberAxis) {
                return new NumberAxisPropertyEditPanel((NumberAxis)axis);
            }
            return new AxisPropertyEditPanel(axis);
        }
        return null;
    }

    public AxisPropertyEditPanel(Axis axis) {
        this.labelFont = axis.getLabelFont();
        this.labelPaintSample = new PaintSample(axis.getLabelPaint());
        this.tickLabelFont = axis.getTickLabelFont();
        this.tickLabelPaintSample = new PaintSample(axis.getTickLabelPaint());
        this.tickLabelInsets = axis.getTickLabelInsets();
        this.labelInsets = axis.getLabelInsets();
        this.setLayout(new BorderLayout());
        KDPanel general = new KDPanel((LayoutManager)new BorderLayout());
        general.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LanguageManager.getLangMessage((String)"General", AxisPropertyEditPanel.class, (String)"General")));
        KDPanel interior = new KDPanel((LayoutManager)new LCBLayout(5));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Label", AxisPropertyEditPanel.class, (String)"Label")));
        this.label = new JTextField(axis.getLabel());
        interior.add((Component)this.label);
        interior.add((Component)new KDPanel());
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Font", AxisPropertyEditPanel.class, (String)"Font")));
        this.labelFontField = new FontDisplayField(this.labelFont);
        interior.add((Component)this.labelFontField);
        KDButton b = new KDButton(LanguageManager.getLangMessage((String)"Select...", AxisPropertyEditPanel.class, (String)"Select..."));
        b.setActionCommand("SelectLabelFont");
        b.addActionListener((ActionListener)this);
        interior.add((Component)b);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Paint", AxisPropertyEditPanel.class, (String)"Paint")));
        interior.add((Component)this.labelPaintSample);
        b = new KDButton(LanguageManager.getLangMessage((String)"Select...", AxisPropertyEditPanel.class, (String)"Select..."));
        b.setActionCommand("SelectLabelPaint");
        b.addActionListener((ActionListener)this);
        interior.add((Component)b);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Label_Insets", AxisPropertyEditPanel.class, (String)"Label Insets")));
        b = new KDButton(LanguageManager.getLangMessage((String)"Edit...", AxisPropertyEditPanel.class, (String)"Edit..."));
        b.setActionCommand("LabelInsets");
        b.addActionListener((ActionListener)this);
        this.labelInsetsTextField = new InsetsTextField(this.labelInsets);
        interior.add((Component)this.labelInsetsTextField);
        interior.add((Component)b);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Tick_Label_Insets", AxisPropertyEditPanel.class, (String)"Tick Label Insets")));
        b = new KDButton(LanguageManager.getLangMessage((String)"Edit...", AxisPropertyEditPanel.class, (String)"Edit..."));
        b.setActionCommand("TickLabelInsets");
        b.addActionListener((ActionListener)this);
        this.tickLabelInsetsTextField = new InsetsTextField(this.tickLabelInsets);
        interior.add((Component)this.tickLabelInsetsTextField);
        interior.add((Component)b);
        general.add((Component)interior);
        this.add((Component)general, "North");
        this.slot1 = new KDPanel((LayoutManager)new BorderLayout());
        KDPanel other = new KDPanel((LayoutManager)new BorderLayout());
        other.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LanguageManager.getLangMessage((String)"Other", AxisPropertyEditPanel.class, (String)"Other")));
        this.otherTabs = new KDTabbedPane();
        this.otherTabs.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        KDPanel ticks = new KDPanel((LayoutManager)new LCBLayout(3));
        ticks.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.showTickLabelsCheckBox = new KDCheckBox(LanguageManager.getLangMessage((String)"Show_tick_labels", AxisPropertyEditPanel.class, (String)"Show tick labels"), axis.isTickLabelsVisible());
        ticks.add((Component)this.showTickLabelsCheckBox);
        ticks.add((Component)new KDPanel());
        ticks.add((Component)new KDPanel());
        ticks.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Tick_label_font", AxisPropertyEditPanel.class, (String)"Tick label font")));
        this.tickLabelFontField = new FontDisplayField(this.tickLabelFont);
        ticks.add((Component)this.tickLabelFontField);
        b = new KDButton(LanguageManager.getLangMessage((String)"Select...", AxisPropertyEditPanel.class, (String)"Select..."));
        b.setActionCommand("SelectTickLabelFont");
        b.addActionListener((ActionListener)this);
        ticks.add((Component)b);
        this.showTickMarksCheckBox = new KDCheckBox(LanguageManager.getLangMessage((String)"Show_tick_marks", AxisPropertyEditPanel.class, (String)"Show tick marks"), axis.isTickMarksVisible());
        ticks.add((Component)this.showTickMarksCheckBox);
        ticks.add((Component)new KDPanel());
        ticks.add((Component)new KDPanel());
        this.otherTabs.add(LanguageManager.getLangMessage((String)"Ticks", AxisPropertyEditPanel.class, (String)"Ticks"), (Component)ticks);
        other.add((Component)this.otherTabs);
        this.slot1.add((Component)other);
        this.slot2 = new KDPanel((LayoutManager)new BorderLayout());
        this.slot2.add((Component)this.slot1, (Object)"North");
        this.add((Component)this.slot2);
    }

    public String getLabel() {
        return this.label.getText();
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Paint getLabelPaint() {
        return this.labelPaintSample.getPaint();
    }

    public boolean isTickLabelsVisible() {
        return this.showTickLabelsCheckBox.isSelected();
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaintSample.getPaint();
    }

    public boolean isTickMarksVisible() {
        return this.showTickMarksCheckBox.isSelected();
    }

    public Insets getTickLabelInsets() {
        return this.tickLabelInsets == null ? new Insets(0, 0, 0, 0) : this.tickLabelInsets;
    }

    public Insets getLabelInsets() {
        return this.labelInsets == null ? new Insets(0, 0, 0, 0) : this.labelInsets;
    }

    public KDTabbedPane getOtherTabs() {
        return this.otherTabs;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("SelectLabelFont")) {
            this.attemptLabelFontSelection();
        } else if (command.equals("SelectLabelPaint")) {
            this.attemptModifyLabelPaint();
        } else if (command.equals("SelectTickLabelFont")) {
            this.attemptTickLabelFontSelection();
        } else if (command.equals("LabelInsets")) {
            this.editLabelInsets();
        } else if (command.equals("TickLabelInsets")) {
            this.editTickLabelInsets();
        }
    }

    private void attemptLabelFontSelection() {
        KDFontChooser panel = new KDFontChooser(this.labelFont, 2);
        int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)panel, (String)LanguageManager.getLangMessage((String)"Font_Selection", AxisPropertyEditPanel.class, (String)"Font Selection"), (int)2, (int)-1);
        if (result == 0) {
            this.labelFont = panel.getSelectionFont();
            this.labelFontField.setText(this.labelFont.getFontName() + " " + this.labelFont.getSize());
        }
    }

    private void attemptModifyLabelPaint() {
        Color c = KDColorChooser.showDialog((Component)((Object)this), (String)LanguageManager.getLangMessage((String)"Label_Color", AxisPropertyEditPanel.class, (String)"Label Color"), (Color)Color.blue);
        if (c != null) {
            this.labelPaintSample.setPaint((Paint)c);
        }
    }

    public void attemptTickLabelFontSelection() {
        KDFontChooser panel = new KDFontChooser(this.tickLabelFont, 2);
        int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)panel, (String)LanguageManager.getLangMessage((String)"Font_Selection", AxisPropertyEditPanel.class, (String)"Font Selection"), (int)2, (int)-1);
        if (result == 0) {
            this.tickLabelFont = panel.getSelectionFont();
            this.tickLabelFontField.setText(this.tickLabelFont.getFontName() + " " + this.tickLabelFont.getSize());
        }
    }

    private void editTickLabelInsets() {
        InsetsChooserPanel panel = new InsetsChooserPanel(this.tickLabelInsets);
        int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)panel, (String)LanguageManager.getLangMessage((String)"Edit_Insets", AxisPropertyEditPanel.class, (String)"Edit Insets"), (int)-1);
        if (result == 0) {
            this.tickLabelInsets = panel.getInsets();
            this.tickLabelInsetsTextField.setInsets(this.tickLabelInsets);
        }
    }

    private void editLabelInsets() {
        InsetsChooserPanel panel = new InsetsChooserPanel(this.labelInsets);
        int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)panel, (String)LanguageManager.getLangMessage((String)"Edit_Insets", AxisPropertyEditPanel.class, (String)"Edit Insets"), (int)-1);
        if (result == 0) {
            this.labelInsets = panel.getInsets();
            this.labelInsetsTextField.setInsets(this.labelInsets);
        }
    }

    public void setAxisProperties(Axis axis) {
        axis.setLabel(this.getLabel());
        axis.setLabelFont(this.getLabelFont());
        axis.setLabelPaint(this.getLabelPaint());
        axis.setTickMarksVisible(this.isTickMarksVisible());
        axis.setTickLabelsVisible(this.isTickLabelsVisible());
        axis.setTickLabelFont(this.getTickLabelFont());
        axis.setTickLabelPaint(this.getTickLabelPaint());
        axis.setTickLabelInsets(this.getTickLabelInsets());
        axis.setLabelInsets(this.getLabelInsets());
    }
}

