/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Dataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.DatasetUtilities;
import org.jfree.util.PaintList;
import org.jfree.util.Rotation;
import org.jfree.util.StrokeList;

public class RadarPlot
extends Plot
implements Cloneable,
Serializable {
    public static final int DEFAULT_CALIBRATION_DENSITY = 5;
    public static final double DEFAULT_HEAD = 0.02;
    public static final double DEFAULT_INTERIOR_GAP = 0.25;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final Shape DEFAULT_LEGEND_ITEM_CIRCLE = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final double DEFAULT_AXIS_LABEL_GAP = 0.1;
    public static final double DEFAULT_MAX_STD = 0.9;
    public static final double DEFAULT_MIN_STD = 0.1;
    public static final Stroke DEFAULT_RANGE_STROKE = new BasicStroke(1.0f);
    public static final int RANGE_STYLE_CIRCLE = 0;
    public static final int RANGE_STYLE_POLYGON = 1;
    public static final double MAX_INTERIOR_GAP = 0.4;
    protected double headPercent;
    private double interiorGap;
    private CategoryDataset dataset;
    private Rotation direction;
    private double startAngle;
    private Font labelFont;
    private transient Paint labelPaint;
    private CategoryItemLabelGenerator labelGenerator;
    private CategoryURLGenerator urlGenerator;
    private boolean webFilled;
    private transient Paint axisLinePaint;
    private transient Stroke axisLineStroke;
    private transient Stroke rangeStroke;
    private transient Paint seriesPaint;
    private PaintList seriesPaintList;
    private transient Paint baseSeriesPaint;
    private transient Paint seriesOutlinePaint;
    private PaintList seriesOutlinePaintList;
    private transient Paint baseSeriesOutlinePaint;
    private transient Stroke seriesOutlineStroke;
    private StrokeList seriesOutlineStrokeList;
    private transient Stroke baseSeriesOutlineStroke;
    private double axisLabelGap;
    private transient Shape legendItemShape;
    private boolean rangeDrawn;
    private int calibrationDensity;
    private int rangeStyle;
    private double max_range_std;
    private double min_range_std;
    private Hashtable formattedCategorySet;

    public RadarPlot() {
        this(null);
    }

    public RadarPlot(CategoryDataset data) {
        this.dataset = data;
        if (this.dataset != null) {
            this.dataset.addChangeListener((DatasetChangeListener)this);
        }
        this.initialize();
    }

    private void initialize() {
        this.headPercent = 0.02;
        this.startAngle = 90.0;
        this.axisLinePaint = Color.black;
        this.axisLinePaint = Color.black;
        this.axisLineStroke = new BasicStroke(1.0f);
        this.axisLabelGap = 0.1;
        this.interiorGap = 0.25;
        this.startAngle = 90.0;
        this.direction = Rotation.CLOCKWISE;
        this.rangeStroke = DEFAULT_RANGE_STROKE;
        this.seriesPaint = null;
        this.seriesPaintList = new PaintList();
        this.baseSeriesPaint = null;
        this.seriesOutlinePaint = null;
        this.seriesOutlinePaintList = new PaintList();
        this.baseSeriesOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.seriesOutlineStroke = null;
        this.seriesOutlineStrokeList = new StrokeList();
        this.baseSeriesOutlineStroke = DEFAULT_OUTLINE_STROKE;
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelPaint = DEFAULT_LABEL_PAINT;
        this.labelGenerator = new RadarItemLabelGenerator();
        this.legendItemShape = DEFAULT_LEGEND_ITEM_CIRCLE;
        this.calibrationDensity = 5;
        this.rangeDrawn = true;
        this.webFilled = true;
        this.max_range_std = 0.9;
        this.min_range_std = 0.1;
        this.rangeStyle = 0;
        this.formattedCategorySet = new Hashtable();
    }

    public double getStandardMaxRange() {
        return this.max_range_std;
    }

    public void setStandardMaxRange(double range) {
        if (range < 0.0 || range > 1.0) {
            throw new IllegalArgumentException("'range' argument has to be between 0 and 1.");
        }
        this.max_range_std = range;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public double getStandardMinRange() {
        return this.min_range_std;
    }

    public void setStandardMinRange(double range) {
        if (range < 0.0 || range > 1.0) {
            throw new IllegalArgumentException("'range' argument has to be between 0 and 1.");
        }
        this.min_range_std = range;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public int getRangeStyle() {
        return this.rangeStyle;
    }

    public void setRangeStyle(int style) {
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException("'style' argument has to be RANGE_STYLE_CIRCLE or RANGE_STYLE_BROKEN_LINE.");
        }
        this.rangeStyle = style;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset dataset) {
        if (this.dataset != null) {
            this.dataset.removeChangeListener((DatasetChangeListener)this);
        }
        this.dataset = dataset;
        if (dataset != null) {
            this.setDatasetGroup(dataset.getGroup());
            dataset.addChangeListener((DatasetChangeListener)this);
        }
        this.datasetChanged(new DatasetChangeEvent((Object)this, (Dataset)dataset));
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.legendItemShape = shape;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaint = paint;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    protected String formatCategoryItemValue(Format format, int category, String value) {
        return ((NumberFormat)format).format(Double.parseDouble(value));
    }

    public boolean isCategoryItemValueFormatting(int category) {
        return this.formattedCategorySet.containsKey(new Integer(category));
    }

    public void setCategoryItemValueFormat(int category, Format format) {
        this.formattedCategorySet.put(new Integer(category), format);
    }

    public Format getCategoryItemValueFormat(int category) {
        return (Format)this.formattedCategorySet.get(new Integer(category));
    }

    public CategoryItemLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(CategoryItemLabelGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.labelGenerator = generator;
    }

    public CategoryURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(CategoryURLGenerator generator) {
        this.urlGenerator = generator;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public boolean isWebFilled() {
        return this.webFilled;
    }

    public void setWebFilled(boolean flag) {
        this.webFilled = flag;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public boolean isRangeDrawn() {
        return this.rangeDrawn;
    }

    public void setRangeDrawn(boolean flag) {
        this.rangeDrawn = flag;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double angle) {
        this.startAngle = angle;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public int getCalibrationDensity() {
        return this.calibrationDensity;
    }

    public void setCalibrationDensity(int d) {
        if (d < 2) {
            throw new IllegalArgumentException("argument can't be less than 2");
        }
        this.calibrationDensity = d;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public double getAxisLabelGap() {
        return this.axisLabelGap;
    }

    public void setAxisLabelGap(double gap) {
        this.axisLabelGap = gap;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Paint getAxisLinePaint() {
        return this.axisLinePaint;
    }

    public void setAxisLinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.axisLinePaint = paint;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double percent) {
        if (percent < 0.0 || percent > 0.4) {
            throw new IllegalArgumentException("Percentage outside valid range.");
        }
        if (this.interiorGap != percent) {
            this.interiorGap = percent;
            this.notifyListeners(new PlotChangeEvent((Plot)this));
        }
    }

    public Stroke getAxisLineStroke() {
        return this.axisLineStroke;
    }

    public void setAxisLineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.axisLineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Stroke getRangeStroke() {
        return this.rangeStroke;
    }

    public void setRangeStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeStroke = stroke;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Paint getSeriesPaint() {
        return this.seriesPaint;
    }

    public void setSeriesPaint(Paint paint) {
        this.seriesPaint = paint;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Paint getSeriesPaint(int series) {
        if (this.seriesPaint != null) {
            return this.seriesPaint;
        }
        Paint result = this.seriesPaintList.getPaint(series);
        if (result == null) {
            DrawingSupplier supplier = this.getDrawingSupplier();
            if (supplier != null) {
                Paint p = supplier.getNextPaint();
                this.seriesPaintList.setPaint(series, p);
                result = p;
            } else {
                result = this.baseSeriesPaint;
            }
        }
        return result;
    }

    public void setSeriesPaint(int series, Paint paint) {
        this.seriesPaintList.setPaint(series, paint);
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Paint getBaseSeriesPaint() {
        return this.baseSeriesPaint;
    }

    public void setBaseSeriesPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSeriesPaint = paint;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Paint getSeriesOutlinePaint() {
        return this.seriesOutlinePaint;
    }

    public void setSeriesOutlinePaint(Paint paint) {
        this.seriesOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Paint getSeriesOutlinePaint(int series) {
        if (this.seriesOutlinePaint != null) {
            return this.seriesOutlinePaint;
        }
        Paint result = this.seriesOutlinePaintList.getPaint(series);
        if (result == null) {
            result = this.baseSeriesOutlinePaint;
        }
        return result;
    }

    public void setSeriesOutlinePaint(int series, Paint paint) {
        this.seriesOutlinePaintList.setPaint(series, paint);
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Paint getBaseSeriesOutlinePaint() {
        return this.baseSeriesOutlinePaint;
    }

    public void setBaseSeriesOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSeriesOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Stroke getSeriesOutlineStroke() {
        return this.seriesOutlineStroke;
    }

    public void setSeriesOutlineStroke(Stroke stroke) {
        this.seriesOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Stroke getSeriesOutlineStroke(int series) {
        if (this.seriesOutlineStroke != null) {
            return this.seriesOutlineStroke;
        }
        Stroke result = this.seriesOutlineStrokeList.getStroke(series);
        if (result == null) {
            result = this.baseSeriesOutlineStroke;
        }
        return result;
    }

    public void setSeriesOutlineStroke(int series, Stroke stroke) {
        this.seriesOutlineStrokeList.setStroke(series, stroke);
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Stroke getBaseSeriesOutlineStroke() {
        return this.baseSeriesOutlineStroke;
    }

    public void setBaseSeriesOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.baseSeriesOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public double getHeadPercent() {
        return this.headPercent;
    }

    public void setHeadPercent(double percent) {
        this.headPercent = percent;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Null 'direction' argument.");
        }
        this.direction = direction;
        this.notifyListeners(new PlotChangeEvent((Plot)this));
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        List keys = null;
        keys = this.dataset.getRowKeys();
        if (keys != null) {
            int series = 0;
            Iterator iterator = keys.iterator();
            Shape shape = this.getLegendItemShape();
            while (iterator.hasNext()) {
                String label;
                String description = label = iterator.next().toString();
                Paint paint = this.getSeriesPaint(series);
                Paint outlinePaint = this.getSeriesOutlinePaint(series);
                Stroke stroke = this.getSeriesOutlineStroke(series);
                LegendItem item = new LegendItem(label, description, shape, paint, outlinePaint, stroke);
                result.add(item);
                ++series;
            }
        }
        return result;
    }

    protected Point2D getWebPoint(Rectangle2D bounds, double angle, double length) {
        double angrad = Math.toRadians(angle);
        double x = Math.cos(angrad) * length * bounds.getWidth() / 2.0;
        double y = -Math.sin(angrad) * length * bounds.getHeight() / 2.0;
        return new Point2D.Double(bounds.getX() + x + bounds.getWidth() / 2.0, bounds.getY() + y + bounds.getHeight() / 2.0);
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, PlotState parentState, PlotRenderingInfo info) {
        Insets insets = this.getInsets();
        if (insets != null) {
            plotArea.setRect(plotArea.getX() + (double)insets.left, plotArea.getY() + (double)insets.top, plotArea.getWidth() - (double)insets.left - (double)insets.right, plotArea.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        if (info != null) {
            info.setPlotArea(plotArea);
            info.setDataArea(plotArea);
        }
        this.drawBackground(g2, plotArea);
        this.drawOutline(g2, plotArea);
        Shape savedClip = g2.getClip();
        g2.clip(plotArea);
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (!DatasetUtilities.isEmptyOrNull((CategoryDataset)this.dataset)) {
            int seriesCount = 0;
            int catCount = 0;
            seriesCount = this.dataset.getRowCount();
            catCount = this.dataset.getColumnCount();
            double gapHorizontal = plotArea.getWidth() * this.getInteriorGap();
            double gapVertical = plotArea.getHeight() * this.getInteriorGap();
            double X = plotArea.getX() + gapHorizontal / 2.0;
            double Y = plotArea.getY() + gapVertical / 2.0;
            double W = plotArea.getWidth() - gapHorizontal;
            double H = plotArea.getHeight() - gapVertical;
            double min = Math.min(W, H) / 2.0;
            X = (X + X + W) / 2.0 - min;
            Y = (Y + Y + H) / 2.0 - min;
            W = 2.0 * min;
            H = 2.0 * min;
            Point2D.Double centre = new Point2D.Double(X + W / 2.0, Y + H / 2.0);
            Rectangle2D.Double maxRect = new Rectangle2D.Double((int)(X + W / 2.0 * (1.0 - this.max_range_std)), (int)(Y + H / 2.0 * (1.0 - this.max_range_std)), (int)(W * this.max_range_std), (int)(H * this.max_range_std));
            Rectangle2D.Double minRect = new Rectangle2D.Double((int)(X + W / 2.0 * (1.0 - this.min_range_std)), (int)(Y + H / 2.0 * (1.0 - this.min_range_std)), (int)(W * this.min_range_std), (int)(H * this.min_range_std));
            Rectangle2D.Double radarArea = new Rectangle2D.Double(X, Y, W, H);
            double headW = ((RectangularShape)radarArea).getWidth() * this.headPercent;
            double headH = ((RectangularShape)radarArea).getHeight() * this.headPercent;
            Polygon maxPoly = new Polygon();
            Polygon minPoly = new Polygon();
            double multiple = this.getDirection().getFactor() * 360.0 / (double)catCount;
            for (int cat = 0; cat < catCount; ++cat) {
                double angle = this.getStartAngle() + multiple * (double)cat;
                Point2D endPoint = this.getWebPoint(radarArea, angle, 1.0);
                Line2D.Double line = new Line2D.Double(centre, endPoint);
                g2.setPaint(this.axisLinePaint);
                g2.setStroke(this.axisLineStroke);
                g2.draw(line);
                this.drawLabel(g2, radarArea, 0.0, cat, angle, 360.0 / (double)catCount);
                Point2D maxRangeNode = this.getWebPoint(radarArea, angle, this.max_range_std);
                Point2D minRangeNode = this.getWebPoint(radarArea, angle, this.min_range_std);
                int part = this.getCalibrationDensity();
                for (int i = 1; i < part; ++i) {
                    int r = (int)((this.min_range_std + (this.max_range_std - this.min_range_std) / (double)part * (double)i) * W / 2.0);
                    Point2D.Double leftCorner = new Point2D.Double(X + W / 2.0 - (double)r, Y + H / 2.0 - (double)r);
                    g2.drawArc((int)((Point2D)leftCorner).getX(), (int)((Point2D)leftCorner).getY(), r * 2, r * 2, (int)angle - 1, 2);
                }
                this.drawLabelForNode(g2, minRect, cat, 0, angle, info, minRangeNode);
                this.drawLabelForNode(g2, maxRect, cat, 1, angle, info, maxRangeNode);
                maxPoly.addPoint((int)maxRangeNode.getX(), (int)maxRangeNode.getY());
                minPoly.addPoint((int)minRangeNode.getX(), (int)minRangeNode.getY());
            }
            if (this.rangeStyle == 0) {
                g2.setStroke(this.rangeStroke);
                g2.setPaint(this.getSeriesPaint(0));
                g2.drawOval((int)((RectangularShape)minRect).getX(), (int)((RectangularShape)minRect).getY(), (int)((RectangularShape)minRect).getWidth(), (int)((RectangularShape)minRect).getHeight());
                g2.setPaint(this.getSeriesPaint(1));
                g2.drawOval((int)((RectangularShape)maxRect).getX(), (int)((RectangularShape)maxRect).getY(), (int)((RectangularShape)maxRect).getWidth(), (int)((RectangularShape)maxRect).getHeight());
            } else if (this.rangeStyle == 1) {
                g2.setStroke(new BasicStroke(1.0f));
                g2.setPaint(this.getSeriesPaint(0));
                g2.drawPolygon(minPoly);
                g2.setPaint(this.getSeriesPaint(1));
                g2.drawPolygon(maxPoly);
            }
            for (int series = 2; series < seriesCount; ++series) {
                this.drawRadarPoly(g2, radarArea, centre, info, series, catCount, headH, headW);
            }
        } else {
            this.drawNoDataMessage(g2, plotArea);
        }
        g2.setClip(savedClip);
        g2.setComposite(originalComposite);
        this.drawOutline(g2, plotArea);
    }

    protected void drawLabel(Graphics2D g2, Rectangle2D plotArea, double value, int cat, double startAngle, double extent) {
        FontRenderContext frc = g2.getFontRenderContext();
        String label = this.dataset.getColumnKey(cat).toString();
        Rectangle2D labelBounds = this.getLabelFont().getStringBounds(label, frc);
        LineMetrics lm = this.getLabelFont().getLineMetrics(label, frc);
        double ascent = lm.getAscent();
        Point2D labelLocation = this.calculateLabelLocation(labelBounds, ascent, plotArea, startAngle);
        Composite saveComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setPaint(this.getLabelPaint());
        g2.setFont(this.getLabelFont());
        g2.drawString(label, (float)labelLocation.getX(), (float)labelLocation.getY());
        g2.setComposite(saveComposite);
    }

    protected void drawLabelForNode(Graphics2D g2, Rectangle2D plotArea, int cat, int series, double angle, PlotRenderingInfo info, Point2D point) {
        Format format;
        FontRenderContext frc = g2.getFontRenderContext();
        double stretch = 5.0;
        Rectangle2D area = (Rectangle2D)plotArea.clone();
        area.setRect(plotArea.getX() + stretch, plotArea.getY() + stretch, plotArea.getWidth() - 2.0 * stretch, plotArea.getHeight() - 2.0 * stretch);
        String label = this.labelGenerator.generateItemLabel(this.dataset, series, cat);
        if (this.isCategoryItemValueFormatting(cat) && (format = this.getCategoryItemValueFormat(cat)) != null) {
            label = this.formatCategoryItemValue(format, cat, label);
        }
        Rectangle2D labelBounds = this.getLabelFont().getStringBounds(label, frc);
        LineMetrics lm = this.getLabelFont().getLineMetrics(label, frc);
        double ascent = lm.getAscent();
        Point2D labelLocation = this.calculateLabelLocation(labelBounds, ascent, area, angle - 5.0);
        Composite saveComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setPaint(this.getSeriesPaint(series));
        g2.setFont(this.getLabelFont());
        g2.drawString(label, (float)labelLocation.getX(), (float)labelLocation.getY());
        g2.setComposite(saveComposite);
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        if (entities != null) {
            String tip = null;
            if (this.labelGenerator != null) {
                if (this.isCategoryItemValueFormatting(cat)) {
                    RadarItemLabelGenerator generator = new RadarItemLabelGenerator((NumberFormat)this.getCategoryItemValueFormat(cat));
                    tip = generator.generateToolTip(this.dataset, series, cat);
                    generator = null;
                } else {
                    tip = this.labelGenerator.generateToolTip(this.dataset, series, cat);
                }
            }
            String url = null;
            if (this.urlGenerator != null) {
                url = this.urlGenerator.generateURL(this.dataset, series, cat);
            }
            Rectangle rect = new Rectangle((int)(point.getX() - 2.0), (int)(point.getY() - 2.0), 4, 4);
            CategoryItemEntity entity = new CategoryItemEntity((Shape)rect, tip, url, this.dataset, series, (Object)this.dataset.getColumnKey(cat), cat);
            entities.addEntity((ChartEntity)entity);
        }
    }

    protected Point2D calculateLabelLocation(Rectangle2D labelBounds, double ascent, Rectangle2D plotArea, double startAngle) {
        Arc2D.Double arc1 = new Arc2D.Double(plotArea, startAngle, 0.0, 0);
        Point2D point1 = arc1.getEndPoint();
        double deltaX = -(point1.getX() - plotArea.getCenterX()) * this.axisLabelGap;
        double deltaY = -(point1.getY() - plotArea.getCenterY()) * this.axisLabelGap;
        double labelX = point1.getX() - deltaX;
        double labelY = point1.getY() - deltaY;
        if (labelX < plotArea.getCenterX()) {
            labelX -= labelBounds.getWidth();
        }
        if (labelX == plotArea.getCenterX()) {
            labelX -= labelBounds.getWidth() / 2.0;
        }
        if (labelY > plotArea.getCenterY()) {
            labelY += ascent;
        }
        return new Point2D.Double(labelX, labelY);
    }

    protected void drawRadarPoly(Graphics2D g2, Rectangle2D plotArea, Point2D centre, PlotRenderingInfo info, int series, int catCount, double headH, double headW) {
        Polygon polygon = new Polygon();
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        double multiple = this.getDirection().getFactor() * 360.0 / (double)catCount;
        for (int cat = 0; cat < catCount; ++cat) {
            Number dataValue = this.getPlotValue(series, cat);
            Number minValue = this.getPlotValue(0, cat);
            Number maxValue = this.getPlotValue(1, cat);
            if (dataValue == null) continue;
            double value = dataValue.doubleValue();
            double minVal = minValue.doubleValue();
            double maxVal = maxValue.doubleValue();
            double length = 1.0;
            double angle = this.getStartAngle() + multiple * (double)cat;
            Point2D point = null;
            if (minVal > maxVal) {
                if (value > minVal) {
                    length = this.min_range_std * (1.5707963267948966 + Math.atan(0.6 * -value)) / Math.PI;
                } else if (value >= maxVal && value <= minVal) {
                    length = this.min_range_std + (minVal - value) * (this.max_range_std - this.min_range_std) / (minVal - maxVal);
                } else if (value < maxVal) {
                    length = this.max_range_std + (1.0 - this.max_range_std) * (1.5707963267948966 + Math.atan(0.6 * -value)) / Math.PI;
                }
                point = this.getWebPoint(plotArea, angle, length);
            } else if (minVal < maxVal) {
                if (value > maxVal) {
                    length = this.max_range_std + (1.0 - this.max_range_std) * (1.5707963267948966 + Math.atan(0.6 * value)) / Math.PI;
                } else if (value >= minVal && value <= maxVal) {
                    length = this.min_range_std + (value - minVal) * (this.max_range_std - this.min_range_std) / (maxVal - minVal);
                } else if (value < minVal) {
                    length = this.min_range_std * (1.5707963267948966 + Math.atan(0.6 * value)) / Math.PI;
                }
                point = this.getWebPoint(plotArea, angle, length);
            } else {
                length = value > maxVal ? this.max_range_std + (1.0 - this.max_range_std) * (1.5707963267948966 + Math.atan(0.6 * value)) / Math.PI : (value == maxVal ? this.max_range_std : this.min_range_std * (1.5707963267948966 + Math.atan(0.6 * value)) / Math.PI);
                point = this.getWebPoint(plotArea, angle, length);
            }
            polygon.addPoint((int)point.getX(), (int)point.getY());
            Paint paint = this.getSeriesPaint(series);
            Paint outlinePaint = this.getSeriesOutlinePaint(series);
            Stroke outlineStroke = this.getSeriesOutlineStroke(series);
            Ellipse2D.Double head = new Ellipse2D.Double(point.getX() - headW / 2.0, point.getY() - headH / 2.0, headW, headH);
            g2.setPaint(paint);
            g2.fill(head);
            g2.setStroke(outlineStroke);
            g2.setPaint(outlinePaint);
            g2.draw(head);
            if (entities == null) continue;
            String tip = null;
            if (this.labelGenerator != null) {
                if (this.isCategoryItemValueFormatting(cat)) {
                    RadarItemLabelGenerator generator = new RadarItemLabelGenerator((NumberFormat)this.getCategoryItemValueFormat(cat));
                    tip = generator.generateToolTip(this.dataset, series, cat);
                    generator = null;
                } else {
                    tip = this.labelGenerator.generateToolTip(this.dataset, series, cat);
                }
            }
            String url = null;
            if (this.urlGenerator != null) {
                url = this.urlGenerator.generateURL(this.dataset, series, cat);
            }
            Rectangle area = new Rectangle((int)(point.getX() - headW), (int)(point.getY() - headH), (int)(headW * 2.0), (int)(headH * 2.0));
            CategoryItemEntity entity = new CategoryItemEntity((Shape)area, tip, url, this.dataset, series, (Object)this.dataset.getColumnKey(cat), cat);
            entities.addEntity((ChartEntity)entity);
        }
        Paint paint = this.getSeriesPaint(series);
        g2.setPaint(paint);
        g2.setStroke(this.getSeriesOutlineStroke(series));
        g2.draw(polygon);
        if (this.webFilled) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            g2.fill(polygon);
            g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        }
    }

    protected Number getPlotValue(int series, int cat) {
        Number value = null;
        value = this.dataset.getValue(series, cat);
        return value;
    }

    public String getPlotType() {
        return "Radar Plot";
    }

    protected class RadarItemLabelGenerator
    extends StandardCategoryItemLabelGenerator {
        RadarItemLabelGenerator() {
        }

        public RadarItemLabelGenerator(NumberFormat format) {
            super(format);
        }

        public String generateToolTip(CategoryDataset data, int series, int category) {
            String result = null;
            String temp = super.generateToolTip(data, series, category);
            result = temp.replaceAll(",", "[").replaceAll("=", "] =");
            return result;
        }

        public String generateItemLabel(CategoryDataset data, int series, int category) {
            String result = super.generateItemLabel(data, series, category);
            return result;
        }
    }
}

