/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.util;

import com.kingdee.bos.ctrl.swing.chart.data.CommonChartData;
import com.kingdee.bos.ctrl.swing.chart.data.GanttChartData;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import com.kingdee.bos.ctrl.swing.chart.data.PieChartData;
import com.kingdee.bos.ctrl.swing.chart.util.PointUtil;
import com.kingdee.bos.ctrl.swing.chart.util.ScatterDataset;
import java.util.Date;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.PieDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;

public class ChartDataUtil {
    public static CommonChartData createCommonChartData(Comparable[] seriesKeys, Comparable[] groupKeys, double[][] values) {
        return new CommonChartData(seriesKeys, groupKeys, values);
    }

    public static CommonChartData createCommonChartData(String[] seriesKeys, String[] groupKeys, double[][] values) {
        return new CommonChartData((Comparable[])seriesKeys, (Comparable[])groupKeys, values);
    }

    public static PieChartData createPieChartData(String[] groupKeys, double[] values) {
        return new PieChartData(groupKeys, values);
    }

    public static GanttChartData createGanttData(String[] seriesKeys, String[] groupKeys, Date[][][] dates) {
        return new GanttChartData(seriesKeys, groupKeys, dates);
    }

    public static PieDataset createPieDataset(IChartData chartData) {
        PieChartData data = (PieChartData)chartData;
        String[] keys = data.getGroupKeys();
        double[] values = data.getValues();
        DefaultPieDataset result = new DefaultPieDataset();
        for (int i = 0; i < keys.length; ++i) {
            result.setValue((Comparable)((Object)keys[i]), values[i]);
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(IChartData chartData) {
        CommonChartData data = (CommonChartData)chartData;
        return ChartDataUtil.createCategoryDataset(data.getSeriesKeys(), data.getGroupKeys(), data.getValues());
    }

    private static CategoryDataset createCategoryDataset(Comparable[] rowKeys, Comparable[] columnKeys, double[][] data) {
        if (rowKeys == null) {
            throw new IllegalArgumentException("Argument 'rowKeys' cannot be null.");
        }
        if (columnKeys == null) {
            throw new IllegalArgumentException("Argument 'columnKeys' cannot be null.");
        }
        if (rowKeys.length != data.length) {
            throw new IllegalArgumentException("The number of row keys does not match the number of rows in the data array.");
        }
        int columnCount = 0;
        for (int r = 0; r < data.length; ++r) {
            columnCount = Math.max(columnCount, data[r].length);
        }
        if (columnKeys.length != columnCount) {
            throw new IllegalArgumentException("The number of column keys does not match the number of columns in the data array.");
        }
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        for (int r = 0; r < data.length; ++r) {
            Comparable rowKey = rowKeys[r];
            for (int c = 0; c < data[r].length; ++c) {
                Comparable columnKey = columnKeys[c];
                if (PointUtil.isNull(data[r][c])) {
                    result.addValue(null, rowKey, columnKey);
                    continue;
                }
                result.addValue((Number)new Double(data[r][c]), rowKey, columnKey);
            }
        }
        return result;
    }

    public static CategoryDataset createStackedCategoryDataset(IChartData chartData) {
        CommonChartData data = (CommonChartData)chartData;
        double[][] values = data.getValues();
        int r = 0;
        int c = 0;
        if (data != null) {
            r = values.length;
            if (values[0] != null) {
                c = values[0].length;
            }
        }
        if (r == 0 || c == 0) {
            return null;
        }
        double[][] stacked = new double[r][c];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                stacked[i][j] = i > 0 ? values[i][j] + stacked[i - 1][j] : values[i][j];
            }
        }
        return ChartDataUtil.createCategoryDataset(data.getSeriesKeys(), data.getGroupKeys(), stacked);
    }

    public static IntervalCategoryDataset createGanttDataset(IChartData chartData) {
        GanttChartData data = (GanttChartData)chartData;
        String[] seriesKeys = data.getSeriesKeys();
        String[] categoryKeys = data.getGroupKeys();
        Date[][][] dates = data.getDates();
        TaskSeriesCollection collection = new TaskSeriesCollection();
        if (seriesKeys != null && seriesKeys.length > 0 && categoryKeys != null && categoryKeys.length > 0) {
            for (int i = 0; i < seriesKeys.length; ++i) {
                TaskSeries taskSeries = new TaskSeries(seriesKeys[i]);
                for (int j = 0; j < categoryKeys.length; ++j) {
                    Task task = new Task(categoryKeys[j], dates[i][j][0], dates[i][j][1]);
                    taskSeries.add(task);
                }
                collection.add(taskSeries);
            }
        }
        return collection;
    }

    public static XYDataset createScatterDataset(IChartData chartData) {
        CommonChartData data = (CommonChartData)chartData;
        return new ScatterDataset(data.getSeriesKeys(), data.getValues());
    }
}

