/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.util;

public class PointUtil {
    public static final double NULL_DOUBLE_VALUE = Double.NaN;

    public static double CalSmoothPoint(double[][] data, int row, int column, double nullValue) {
        int len = data[0].length;
        int prePos = 0;
        for (int ii = column - 1; ii >= 0; --ii) {
            if (PointUtil.isNull(data[row][ii])) continue;
            prePos = column - ii;
            break;
        }
        if (prePos == 0) {
            return Double.NaN;
        }
        int nextPos = 0;
        for (int ii = column + 1; ii < len; ++ii) {
            if (PointUtil.isNull(data[row][ii])) continue;
            nextPos = ii - column;
            break;
        }
        if (nextPos == 0) {
            return Double.NaN;
        }
        double nextValue = data[row][column + nextPos];
        double prevValue = data[row][column - prePos];
        return prevValue + (nextValue - prevValue) * (double)prePos / (double)(nextPos + prePos);
    }

    public static boolean isNull(double v) {
        return Double.isNaN(v);
    }

    public static void main(String[] args) {
        double[][] data = new double[][]{{1.0, 3.0, Double.NaN, 8.0}, {2.0, Double.NaN, Double.NaN, 11.0}, {Double.NaN, Double.NaN, 5.0, 8.0}, {1.0, 2.0, Double.NaN, Double.NaN}};
        System.out.println(PointUtil.CalSmoothPoint(data, 0, 2, Double.NaN));
        System.out.println(PointUtil.CalSmoothPoint(data, 1, 1, Double.NaN));
        System.out.println(PointUtil.CalSmoothPoint(data, 1, 2, Double.NaN));
        System.out.println(PointUtil.CalSmoothPoint(data, 2, 0, Double.NaN));
        System.out.println(PointUtil.CalSmoothPoint(data, 2, 1, Double.NaN));
        System.out.println(PointUtil.CalSmoothPoint(data, 3, 2, Double.NaN));
        System.out.println(PointUtil.CalSmoothPoint(data, 3, 3, Double.NaN));
    }
}

