/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class ControlUtilities {
    public static final String EDITOR_MASK = "EditorForCompositeControl";

    public static void checkFocusAndCommit() throws ParseException {
        Component compCommit = null;
        for (Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner(); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof KDPromptBox) && !(comp instanceof JFormattedTextField) && !(comp instanceof KDDatePicker) && !(comp instanceof KDSpinner) && !(comp instanceof KDTable) && !(comp instanceof SpreadContext)) continue;
            compCommit = comp;
        }
        if (compCommit != null) {
            if (compCommit instanceof KDPromptBox) {
                KDPromptBox pb = (KDPromptBox)compCommit;
                try {
                    pb.commitEdit();
                }
                catch (ParseException e1) {
                    pb.setText("");
                    pb.setData(null);
                    pb.setLabelText("");
                }
            } else if (compCommit instanceof JFormattedTextField) {
                ((JFormattedTextField)compCommit).commitEdit();
            } else if (compCommit instanceof KDDatePicker) {
                ((KDDatePicker)compCommit).commitEdit();
                ((KDDatePicker)compCommit).getEditor().hideInfoTip();
            } else if (compCommit instanceof KDSpinner) {
                ((KDSpinner)compCommit).commitEdit();
            } else if (compCommit instanceof KDTable) {
                ((KDTable)compCommit).getEditManager().stopEditing();
            } else if (compCommit instanceof SpreadContext) {
                ((SpreadContext)compCommit).getStateManager().stopEditing();
            }
        }
    }

    public static boolean isEditorForCompositeControl(Component comp) {
        Object obj;
        if (comp instanceof JComponent && (obj = ((JComponent)comp).getClientProperty(EDITOR_MASK)) instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static void registerEscapeAction(JRootPane pane, Action action) {
        InputMap inputMap = pane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "esc");
        ActionMap actionMap = pane.getActionMap();
        actionMap.put("esc", action);
    }

    public static void printInputMap(InputMap map) {
        KeyStroke[] keys = map.allKeys();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                KeyStroke key = keys[i];
                Object object = map.get(key);
            }
        }
    }

    public static void printActionMap(ActionMap map) {
        Object[] keys = map.allKeys();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                Action action = map.get(key);
            }
        }
    }

    public static Set getManagingFocusForwardTraversalKeys(JComponent comp) {
        return comp.getFocusTraversalKeys(0);
    }

    public static Set getManagingFocusBackwardTraversalKeys(JComponent comp) {
        return comp.getFocusTraversalKeys(1);
    }

    public static void addManagingFocusForwardTraversalKeys(JComponent comp, KeyStroke keyStroke) {
        if (comp == null) {
            return;
        }
        Set sets = ControlUtilities.getManagingFocusForwardTraversalKeys(comp);
        HashSet<KeyStroke> treeset = new HashSet<KeyStroke>(sets);
        treeset.add(keyStroke);
        comp.setFocusTraversalKeys(0, treeset);
    }

    public static void addManagingFocusBackwardTraversalKeys(JComponent comp, KeyStroke keyStroke) {
        if (comp == null) {
            return;
        }
        Set sets = ControlUtilities.getManagingFocusBackwardTraversalKeys(comp);
        HashSet<KeyStroke> treeset = new HashSet<KeyStroke>(sets);
        treeset.add(keyStroke);
        comp.setFocusTraversalKeys(1, treeset);
    }

    public static void removeManagingFocusForwardTraversalKeys(JComponent comp, KeyStroke keyStroke) {
        if (comp == null) {
            return;
        }
        Set sets = ControlUtilities.getManagingFocusForwardTraversalKeys(comp);
        HashSet treeset = new HashSet(sets);
        treeset.remove(keyStroke);
        comp.setFocusTraversalKeys(0, treeset);
    }

    public static void removeManagingFocusBackwardTraversalKeys(JComponent comp, KeyStroke keyStroke) {
        if (comp == null) {
            return;
        }
        Set sets = ControlUtilities.getManagingFocusBackwardTraversalKeys(comp);
        HashSet treeset = new HashSet(sets);
        treeset.remove(keyStroke);
        comp.setFocusTraversalKeys(1, treeset);
    }

    public static void addTotalDefaultFocusTraversalKeys(int id, KeyStroke keyStroke) {
        if (id != 0 && id != 1) {
            throw new IllegalArgumentException("id must be KeyboardFocusManager.FORWARD_TRAVERSAL_KEYS or KeyboardFocusManager.BACKWARD_TRAVERSAL_KEYS.");
        }
        Set<AWTKeyStroke> set = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(set);
        hashSet.add(keyStroke);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(id, hashSet);
    }

    public static void resetAppDefaultFocusTraversalKeys() {
        Set set = (Set)UIManager.get("extendforwardkeys");
        Set set1 = (Set)UIManager.get("extendbackwardkeys");
        int id = 0;
        if (set != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(id, Collections.EMPTY_SET);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(id, set);
        }
        if (set1 != null) {
            id = 1;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(id, Collections.EMPTY_SET);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(id, set1);
        }
    }

    public static void appendActionToComponent(JComponent target, int condition, KeyStroke keyStroke, String oprtStr, Action action) {
        if (target == null || keyStroke == null || action == null) {
            throw new NullPointerException("target or keyStroke or action don't is null .");
        }
        InputMap inputMap = target.getInputMap(condition);
        ActionMap actionMap = target.getActionMap();
        String pOprtStr = (String)inputMap.get(keyStroke);
        if (pOprtStr != null) {
            inputMap.remove(keyStroke);
            actionMap.remove(pOprtStr);
        }
        inputMap.put(keyStroke, oprtStr);
        actionMap.put(oprtStr, action);
    }

    public static void removeActionToComponent(JComponent target, int condition, KeyStroke keyStroke) {
        if (target == null || keyStroke == null) {
            throw new NullPointerException("target or keyStroke or action don't is null .");
        }
        InputMap inputMap = target.getInputMap(condition);
        ActionMap actionMap = target.getActionMap();
        String pOprtStr = (String)inputMap.get(keyStroke);
        if (pOprtStr != null) {
            inputMap.remove(keyStroke);
            actionMap.remove(pOprtStr);
        }
    }
}

