/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2;

import com.kingdee.bos.ctrl.kdf.fd2.ILocation;
import com.kingdee.bos.ctrl.kdf.fd2.SideLocation;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import org.jdom2.Element;

public class Location
implements ILocation {
    public static final int RELATIVE_LOCATION = 0;
    public static final int ALIGN_LOCATION = 1;
    public static final int CUSTOMED_LOCATION = 2;
    public static final int SELFADAPTION = 3;
    public static final int RELATIVE_LEFT = 0;
    public static final int RELATIVE_RIGHT = 1;
    public static final int RELATIVE_TOP = 2;
    public static final int RELATIVE_BOTTOM = 3;
    public static final int LEFT_ALIGN = 0;
    public static final int CENTER_ALIGN = 1;
    public static final int RIGHT_ALIGN = 2;
    public static final int TOP_ALIGN = 3;
    public static final int MIDDLE_ALIGN = 4;
    public static final int BOTTM_ALIGN = 5;
    public String custFormula = "";
    private SideLocation[] locations = new SideLocation[4];
    private ReportElement owner = null;

    public Location(ReportElement re) {
        for (int i = 0; i < 4; ++i) {
            this.locations[i] = new SideLocation(0, this);
        }
        this.owner = re;
    }

    public Location cloneMe() {
        Location loc = new Location(this.owner);
        loc.cloneSide(this);
        return loc;
    }

    public void setOwner(ReportElement re) {
        this.owner = re;
    }

    public void createDefaultLocation() {
        block12: for (int i = 0; i < 4; ++i) {
            if (!(this.owner instanceof Page)) {
                switch (i) {
                    case 0: {
                        this.locations[i].setRelativeObjectID(this.owner.getParent().getName());
                        this.locations[i].setContextValue(0);
                        this.locations[i].setValue(this.owner.getPosLom().x);
                        break;
                    }
                    case 1: {
                        this.locations[i].setRelativeObjectID(this.owner.getName());
                        this.locations[i].setContextValue(0);
                        this.locations[i].setValue(this.owner.getWidthLom());
                        break;
                    }
                    case 2: {
                        this.locations[i].setRelativeObjectID(this.owner.getParent().getName());
                        this.locations[i].setContextValue(2);
                        this.locations[i].setValue(this.owner.getPosLom().y);
                        break;
                    }
                    case 3: {
                        this.locations[i].setRelativeObjectID(this.owner.getName());
                        this.locations[i].setContextValue(2);
                        this.locations[i].setValue(this.owner.getHeightLom());
                    }
                }
                continue;
            }
            switch (i) {
                case 0: {
                    this.locations[i].setContextValue(0);
                    this.locations[i].setValue(this.owner.getPosLom().x);
                    continue block12;
                }
                case 1: {
                    this.locations[i].setContextValue(0);
                    this.locations[i].setValue(this.owner.getWidthLom());
                    continue block12;
                }
                case 2: {
                    this.locations[i].setContextValue(2);
                    this.locations[i].setValue(this.owner.getPosLom().y);
                    continue block12;
                }
                case 3: {
                    this.locations[i].setContextValue(2);
                    this.locations[i].setValue(this.owner.getHeightLom());
                }
            }
        }
    }

    public void cloneSide(Location loc) {
        for (int i = 0; i < 4; ++i) {
            this.locations[i].setType(loc.getSideLocation(i).getType());
            this.locations[i].setRelativeObjectID(loc.getSideLocation(i).getRelativeObjectID());
            this.locations[i].setContextValue(loc.getSideLocation(i).getContextValue());
            this.locations[i].setValue(loc.getSideLocation(i).getValue());
            this.locations[i].setStrFormula(loc.getSideLocation(i).getStrFormula());
        }
    }

    public SideLocation getSideLocation(int side) {
        return this.locations[side];
    }

    public boolean isDefaultLocation() {
        for (int i = 0; i < 4; ++i) {
            if (this.isDefaultLocationSide(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isSimpleLocation() {
        for (int i = 0; i < 4; ++i) {
            if (this.isSimpleSide(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultLocationSide(int side) {
        if (this.owner instanceof Page) {
            return true;
        }
        if (this.locations[side].getType() == 2 || this.locations[side].getType() == 3) {
            return true;
        }
        if (this.locations[side].getType() == 1) {
            return false;
        }
        switch (side) {
            case 0: 
            case 2: {
                if (this.locations[side].getRelativeObjectID().equals(this.owner.getParent().getName())) break;
                return false;
            }
            case 1: 
            case 3: {
                if (this.locations[side].getRelativeObjectID().equals(this.owner.getName())) break;
                return false;
            }
        }
        switch (side) {
            case 0: 
            case 1: {
                if (this.locations[side].getContextValue() == 0) break;
                return false;
            }
            case 2: 
            case 3: {
                if (this.locations[side].getContextValue() == 2) break;
                return false;
            }
        }
        return true;
    }

    public boolean isSimpleSide(int side) {
        if (this.owner instanceof Page) {
            return true;
        }
        if (this.locations[side].getType() != 0) {
            return false;
        }
        switch (side) {
            case 0: 
            case 2: {
                if (this.locations[side].getRelativeObjectID().equals(this.owner.getParent().getName())) break;
                return false;
            }
            case 1: 
            case 3: {
                if (this.locations[side].getRelativeObjectID().equals(this.owner.getName())) break;
                return false;
            }
        }
        switch (side) {
            case 0: 
            case 1: {
                if (this.locations[side].getContextValue() == 0) break;
                return false;
            }
            case 2: 
            case 3: {
                if (this.locations[side].getContextValue() == 2) break;
                return false;
            }
        }
        return true;
    }

    private boolean isInterDefaultLocationSide(int side) {
        if (this.owner instanceof Page) {
            return true;
        }
        if (this.locations[side].getType() == 2 || this.locations[side].getType() == 3) {
            return false;
        }
        if (this.locations[side].getType() == 1) {
            return false;
        }
        switch (side) {
            case 0: 
            case 2: {
                if (this.locations[side].getRelativeObjectID().equals(this.owner.getParent().getName())) break;
                return false;
            }
            case 1: 
            case 3: {
                if (this.locations[side].getRelativeObjectID().equals(this.owner.getName())) break;
                return false;
            }
        }
        switch (side) {
            case 0: 
            case 1: {
                if (this.locations[side].getContextValue() == 0) break;
                return false;
            }
            case 2: 
            case 3: {
                if (this.locations[side].getContextValue() == 2) break;
                return false;
            }
        }
        return true;
    }

    public String getRelationFormula(int side) {
        StringBuffer sb = new StringBuffer();
        SideLocation sl = this.locations[side];
        sb.append("=");
        switch (side) {
            case 0: {
                if (this.isInterDefaultLocationSide(side)) {
                    sb.append(this.owner.getParent().getName());
                    sb.append("_");
                    sb.append("left");
                    sb.append("+");
                    sb.append(sl.getValue());
                    break;
                }
                if (sl.getType() == 0 || sl.getType() == 2 || sl.getType() == 3) {
                    sb.append(sl.getRelativeObjectID());
                    sb.append("_");
                    int contextvalue = 0;
                    contextvalue = sl.getContextValue();
                    sb.append(this.sideToRelationString(contextvalue));
                    sb.append("+");
                    sb.append(sl.getValue());
                    break;
                }
                switch (sl.getContextValue()) {
                    case 0: {
                        sb.append(sl.getRelativeObjectID());
                        sb.append("_left");
                        break;
                    }
                    case 1: {
                        sb.append("(");
                        sb.append(sl.getRelativeObjectID());
                        sb.append("_left+");
                        sb.append(sl.getRelativeObjectID());
                        sb.append("_right");
                        sb.append("-");
                        sb.append(this.locations[1].getValue());
                        sb.append(")/2");
                        break;
                    }
                    case 2: {
                        sb.append(sl.getRelativeObjectID());
                        sb.append("_right-");
                        sb.append(this.locations[1].getValue());
                    }
                }
                break;
            }
            case 1: {
                if (this.isInterDefaultLocationSide(side) || this.locations[0].getType() == 1) {
                    sb.append(this.owner.getName());
                    sb.append("_left+");
                    sb.append(sl.getValue());
                    break;
                }
                if (sl.getType() == 2 || sl.getType() == 3) {
                    sb.append(sl.getRelativeObjectID());
                    sb.append("_");
                    sb.append(this.sideToRelationString(sl.getContextValue()));
                    sb.append("+");
                    sb.append(sl.getValue());
                    break;
                }
                if (sl.getType() != 0) break;
                sb.append(sl.getRelativeObjectID());
                sb.append("_");
                sb.append(this.sideToRelationString(sl.getContextValue()));
                sb.append("+");
                sb.append(sl.getValue());
                break;
            }
            case 2: {
                if (this.isInterDefaultLocationSide(side)) {
                    sb.append(this.owner.getParent().getName());
                    sb.append("_");
                    sb.append("top");
                    sb.append("+");
                    sb.append(sl.getValue());
                    break;
                }
                if (sl.getType() == 0 || sl.getType() == 2 || sl.getType() == 3) {
                    sb.append(sl.getRelativeObjectID());
                    sb.append("_");
                    int contextvalue = 2;
                    contextvalue = sl.getContextValue();
                    sb.append(this.sideToRelationString(contextvalue));
                    sb.append("+");
                    sb.append(sl.getValue());
                    break;
                }
                switch (sl.getContextValue()) {
                    case 3: {
                        sb.append(sl.getRelativeObjectID());
                        sb.append("_top");
                        break;
                    }
                    case 4: {
                        sb.append("(");
                        sb.append(sl.getRelativeObjectID());
                        sb.append("_top+");
                        sb.append(sl.getRelativeObjectID());
                        sb.append("_bottom");
                        sb.append("-");
                        sb.append(this.locations[3].getValue());
                        sb.append(")/2");
                        break;
                    }
                    case 5: {
                        sb.append(sl.getRelativeObjectID());
                        sb.append("_bottom-");
                        sb.append(this.locations[3].getValue());
                    }
                }
                break;
            }
            case 3: {
                if (this.isInterDefaultLocationSide(side) || this.locations[2].getType() == 1) {
                    sb.append(this.owner.getName());
                    sb.append("_top+");
                    sb.append(sl.getValue());
                    break;
                }
                if (sl.getType() == 2 || sl.getType() == 3) {
                    sb.append(sl.getRelativeObjectID());
                    sb.append("_");
                    sb.append(this.sideToRelationString(sl.getContextValue()));
                    sb.append("+");
                    sb.append(sl.getValue());
                    break;
                }
                if (sl.getType() != 0) break;
                sb.append(sl.getRelativeObjectID());
                sb.append("_");
                sb.append(this.sideToRelationString(sl.getContextValue()));
                sb.append("+");
                sb.append(sl.getValue());
            }
        }
        return sb.toString();
    }

    public String getKDFRelationFormula(int side) {
        StringBuffer sb = new StringBuffer();
        SideLocation sl = this.locations[side];
        ReportElement reParent = (ReportElement)((Object)this.owner.getParent());
        switch (side) {
            case 0: {
                if (this.isInterDefaultLocationSide(side)) {
                    sb.append("[");
                    sb.append(reParent.getName());
                    sb.append(".");
                    sb.append("left");
                    sb.append("]");
                    this.getAddFormula(sb, sl.getValue());
                    break;
                }
                if (sl.getType() == 0 || sl.getType() == 2 || sl.getType() == 3) {
                    sb.append("[");
                    sb.append(sl.getRelativeObjectID());
                    sb.append(".");
                    sb.append(this.sideToRelationString(sl.getContextValue()));
                    sb.append("]");
                    this.getAddFormula(sb, sl.getValue());
                    break;
                }
                switch (sl.getContextValue()) {
                    case 0: {
                        sb.append("[");
                        sb.append(sl.getRelativeObjectID());
                        sb.append(".left]");
                        break;
                    }
                    case 1: {
                        sb.append("([");
                        sb.append(sl.getRelativeObjectID());
                        sb.append(".left]+[");
                        sb.append(sl.getRelativeObjectID());
                        sb.append(".right]");
                        sb.append("-");
                        sb.append(this.locations[1].getValue());
                        sb.append(")/2");
                        break;
                    }
                    case 2: {
                        sb.append("[");
                        sb.append(sl.getRelativeObjectID());
                        sb.append(".right]");
                        this.getDecreaseFormula(sb, this.locations[1].getValue());
                    }
                }
                break;
            }
            case 1: {
                if (this.isInterDefaultLocationSide(side) || this.locations[0].getType() == 1) {
                    sb.append("[");
                    sb.append(this.owner.getName());
                    sb.append(".left]");
                    this.getAddFormula(sb, sl.getValue());
                    break;
                }
                if (sl.getType() == 2 || sl.getType() == 3) {
                    sb.append("[");
                    sb.append(sl.getRelativeObjectID());
                    sb.append(".");
                    sb.append(this.sideToRelationString(sl.getContextValue()));
                    sb.append("]");
                    this.getAddFormula(sb, sl.getValue());
                    break;
                }
                if (sl.getType() != 0) break;
                sb.append("[");
                sb.append(sl.getRelativeObjectID());
                sb.append(".");
                sb.append(this.sideToRelationString(sl.getContextValue()));
                sb.append("]");
                this.getAddFormula(sb, sl.getValue());
                break;
            }
            case 2: {
                if (this.isInterDefaultLocationSide(side)) {
                    sb.append("[");
                    sb.append(reParent.getName());
                    sb.append(".");
                    sb.append("top");
                    sb.append("]");
                    this.getAddFormula(sb, sl.getValue());
                    break;
                }
                if (sl.getType() == 0 || sl.getType() == 2 || sl.getType() == 3) {
                    sb.append("[");
                    sb.append(sl.getRelativeObjectID());
                    sb.append(".");
                    sb.append(this.sideToRelationString(sl.getContextValue()));
                    sb.append("]");
                    this.getAddFormula(sb, sl.getValue());
                    break;
                }
                switch (sl.getContextValue()) {
                    case 3: {
                        sb.append("[");
                        sb.append(sl.getRelativeObjectID());
                        sb.append(".top]");
                        break;
                    }
                    case 4: {
                        sb.append("([");
                        sb.append(sl.getRelativeObjectID());
                        sb.append(".top]+[");
                        sb.append(sl.getRelativeObjectID());
                        sb.append(".bottom]");
                        this.getDecreaseFormula(sb, this.locations[3].getValue());
                        sb.append(")/2");
                        break;
                    }
                    case 5: {
                        sb.append("[");
                        sb.append(sl.getRelativeObjectID());
                        sb.append(".bottom]");
                        this.getDecreaseFormula(sb, this.locations[3].getValue());
                    }
                }
                break;
            }
            case 3: {
                if (this.isInterDefaultLocationSide(side) || this.locations[2].getType() == 1) {
                    sb.append("[");
                    sb.append(this.owner.getName());
                    sb.append(".top]");
                    this.getAddFormula(sb, sl.getValue());
                    break;
                }
                if (sl.getType() == 2 || sl.getType() == 3) {
                    sb.append("[");
                    sb.append(sl.getRelativeObjectID());
                    sb.append(".");
                    sb.append(this.sideToRelationString(sl.getContextValue()));
                    sb.append("]");
                    this.getAddFormula(sb, sl.getValue());
                    break;
                }
                if (sl.getType() != 0) break;
                sb.append("[");
                sb.append(sl.getRelativeObjectID());
                sb.append(".");
                sb.append(this.sideToRelationString(sl.getContextValue()));
                sb.append("]");
                this.getAddFormula(sb, sl.getValue());
            }
        }
        return sb.toString();
    }

    public void saveKDFAttriubtes(Element designNode) {
        for (int i = 0; i < 4; ++i) {
            SideLocation side = this.locations[i];
            String strPrefix = this.sideToRelationString(i);
            String strLoctaionType = strPrefix + "LocationType";
            switch (side.getType()) {
                case 0: {
                    designNode.setAttribute(strLoctaionType, "relative");
                    break;
                }
                case 1: {
                    designNode.setAttribute(strLoctaionType, "alignment");
                    break;
                }
                case 2: {
                    designNode.setAttribute(strLoctaionType, "custom");
                    break;
                }
                case 3: {
                    designNode.setAttribute(strLoctaionType, "selfAdapt");
                }
            }
            String strObject = strPrefix + "RelativeObjID";
            designNode.setAttribute(strObject, side.getRelativeObjectID());
            String strBorder = strPrefix + "RelativeBorder";
            designNode.setAttribute(strBorder, this.getContextString(side));
            String strValue = strPrefix + "RelativeOffset";
            designNode.setAttribute(strValue, String.valueOf(side.getValue()));
        }
    }

    private String getContextString(SideLocation side) {
        if (side.getType() == 1) {
            switch (side.getContextValue()) {
                case 0: {
                    return "left";
                }
                case 1: {
                    return "center";
                }
                case 2: {
                    return "right";
                }
                case 3: {
                    return "top";
                }
                case 4: {
                    return "middle";
                }
                case 5: {
                    return "bottom";
                }
            }
            return "";
        }
        return this.sideToRelationString(side.getContextValue());
    }

    private void getAddFormula(StringBuffer sb, float value) {
        if (value > 0.0f) {
            sb.append("+");
            sb.append(value);
        } else if (value < 0.0f) {
            sb.append(value);
        }
    }

    private void getDecreaseFormula(StringBuffer sb, float value) {
        if (value > 0.0f) {
            sb.append("-");
            sb.append(value);
        } else if (value < 0.0f) {
            sb.append("+");
            sb.append(-value);
        }
    }

    public String getRelationString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            sb.append(this.getRelationFormula(i));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            sb.append(this.locations[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String sideToRelationString(int side) {
        switch (side) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "top";
            }
            case 3: {
                return "bottom";
            }
        }
        return "";
    }
}

