/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.data;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.TreeView;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.io.Xml2Meta;
import com.kingdee.bos.ctrl.data.meta.ui.MetaTreeCtrl;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.DialogClosedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.DialogClosedListener;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.fd2.icons.Icons;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class MetaManageDialog
extends KDDialog {
    private KDList lstFile;
    private KDPanel panStructure;
    private KDWorkButton btnAdd;
    private KDWorkButton btnRemove;
    private KDWorkButton btnUp;
    private KDWorkButton btnDown;
    private KDButton btnOK;
    private boolean donotHandle = false;
    private boolean isCanEdit = true;
    private static String res = CtrlClassUtil.getPackageName(MetaManageDialog.class) + ".data";
    private EventListenerList listenerList = new EventListenerList();
    private ArrayList metaFileList;

    public MetaManageDialog(Frame owner) {
        super(owner, true);
        this.init();
    }

    public MetaManageDialog(Dialog owner) {
        super(owner, true);
        this.init();
    }

    private void init() {
        this.setSize(480, 360);
        this.setLocationRelativeTo(null);
        this.setTitle(MetaManageDialog.getMLS("kdmManagerTitle", "\u5143\u6570\u636e\u7ba1\u7406\u5668"));
        this.initComponent();
        this.installListener();
    }

    private static String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }

    private void initComponent() {
        this.lstFile = new KDList();
        this.panStructure = new KDPanel((LayoutManager)new BorderLayout());
        this.btnAdd = new KDWorkButton(MetaManageDialog.getMLS("kdmmAdd", "\u6dfb\u52a0"), (Icon)Icons.ICN_NEW);
        this.btnRemove = new KDWorkButton(MetaManageDialog.getMLS("kdmmRemove", "\u5220\u9664"), (Icon)Icons.ICN_DELETE);
        this.btnUp = new KDWorkButton(MetaManageDialog.getMLS("kdmmMoveUp", "\u4e0a\u79fb"), (Icon)Icons.ICN_MOVE_UP);
        this.btnDown = new KDWorkButton(MetaManageDialog.getMLS("kdmmMoveDown", "\u4e0b\u79fb"), (Icon)Icons.ICN_MOVE_DOWN);
        this.btnOK = new KDButton(MetaManageDialog.getMLS("ok", "\u786e\u5b9a"));
        TableLayout layout = TableLayout.splitRow((int)3);
        Container cp = super.getContentPane();
        layout.rowStyle(0).setPriY(1);
        layout.rowStyle(0).setMargin(10);
        layout.rowStyle(2).setMargin(10);
        Table tbTop = layout.cell(0).splitCol(2);
        Table tbBtm = layout.cell(2).splitCol(2);
        tbTop.colStyle(0).setPriX(1);
        tbTop.colStyle(1).setMarginLeft(8);
        tbTop.colStyle(1).setWidth(80);
        Table t0 = tbTop.cell(0).splitRow(2);
        t0.rowStyle(0).setHeight(100);
        t0.rowStyle(1).setMarginTop(8);
        t0.rowStyle(1).setPriY(1);
        Table t1 = tbTop.cell(1).splitRow(6);
        t1.defaultStyle().setMarginTop(3);
        t1.rowStyle(2).setHeight(6);
        t1.rowStyle(5).setPriY(1);
        tbBtm.colStyle(0).setPriX(1);
        tbBtm.colStyle(1).setWidth(79);
        cp.setLayout((LayoutManager)layout);
        cp.add((Component)new KDScrollPane((Component)this.lstFile), t0.cell(0));
        cp.add((Component)this.panStructure, t0.cell(1));
        cp.add((Component)this.btnAdd, t1.cell(0));
        cp.add((Component)this.btnRemove, t1.cell(1));
        cp.add((Component)this.btnUp, t1.cell(3));
        cp.add((Component)this.btnDown, t1.cell(4));
        cp.add((Component)new KDSeparator(), layout.cell(1));
        cp.add((Component)this.btnOK, tbBtm.cell(1));
        this.showTree((JComponent)this.createEmptyTree());
    }

    private void installListener() {
        ActionHandler handler = new ActionHandler();
        this.lstFile.addListSelectionListener((ListSelectionListener)handler);
        this.btnAdd.addActionListener((ActionListener)handler);
        this.btnRemove.addActionListener((ActionListener)handler);
        this.btnUp.addActionListener((ActionListener)handler);
        this.btnDown.addActionListener((ActionListener)handler);
        this.btnOK.addActionListener((ActionListener)handler);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                MetaManageDialog.this.fireCloseListener(0);
            }
        });
    }

    private TreeView createEmptyTree() {
        TreeView tv = new TreeView(new KDTree((ITreeNode)new DefaultKingdeeTreeNode()));
        tv.setTitle(MetaManageDialog.getMLS("metaContent", "\u5143\u6570\u636e\u5185\u5bb9"));
        tv.getTree().setRootVisible(false);
        return tv;
    }

    private void showTree(JComponent tree) {
        this.panStructure.removeAll();
        if (tree != null) {
            this.panStructure.add((Component)tree, (Object)"Center");
        }
        this.panStructure.validate();
        this.panStructure.repaint();
    }

    private void actionLstFileSelected(ListSelectionEvent e) {
        this.changeButtonEnabled();
        this.showKDMStructure();
    }

    private void changeButtonEnabled() {
        if (!this.isCanEdit) {
            this.btnAdd.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            return;
        }
        this.btnAdd.setEnabled(true);
        if (this.lstFile.getSelectedIndex() == -1) {
            this.btnRemove.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
        } else {
            boolean isCanDel = true;
            this.btnRemove.setEnabled(isCanDel);
            if (this.lstFile.getElementCount() > 1) {
                if (this.lstFile.getSelectedIndex() == 0) {
                    this.btnUp.setEnabled(false);
                } else {
                    this.btnUp.setEnabled(true);
                }
                if (this.lstFile.getSelectedIndex() == this.lstFile.getElementCount() - 1) {
                    this.btnDown.setEnabled(false);
                } else {
                    this.btnDown.setEnabled(true);
                }
            } else {
                this.btnUp.setEnabled(false);
                this.btnDown.setEnabled(false);
            }
        }
    }

    private void showKDMStructure() {
        Object obj = this.lstFile.getSelectedValue();
        if (obj instanceof KDMManagerListElement) {
            this.showTree((JComponent)((KDMManagerListElement)obj).getTreeStructure().getTreeUI());
        } else {
            this.showTree((JComponent)this.createEmptyTree());
        }
    }

    private void actionAdd(ActionEvent e) {
        KDFileChooser fc = new KDFileChooser(System.getProperty("KDF.meta.dir"));
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String filename = file.getName();
                if (file.isDirectory()) {
                    return true;
                }
                if (filename.length() > 4) {
                    String ext = filename.substring(filename.length() - 4);
                    return ext.equalsIgnoreCase(".rsm");
                }
                return false;
            }

            @Override
            public String getDescription() {
                return MetaManageDialog.getMLS("kdmFilter", "\u91d1\u8776\u62a5\u8868\u5143\u6570\u636e") + "(*.rsm)";
            }
        });
        boolean isOpened = false;
        fc.setDialogType(0);
        if (fc.showOpenDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            for (int i = 0; i < this.lstFile.getElementCount(); ++i) {
                Object obj = this.lstFile.getElement(i);
                if (!(obj instanceof KDMManagerListElement) || !file.equals(((KDMManagerListElement)obj).getFile())) continue;
                MsgBox.show((Component)((Object)this), MetaManageDialog.getMLS("fileHasOpened", "\u6587\u4ef6\u5df2\u5728\u5217\u8868\u4e2d\u3002"), MetaManageDialog.getMLS("promptTitle", "\u91d1\u8776\u63d0\u793a"), 129);
                this.lstFile.setSelectedIndex(i);
                isOpened = true;
                break;
            }
            if (!isOpened) {
                this.addListElement(file, -1);
            }
        }
        System.setProperty("KDF.meta.dir", fc.getCurrentDirectory().toString());
    }

    private void addListElement(File file, int location) {
        throw new UnsupportedOperationException("");
    }

    private MetaLibrary buildMetaLib(File file) {
        Element node = null;
        try {
            node = XmlUtil.loadXmlFile((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
        Xml2Meta x2m = new Xml2Meta();
        MetaLibrary ml = x2m.transform(node);
        return ml;
    }

    private void actionRemove(ActionEvent e) {
        int idx = this.lstFile.getSelectedIndex();
        if (idx != -1) {
            this.donotHandle = true;
            this.lstFile.removeElementAt(idx);
            if (this.lstFile.getElementCount() > 0) {
                if (this.lstFile.getElementCount() > idx) {
                    this.lstFile.setSelectedIndex(idx);
                } else {
                    this.lstFile.setSelectedIndex(idx - 1);
                }
            }
            this.donotHandle = false;
        }
    }

    private void actionMoveUp(ActionEvent e) {
        int idx = this.lstFile.getSelectedIndex();
        if (idx <= 0) {
            return;
        }
        Object obj = this.lstFile.getSelectedValue();
        this.donotHandle = true;
        Icon icon = this.lstFile.getElementIcon(idx);
        this.lstFile.removeElementAt(idx);
        this.lstFile.insertElement(obj, idx - 1);
        this.lstFile.setElementIcon(icon, idx - 1);
        this.lstFile.setSelectedIndex(idx - 1);
        this.donotHandle = false;
    }

    private void actionMoveDown(ActionEvent e) {
        int idx = this.lstFile.getSelectedIndex();
        if (idx == -1 || idx == this.lstFile.getElementCount() - 1) {
            return;
        }
        Object obj = this.lstFile.getSelectedValue();
        this.donotHandle = true;
        Icon icon = this.lstFile.getElementIcon(idx);
        this.lstFile.removeElementAt(idx);
        this.lstFile.insertElement(obj, idx + 1);
        this.lstFile.setElementIcon(icon, idx + 1);
        this.lstFile.setSelectedIndex(idx + 1);
        this.donotHandle = false;
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        MetaManageDialog kdmm = new MetaManageDialog((Frame)null);
        kdmm.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        kdmm.show();
    }

    public void acceptKDMFile() {
        ArrayList<File> newList = new ArrayList<File>();
        for (int i = 0; i < this.lstFile.getElementCount(); ++i) {
            Object obj = this.lstFile.getElement(i);
            if (!(obj instanceof KDMManagerListElement)) continue;
            newList.add(((KDMManagerListElement)obj).getFile());
        }
        this.metaFileList = newList;
    }

    public void setKDMFiles(ArrayList filesList) {
        this.metaFileList = filesList;
        this.lstFile.removeAllElements();
        if (filesList != null) {
            Object[] files = filesList.toArray();
            for (int i = 0; i < files.length; ++i) {
                File file = MetaManageDialog.getMetaFile(files[i]);
                this.addListElement(file, i);
            }
        }
        this.changeButtonEnabled();
        this.showKDMStructure();
    }

    public ArrayList getKDMFiles() {
        return this.metaFileList;
    }

    public MetaLibrary[] getMetaLibrarys() {
        Iterator it = this.metaFileList.iterator();
        MetaLibrary[] mls = new MetaLibrary[this.metaFileList.size()];
        for (int i = 0; i < this.metaFileList.size(); ++i) {
            File file = MetaManageDialog.getMetaFile(it.next());
            mls[i] = this.buildMetaLib(file);
        }
        return mls;
    }

    public void setEditable(boolean b) {
        this.isCanEdit = b;
    }

    public static File getMetaFile(Object objGetFromMetaFileList) {
        if (objGetFromMetaFileList instanceof File) {
            return (File)objGetFromMetaFileList;
        }
        if (objGetFromMetaFileList instanceof String) {
            return new File(objGetFromMetaFileList.toString());
        }
        return null;
    }

    public static void removeFromList(File file, ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            File anExistFile = MetaManageDialog.getMetaFile(obj);
            if (file == null || !file.equals(anExistFile)) continue;
            list.remove(i);
            return;
        }
    }

    public void addCloseListener(DialogClosedListener l) {
        this.listenerList.add(DialogClosedListener.class, l);
    }

    public void removeCloseListener(DialogClosedListener l) {
        this.listenerList.remove(DialogClosedListener.class, l);
    }

    private void fireCloseListener(int closeType) {
        Object[] listeners = this.listenerList.getListenerList();
        DialogClosedEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DialogClosedListener.class) continue;
            if (null == evt) {
                evt = new DialogClosedEvent((Object)this, closeType);
            }
            ((DialogClosedListener)listeners[i + 1]).closed(evt);
        }
    }

    public void show() {
        this.changeButtonEnabled();
        super.show();
    }

    private class KDMManagerListElement {
        private File file;
        private String dsType;
        private MetaTreeCtrl treeStructure;

        private KDMManagerListElement() {
        }

        public String getDSType() {
            return this.dsType;
        }

        public File getFile() {
            return this.file;
        }

        public void setDSType(String string) {
            this.dsType = string;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String toString() {
            return this.file.toString() + " (" + this.dsType + ")";
        }

        public MetaTreeCtrl getTreeStructure() {
            return this.treeStructure;
        }

        public void setTreeStructure(MetaTreeCtrl tree) {
            this.treeStructure = tree;
        }
    }

    private class ActionHandler
    implements ListSelectionListener,
    ActionListener {
        private ActionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (MetaManageDialog.this.donotHandle) {
                return;
            }
            if (e.getSource() == MetaManageDialog.this.lstFile) {
                MetaManageDialog.this.actionLstFileSelected(e);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == MetaManageDialog.this.btnAdd) {
                MetaManageDialog.this.actionAdd(e);
                MetaManageDialog.this.changeButtonEnabled();
                MetaManageDialog.this.showKDMStructure();
                return;
            }
            if (source == MetaManageDialog.this.btnRemove) {
                MetaManageDialog.this.actionRemove(e);
                MetaManageDialog.this.changeButtonEnabled();
                MetaManageDialog.this.showKDMStructure();
                return;
            }
            if (source == MetaManageDialog.this.btnUp) {
                MetaManageDialog.this.actionMoveUp(e);
                MetaManageDialog.this.changeButtonEnabled();
                return;
            }
            if (source == MetaManageDialog.this.btnDown) {
                MetaManageDialog.this.actionMoveDown(e);
                MetaManageDialog.this.changeButtonEnabled();
                return;
            }
            if (source == MetaManageDialog.this.btnOK) {
                MetaManageDialog.this.dispose();
                return;
            }
        }
    }
}

