/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.propertiesdialog;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.kdf.fd2.gui.propertiesdialog.AbstractPropPanel;
import com.kingdee.bos.ctrl.kdf.fd2.gui.propertiesdialog.FormatUtil;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.VariantElement;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class VariantPropsPanel
extends AbstractPropPanel {
    private FormatUtil formatUtil;
    private KDLabel labVariant;
    private KDLabel labFormat;
    private KDComboBox cmbVariant;
    private KDPromptBox f7Format;
    private boolean fireVariantComboBox = true;

    public VariantPropsPanel(Component parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.formatUtil = new FormatUtil(this);
        this.labVariant = new KDLabel();
        this.cmbVariant = new KDComboBox();
        this.labFormat = new KDLabel();
        this.f7Format = new KDPromptBox();
        this.setLayout(null);
        this.add((Component)this.labVariant);
        this.add((Component)this.cmbVariant);
        this.add((Component)this.labFormat);
        this.add((Component)this.f7Format);
        this.labVariant.setText(VariantPropsPanel.getMLS("variantName", "\u53d8\u91cf\u540d"));
        this.labFormat.setText(VariantPropsPanel.getMLS("format", "\u683c\u5f0f"));
        this.labVariant.setUnderline(true);
        this.labFormat.setUnderline(true);
        this.labVariant.setBounds(10, 10, 80, 19);
        this.cmbVariant.setBounds(90, 10, 350, 19);
        this.labFormat.setBounds(10, 32, 80, 19);
        this.f7Format.setBounds(90, 32, 350, 19);
        this.ctrlList.add(this.cmbVariant);
        this.ctrlList.add(this.f7Format.getEditor());
        this.reactFocusPolicy();
        this.f7Format.setSelector((KDPromptSelector)this.formatUtil.getDialog());
        this.f7Format.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                VariantPropsPanel.this.formatUtil.formulaDialogWillShow(VariantPropsPanel.this.f7Format);
            }
        });
        this.f7Format.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (VariantPropsPanel.this.curRE != null) {
                    ((VariantElement)VariantPropsPanel.this.curRE).setFormat(VariantPropsPanel.this.f7Format.getText());
                } else if (VariantPropsPanel.this.resList != null) {
                    Iterator it = VariantPropsPanel.this.resList.iterator();
                    while (it.hasNext()) {
                        ((VariantElement)it.next()).setFormat(VariantPropsPanel.this.f7Format.getText());
                    }
                }
            }
        });
        this.cmbVariant.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!VariantPropsPanel.this.fireVariantComboBox) {
                    return;
                }
                Object objSelected = VariantPropsPanel.this.cmbVariant.getSelectedItem();
                if (objSelected == null) {
                    return;
                }
                String value = ((VariantElement.Variant)objSelected).getName();
                if (VariantPropsPanel.this.curRE != null) {
                    ((VariantElement)VariantPropsPanel.this.curRE).setVariant(value);
                } else if (VariantPropsPanel.this.resList != null) {
                    Iterator it = VariantPropsPanel.this.resList.iterator();
                    while (it.hasNext()) {
                        ((VariantElement)it.next()).setVariant(value);
                    }
                }
                VariantPropsPanel.this.repaintElement();
            }
        });
        this.fireVariantComboBox = false;
        VariantElement.Variant var = new VariantElement.Variant("");
        this.cmbVariant.addItem((Object)var);
        VariantElement.getVariantSupply().put(var.getName(), var);
        this.fireVariantComboBox = true;
        this.prepareDefaultCtrlValue();
    }

    @Override
    public void setSelectElement(ReportElement re) {
        this.setCurRE(re);
        this.fireVariantComboBox = false;
        this.cmbVariant.setSelectedIndex(0);
        this.fireVariantComboBox = true;
        VariantElement.Variant v = ((VariantElement)re).getVariant();
        if (v == null) {
            this.cmbVariant.setSelectedItem(null);
        } else {
            this.cmbVariant.setSelectedItem((Object)v);
        }
        this.f7Format.setText(((VariantElement)re).getFormat());
    }

    @Override
    public void setSelectElement(ArrayList res) {
        this.setResList(res);
        VariantElement re0 = (VariantElement)res.get(0);
        VariantElement.Variant variant = re0.getVariant();
        String format = re0.getFormat();
        boolean isVariantSame = true;
        boolean isFormatSame = true;
        for (VariantElement re : this.resList) {
            if (isVariantSame && variant != null && !variant.equals(re.getVariant())) {
                isVariantSame = false;
            }
            if (!isFormatSame || StringUtil.equals((String)format, (String)re.getFormat())) continue;
            isFormatSame = false;
        }
        if (isVariantSame) {
            this.cmbVariant.setSelectedItem((Object)variant);
        } else {
            this.cmbVariant.setSelectedItem(null);
        }
        if (isFormatSame) {
            this.f7Format.setText(format);
        } else {
            this.f7Format.setText("");
        }
    }

    private void prepareDefaultCtrlValue() {
        File confFile = null;
        try {
            confFile = GlobalLocator.getInstance().locateResourceFile("/client/KDNoteVariant.xml");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        if (confFile != null) {
            Element root = null;
            try {
                root = XmlUtil.loadXmlFile((File)confFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            this.addSupplyFormXml(root);
        }
    }

    public void prepareCtrlValue(byte[] filedata) {
        Element root = null;
        try {
            root = XmlUtil.loadXmlBytes((byte[])filedata);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        this.addSupplyFormXml(root);
    }

    private void addSupplyFormXml(Element root) {
        this.fireVariantComboBox = false;
        if (root != null && "VariantSupplier".equalsIgnoreCase(root.getName())) {
            for (Element node : root.getChildren("Variant")) {
                String name = node.getAttributeValue("name");
                String alias = LangUtil.getAttrValue((Element)node, (String)"alias");
                VariantElement.Variant var = new VariantElement.Variant(name, alias);
                this.cmbVariant.addItem((Object)var);
                VariantElement.getVariantSupply().put(var.getName(), var);
            }
        }
        this.fireVariantComboBox = true;
    }
}

