/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.LinkedList;

public class CustomFocusTraversalPolicy
extends FocusTraversalPolicy {
    private LinkedList componentsList = new LinkedList();
    private Component defaultComponent = null;

    public void setComponentsList(LinkedList list) {
        this.componentsList = list;
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        if (this.defaultComponent == null) {
            return this.getFirstComponent(focusCycleRoot);
        }
        return this.defaultComponent;
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        Component c = this.getComponent(this.componentsList.getFirst());
        if (!c.isVisible() || !c.isEnabled()) {
            return this.getComponentAfter(focusCycleRoot, c);
        }
        return c;
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        Component c = this.getComponent(this.componentsList.getLast());
        if (!c.isVisible() || !c.isEnabled()) {
            return this.getComponentBefore(focusCycleRoot, c);
        }
        return c;
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        Component c;
        int idx = this.componentsList.indexOf(aComponent);
        if (idx == this.componentsList.size() - 1) {
            idx = -1;
        }
        if (!(c = this.getComponent(this.componentsList.get(idx + 1))).isVisible() || !c.isEnabled()) {
            return this.getComponentAfter(focusCycleRoot, c);
        }
        return c;
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        Component c;
        int idx = this.componentsList.indexOf(aComponent);
        if (idx <= 0) {
            idx = this.componentsList.size();
        }
        if (!(c = this.getComponent(this.componentsList.get(idx - 1))).isVisible() || !c.isEnabled()) {
            return this.getComponentBefore(focusCycleRoot, c);
        }
        return c;
    }

    private Component getComponent(Object o) {
        if (o instanceof Component) {
            return (Component)o;
        }
        return null;
    }
}

