/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.util;

import java.text.DecimalFormatSymbols;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberDocument
extends PlainDocument {
    private char groupingSeparator = (char)44;
    private char decimalSeparator = (char)46;
    private boolean bEx;
    private boolean isEnableNegative = false;

    public NumberDocument() {
        this(false);
    }

    public NumberDocument(boolean bEx) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        this.groupingSeparator = dfs.getGroupingSeparator();
        this.decimalSeparator = dfs.getDecimalSeparator();
    }

    public void setEx(boolean bEx) {
        this.bEx = bEx;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (proposedResult.equals("*") && this.bEx) {
            super.insertString(offs, str, a);
        } else if (this.isEnableNegative && proposedResult.equals("-")) {
            super.insertString(offs, str, a);
        } else {
            proposedResult = proposedResult.replaceAll("\\" + this.groupingSeparator + "", "");
            proposedResult = proposedResult.replace(this.decimalSeparator, '.');
            try {
                Double.parseDouble(proposedResult);
                super.insertString(offs, str, a);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        block5: {
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(len + offs, currentText.length());
            String proposedResult = beforeOffset + afterOffset;
            proposedResult = proposedResult.replaceAll("\\" + this.groupingSeparator + "", "");
            if ((proposedResult = proposedResult.replace(this.decimalSeparator, '.')).endsWith("*") && this.bEx) {
                super.remove(offs, len);
            } else {
                try {
                    if (proposedResult.length() != 0) {
                        Double.parseDouble(proposedResult);
                    }
                    super.remove(offs, len);
                }
                catch (NumberFormatException e) {
                    if (!proposedResult.equals("-")) break block5;
                    super.remove(offs, len);
                }
            }
        }
    }

    public boolean isEnableNegative() {
        return this.isEnableNegative;
    }

    public void setEnableNegative(boolean isEnableNegative) {
        this.isEnableNegative = isEnableNegative;
    }
}

