/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.wizard;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.fd2.SideLocation;
import com.kingdee.bos.ctrl.kdf.fd2.gui.FormDesigner;
import com.kingdee.bos.ctrl.kdf.fd2.gui.KDFFrame;
import com.kingdee.bos.ctrl.kdf.fd2.gui.wizard.NormalStep1;
import com.kingdee.bos.ctrl.kdf.fd2.gui.wizard.NormalStep2;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.FieldElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.FormulaElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.LoopArea;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.StaticTextElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Table;
import com.kingdee.bos.ctrl.kdf.fd2.util.DataUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.LinkedList;

public class ReportWizardDialog
extends WizardDialog {
    private FormDesigner designer;
    private ReportElement targetParent;
    private NormalStep1 step1;
    private NormalStep2 step2;
    private String res = CtrlClassUtil.getPackageName(((Object)((Object)this)).getClass()) + ".wizard";

    public ReportWizardDialog(Frame owner, FormDesigner designer) {
        super(owner);
        this.designer = designer;
        this.init();
    }

    public ReportWizardDialog(Dialog owner, FormDesigner designer) {
        super(owner);
        this.designer = designer;
        this.init();
    }

    private void init() {
        KDFFrame frame = this.designer.getKDFFrame();
        if (frame == null) {
            return;
        }
        this.targetParent = frame.getSelectedElements().size() == 0 ? frame.getCurrentPage() : (ReportElement)frame.getSelectedElements().get(0);
        this.step1 = new NormalStep1();
        this.step2 = new NormalStep2();
        this.step1.setTargetParent(this.targetParent);
        DataUtil.updataQueryTree(this.designer.getKDFFrame(), this.step2.getQueryTree());
        LinkedList<KDPanel> list = new LinkedList<KDPanel>();
        list.add(this.step1);
        list.add(this.step2);
        this.setStepsList(list);
        this.setBigSize(true);
        this.setTitle(this.getMLS2("wizardTitle", "\u62a5\u8868\u5411\u5bfc"), true);
        this.setModal(true);
    }

    public void createReportStructrue() {
        int height;
        if (!this.isFinished()) {
            return;
        }
        KDFFrame frame = this.designer.getKDFFrame();
        if (frame == null) {
            return;
        }
        IContainer parent = (IContainer)((Object)this.targetParent);
        int colsCount = this.step2.getSelectedQuery().getColsCount();
        if (colsCount == 0) {
            return;
        }
        MetaClass scm = this.step2.getSelectedQuery().getQuery();
        Object[] cols = this.step2.getSelectedQuery().getColumns();
        boolean isNeedItemNum = this.step1.isNeedItemNum();
        boolean isNeedTableHead = this.step1.isNeedTableHead();
        boolean isNeedNextLoop = this.step1.isNeedNextLoop();
        int n = height = parent.getHeightLom() > 400 ? 100 : parent.getHeightLom() / 4;
        if (isNeedItemNum) {
            ++colsCount;
        }
        if (isNeedTableHead) {
            StaticTextElement text;
            Table tableHead = (Table)frame.insertReportElement(parent, 10, -1, -1);
            tableHead.setRowCount(1);
            tableHead.setColumnCount(colsCount);
            tableHead.getLocation().getSideLocation(3).setValue(height);
            if (isNeedItemNum) {
                text = (StaticTextElement)frame.insertReportElement(tableHead, 3, -1, -1);
                text.setText("No.");
            }
            for (int i = 0; i < cols.length; ++i) {
                text = (StaticTextElement)frame.insertReportElement(tableHead, 3, -1, -1);
                text.setText(((MetaField)cols[i]).getAlias());
            }
            tableHead.setLocation(tableHead.getLocation());
        }
        LoopArea loopArea = (LoopArea)frame.insertReportElement(parent, 11, -1, -1);
        Table tableGroup = (Table)frame.insertReportElement(loopArea, 10, -1, -1);
        if (isNeedNextLoop) {
            loopArea.setNextLoopArea(loopArea);
        }
        if (isNeedTableHead) {
            loopArea.getLocation().getSideLocation(2).setValue(height);
        }
        loopArea.getLocation().getSideLocation(3).setValue(height * 3);
        loopArea.setLocation(loopArea.getLocation());
        tableGroup.setDataSource(scm.getName());
        tableGroup.setRowCount(1);
        tableGroup.setColumnCount(colsCount);
        SideLocation left = tableGroup.getLocation().getSideLocation(0);
        SideLocation right = tableGroup.getLocation().getSideLocation(1);
        SideLocation top = tableGroup.getLocation().getSideLocation(2);
        SideLocation bottom = tableGroup.getLocation().getSideLocation(3);
        left.setType(0);
        left.setRelativeObjectID(loopArea.getName());
        left.setContextValue(0);
        left.setValue(0);
        right.setType(0);
        right.setRelativeObjectID(loopArea.getName());
        right.setContextValue(1);
        right.setValue(0);
        top.setType(0);
        top.setRelativeObjectID(loopArea.getName());
        top.setContextValue(2);
        top.setValue(0);
        bottom.setType(0);
        bottom.setRelativeObjectID(tableGroup.getName());
        bottom.setContextValue(2);
        bottom.setValue(height);
        tableGroup.setLocation(tableGroup.getLocation());
        if (isNeedItemNum) {
            FormulaElement formula = (FormulaElement)frame.insertReportElement(tableGroup, 13, -1, -1);
            formula.setFormula("$ROWNO");
        }
        for (int i = 0; i < cols.length; ++i) {
            FieldElement field = (FieldElement)frame.insertReportElement(tableGroup, 4, -1, -1);
            field.setField((MetaField)cols[i]);
        }
        frame.setSelectedElement(loopArea);
    }

    private String getMLS2(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)this.res, (String)defaultValue);
    }
}

