/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.reportelement;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractGroup;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.TextElement;

public class FieldElement
extends TextElement {
    private int fieldType;
    private boolean isPhoto;
    private String strFieldAlias;
    private String fieldID;
    private String format;
    public static final int NORMALFIELD = 0;
    public static final int GROUPFIELD = 1;
    public static final int GROUPTOTAL = 2;
    public static final int AREATOTAL = 3;
    private static final String defaultText = "";
    private int scale = 0;

    public FieldElement(String name, int x, int y, int width, int height) {
        super(name, x, y, width, height);
        this.setText(defaultText);
        this.fieldType = 0;
        this.isPhoto = false;
        this.eletype = 4;
    }

    @Override
    public ReportElement cloneMe() {
        FieldElement newReportElement = new FieldElement(this.name, 0, 0, this.width, this.height);
        newReportElement.fieldType = this.fieldType;
        newReportElement.isPhoto = this.isPhoto;
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int fieldType) {
        this.fieldType = fieldType;
        this.firePropertyChange(null);
    }

    public boolean isPhoto() {
        return this.isPhoto;
    }

    public void setPhoto(boolean isPhoto) {
        this.isPhoto = isPhoto;
        this.firePropertyChange(null);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.firePropertyChange(null);
    }

    public String getFieldAlias() {
        return this.strFieldAlias;
    }

    public void setFieldAlias(String fieldAlias) {
        this.strFieldAlias = fieldAlias;
        if (StringUtil.isEmptyString((String)this.strFieldAlias)) {
            this.setText(defaultText);
        } else {
            this.setText(this.strFieldAlias);
        }
    }

    public void setField(MetaField qryCln) {
        if (qryCln == null) {
            this.setFieldAlias(defaultText);
            this.setFieldID(defaultText);
        } else {
            this.setFieldAlias(qryCln.getAliasName());
            this.setFieldID(qryCln.getName());
        }
    }

    public void setFieldID(String id) {
        this.fieldID = id;
    }

    public String getFieldID() {
        return this.fieldID;
    }

    public String getNearDataSource() {
        IContainer parent = this.getParent();
        while (!(parent instanceof Page)) {
            if (parent instanceof AbstractGroup && !StringUtil.isEmptyString((String)((AbstractGroup)parent).getDataSource())) {
                return ((AbstractGroup)parent).getDataSource();
            }
            parent = parent.getParent();
        }
        return ((Page)parent).getDataSource();
    }

    @Override
    public void setText(String text) {
        super.setText("$F{" + text + "}");
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }
}

