/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.impl;

import com.kingdee.bos.ctrl.kdf.data.DataSetVisitor;
import com.kingdee.bos.ctrl.kdf.data.exception.DataSetWrapperException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public final class CsvDataSetVisitor
implements DataSetVisitor {
    private BufferedReader bReader;
    private String[] data = new String[0];
    private String[] fields = new String[0];
    private int recCount = 0;
    private int currentPos = -1;
    private boolean shrinkMode;
    private boolean linkMode;
    private char separator = (char)44;
    private static final int BUFFER_LENGTH = 100;

    public boolean isLinkMode() {
        return this.linkMode;
    }

    public void setLinkMode(boolean linkMode) {
        this.linkMode = linkMode;
    }

    public boolean isShrinkMode() {
        return this.shrinkMode;
    }

    public void setShrinkMode(boolean shrinkMode) {
        this.shrinkMode = shrinkMode;
        this.linkMode = false;
    }

    public CsvDataSetVisitor() {
        this(false);
    }

    public CsvDataSetVisitor(boolean shrinkMode) {
        this.shrinkMode = shrinkMode;
    }

    @Override
    public boolean execute(String sName, String sQuery) throws DataSetWrapperException {
        try {
            String buf;
            this.bReader = this.linkMode ? new BufferedReader(new FileReader(FilenameUtils.normalize((String)sQuery))) : new BufferedReader(new StringReader(sQuery));
            if (this.bReader.ready() && (buf = this.bReader.readLine()) != null) {
                Pattern pat = Pattern.compile("\\" + this.separator);
                this.fields = pat.split(buf);
                int colCount = this.fields.length;
                int rowCount = 0;
                this.data = new String[100 * colCount];
                while ((buf = this.bReader.readLine()) != null) {
                    if (rowCount * colCount >= this.data.length) {
                        String[] nData = new String[this.data.length + 100 * colCount];
                        System.arraycopy(this.data, 0, nData, 0, this.data.length);
                        this.data = nData;
                    }
                    String[] vals = pat.split(buf);
                    if (vals.length < colCount) {
                        String[] tbuf = new String[colCount];
                        System.arraycopy(vals, 0, tbuf, 0, vals.length);
                        vals = tbuf;
                    }
                    System.arraycopy(vals, 0, this.data, rowCount * colCount, colCount);
                    ++rowCount;
                }
                this.recCount = rowCount;
                this.currentPos = -1;
                if (this.shrinkMode) {
                    this.data = this.shrinkData(this.data, this.recCount * colCount);
                }
            }
        }
        catch (IOException e) {
            throw new DataSetWrapperException(e);
        }
        return true;
    }

    private String[] shrinkData(String[] src, int desLength) {
        String[] out = new String[desLength];
        System.arraycopy(src, 0, out, 0, desLength);
        return out;
    }

    @Override
    public boolean next(ArrayList avOut) throws DataSetWrapperException {
        ++this.currentPos;
        avOut.clear();
        if (this.isValidRow()) {
            for (int i = 0; i < this.fields.length; ++i) {
                avOut.add(new Variant((Object)this.data[this.currentPos * this.fields.length + i], 11));
            }
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                avOut.add(new Variant());
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidRow() throws DataSetWrapperException {
        return this.currentPos < this.recCount && this.currentPos >= 0;
    }

    @Override
    public int getFieldCount() {
        return this.fields.length;
    }

    @Override
    public String[] getAllFieldName() {
        return this.fields;
    }

    @Override
    public int getRecordCount() {
        return this.recCount;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }
}

