/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.pool;

import com.kingdee.bos.ctrl.kdf.data.pool.Cache;
import com.kingdee.bos.ctrl.kdf.data.pool.DataPoolProperties;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class IOCache
implements Cache {
    private String ext = ".dat";
    private String filepath = null;
    private DataPoolProperties prop = DataPoolProperties.getInstance();

    public IOCache() {
        this.filepath = this.prop.getFilePath() + File.separator + "pool";
        File f = new File(FilenameUtils.normalize((String)this.filepath));
        if (!f.exists()) {
            f.mkdir();
        }
        f = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addBlock(int taskID, int blockID, byte[] block) {
        String pathname = this.filepath + File.separator + taskID;
        String filename = pathname + File.separator + blockID + this.ext;
        FileOutputStream fos = null;
        try {
            this.createTaskPath(pathname);
            this.createBlockFile(filename);
            fos = new FileOutputStream(new File(filename));
            fos.write(block);
        }
        catch (SecurityException securityException) {
            CloseUtil.close((Closeable[])new Closeable[]{fos});
            return;
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                {
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{fos});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{fos});
                return;
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    CloseUtil.close((Closeable[])new Closeable[]{fos});
                    return;
                }
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fos});
        return;
    }

    private void createBlockFile(String filename) throws IOException, SecurityException {
        File f = new File(filename);
        if (!f.exists()) {
            f.createNewFile();
        }
        f = null;
    }

    private void createTaskPath(String pathname) throws SecurityException {
        File f = new File(pathname);
        if (!f.exists()) {
            f.mkdir();
        }
        f = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    @Override
    public byte[] getBlock(int taskID, int blockID) {
        byte[] byArray;
        String pathname = this.filepath + File.separator + taskID;
        String filename = pathname + File.separator + blockID + this.ext;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filename));
            int i = fis.available();
            byte[] b = new byte[i];
            fis.read(b);
            byArray = b;
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            CloseUtil.close((Closeable[])new Closeable[]{fis});
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            {
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{fis});
                    throw throwable;
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{fis});
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        return byArray;
        return new byte[0];
    }

    @Override
    public boolean remove() {
        boolean result = true;
        File f = new File(this.filepath);
        if (f.exists()) {
            String[] s = f.list();
            for (int i = 0; i < s.length; ++i) {
                result = this.removeTask(Integer.parseInt(s[i]));
            }
        }
        return result;
    }

    @Override
    public boolean removeBlock(int taskID, int blockID) {
        boolean result = true;
        String pathname = this.filepath + File.separator + taskID;
        String filename = pathname + File.separator + blockID + this.ext;
        File f = new File(filename);
        if (f.exists()) {
            result = f.delete();
        }
        return result;
    }

    @Override
    public boolean removeTask(int taskID) {
        boolean result = true;
        String pathname = this.filepath + File.separator + taskID;
        File f = new File(FilenameUtils.normalize((String)pathname));
        if (f.exists()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
            result = f.delete();
        }
        return result;
    }

    @Override
    public void addTask(int taskID) {
    }

    @Override
    public void updateTask(int taskID) {
    }

    @Override
    public void updateBlock(int taskID, int blockID, byte[] block) {
    }
}

