/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.kdf.data.util.KDMXmlOperator;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.IQuery;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.FilenameUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class BOSMetaData2KDM {
    protected KDMXmlOperator xmlHandler;
    public static final String TABLE_TYPE_BOS_ENTITY = "entity";
    public static final String TABLE_TYPE_BOS_QUERY = "query";

    public BOSMetaData2KDM() {
    }

    public BOSMetaData2KDM(String fileName) throws FileNotFoundException {
        this.xmlHandler = new KDMXmlOperator(new File(fileName));
    }

    public BOSMetaData2KDM(Reader reader) {
        this.xmlHandler = new KDMXmlOperator(reader);
    }

    public BOSMetaData2KDM(InputStream stream) {
        this.xmlHandler = new KDMXmlOperator(stream);
    }

    public BOSMetaData2KDM(File file) throws FileNotFoundException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.xmlHandler = new KDMXmlOperator(fis);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
    }

    public KDMXmlOperator getXmlHandler() {
        if (this.xmlHandler == null) {
            this.xmlHandler = new KDMXmlOperator();
        }
        return this.xmlHandler;
    }

    private String login(String url, LoginContext ctx) {
        ORMRPCServiceLocator.setCurrentServiceURL((String)url);
        try {
            ILoginModule login = LoginModuleFactory.getRemoteInstance();
            return login.login(ctx);
        }
        catch (BOSLoginException err) {
            err.printStackTrace();
        }
        catch (BOSException err) {
            err.printStackTrace();
        }
        return null;
    }

    public void parseOnline(String url, LoginContext ctx) {
        if (this.login(url, ctx) != null) {
            String dbName = "MetaData_" + url;
            Element nodeDB = this.createEmptyMetaDBNode(dbName);
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            Iterator iterEntity = loader.getCollection(MetaDataTypeList.ENTITY).iterator();
            this.parseEntities(iterEntity, nodeDB);
            Iterator iterQuery = loader.getQueryCollection().iterator();
            this.parseQueries(iterQuery, nodeDB);
        }
    }

    public void parseOffline(String metaRootPath) {
        File root = new File(FilenameUtils.normalize((String)metaRootPath));
        if (!root.exists()) {
            return;
        }
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)metaRootPath);
        try {
            IEntityObjectCtrl entityCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.ENTITY);
            IQuery queryCtrl = (IQuery)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.BASEQUERY);
            ArrayList entl = new ArrayList();
            ArrayList qurl = new ArrayList();
            this.filterData(true, root, entl, qurl, entityCtrl, queryCtrl, "", ctx);
            String dbName = "MetaData_" + metaRootPath;
            Element nodeDB = this.createEmptyMetaDBNode(dbName);
            this.parseEntities(entl.iterator(), nodeDB);
            this.parseQueries(qurl.iterator(), nodeDB);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void filterData(boolean ignoreRootPath, File root, ArrayList entites, ArrayList querys, IEntityObjectCtrl ectrl, IQuery qctrl, String rootPath, Context ctx) {
        if (root.isDirectory()) {
            File[] files = root.listFiles();
            if (!ignoreRootPath) {
                rootPath = rootPath + root.getName() + ".";
            }
            for (int i = 0; i < files.length; ++i) {
                this.filterData(false, files[i], entites, querys, ectrl, qctrl, rootPath, ctx);
            }
            return;
        } else {
            try {
                String fileName = root.getName();
                if (fileName.endsWith(".entity")) {
                    int i = fileName.lastIndexOf(46);
                    String fullname = rootPath + root.getName().substring(0, i);
                    EntityObjectInfo entity = ectrl.getValue((IMetaDataPK)new MetaDataPK(fullname));
                    entites.add(entity);
                    return;
                }
                if (!fileName.endsWith(".query")) return;
                int i = fileName.lastIndexOf(46);
                String fullname = rootPath + root.getName().substring(0, i);
                QueryInfo query = qctrl.getValue((IMetaDataPK)new MetaDataPK(fullname));
                querys.add(query);
                return;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    protected void parseEntities(Iterator iter, Element nodeDB) {
        Element nodeTables = this.getNodeTables(nodeDB);
        while (iter.hasNext()) {
            EntityObjectInfo entity = (EntityObjectInfo)iter.next();
            Element nodeTable = new Element("Table", nodeTables.getNamespace());
            this.parseEntity(entity, nodeTable);
            nodeTables.addContent((Content)nodeTable);
        }
    }

    protected void parseEntity(EntityObjectInfo entity, Element nodeTable) {
        this.addSubToNode(nodeTable, "Name", entity.getFullName());
        this.addSubToNode(nodeTable, "Alias", entity.getAlias());
        this.addSubToNode(nodeTable, "Description", entity.getDescription());
        this.addAttributeToNode(nodeTable, "type", TABLE_TYPE_BOS_ENTITY);
        this.addAttributeToNode(nodeTable, "bosType", entity.getBOSType().toString());
        this.addAttributeToNode(nodeTable, "packName", entity.getPackage());
        this.addAttributeToNode(nodeTable, "name", entity.getName());
        Element nodeFields = this.getSubNode(nodeTable, "Fields");
        for (PropertyInfo info : entity.getProperties()) {
            this.parseNodeField(nodeFields, entity, info);
        }
    }

    protected void parseNodeField(Element nodeFields, EntityObjectInfo entity, PropertyInfo info) {
        Element nodeField = new Element("Field", nodeFields.getNamespace());
        if (info instanceof LinkPropertyInfo) {
            LinkPropertyInfo lkInfo = (LinkPropertyInfo)info;
            EntityObjectInfo entityInfo = lkInfo.getRelationship().getSupplierObject();
            if (entityInfo.getLogicalKey() != null) {
                for (PropertyInfo keyInfo : entityInfo.getLogicalKey().getKeyPropertys()) {
                    this.parseNodeField(nodeFields, entityInfo, keyInfo);
                }
            }
        } else {
            this.addSubToNode(nodeField, "Name", this.getFullName(entity.getName(), info.getName()));
            this.addSubToNode(nodeField, "Alias", this.getFullName(entity.getAlias(), info.getAlias()));
            this.addSubToNode(nodeField, "Description", info.getDescription());
        }
        nodeFields.addContent((Content)nodeField);
    }

    protected String getFullName(String parentName, String name) {
        if (name == null) {
            return null;
        }
        if (parentName == null) {
            return name;
        }
        return parentName + "." + name;
    }

    protected Element addSubToNode(Element node, String name, String text, Namespace ns) {
        if (!this.isEmptyString(name) && !this.isEmptyString(text) && node != null) {
            Element nodeSub = new Element(name, ns);
            nodeSub.setText(text);
            node.addContent((Content)nodeSub);
            return nodeSub;
        }
        return null;
    }

    protected Element addSubToNode(Element node, String name, String text) {
        return this.addSubToNode(node, name, text, node.getNamespace());
    }

    protected void addAttributeToNode(Element node, String attr, String value) {
        if (!this.isEmptyString(value) && !this.isEmptyString(attr) && node != null) {
            node.setAttribute(attr, value);
        }
    }

    protected boolean isEmptyString(String value) {
        return value == null || value.equals("");
    }

    protected void parseQueries(Iterator iter, Element nodeDB) {
        Element nodeTables = this.getNodeTables(nodeDB);
        while (iter.hasNext()) {
            QueryInfo query = (QueryInfo)iter.next();
            Element nodeTable = new Element("Table", nodeTables.getNamespace());
            this.parseQuery(query, nodeTable);
            nodeTables.addContent((Content)nodeTable);
        }
    }

    protected void parseQuery(QueryInfo query, Element nodeTable) {
        this.addSubToNode(nodeTable, "Name", query.getFullName());
        this.addSubToNode(nodeTable, "Alias", query.getAlias());
        this.addSubToNode(nodeTable, "Description", query.getDescription());
        this.addAttributeToNode(nodeTable, "type", TABLE_TYPE_BOS_QUERY);
        this.addAttributeToNode(nodeTable, "bosType", query.getBOSType().toString());
        this.addAttributeToNode(nodeTable, "packName", query.getPackage());
        this.addAttributeToNode(nodeTable, "name", query.getName());
        Element nodeFields = this.getSubNode(nodeTable, "Fields");
        for (QueryFieldInfo info : query.getSelector().getFields()) {
            Element nodeField = new Element("Fields", nodeFields.getNamespace());
            this.parseNodeField(nodeField, info);
            nodeFields.addContent((Content)nodeField);
        }
    }

    protected void parseNodeField(Element nodeField, QueryFieldInfo info) {
        this.addSubToNode(nodeField, "Name", info.getName());
        this.addSubToNode(nodeField, "Alias", info.getDisplayName());
    }

    protected Element createEmptyMetaDBNode(String dbName) {
        Element nodeDB = new Element("DataBase", this.getXmlHandler().getRoot().getNamespace());
        Element nodeName = new Element("Name", nodeDB.getNamespace());
        nodeName.setText(dbName);
        nodeDB.addContent((Content)nodeName);
        this.getXmlHandler().getRoot().addContent((Content)nodeDB);
        return nodeDB;
    }

    protected Element getNodeTables(Element nodeDB) {
        return this.getSubNode(nodeDB, "Tables");
    }

    protected Element getSubNode(Element parent, String subName) {
        return this.getSubNode(parent, subName, parent.getNamespace());
    }

    protected Element getSubNode(Element parent, String subName, Namespace ns) {
        Element subnode = parent.getChild(subName, ns);
        if (null == subnode) {
            subnode = new Element(subName, ns);
            parent.addContent((Content)subnode);
        }
        return subnode;
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            BOSMetaData2KDM parser = new BOSMetaData2KDM();
            parser.parseOffline(args[0]);
            parser.getXmlHandler().save(args[1]);
        }
    }
}

