/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.util;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.bos.ctrl.kdf.data.query.KDBasicQuery;
import com.kingdee.bos.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.bos.ctrl.kdf.data.query.QueryDir;
import com.kingdee.bos.ctrl.kdf.data.util.MetaFileNotMatchingException;
import com.kingdee.bos.ctrl.kdf.data.wizard.KDDataManager;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdom2.Content;
import org.jdom2.Element;

public class DesignedDataUpgradeFromV1_1 {
    private String kdmFile;
    private DataSource[] dataSources;
    private HashMap allMetaTable;
    private HashMap allMetaField;
    private QueryDir sysQueryDir;

    public DesignedDataUpgradeFromV1_1() {
    }

    public DesignedDataUpgradeFromV1_1(QueryDir sysQueryDir) {
        this.setSysQueryDir(sysQueryDir);
    }

    public boolean transer(String xmlFile, String saveFile) throws KDFException, MetaFileNotMatchingException {
        KDF kdfDom = null;
        try {
            kdfDom = new KDF(xmlFile, true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (null != kdfDom && this.transer(kdfDom)) {
            kdfDom.saveToFile(saveFile);
            return true;
        }
        return false;
    }

    public boolean transer(KDF kdfDom) throws KDFException, MetaFileNotMatchingException {
        if ("1.1".equals(kdfDom.getVersion())) {
            this.dataSources = kdfDom.getDataSources();
            Element designedForm = (Element)kdfDom.getForm("Form").getUserObject();
            if (designedForm == null) {
                throw new KDFException(this.getMLS("noDesignedForm", "KDF(V1.1)\u4e2d\u627e\u4e0d\u5230<DesignedForm>\u8282\u70b9\uff0c\u4e0d\u80fd\u6b63\u786e\u4ece1.1\u7248\u672c\u5347\u7ea7\u3002"));
            }
            Element qos = designedForm.getChild("QueryObjects", KDFXmlReader.NS_FORM);
            if (qos == null) {
                throw new KDFException(this.getMLS("noQueryObjects", "KDF(V1.1)\u4e2d\u627e\u4e0d\u5230\u6570\u636e\u6e90\u8bbe\u8ba1\u4fe1\u606f<QueryObjects>\u8282\u70b9\uff0c\u4e0d\u80fd\u6b63\u786e\u4ece1.1\u7248\u672c\u5347\u7ea7\u3002"));
            }
            Iterator it = qos.getChildren("QueryObject", KDFXmlReader.NS_FORM).iterator();
            while (it.hasNext()) {
                this.cacheAllSubQuerysAndField();
                Element qo = (Element)it.next();
                Element designedDS = this.parseQuery(qo);
                this.getDataSource(this.getChildText_Name(qo)).setUserObject(designedDS);
            }
            kdfDom.setVersion("3.101");
            return true;
        }
        return false;
    }

    private String getChildText_Name(Element node) {
        return node.getChildText("Name", KDFXmlReader.NS_FORM);
    }

    private String getChildText_Text(Element node) {
        return node.getChildText("Text", KDFXmlReader.NS_FORM);
    }

    private void cacheAllSubQuerysAndField() {
        this.allMetaTable = new HashMap();
        this.allMetaField = new HashMap();
        HashMap sysQuerys = this.sysQueryDir.getQueryMap();
        Iterator itQK = sysQuerys.keySet().iterator();
        while (itQK.hasNext()) {
            KDBasicQuery bQ = (KDBasicQuery)sysQuerys.get(itQK.next());
            this.allMetaTable.put(bQ.getName(), bQ.getID());
            StringBuffer tableName = new StringBuffer();
            tableName.append("[");
            tableName.append(bQ.getName());
            tableName.append("].[");
            for (QueryColumn field : bQ.getColumnList()) {
                StringBuffer fKey = new StringBuffer();
                StringBuffer fValue = new StringBuffer();
                fKey.append(tableName);
                fKey.append(field.getName());
                fKey.append("]");
                fValue.append(tableName);
                fValue.append(field.getFormula());
                fValue.append("]");
                this.allMetaField.put(fKey.toString(), fValue.toString());
            }
        }
    }

    private DataSource getDataSource(String id) {
        for (int i = 0; i < this.dataSources.length; ++i) {
            if (!this.dataSources[i].getID().equals(id)) continue;
            return this.dataSources[i];
        }
        return null;
    }

    private void transID(Element nodeOld, Element nodeNew) {
        String name = this.getChildText_Name(nodeOld);
        nodeNew.setAttribute("id", name);
        nodeNew.setAttribute("name", name);
    }

    private Element transFormula(String formula) {
        Element nodeFormula = new Element("Formula", KDFXmlReader.NS_COMMON);
        nodeFormula.setText(formula);
        return nodeFormula;
    }

    private Element transFormula4Sql(String formula4Sql) {
        Element nodeFormula4Sql = new Element("Formula4Sql", KDFXmlReader.NS_COMMON);
        nodeFormula4Sql.setText(formula4Sql);
        return nodeFormula4Sql;
    }

    public Element parseQuery(Element nodeQuery) throws MetaFileNotMatchingException {
        Element designedDS = new Element("DesignedDataSource", KDFXmlReader.NS_COMMON);
        this.transID(nodeQuery, designedDS);
        designedDS.setAttribute("queryType", String.valueOf(1));
        designedDS.setAttribute("objectClass", "KDQuery");
        designedDS.setAttribute("isLinked", "true");
        if ("custom".equalsIgnoreCase(nodeQuery.getAttributeValue("type"))) {
            designedDS.setAttribute("isSelfDefine", "true");
            designedDS.setAttribute("selfDefineSql", Base64.encodeString((String)this.getChildText_Text(nodeQuery)));
        } else {
            designedDS.setAttribute("isSelfDefine", "false");
        }
        designedDS.addContent((Content)this.parseColumns(nodeQuery));
        designedDS.addContent((Content)this.parseSubQuerys(nodeQuery));
        designedDS.addContent((Content)this.parseFilters(nodeQuery));
        designedDS.addContent((Content)this.parseJoins(nodeQuery));
        designedDS.addContent((Content)this.parseSorts(nodeQuery));
        designedDS.addContent((Content)this.parseGroup(nodeQuery));
        designedDS.addContent((Content)this.parseParams(nodeQuery));
        return designedDS;
    }

    private Element parseColumns(Element nodeQuery) {
        Element nodeCols = new Element("Columns", KDFXmlReader.NS_COMMON);
        Element nodeFields = nodeQuery.getChild("Fields", KDFXmlReader.NS_FORM);
        for (Element nodeField : nodeFields.getChildren("Field", KDFXmlReader.NS_FORM)) {
            Element nodeCol = new Element("Column", KDFXmlReader.NS_COMMON);
            this.transID(nodeField, nodeCol);
            String text = this.getChildText_Text(nodeField);
            String formula = this.replaceFieldsZh2En(text);
            nodeCol.addContent((Content)this.transFormula(text));
            nodeCol.addContent((Content)this.transFormula4Sql(formula));
            nodeCols.addContent((Content)nodeCol);
            int index = text.indexOf("].[");
            if (index == -1) continue;
            text = "[" + text.substring(index);
            this.allMetaField.put(text, formula);
        }
        return nodeCols;
    }

    private Element parseSubQuerys(Element nodeQuery) throws MetaFileNotMatchingException {
        Element nodeSubQs = new Element("SubQuerys", KDFXmlReader.NS_COMMON);
        Element nodeTables = nodeQuery.getChild("Tables", KDFXmlReader.NS_FORM);
        Iterator iter = nodeTables.getChildren("Table", KDFXmlReader.NS_FORM).iterator();
        String metaTableNotFound = "";
        while (iter.hasNext()) {
            Element nodeTable = (Element)iter.next();
            Element nodeSub = new Element("SubQuery", KDFXmlReader.NS_COMMON);
            this.transID(nodeTable, nodeSub);
            String tableAlias = this.getChildText_Name(nodeTable);
            Object tableName = this.allMetaTable.get(tableAlias);
            if (tableName == null) {
                metaTableNotFound = metaTableNotFound + "\r\n" + tableAlias;
            } else {
                nodeSub.setAttribute("subQueryID", tableName.toString());
            }
            nodeSubQs.addContent((Content)nodeSub);
        }
        if (!StringUtil.isEmptyString((String)metaTableNotFound)) {
            throw new MetaFileNotMatchingException(this.getMLS("noMetaTable", "\u5143\u6570\u636e\u6587\u4ef6\u4e2d\u627e\u4e0d\u5230\u8868: ") + metaTableNotFound + "\r\n" + this.getMLS("cannotUpgrade", "\u4e0d\u80fd\u6b63\u786e\u4eceV1.1\u7248\u672c\u5347\u7ea7\u3002"));
        }
        return nodeSubQs;
    }

    private Element parseFilters(Element nodeQuery) {
        Element nodeNewFilters = new Element("Filters", KDFXmlReader.NS_COMMON);
        Element nodeOldFilters = nodeQuery.getChild("Filters", KDFXmlReader.NS_FORM);
        Iterator iter = nodeOldFilters.getChildren("Filter", KDFXmlReader.NS_FORM).iterator();
        boolean isActive = true;
        while (iter.hasNext()) {
            Element nodeOldFilter = (Element)iter.next();
            Element nodeNewFilter = new Element("Filter", KDFXmlReader.NS_COMMON);
            this.transID(nodeOldFilter, nodeNewFilter);
            nodeNewFilter.setAttribute("active", isActive ? "true" : "false");
            isActive = false;
            String text = this.getChildText_Text(nodeOldFilter);
            String formula = this.replaceFieldsZh2En(text);
            nodeNewFilter.addContent((Content)this.transFormula(text));
            nodeNewFilter.addContent((Content)this.transFormula4Sql(formula));
            nodeNewFilters.addContent((Content)nodeNewFilter);
        }
        return nodeNewFilters;
    }

    private Element parseJoins(Element nodeQuery) {
        Element nodeNewJoins = new Element("Joins", KDFXmlReader.NS_COMMON);
        Element nodeOldJoins = nodeQuery.getChild("Joins", KDFXmlReader.NS_FORM);
        for (Element nodeOldJoin : nodeOldJoins.getChildren("Join", KDFXmlReader.NS_FORM)) {
            Element nodeNewJoin = new Element("Join", KDFXmlReader.NS_COMMON);
            this.transID(nodeOldJoin, nodeNewJoin);
            Element tableLR = nodeOldJoin.getChild("TableLR", KDFXmlReader.NS_FORM);
            String opr = tableLR.getAttributeValue("operator");
            int type = 0;
            if ("LEFT JOIN".equals(opr)) {
                type = 1;
            } else if ("RIGHT JOIN".equals(opr)) {
                type = 2;
            }
            nodeNewJoin.setAttribute("type", String.valueOf(type));
            String firstTableID = tableLR.getChildText("TableL", KDFXmlReader.NS_FORM);
            nodeNewJoin.setAttribute("firstTableID", firstTableID);
            String secondTableID = tableLR.getChildText("TableR", KDFXmlReader.NS_FORM);
            nodeNewJoin.setAttribute("secondTableID", secondTableID);
            nodeNewJoin.setAttribute("active", "true");
            String text = this.getChildText_Text(nodeOldJoin);
            int formulaStart = text.indexOf(" ON ");
            String formula = this.replaceFieldsZh2En(text.substring(formulaStart + 4));
            nodeNewJoin.addContent((Content)this.transFormula(text));
            nodeNewJoin.addContent((Content)this.transFormula4Sql(formula));
            nodeNewJoins.addContent((Content)nodeNewJoin);
        }
        return nodeNewJoins;
    }

    private Element parseSorts(Element nodeQuery) {
        Element nodeSorts = new Element("Sorts", KDFXmlReader.NS_COMMON);
        Element nodeOrders = nodeQuery.getChild("Orders", KDFXmlReader.NS_FORM);
        Iterator iter = nodeOrders.getChildren("Order", KDFXmlReader.NS_FORM).iterator();
        boolean isActive = true;
        while (iter.hasNext()) {
            Element nodeOrder = (Element)iter.next();
            Element nodeSort = new Element("Sort", KDFXmlReader.NS_COMMON);
            this.transID(nodeOrder, nodeSort);
            nodeSort.setAttribute("active", isActive ? "true" : "false");
            isActive = false;
            Element nodeByFields = nodeOrder.getChild("ByFields", KDFXmlReader.NS_FORM);
            for (Element nodeByField : nodeByFields.getChildren("ByField", KDFXmlReader.NS_FORM)) {
                Element nodeSortItem = new Element("SortItem", KDFXmlReader.NS_COMMON);
                this.transID(nodeByField, nodeSortItem);
                String desc = nodeByField.getAttributeValue("order");
                nodeSortItem.setAttribute("desc", "ASC".equals(desc) ? "false" : "true");
                String text = this.getChildText_Text(nodeByField);
                String formula = this.replaceFieldsZh2En(text);
                nodeSortItem.addContent((Content)this.transFormula(text));
                nodeSortItem.addContent((Content)this.transFormula4Sql(formula));
                int s = text.indexOf("].[");
                nodeSortItem.setAttribute("columnID", text.substring(s + 3, text.length() - 1));
                nodeSort.addContent((Content)nodeSortItem);
            }
            nodeSorts.addContent((Content)nodeSort);
        }
        return nodeSorts;
    }

    private Element parseGroup(Element nodeQuery) {
        Element nodeNewGroups = new Element("Group", KDFXmlReader.NS_COMMON);
        Element nodeOldGroups = nodeQuery.getChild("Groups", KDFXmlReader.NS_FORM);
        for (Element nodeOldGroup : nodeOldGroups.getChildren("Group", KDFXmlReader.NS_FORM)) {
            Element nodeNewItem = new Element("GroupItem", KDFXmlReader.NS_COMMON);
            this.transID(nodeOldGroup, nodeNewItem);
            String text = this.getChildText_Text(nodeOldGroup);
            String colID = text.substring(1, text.length() - 1);
            nodeNewItem.setAttribute("columnID", colID);
            String desc = nodeOldGroup.getAttributeValue("order");
            nodeNewItem.setAttribute("desc", "ASC".equals(desc) ? "false" : "true");
            nodeNewGroups.addContent((Content)nodeNewItem);
        }
        return nodeNewGroups;
    }

    private Element parseParams(Element nodeQuery) {
        Element nodeOldParam;
        Element nodeNewParams = new Element("Params", KDFXmlReader.NS_COMMON);
        Element nodeOldParams = nodeQuery.getChild("Parameters", KDFXmlReader.NS_FORM);
        Iterator iter = nodeOldParams.getChildren("Parameter", KDFXmlReader.NS_FORM).iterator();
        if (iter.hasNext() && "associate".equals((nodeOldParam = (Element)iter.next()).getAttributeValue("source"))) {
            Element nodeNewParam = new Element("Param", KDFXmlReader.NS_COMMON);
            this.transID(nodeOldParam, nodeNewParam);
            nodeNewParam.setAttribute("active", "true");
            nodeNewParam.setAttribute("binding", "true");
            String dataType = nodeOldParam.getAttributeValue("dataType");
            nodeNewParam.setAttribute("typeName", dataType);
            String colID = nodeOldParam.getChildText("Field", KDFXmlReader.NS_FORM);
            nodeNewParam.setAttribute("columnID", colID);
            String id = this.getChildText_Name(nodeOldParam);
            for (DSParam dsParam : this.getDataSource(this.getChildText_Name(nodeQuery)).getParams()) {
                if (!dsParam.getColName().equals(id)) continue;
                String subTableID = dsParam.getAssociateSource();
                nodeNewParam.setAttribute("subTableID", subTableID);
                String subColID = dsParam.getAssociateField();
                nodeNewParam.setAttribute("subColumnID", subColID);
                break;
            }
            nodeNewParams.addContent((Content)nodeNewParam);
        }
        return nodeNewParams;
    }

    public void showFrame() {
        final JFrame frame = new JFrame("KDF DesignedDataSource translator (from V1.1)");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        final DefaultListModel listModel = new DefaultListModel();
        JButton btnKDM = new JButton("KDM");
        JButton btnAdd = new JButton("Add");
        JButton btnDel = new JButton("Del");
        JButton btnTra = new JButton("Translate");
        JButton btnEnd = new JButton("End");
        final JTextField txtKDM = new JTextField(28);
        final JList lstFile = new JList(listModel);
        txtKDM.setEditable(false);
        JPanel panTop = new JPanel();
        panTop.add(btnKDM);
        panTop.add(txtKDM);
        JPanel panBtm = new JPanel();
        panBtm.add(btnAdd);
        panBtm.add(btnDel);
        panBtm.add(btnTra);
        panBtm.add(btnEnd);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)panTop, "North");
        frame.getContentPane().add((Component)new JScrollPane(lstFile), "Center");
        frame.getContentPane().add((Component)panBtm, "South");
        btnKDM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                jfc.setDialogType(0);
                jfc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String filename = file.getName();
                        if (file.isDirectory()) {
                            return true;
                        }
                        if (filename.length() > 4) {
                            String ext = filename.substring(filename.length() - 4);
                            return ext.equalsIgnoreCase(".xml");
                        }
                        return false;
                    }

                    @Override
                    public String getDescription() {
                        return "XML";
                    }
                });
                if (jfc.showOpenDialog(frame) == 0) {
                    DesignedDataUpgradeFromV1_1.this.kdmFile = jfc.getSelectedFile().toString();
                    txtKDM.setText(DesignedDataUpgradeFromV1_1.this.kdmFile);
                    KDDataManager dataManager = new KDDataManager();
                    dataManager.setMetaFile(DesignedDataUpgradeFromV1_1.this.kdmFile);
                    DesignedDataUpgradeFromV1_1.this.setSysQueryDir(dataManager.getDirSystem());
                }
            }
        });
        btnEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                jfc.setMultiSelectionEnabled(true);
                jfc.setDialogType(0);
                jfc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String filename = file.getName();
                        if (file.isDirectory()) {
                            return true;
                        }
                        if (filename.length() > 4) {
                            String ext = filename.substring(filename.length() - 4);
                            return ext.equalsIgnoreCase(".kdf");
                        }
                        return false;
                    }

                    @Override
                    public String getDescription() {
                        return "KDF";
                    }
                });
                if (jfc.showOpenDialog(frame) == 0) {
                    File[] files = jfc.getSelectedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        listModel.addElement(files[i]);
                    }
                }
            }
        });
        btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] sel = lstFile.getSelectedIndices();
                for (int i = sel.length - 1; i >= 0; --i) {
                    listModel.remove(sel[i]);
                }
            }
        });
        btnTra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmptyString((String)txtKDM.getText()) || listModel.size() == 0) {
                    return;
                }
                for (int i = 0; i < listModel.size(); ++i) {
                    String f = listModel.get(i).toString();
                    String newF = f.substring(0, f.length() - 4) + "_V31.kdf";
                    try {
                        if (DesignedDataUpgradeFromV1_1.this.transer(f, newF)) {
                            WindowUtil.msgboxInfo((Object)(f + " ==> " + newF + "\r\n Translation has complated successfully."), (String)"Prompt", (Component)frame);
                            continue;
                        }
                        WindowUtil.msgboxInfo((Object)(f + "\r\n Version is not 1.1 or Designed Infomation are incorrect.\r\n Do nothing."), (String)"Prompt", (Component)frame);
                        continue;
                    }
                    catch (KDFException e1) {
                        WindowUtil.msgboxInfo((Object)(f + "\r\n" + e1.getMessage() + "\r\n translate faild."), (String)"Prompt", (Component)frame);
                        e1.printStackTrace();
                        continue;
                    }
                    catch (MetaFileNotMatchingException e1) {
                        WindowUtil.msgboxInfo((Object)(f + "\r\n" + e1.getMessage() + "\r\n translate faild."), (String)"Prompt", (Component)frame);
                        e1.printStackTrace();
                    }
                }
            }
        });
        frame.setSize(400, 300);
        frame.show();
    }

    public static void main(String[] args) {
        DesignedDataUpgradeFromV1_1 t = new DesignedDataUpgradeFromV1_1();
        t.showFrame();
    }

    public void setSysQueryDir(QueryDir dir) {
        this.sysQueryDir = dir;
    }

    private String replaceFieldsZh2En(String fieldsZn) {
        ArrayList<String> cache = new ArrayList<String>();
        int lastEnd = 0;
        while (lastEnd != -1) {
            int left = fieldsZn.indexOf("[", lastEnd);
            int mid = fieldsZn.indexOf("].[", left + 1);
            int right = fieldsZn.indexOf("]", mid + 1);
            if (left != -1 && mid != -1 && right != -1) {
                String aFieldZn = fieldsZn.substring(left, right + 1);
                cache.add(aFieldZn);
                lastEnd = right + 1;
                continue;
            }
            lastEnd = -1;
        }
        String fieldsEn = new String(fieldsZn);
        for (String aFieldZn : cache) {
            Object obj = this.allMetaField.get(aFieldZn);
            if (obj == null) continue;
            int start = fieldsEn.indexOf(aFieldZn);
            fieldsEn = fieldsEn.substring(0, start) + obj.toString() + fieldsEn.substring(start + aFieldZn.length());
        }
        return fieldsEn;
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.kdf.data.util.DesignedDataUpgradeFromV1_1", (String)defaultValue);
    }
}

