/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.dialogs;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.RtfExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.XlsExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.direct.ImageExporterParameter;
import com.kingdee.bos.ctrl.kdf.form.PageCollection;
import com.kingdee.bos.ctrl.kdf.formbrowser2.resources.Resources;
import com.kingdee.bos.ctrl.kdf.kdprint.PrintPage;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.bos.ctrl.kdf.printprovider.util.ExtensionFilter;
import com.kingdee.bos.ctrl.kdf.util.TransForm;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.io.File;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class Export2FileDlg
extends KDDialog {
    private static final long serialVersionUID = 4762311665819919007L;
    private KDTextField pathBox;
    private KDRadioButton r1;
    private KDRadioButton r2;
    private KDRadioButton r3;
    private KDRadioButton r4;
    private KDRadioButton r5;
    private KDRadioButton r6;
    private KDRadioButton r7;
    private KDRadioButton r8;
    private ButtonGroup itemGroup;
    boolean isDone = false;
    private String[][] expTypes = new String[][]{{"PDF " + Resources.LOCAL_STR("File"), ".pdf"}, {"EXCEL " + Resources.LOCAL_STR("File"), ".xls"}, {"EXCEL " + Resources.LOCAL_STR("File") + Resources.LOCAL_STR("Pagination-By-Sheet", "Pagination-By-Sheet"), ".xls"}, {"WORD " + Resources.LOCAL_STR("File"), ".rtf"}, {"WORD " + Resources.LOCAL_STR("File") + Resources.LOCAL_STR("Without-Sheet", "Without-Sheet"), ".rtf"}, {"HTML " + Resources.LOCAL_STR("File"), ".htm"}, {"IMAGE " + Resources.LOCAL_STR("File"), ".png"}, {"IMAGE " + Resources.LOCAL_STR("File") + "(" + Resources.LOCAL_STR("Single-File", "(Single File)") + ")", ".png"}};
    private PageCollection pageColl;
    private KDButton okButton = new KDButton(Resources.LOCAL_STR("approve", "OK"));
    private Printable printable;
    private PrinterAttrManager pam;

    public Export2FileDlg(Frame frame, PageCollection pc, Printable printable, PrinterAttrManager attrMgr) {
        super(frame);
        this.pageColl = pc;
        this.printable = printable;
        this.pam = attrMgr;
        this.init();
        this.setModal(true);
        this.setDefaultCloseOperation(1);
    }

    public void init() {
        this.setTitle(Resources.LOCAL_STR("exprot2file-name", "Export To File"));
        JPanel itemsPane = new JPanel();
        JPanel filePane = new JPanel();
        JPanel cmdPane = new JPanel();
        this.getContentPane().setLayout(new BorderLayout());
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)itemsPane, "North");
        this.getContentPane().add((Component)filePane, "Center");
        this.getContentPane().add((Component)cmdPane, "South");
        itemsPane.setLayout(new BoxLayout(itemsPane, 1));
        itemsPane.setBorder(BorderFactory.createTitledBorder(Resources.LOCAL_STR("select-file-type", " Select File Type ")));
        this.r1 = new KDRadioButton(this.expTypes[0][0], true);
        itemsPane.add((Component)this.r1);
        this.r2 = new KDRadioButton(this.expTypes[1][0], false);
        itemsPane.add((Component)this.r2);
        this.r3 = new KDRadioButton(this.expTypes[2][0], false);
        itemsPane.add((Component)this.r3);
        this.r4 = new KDRadioButton(this.expTypes[3][0], false);
        itemsPane.add((Component)this.r4);
        this.r5 = new KDRadioButton(this.expTypes[4][0], false);
        itemsPane.add((Component)this.r5);
        this.r6 = new KDRadioButton(this.expTypes[5][0], false);
        itemsPane.add((Component)this.r6);
        this.r7 = new KDRadioButton(this.expTypes[6][0], false);
        itemsPane.add((Component)this.r7);
        this.r8 = new KDRadioButton(this.expTypes[7][0], false);
        itemsPane.add((Component)this.r8);
        this.itemGroup = new ButtonGroup();
        this.itemGroup.add((AbstractButton)this.r1);
        this.itemGroup.add((AbstractButton)this.r2);
        this.itemGroup.add((AbstractButton)this.r3);
        this.itemGroup.add((AbstractButton)this.r4);
        this.itemGroup.add((AbstractButton)this.r5);
        this.itemGroup.add((AbstractButton)this.r6);
        this.itemGroup.add((AbstractButton)this.r7);
        this.itemGroup.add((AbstractButton)this.r8);
        this.pathBox = new KDTextField();
        this.pathBox.setEditable(false);
        this.pathBox.setPreferredSize(new Dimension(320, 30));
        this.pathBox.setBackground(Color.GRAY);
        KDButton pathButton = new KDButton("...");
        filePane.setLayout(new BorderLayout());
        this.pathBox.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        filePane.add((Component)this.pathBox, "West");
        filePane.add((Component)pathButton, "East");
        filePane.setBorder(new EmptyBorder(10, 0, 10, 0));
        filePane.setPreferredSize(new Dimension(400, 40));
        pathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String path = Export2FileDlg.this.getSavePath();
                if (path != null) {
                    Export2FileDlg.this.pathBox.setText(path);
                    Export2FileDlg.this.okButton.setEnabled(true);
                } else if (Export2FileDlg.this.pathBox.getText() == null) {
                    Export2FileDlg.this.okButton.setEnabled(false);
                }
            }
        });
        KDButton cancelButton = new KDButton(Resources.LOCAL_STR("cancel"));
        this.okButton.setEnabled(false);
        JPanel cmdPane1 = new JPanel();
        JPanel cmdPane2 = new JPanel();
        cmdPane1.setBorder(BorderFactory.createEtchedBorder());
        cmdPane1.setPreferredSize(new Dimension(400, 2));
        cmdPane.setLayout(new BorderLayout());
        cmdPane.add(cmdPane1);
        cmdPane.add(cmdPane2);
        cmdPane2.setLayout(new FlowLayout(2));
        cmdPane2.add((Component)this.okButton);
        cmdPane2.add((Component)cancelButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Export2FileDlg.this.isDone = Export2FileDlg.this.export2File(Export2FileDlg.this.pathBox.getText(), Export2FileDlg.this.pageColl);
                Export2FileDlg.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Export2FileDlg.this.isDone = false;
                Export2FileDlg.this.setVisible(false);
            }
        });
    }

    int getSelectedRadio() {
        if (this.r1.isSelected()) {
            return 0;
        }
        if (this.r2.isSelected()) {
            return 1;
        }
        if (this.r3.isSelected()) {
            return 2;
        }
        if (this.r4.isSelected()) {
            return 3;
        }
        if (this.r5.isSelected()) {
            return 4;
        }
        if (this.r6.isSelected()) {
            return 5;
        }
        if (this.r7.isSelected()) {
            return 6;
        }
        if (this.r8.isSelected()) {
            return 7;
        }
        return -1;
    }

    private String getSavePath() {
        int index = this.getSelectedRadio();
        String subfix = this.expTypes[index][1];
        KDFileChooser chooser = new KDFileChooser();
        chooser.setDialogTitle(Resources.LOCAL_STR("exprot2file-name", "Export To File"));
        String[] exts = subfix.split("\\|");
        FileFilter[] filters = new FileFilter[]{new ExtensionFilter(this.expTypes[index][0], exts)};
        chooser.setFileFilter(filters[0]);
        chooser.showSaveDialog((Component)((Object)this));
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile != null) {
            int rt;
            if (selectedFile.exists() && (rt = JOptionPane.showConfirmDialog((Component)((Object)this), Resources.LOCAL_STR("file-exist-tip", "File Exist , Replace It ?"), "", 0)) != 0) {
                return null;
            }
            String path = selectedFile.getPath();
            if (path != null) {
                boolean ext = false;
                for (int i = 0; i < exts.length; ++i) {
                    if (!path.toUpperCase(Locale.CHINA).endsWith(exts[i].toUpperCase(Locale.CHINA))) continue;
                    ext = true;
                }
                if (!ext) {
                    path = path + exts[0];
                }
                return path;
            }
        }
        return null;
    }

    private float pixel2mm(float pix) {
        return pix * 254.0f / 720.0f;
    }

    private PrintableBook getPtBook(PageCollection pc) {
        KDSBook book = TransForm.toBook(pc);
        PrintableBook ptbook = new PrintableBook(book);
        PrintPage pp = ptbook.getPrintBase().getPrintPage();
        if (this.pam.isPortrait()) {
            pp.setLeftEdge(this.pixel2mm(this.pam.getLeft()));
            pp.setRightEdge(this.pixel2mm(this.pam.getRight()));
            pp.setTopEdge(this.pixel2mm(this.pam.getTop()));
            pp.setBottomEdge(this.pixel2mm(this.pam.getBottom()));
        } else {
            pp.setLeftEdge(this.pixel2mm(this.pam.getTop()));
            pp.setRightEdge(this.pixel2mm(this.pam.getBottom()));
            pp.setTopEdge(this.pixel2mm(this.pam.getLeft()));
            pp.setBottomEdge(this.pixel2mm(this.pam.getRight()));
        }
        pp.setPrintPageW(this.pixel2mm(this.pam.getPaperWidth()));
        pp.setPrintPageH(this.pixel2mm(this.pam.getPaperHeight()));
        return ptbook;
    }

    boolean export2File(String thePath, PageCollection pc) {
        int selectedType = this.getSelectedRadio();
        if (thePath == null || pc == null || thePath != null && thePath.length() == 0) {
            return false;
        }
        ExportManager exp = new ExportManager();
        switch (selectedType) {
            case 0: {
                exp.setExporterParmeter(ExporterParameter.PAGE_SIZE, new Dimension((int)(this.pixel2mm(this.pam.getPaperWidth()) * 10.0f), (int)(this.pixel2mm(this.pam.getPaperHeight()) * 10.0f)));
                exp.setExporterParmeter(ExporterParameter.PAGE_MARGIN, new float[]{this.pixel2mm(this.pam.getTop()) * 10.0f, this.pixel2mm(this.pam.getBottom()) * 10.0f, this.pixel2mm(this.pam.getLeft()) * 10.0f, this.pixel2mm(this.pam.getRight()) * 10.0f});
                exp.exportToPdfFile2(this.printable, thePath);
                break;
            }
            case 1: {
                exp.exportToExcel(this.getPtBook(pc), thePath);
                break;
            }
            case 2: {
                exp.setExporterParmeter(XlsExporterParameter.IS_ONE_PAGE_PER_SHEET, true);
                exp.exportToExcel(this.getPtBook(pc), thePath);
                break;
            }
            case 3: {
                exp.exportToRtfFile(this.getPtBook(pc), thePath);
                break;
            }
            case 4: {
                exp.setExporterParmeter(RtfExporterParameter.IS_OUTTABLE, Boolean.FALSE);
                exp.setExporterParmeter(ExporterParameter.PAGE_SIZE, new Dimension((int)(this.pixel2mm(this.pam.getPaperWidth()) * 10.0f), (int)(this.pixel2mm(this.pam.getPaperHeight()) * 10.0f)));
                exp.setExporterParmeter(ExporterParameter.PAGE_MARGIN, new float[]{this.pixel2mm(this.pam.getTop()) * 10.0f, this.pixel2mm(this.pam.getBottom()) * 10.0f, this.pixel2mm(this.pam.getLeft()) * 10.0f, this.pixel2mm(this.pam.getRight()) * 10.0f});
                exp.exportToRtfFile2(pc, thePath);
                break;
            }
            case 5: {
                exp.exportToHtmlFile(this.getPtBook(pc), thePath);
                break;
            }
            case 6: {
                exp.setExporterParmeter(ImageExporterParameter.IMAGE_DIMENSION, new Dimension((int)this.pam.getPaperWidth(), (int)this.pam.getPaperHeight()));
                exp.exportToImageFile(this.printable, thePath);
                break;
            }
            case 7: {
                exp.setExporterParmeter(ImageExporterParameter.IMAGE_DIMENSION, new Dimension((int)this.pam.getPaperWidth(), (int)this.pam.getPaperHeight()));
                exp.setExporterParmeter(ImageExporterParameter.SINGLE_IMAGE_OUTPUT, Boolean.TRUE);
                exp.exportToImageFile(this.printable, thePath);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    public boolean isDone() {
        return this.isDone;
    }
}

