/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormContainerObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormObject;
import com.kingdee.bos.ctrl.kdf.util.BMPReader;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ImageObject
extends FormObject {
    private static Logger logger = LogUtil.getPackageLogger(ImageObject.class);
    private Image image;
    private String align;
    private String verticalAlign;

    public ImageObject(int x, int y, int width, int height, byte[] imageData, Container cont, FormContainerObject parent) {
        super(x, y, width, height, cont, parent);
        this.align = "";
        this.verticalAlign = "";
        this.image = imageData.length > 1 && imageData[0] == 66 && imageData[1] == 77 ? BMPReader.loadBitMap(imageData) : new ImageIcon(imageData).getImage();
        String hAlign = this.getStyle().getHorizontalAlign().toString();
        String vAlign = this.getStyle().getVerticalAlign().toString();
        this.setVerticalAlign(vAlign);
        this.setAlign(hAlign);
        this.convertImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageObject(int x, int y, int width, int height, URL urlOfData, Container cont, FormContainerObject parent) {
        block6: {
            super(x, y, width, height, cont, parent);
            this.align = "";
            this.verticalAlign = "";
            String hAlign = this.getStyle().getHorizontalAlign().toString();
            String vAlign = this.getStyle().getVerticalAlign().toString();
            this.setVerticalAlign(vAlign);
            this.setAlign(hAlign);
            try {
                String url = urlOfData.toString();
                String suffix = url.substring(url.length() - 3, url.length());
                if (urlOfData.getProtocol().equalsIgnoreCase("file")) {
                    this.image = "bmp".equalsIgnoreCase(suffix) || "dib".equalsIgnoreCase(suffix) ? BMPReader.loadBitMap(url.substring(7)) : new ImageIcon(url.substring(7)).getImage();
                    break block6;
                }
                if ("bmp".equalsIgnoreCase(suffix) || "dib".equalsIgnoreCase(suffix)) {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(new File(new URI(urlOfData.toString())));
                        this.image = BMPReader.loadBitMap(fis);
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{fis});
                        throw throwable;
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{fis});
                    break block6;
                }
                this.image = new ImageIcon(urlOfData).getImage();
            }
            catch (Exception e) {
                this.image = null;
            }
        }
        this.convertImage();
    }

    private void convertImage() {
        if (this.image != null) {
            try {
                BufferedImage bi = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
                bi.getGraphics().drawImage(this.image, 0, 0, null);
                this.image = bi;
            }
            catch (Exception e) {
                logger.error((Object)"convert Image failed");
                logger.error((Object)"Exception occurred.", (Throwable)e);
                this.image = null;
            }
        }
    }

    public void setVerticalAlign(String string) {
        this.verticalAlign = string;
    }

    public void setAlign(String string) {
        this.align = string;
    }

    public Image getImage() {
        return this.image;
    }

    public String getVerticalAlign() {
        return this.verticalAlign;
    }

    public String getAlign() {
        return this.align;
    }

    public int getActualImgageHeight() {
        return this.image == null ? 0 : this.image.getHeight(null);
    }

    public int getActualImgageWidth() {
        return this.image == null ? 0 : this.image.getWidth(null);
    }
}

