/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.gui;

import com.kingdee.bos.ctrl.kdf.form.Cell;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ContextOfBrowser;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.PhysicalPage;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.PhysicalPageManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormContainerObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.TextObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.editing.IFormObjectEditContext;
import com.kingdee.bos.ctrl.kdf.formbrowser2.gui.ISelectionRegion;
import com.kingdee.bos.ctrl.kdf.printprovider.ContextOfPreview;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.ContextEventAdapter;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.CurrentPageChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.gui.AbstractPreviewPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;

public class PreviewPaneMouseHandler
extends MouseInputAdapter {
    PhysicalPageManager phypagemgr;
    ContextOfBrowser context;
    PrinterAttrManager attrmgr;
    IFormObjectEditContext editContext;
    int formObjOldX = 0;
    int formObjOldY = 0;
    public ISelectionRegion lastSelReg = null;
    public TextEditor textEditor = new TextEditor();
    boolean bSelecting = false;
    boolean bMoving = false;
    boolean bResizing = false;
    Point dragSel_origin = null;
    Point dragSel_origin_end = null;
    Point transform_origin = null;
    Point transform_origin_end = null;
    public Rectangle resizingRect = null;
    ZoomedDim2Origin zoomedDim2Origin;
    public Rectangle selBounds;
    public Rectangle movingBounds;
    public Point lastMouse = null;
    private static BasicStroke m_SelectedDash = null;

    public PreviewPaneMouseHandler(IFormObjectEditContext editContext, PhysicalPageManager phypagemgr, ContextOfBrowser context, PrinterAttrManager attrmgr) {
        float[] fArray2 = new float[]{2.0f, 2.0f};
        m_SelectedDash = new BasicStroke(1.0f, 0, 0, 4.0f, fArray2, 0.0f);
        this.phypagemgr = phypagemgr;
        this.context = context;
        this.attrmgr = attrmgr;
        this.editContext = editContext;
        context.activePreviewContext.addContextEventListener(new ContextEventAdapter(){

            @Override
            public void currentPageChanged(CurrentPageChangedEvent event) {
                PreviewPaneMouseHandler.this.clear();
            }
        });
        this.zoomedDim2Origin = new ZoomedDim2Origin();
    }

    public void clear() {
        this.editContext.selectedObjectClear();
        if (this.bMoving) {
            this.editContext.moveOff();
        }
        this.lastSelReg = null;
    }

    @Override
    public void mouseClicked(MouseEvent eSrc) {
        ISelectionRegion selReg;
        MyMouseEvent e = new MyMouseEvent(eSrc, this.context.activePreviewContext);
        if (e.getButton() == 3) {
            return;
        }
        if (this.context.getCurrentPage() >= 0 && e.getClickCount() == 2 && (selReg = this.mouseSelected(e)) != null) {
            this.textEditor.editText(selReg.getFormObject(), selReg, this.context.activePreviewContext.getBeginOfCurrentPage(), this.context.activePreviewContext.getZoomFactor(), e.getComponent());
        }
    }

    public ISelectionRegion mouseSelected(MouseEvent e) {
        if (!e.isControlDown()) {
            this.editContext.selectedObjectClear();
        }
        this.lastSelReg = null;
        if (this.context.getCurrentPage() >= 0) {
            ISelectionRegion selReg = null;
            PhysicalPage phypage = (PhysicalPage)this.phypagemgr.get(this.context.getCurrentPage());
            ISelectionRegion startReg = (ISelectionRegion)phypage.selectionRegoins.get(phypage.get(0));
            selReg = startReg.lookupSelectedRegion(e.getPoint());
            if (selReg == null) {
                this.lastSelReg = null;
                return null;
            }
            this.editContext.redrawAll();
            this.editContext.selectedObjectsAdd(selReg.getFormObject());
            Graphics g = e.getComponent().getGraphics();
            g.translate(this.context.activePreviewContext.getBeginOfCurrentPage().x, this.context.activePreviewContext.getBeginOfCurrentPage().y);
            if (this.lastSelReg != selReg) {
                g.setClip((int)this.attrmgr.getLeft(), (int)this.attrmgr.getBodyY(), (int)this.attrmgr.getPrintableW() + 1, phypage.getAdjustedHeight() + 1);
                selReg.drawSelected(g, this.context.activePreviewContext.getZoomFactor());
                if (this.lastSelReg != null) {
                    this.lastSelReg.drawSelected(g, this.context.activePreviewContext.getZoomFactor());
                }
                this.lastSelReg = selReg;
                this.selBounds = (Rectangle)this.lastSelReg.getRect().clone();
            } else if (this.lastSelReg != null) {
                this.lastSelReg.drawSelected(g, this.context.activePreviewContext.getZoomFactor());
                this.lastSelReg = null;
            }
            g.translate(-this.context.activePreviewContext.getBeginOfCurrentPage().x, -this.context.activePreviewContext.getBeginOfCurrentPage().y);
            return selReg;
        }
        return null;
    }

    private Rectangle getNormalRectangle(Point pt1, Point pt2) {
        Rectangle rc = new Rectangle();
        if (pt1.x <= pt2.x) {
            if (pt1.y < pt2.y) {
                rc.x = pt1.x;
                rc.y = pt1.y;
                rc.width = pt2.x - pt1.x;
                rc.height = pt2.y - pt1.y;
            } else {
                rc.x = pt1.x;
                rc.y = pt2.y;
                rc.width = pt2.x - pt1.x;
                rc.height = pt1.y - pt2.y;
            }
        } else {
            return this.getNormalRectangle(pt2, pt1);
        }
        return rc;
    }

    private void move(MouseEvent evt) {
        Graphics2D gg = this.editContext.getGraphics();
        gg.setXORMode(Color.WHITE);
        Stroke oldstroke = gg.getStroke();
        Color oldColor = gg.getColor();
        gg.setColor(Color.GRAY);
        gg.setStroke(new BasicStroke(3.0f));
        if (this.lastMouse == null) {
            this.lastMouse = evt.getPoint();
            this.selBounds = (Rectangle)this.lastSelReg.getRect().clone();
            this.movingBounds = this.zoomedDim2Origin.zoom(this.lastSelReg.getRect());
            return;
        }
        this.movingBounds.translate(this.context.activePreviewContext.getBeginOfCurrentPage().x, this.context.activePreviewContext.getBeginOfCurrentPage().y);
        gg.draw(this.movingBounds);
        this.movingBounds.translate(this.zoomedDim2Origin.zoom(evt.getPoint().x - this.lastMouse.x), this.zoomedDim2Origin.zoom(evt.getPoint().y - this.lastMouse.y));
        gg.draw(this.movingBounds);
        this.movingBounds.translate(-this.context.activePreviewContext.getBeginOfCurrentPage().x, -this.context.activePreviewContext.getBeginOfCurrentPage().y);
        this.lastMouse = evt.getPoint();
        gg.setPaintMode();
        gg.setStroke(oldstroke);
        gg.setColor(oldColor);
    }

    @Override
    public void mousePressed(MouseEvent eSrc) {
        MyMouseEvent e = new MyMouseEvent(eSrc, this.context.activePreviewContext);
        if (this.bMoving) {
            if (e.getButton() == 3) {
                this.editContext.moveOff();
            }
            if (this.movingBounds == null) {
                return;
            }
            Point p = (Point)eSrc.getPoint().clone();
            p.translate(-this.context.activePreviewContext.getBeginOfCurrentPage().x, -this.context.activePreviewContext.getBeginOfCurrentPage().y);
            if (this.movingBounds.contains(p)) {
                return;
            }
            this.editContext.moveOff();
        }
        if (this.bResizing) {
            return;
        }
        if (e.getButton() == 1 && e.getClickCount() < 2) {
            this.dragSel_origin = new Point(e.getX(), e.getY());
            this.dragSel_origin_end = new Point(e.getX(), e.getY());
            if (this.bSelecting) {
                this.lastSelReg = this.mouseSelected(e);
            }
            if (this.bMoving) {
                // empty if block
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent eSrc) {
        MyMouseEvent e = new MyMouseEvent(eSrc, this.context.activePreviewContext);
        this.dragSel_origin_end = (Point)eSrc.getPoint().clone();
        if (this.bSelecting) {
            // empty if block
        }
        if (this.bMoving) {
            this.move(e);
        }
    }

    private int getSelecteds(ISelectionRegion cont, Rectangle mouseSel) {
        this.editContext.selectedObjectClear();
        if (cont.getFormObject() instanceof FormContainerObject) {
            FormContainerObject contObj = (FormContainerObject)cont.getFormObject();
            Iterator itr = contObj.getChildren().iterator();
            while (itr.hasNext()) {
                PhysicalPage phypage = (PhysicalPage)this.phypagemgr.get(this.context.getCurrentPage());
                FormObject child = (FormObject)itr.next();
                ISelectionRegion selReg = (ISelectionRegion)phypage.selectionRegoins.get(child);
                if (!mouseSel.contains(selReg.getRect())) continue;
                this.editContext.selectedObjectsAdd(selReg.getFormObject());
            }
            if (this.editContext.selectedObjects().length == 0) {
                this.editContext.selectedObjectsAdd(cont.getFormObject());
            }
            return this.editContext.selectedObjects().length;
        }
        return 0;
    }

    @Override
    public void mouseReleased(MouseEvent eSrc) {
        MyMouseEvent e = new MyMouseEvent(eSrc, this.context.activePreviewContext);
        if (e.isPopupTrigger()) {
            if (this.bResizing) {
                this.editContext.resizeOff();
                return;
            }
            this.lastSelReg = this.mouseSelected(e);
            if (this.lastSelReg != null) {
                this.editContext.trackPopupMenu(e.getComponent(), eSrc.getPoint(), this.lastSelReg);
            }
            return;
        }
        if (this.bResizing) {
            this.editContext.resize((int)((double)this.resizingRect.width / this.context.activePreviewContext.getZoomFactor()), (int)((double)this.resizingRect.height / this.context.activePreviewContext.getZoomFactor()));
            this.editContext.resizeOff();
            return;
        }
        if (this.bMoving) {
            this.lastMouse = null;
            this.editContext.move((int)((double)this.movingBounds.x / this.context.activePreviewContext.getZoomFactor() - (double)this.selBounds.x), (int)((double)this.movingBounds.y / this.context.activePreviewContext.getZoomFactor() - (double)this.selBounds.y));
            this.selBounds = this.zoomedDim2Origin.unZoom(this.movingBounds);
        } else if (this.bSelecting) {
            this.selBounds = this.getNormalRectangle(this.dragSel_origin_end, this.dragSel_origin);
            if (this.lastSelReg != null) {
                this.getSelecteds(this.lastSelReg, this.selBounds);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent eSrc) {
        if (this.bResizing) {
            Graphics2D gg = this.editContext.getGraphics();
            gg.setXORMode(Color.WHITE);
            Stroke oldstroke = gg.getStroke();
            gg.setStroke(m_SelectedDash);
            if (this.resizingRect == null) {
                this.resizingRect = new Rectangle(this.zoomedDim2Origin.zoom(this.lastSelReg.getRect().getLocation()));
                this.resizingRect.translate(this.context.activePreviewContext.getBeginOfCurrentPage().x, this.context.activePreviewContext.getBeginOfCurrentPage().y);
                this.resizingRect.add(eSrc.getPoint());
                return;
            }
            gg.draw(this.resizingRect);
            Point p = this.zoomedDim2Origin.zoom(this.lastSelReg.getRect().getLocation());
            p.translate(this.context.activePreviewContext.getBeginOfCurrentPage().x, this.context.activePreviewContext.getBeginOfCurrentPage().y);
            this.resizingRect = this.getNormalRectangle(p, eSrc.getPoint());
            if (this.lastSelReg.getParentRegion() != null) {
                Rectangle rp = this.zoomedDim2Origin.zoom(this.lastSelReg.getParentRegion().getRect());
                rp.translate(this.context.activePreviewContext.getBeginOfCurrentPage().x, this.context.activePreviewContext.getBeginOfCurrentPage().y);
                if (!rp.contains(this.resizingRect)) {
                    this.resizingRect = this.resizingRect.intersection(this.zoomedDim2Origin.zoom(this.lastSelReg.getParentRegion().getRect()));
                }
            }
            gg.draw(this.resizingRect);
            gg.setPaintMode();
            gg.setStroke(oldstroke);
        }
    }

    public void drawRectOfLastSel() {
    }

    public void drawRectOfLastSels() {
    }

    class ZoomedDim2Origin {
        PrinterAttrManager attr;

        ZoomedDim2Origin() {
        }

        public Point unZoom(Point zp) {
            Point p = (Point)zp.clone();
            p.setLocation((double)zp.x / PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor(), (double)zp.y / PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor());
            return p;
        }

        public Rectangle unZoom(Rectangle zr) {
            Rectangle rect = (Rectangle)zr.clone();
            rect.setBounds((int)((double)zr.x / PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor()), (int)((double)zr.y / PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor()), (int)((double)zr.width / PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor()), (int)((double)zr.height / PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor()));
            return rect;
        }

        public Point zoom(Point zp) {
            Point p = (Point)zp.clone();
            p.setLocation((double)zp.x * PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor(), (double)zp.y * PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor());
            return p;
        }

        public Rectangle zoom(Rectangle zr) {
            Rectangle rect = (Rectangle)zr.clone();
            rect.setBounds((int)((double)zr.x * PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor()), (int)((double)zr.y * PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor()), (int)((double)zr.width * PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor()), (int)((double)zr.height * PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor()));
            return rect;
        }

        public int zoom(int l) {
            return (int)((double)l * PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor());
        }

        public int unZoom(int l) {
            return (int)((double)l / PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor());
        }
    }

    static class TextEditor {
        private JEditorPane editorPane = new JEditorPane();
        private Component theComp;
        private JDialog editorDlg;
        private FormObject theFormObj;

        TextEditor() {
        }

        public void editText(FormObject formObj, ISelectionRegion selreg, Point offset, double zoomFactor, Component comp) {
            this.theFormObj = formObj;
            this.theComp = comp;
            if (formObj instanceof TextObject) {
                if (this.editorDlg == null) {
                    this.editorPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                    this.editorDlg = new JDialog();
                    this.editorPane.setOpaque(true);
                    this.editorDlg.getRootPane().setOpaque(true);
                    ((JComponent)this.editorDlg.getContentPane()).setOpaque(true);
                    this.editorDlg.getContentPane().add(this.editorPane);
                    this.editorDlg.setUndecorated(true);
                    this.editorDlg.setBackground(Color.WHITE);
                    this.editorDlg.setModal(false);
                    this.editorPane.setFocusable(true);
                    this.editorPane.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusLost(FocusEvent e) {
                            if (editorDlg.isVisible()) {
                                this.finishEdit(true);
                            }
                        }
                    });
                    this.editorPane.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyReleased(KeyEvent e) {
                            if (e.getKeyCode() == 27) {
                                this.finishEdit(false);
                            }
                        }
                    });
                }
                TextObject textElt = (TextObject)formObj;
                Font font = new Font(textElt.getFontName(), 0, 14);
                this.editorPane.setFont(font);
                this.editorPane.setText(textElt.getText());
                Rectangle bounds = new Rectangle((int)((double)selreg.getRect().x * zoomFactor) + offset.x, (int)((double)selreg.getRect().y * zoomFactor) + offset.y, (int)((double)selreg.getRect().width * zoomFactor), (int)((double)selreg.getRect().height * zoomFactor));
                Component rootComp = SwingUtilities.getRoot(comp);
                Point pos = SwingUtilities.convertPoint(comp, new Point(0, 0), rootComp);
                pos.x += rootComp.getBounds().x;
                pos.y += rootComp.getBounds().y;
                bounds.x += pos.x;
                bounds.y += pos.y;
                this.editorDlg.setBounds(bounds);
                this.editorDlg.setVisible(true);
            }
        }

        private void finishEdit(boolean saveit) {
            this.editorDlg.setVisible(false);
            if (!saveit) {
                return;
            }
            if (this.saveEdit() && this.theComp instanceof AbstractPreviewPane) {
                ((AbstractPreviewPane)this.theComp).doRepaint();
            }
            this.theFormObj = null;
        }

        public boolean saveEdit() {
            boolean result = false;
            if (this.theFormObj instanceof TextObject) {
                if (((TextObject)this.theFormObj).getText().equals(this.editorPane.getText())) {
                    result = false;
                } else {
                    ((TextObject)this.theFormObj).setText(this.editorPane.getText());
                    ((Cell)this.theFormObj.contOfOutForm.getSource()).getData().setValue(this.editorPane.getText());
                    ((Cell)this.theFormObj.contOfOutForm.getSource()).getData().setFormat(this.editorPane.getText());
                    ((Cell)this.theFormObj.contOfOutForm).getData().setFormat(this.editorPane.getText());
                    ((Cell)this.theFormObj.contOfOutForm).getData().setValue(this.editorPane.getText());
                    result = true;
                }
            }
            return result;
        }
    }

    class DelayActiveAction
    implements ActionListener {
        Graphics g;
        ISelectionRegion selReg;
        PhysicalPage phypage;

        public DelayActiveAction(ISelectionRegion selReg, Graphics g, PhysicalPage phypage) {
            this.phypage = phypage;
            this.selReg = selReg;
            this.g = g;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((Timer)e.getSource()).stop();
            if (PreviewPaneMouseHandler.this.lastSelReg == this.selReg) {
                this.g.setClip((int)PreviewPaneMouseHandler.this.attrmgr.getLeft(), (int)PreviewPaneMouseHandler.this.attrmgr.getBodyY(), (int)PreviewPaneMouseHandler.this.attrmgr.getPrintableW() + 1, this.phypage.getAdjustedHeight() + 1);
                if (this.selReg != null) {
                    this.selReg.drawSelected(this.g, PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor());
                }
            } else if (PreviewPaneMouseHandler.this.lastSelReg != null) {
                PreviewPaneMouseHandler.this.lastSelReg.drawSelected(this.g, PreviewPaneMouseHandler.this.context.activePreviewContext.getZoomFactor());
                PreviewPaneMouseHandler.this.lastSelReg = this.selReg;
            }
        }
    }

    class MyMouseEvent
    extends MouseEvent {
        private static final long serialVersionUID = -7112472307085805328L;
        ContextOfPreview ctx;
        Point point;

        public MyMouseEvent(MouseEvent eSrc, ContextOfPreview attr) {
            super(eSrc.getComponent(), eSrc.getID(), eSrc.getWhen(), eSrc.getModifiers(), eSrc.getX(), eSrc.getY(), eSrc.getClickCount(), eSrc.isPopupTrigger());
            this.ctx = attr;
        }

        @Override
        public int getX() {
            return (int)((double)(super.getX() - this.ctx.getBeginOfCurrentPage().x) / this.ctx.getZoomFactor());
        }

        @Override
        public int getY() {
            return (int)((double)(super.getY() - this.ctx.getBeginOfCurrentPage().y) / this.ctx.getZoomFactor());
        }

        @Override
        public Point getPoint() {
            if (this.point == null) {
                this.point = new Point(this.getX(), this.getY());
            }
            return this.point;
        }
    }
}

