/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.printprovider;

import com.kingdee.bos.ctrl.kdf.printprovider.IDocInfoProvider;
import com.kingdee.bos.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.ContextEventListener;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.CurrentPageChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.UIStateChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.UpdateViewEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.gui.AbstractPreviewPane;
import com.kingdee.bos.ctrl.kdf.printprovider.gui.BaseComponent;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.HashMap;
import javax.swing.event.EventListenerList;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ContextOfPreview
implements Serviceable {
    private EventListenerList listenerList = null;
    private int currentPageIndex = -1;
    HashMap docInfo = new HashMap();
    private boolean isfirstPageReady = false;
    private boolean isAdjustingMargin = false;
    private boolean isEditing = false;
    public static final int OPER_SCOPE_OBJECT = 0;
    public static final int OPER_SCOPE_PAGE = 1;
    public static final int OPER_SCOPE_GLOBAL = 2;
    public static final int FitByWidth = 1;
    public static final int FitByHeight = 2;
    public static final int FitByAuto = 3;
    public static final int FitByZoom = 4;
    private boolean forwardInfoFetch = true;
    private double zoomFactor = 1.3333333333333333;
    public int xOff = 0;
    public int yOff = 0;
    private int cPageRow = 1;
    private int cPageCol = 1;
    public int span = 5;
    private int fitStyle = 4;
    private PrintCompContainer container;
    private AbstractPreviewPane previewpane;
    private PrinterAttrManager printerattr;
    Point beginOfPages = new Point();
    IDocInfoProvider docInfoProvider;
    UpdateViewEvent theUpdateViewEvent = new UpdateViewEvent(this);
    boolean supressUpdateView = false;

    public Point getBeginOfCurrentPage() {
        Point result = this.getBeginOfPage(this.getCurrentPage());
        result.translate(this.getBeginOfPages().x, this.getBeginOfPages().y);
        return result;
    }

    public Point getBeginOfPages() {
        return this.beginOfPages;
    }

    public Point getBeginOfPage(int index) {
        Point beginOfPagei = new Point(0, 0);
        if (this.fitStyle != 3) {
            return beginOfPagei;
        }
        int iRow = index / this.cPageCol % this.cPageRow;
        int iCol = index % this.cPageCol;
        double splitWidth = this.zoomFactor * (double)this.getAttrMgr().getPaperWidth() + (double)this.span;
        double splitHeight = splitWidth * (double)this.getAttrMgr().getPaperHeight() / (double)this.getAttrMgr().getPaperWidth();
        beginOfPagei.translate((int)(splitWidth * (double)iCol / (double)this.getAttrMgr().screenMapRatio), (int)(splitHeight * (double)iRow / (double)this.getAttrMgr().screenMapRatio));
        return beginOfPagei;
    }

    private AbstractPreviewPane getPreviewPane() {
        if (this.previewpane == null) {
            this.previewpane = this.container.getBaseComponent().getPreviewPane();
        }
        return this.previewpane;
    }

    private PrinterAttrManager getAttrMgr() {
        if (this.printerattr == null) {
            this.printerattr = this.container.getPrinterAttrManager();
        }
        return this.printerattr;
    }

    public int getPaneFitStyle() {
        return this.fitStyle;
    }

    public double setPaneFitStyle(int paneFitStyle) {
        this.fitStyle = paneFitStyle;
        if (this.getPreviewPane() == null) {
            return this.getZoomFactor();
        }
        Dimension paneSize = this.getPreviewPane().getVisibleSize();
        if (paneSize == null) {
            paneSize = this.getPreviewPane().getBounds().getSize();
        }
        this.beginOfPages.setLocation(0, 0);
        if (this.fitStyle == 3) {
            float aspectRatio = this.getAttrMgr().getPaperHeight() * (float)this.cPageRow / (this.getAttrMgr().getPaperWidth() * (float)this.cPageCol);
            if ((float)paneSize.height / (float)paneSize.width > aspectRatio) {
                float heightAdjusted = (float)(paneSize.width - 10) * aspectRatio;
                this.beginOfPages.translate(this.span, (int)(0.5 * (double)((float)paneSize.height - heightAdjusted)));
                this.zoomFactor = (heightAdjusted * this.getAttrMgr().screenMapRatio / (float)this.cPageRow - (float)this.span * aspectRatio) / this.getAttrMgr().getPaperHeight();
            } else {
                float widthAdjusted = (float)paneSize.height / aspectRatio;
                this.beginOfPages.translate((int)(0.5 * (double)((float)paneSize.width - widthAdjusted)), this.span);
                this.zoomFactor = (widthAdjusted * this.getAttrMgr().screenMapRatio / (float)this.cPageCol - (float)this.span) / this.getAttrMgr().getPaperWidth();
            }
        } else if (this.fitStyle == 1) {
            this.zoomFactor = (float)(paneSize.width - 10 - 2 * this.span) * this.getAttrMgr().screenMapRatio / this.getAttrMgr().getPaperWidth();
            if ((double)this.getAttrMgr().getPaperHeight() * this.zoomFactor < (double)(paneSize.height - 2 * this.span)) {
                this.beginOfPages.translate(this.span, (int)(0.5 * ((double)(paneSize.height - 2 * this.span) - (double)this.getAttrMgr().getPaperHeight() * this.zoomFactor)));
            }
        } else if (this.fitStyle == 2) {
            this.zoomFactor = (float)(paneSize.height - 2 * this.span) * this.getAttrMgr().screenMapRatio / this.getAttrMgr().getPaperHeight();
            this.beginOfPages.translate((int)(0.5 * ((double)(paneSize.width - 2 * this.span) - (double)this.getAttrMgr().getPaperWidth() * this.zoomFactor)), this.span);
        } else if (this.fitStyle == 4) {
            if ((double)paneSize.width > (double)this.getAttrMgr().getPaperWidth() * this.zoomFactor + (double)(this.span * 2)) {
                this.beginOfPages.translate((int)(0.5 * ((double)paneSize.width - (double)this.getAttrMgr().getPaperWidth() * this.zoomFactor)), 0);
            }
            if ((double)paneSize.height > (double)this.getAttrMgr().getPaperHeight() * this.zoomFactor + (double)(this.span * 2)) {
                this.beginOfPages.translate(0, (int)(0.5 * ((double)paneSize.height - (double)this.getAttrMgr().getPaperHeight() * this.zoomFactor)));
            }
        }
        this.updateMargins();
        this.fireUpdateView();
        return this.zoomFactor;
    }

    public void setGraphics(Graphics2D g2) {
        g2.scale(this.zoomFactor, this.zoomFactor);
    }

    public void resetGraphics(Graphics2D g2) {
        g2.scale(1.0 / this.zoomFactor, 1.0 / this.zoomFactor);
    }

    public void init() {
        this.isAdjustingMargin = false;
    }

    public void refresh() {
        int pageIndex = this.getCurrentPage();
        this.clear();
        int pageCount = this.getTotalPageCount();
        if (pageIndex >= pageCount) {
            pageIndex = pageCount - 1;
        }
        if (pageIndex < 0) {
            pageIndex = 0;
        }
        this.Goto(pageIndex);
    }

    public void clear() {
        if (this.container != null) {
            this.container.clear();
        }
        this.currentPageIndex = -1;
        this.isfirstPageReady = false;
        this.isEditing = false;
    }

    public boolean Goto(int i) {
        boolean dataIncomplete = this.isDataIncomplete();
        this.forwardInfoFetch = false;
        if (!dataIncomplete) {
            int pageCount = this.getTotalPageCount();
            if (i < 0 || i >= pageCount) {
                CurrentPageChangedEvent event = new CurrentPageChangedEvent(this, this.currentPageIndex, i);
                this.fireCurrentPageChanged(event);
                this.forwardInfoFetch = true;
                return false;
            }
        }
        if (this.currentPageIndex != i) {
            int oldPageIdx = this.currentPageIndex;
            this.currentPageIndex = i;
            CurrentPageChangedEvent event = new CurrentPageChangedEvent(this, oldPageIdx, i);
            this.fireCurrentPageChanged(event);
            if (this.cPageCol > 1 || this.cPageRow > 1) {
                this.previewpane.marginlines.recalcMargins();
            }
        }
        this.forwardInfoFetch = true;
        return true;
    }

    public void GotoNextView() {
        int cp = this.getCurrentPage();
        if (this.cPageCol > 1 || this.cPageRow > 1) {
            this.Goto((cp / (this.cPageCol * this.cPageRow) + 1) * (this.cPageCol * this.cPageRow));
        } else {
            this.Goto(cp + 1);
        }
    }

    public void GotoPrivisousView() {
        int cp = this.getCurrentPage();
        if (this.cPageCol > 1 || this.cPageRow > 1) {
            this.Goto((cp / (this.cPageCol * this.cPageRow) - 1) * (this.cPageCol * this.cPageRow));
        } else {
            this.Goto(cp - 1);
        }
    }

    public void GotoFirstView() {
    }

    public void GotoLastView() {
    }

    public boolean isNextViewAvailable() {
        int iCurrentView = this.currentPageIndex / (this.cPageCol * this.cPageRow);
        int cTotalView = (this.getTotalPageCount() + (this.cPageCol * this.cPageRow - 1)) / (this.cPageCol * this.cPageRow);
        boolean result = iCurrentView == cTotalView - 1 ? this.isDataIncomplete() : true;
        return result;
    }

    public boolean isPreviousViewAvailable() {
        return this.currentPageIndex / (this.cPageCol * this.cPageRow) > 0;
    }

    public int getCurrentPage() {
        return this.currentPageIndex;
    }

    public void setForwardInfoFetch(boolean forwardInfoFetch) {
        this.forwardInfoFetch = forwardInfoFetch;
    }

    public int getTotalPageCount() {
        if (this.forwardInfoFetch) {
            this.docInfoProvider.getDocInfos(this.docInfo);
        }
        int cTotal = (Integer)this.docInfo.get("TotalPageCount");
        if (this.docInfo.get("PaginationFinished") != null) {
            if (((Boolean)this.docInfo.get("PaginationFinished")).booleanValue()) {
                return cTotal;
            }
            return cTotal == 0 ? 1 : cTotal;
        }
        return cTotal;
    }

    public void setDocInfoProvider(IDocInfoProvider docInfoProvider) {
        this.docInfoProvider = docInfoProvider;
    }

    public IDocInfoProvider getDocInfoProvider() {
        return this.docInfoProvider;
    }

    public void beginDataUpdate() {
        this.isfirstPageReady = false;
        this.fireUIStateChanged(new UIStateChangedEvent(this, 1));
    }

    public void setDataUpdated(boolean b) {
        if (!b) {
            return;
        }
        this.fireUIStateChanged(new UIStateChangedEvent(this, 1));
        if (!this.isfirstPageReady) {
            this.isfirstPageReady = true;
            this.Goto(0);
        }
    }

    public void finishDataUpdate() {
        this.fireUIStateChanged(new UIStateChangedEvent(this, 0));
    }

    public void service(ServiceManager servmgr) throws ServiceException {
        this.container = (PrintCompContainer)servmgr.lookup("KDPrintService");
    }

    public boolean isAdjustingMargin() {
        return this.isAdjustingMargin;
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    public boolean isDataIncomplete() {
        Object finished;
        if (this.docInfoProvider == null) {
            return false;
        }
        if (this.forwardInfoFetch) {
            this.docInfoProvider.getDocInfos(this.docInfo);
        }
        if ((finished = this.docInfo.get("PaginationFinished")) != null) {
            return (Boolean)finished == false;
        }
        return false;
    }

    public void setAdjustingMargin(boolean isAdjusting) {
        this.isAdjustingMargin = isAdjusting;
        if (isAdjusting) {
            this.fireUIStateChanged(new UIStateChangedEvent(this, 3));
        } else {
            this.fireUIStateChanged(new UIStateChangedEvent(this, 4));
        }
    }

    public void addContextEventListener(ContextEventListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ContextEventListener.class, listener);
    }

    public void removeContextEventListener(ContextEventListener listener) {
        this.listenerList.remove(ContextEventListener.class, listener);
    }

    protected void fireCurrentPageChanged(CurrentPageChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContextEventListener.class) continue;
            ((ContextEventListener)listeners[i + 1]).currentPageChanged(event);
        }
    }

    protected void fireUIStateChanged(UIStateChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContextEventListener.class) continue;
            ((ContextEventListener)listeners[i + 1]).uiStateChanged(event);
        }
    }

    public void updateStatus() {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContextEventListener.class || !(listeners[i + 1] instanceof BaseComponent)) continue;
            BaseComponent baseComp = (BaseComponent)listeners[i + 1];
            String totalPage = this.isDataIncomplete() ? "..." : "" + this.getTotalPageCount();
            baseComp.getStausbar().setLeftInfo(BaseComponent.resources.getString("tip.the") + (this.getCurrentPage() + 1) + BaseComponent.resources.getString("tip.page/total") + totalPage + BaseComponent.resources.getString("tip.page"));
        }
    }

    public void updateView() {
        this.updateMargins();
        this.setPaneFitStyle(this.getPaneFitStyle());
    }

    private void updateMargins() {
        if (this.currentPageIndex >= 0) {
            this.getPreviewPane().marginlines.recalcMargins();
        }
    }

    private void fireUpdateView() {
        if (this.isAdjustingMargin()) {
            this.setAdjustingMargin(false);
            this.setAdjustingMargin(true);
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContextEventListener.class) continue;
            ((ContextEventListener)listeners[i + 1]).updateView(this.theUpdateViewEvent);
        }
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double factor) {
        this.cPageCol = 1;
        this.cPageRow = 1;
        if (this.zoomFactor != factor) {
            this.zoomFactor = factor;
            this.setPaneFitStyle(4);
        }
    }

    public int getPageColsInView() {
        return this.cPageCol;
    }

    public void setPageColsInView(int pageCol) {
        this.cPageCol = pageCol;
    }

    public int getPageRowsInView() {
        return this.cPageRow;
    }

    public void setPageRowsInView(int pageRow) {
        this.cPageRow = pageRow;
    }

    public UpdateViewEvent getTheUpdateViewEvent() {
        return this.theUpdateViewEvent;
    }
}

