/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.read;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.ColorUtil;
import com.kingdee.bos.ctrl.common.util.NumberUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.kds.ICells;
import com.kingdee.bos.ctrl.kdf.kds.IMerges;
import com.kingdee.bos.ctrl.kdf.kds.KDSAttributeSpan;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.kds.ViewSplitInfoVO;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.util.RecordFormatException;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class POIXlsxReader {
    private static final int nonLeapDay = 61;
    private static final int utcOffsetDays = 25569;
    private static final long msInADay = 86400000L;
    private static Map colors = HSSFColor.getIndexHash();
    public static final String NULL_FORMULA = "ATTR(semiVolatile)";
    public static final String EXPORT_FORMULA = "EXPORT_FORMULA";
    public static final String IMPORT_FORMAT = "IMPORT_FORMAT";
    public static final String IMPORT_STYLE = "IMPORT_STYLE";
    public static final String KD_SINGLE_COMMA = "\\\\'";
    public static final String KD_DOUBLE_COMMA = "'";
    public static final String KD_EXCHANGE_COMMA = "KD_EXCHANGE_COMMA";
    public static final String KD_FORMULA_SPLIT = "_@_";
    static HashSet extendDateFormat = new HashSet();

    public static KDSBook parse(String xlsfileName) {
        KDSBook book = null;
        try {
            book = POIXlsxReader.parse2(xlsfileName);
        }
        catch (FileNotFoundException e) {
            book = null;
        }
        catch (IOException e) {
            book = null;
        }
        catch (Exception e) {
            book = null;
        }
        return book;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KDSBook parse2(String xlsfileName) throws FileNotFoundException, IOException {
        KDSBook book = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(xlsfileName);
            book = POIXlsxReader.parse2(stream);
        }
        catch (FileNotFoundException e) {
            book = null;
            throw e;
        }
        catch (IOException e) {
            book = null;
            throw e;
        }
        catch (Exception e) {
            book = null;
        }
        finally {
            if (null != stream) {
                ((InputStream)stream).close();
            }
        }
        return book;
    }

    public static KDSBook parse(String xlsfileName, HashMap parameter) {
        KDSBook book = null;
        try {
            book = POIXlsxReader.parse2(xlsfileName, parameter);
        }
        catch (FileNotFoundException e) {
            book = null;
        }
        catch (IOException e) {
            book = null;
        }
        catch (InvalidFormatException e) {
            book = null;
            e.printStackTrace();
        }
        return book;
    }

    public static KDSBook parse2(String xlsfileName, HashMap parameter) throws FileNotFoundException, IOException, InvalidFormatException {
        KDSBook book = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(xlsfileName);
            book = POIXlsxReader.parse2(stream, parameter);
        }
        catch (FileNotFoundException e) {
            book = null;
            throw e;
        }
        catch (IOException e) {
            book = null;
            throw e;
        }
        catch (InvalidFormatException e) {
            book = null;
            throw e;
        }
        finally {
            if (null != stream) {
                ((InputStream)stream).close();
            }
        }
        return book;
    }

    public static KDSBook parse(InputStream stream) {
        KDSBook book = null;
        try {
            book = POIXlsxReader.parse2(stream);
        }
        catch (FileNotFoundException e) {
            book = null;
        }
        catch (IOException e) {
            book = null;
        }
        catch (Exception e) {
            book = null;
        }
        return book;
    }

    public static KDSBook parse2(InputStream stream) throws Exception {
        KDSBook book = null;
        XSSFWorkbook wb = null;
        OPCPackage pkg = OPCPackage.open((InputStream)stream);
        wb = new XSSFWorkbook(pkg);
        book = new KDSBook("aa");
        for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
            CTCols ctCol;
            List cols;
            XSSFSheet sheet = wb.getSheetAt(k);
            KDSSheet kdssheet = new KDSSheet(book, wb.getSheetName(k));
            try {
                book.addSheet(null, kdssheet);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            int lastCol = -1;
            int rows = sheet.getLastRowNum();
            PaneInformation paneinfo = sheet.getPaneInformation();
            if (null != paneinfo && paneinfo.isFreezePane()) {
                ViewSplitInfoVO info = new ViewSplitInfoVO();
                info.setFreezed(true);
                info.setColSplit(paneinfo.getVerticalSplitPosition());
                info.setActivePane(POIXlsxReader.getSplitPaneIndex(paneinfo.getActivePane() + 1));
                info.setRowSplit(paneinfo.getHorizontalSplitPosition());
                info.setColFixLine(paneinfo.getVerticalSplitLeftColumn());
                info.setRowFixLine(paneinfo.getHorizontalSplitTopRow());
                kdssheet.setViewSplitInfo(info);
            }
            block5: for (int r = 0; r <= rows; ++r) {
                XSSFRow row = sheet.getRow(r);
                if (row == null) {
                    kdssheet.getRows().setRowHeight(r, (float)(StyleUtil.ptToLom((double)(sheet.getDefaultRowHeight() / 20)) / 10.0));
                    continue;
                }
                float h = (float)(StyleUtil.ptToLom((double)(row.getHeight() / 20)) / 10.0);
                if (row.getOutlineLevel() != 0) {
                    KDSAttributeSpan span = new KDSAttributeSpan(r, r, null, (int)h, !row.getCTRow().isSetHidden(), row.getOutlineLevel(), row.getCTRow().isSetCollapsed());
                    if (null == kdssheet.getRowSpans()) {
                        kdssheet.setRowSpans(new ArrayList());
                    }
                    kdssheet.getRowSpans().add(span);
                } else {
                    kdssheet.getRows().setRowHeight(r, h);
                }
                int cols2 = row.getLastCellNum() + 1;
                for (int c = 0; c < cols2; ++c) {
                    XSSFCell cell = row.getCell((int)((short)c));
                    if (cell == null) continue;
                    if (c > lastCol) {
                        lastCol = c;
                    }
                    CellType type = CellType.NUMERIC;
                    Object value = null;
                    String formula = null;
                    CellType cellType = cell.getCellType();
                    if (cellType == CellType.NUMERIC) {
                        if (POIXlsxReader.isValidExcelDate(wb, cell)) {
                            value = cell.getDateCellValue();
                            Date dateValue = (Date)value;
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(dateValue);
                            value = cal;
                            type = CellType.NUMERIC;
                        } else {
                            value = POIXlsxReader.double2String(cell.getNumericCellValue());
                            value = NumberUtil.cutZero((String)((String)value));
                            type = CellType.NUMERIC;
                        }
                    } else if (cellType == CellType.STRING) {
                        value = cell.getStringCellValue();
                        type = CellType.STRING;
                    } else if (cellType == CellType.FORMULA) {
                        value = cell.getCachedFormulaResultType() == CellType.STRING ? cell.getStringCellValue() : "";
                        if (StringUtil.isEmptyString((String)((String)value))) {
                            value = CellType.ERROR == cell.getCachedFormulaResultType() ? "" : (CellType.NUMERIC == cell.getCachedFormulaResultType() ? POIXlsxReader.double2String(cell.getNumericCellValue()) : "");
                        }
                        try {
                            formula = cell.getCellFormula();
                        }
                        catch (RecordFormatException rfe) {
                            value = POIXlsxReader.double2String(cell.getNumericCellValue());
                            value = NumberUtil.cutZero((String)((String)value));
                            if (value.equals("NaN")) {
                                value = cell.getRichStringCellValue().toString();
                            }
                            type = CellType.STRING;
                            continue block5;
                        }
                        String[] returnValue = POIXlsxReader.convertFormula(formula);
                        if (returnValue[1].equals("1")) {
                            value = returnValue[2];
                        }
                        formula = returnValue[0];
                        type = CellType.FORMULA;
                    } else if (cellType == CellType.BOOLEAN) {
                        value = String.valueOf(cell.getBooleanCellValue());
                        type = CellType.BOOLEAN;
                    } else if (cellType == CellType.ERROR) {
                        value = String.valueOf(cell.getErrorCellValue());
                        type = CellType.STRING;
                    } else {
                        value = cell.getStringCellValue();
                        type = CellType.STRING;
                    }
                    ICells kdscells = kdssheet.getCells();
                    XSSFCellStyle hssfcellstyle = cell.getCellStyle();
                    StyleAttributes kdsa = POIXlsxReader.hssfstyle2kdStyleAttribute(wb, hssfcellstyle, true, true, type);
                    int colIndex = cell.getColumnIndex();
                    KDSCell kdsCll = !kdsa.isEmpty() ? kdscells.setCell(r, colIndex, value, formula, Styles.getSSA((StyleAttributes)kdsa)) : kdscells.setCellValue(r, colIndex, value);
                    kdsCll.setType((short)type.getCode());
                    if (formula != null) {
                        kdssheet.getCell(r, colIndex, true).setFormula(formula);
                    }
                    if (null == cell.getHyperlink()) continue;
                    HyperLink hyperLink = new HyperLink();
                    if (cell.getHyperlink().getAddress().indexOf("#") != -1) {
                        hyperLink.setLinkTo(cell.getHyperlink().getAddress());
                    } else {
                        hyperLink.setLinkTo("#" + cell.getHyperlink().getAddress());
                    }
                    hyperLink.setText(cell.getHyperlink().getLabel());
                    kdsCll.setHyperLink(hyperLink);
                }
            }
            POIXlsxReader.parseMergeCell(sheet, kdssheet);
            for (int i = 0; i <= lastCol; ++i) {
                int tempWidth = sheet.getColumnWidth(i);
                if (tempWidth == 8) {
                    tempWidth = 2340;
                }
                kdssheet.setColumnWidth(i, (float)((double)tempWidth / 120.0));
            }
            CTWorksheet ctSheet = sheet.getCTWorksheet();
            List ctCols = ctSheet.getColsList();
            if (null == ctCols || ctCols.isEmpty() || null == (cols = (ctCol = (CTCols)ctCols.get(0)).getColList())) continue;
            for (int i = 0; i < cols.size(); ++i) {
                CTCol col = (CTCol)cols.get(i);
                if (null == col) continue;
                int min = (int)(col.getMin() - 1L);
                int max = (int)(col.getMax() - 1L);
                boolean collapsed = col.getCollapsed();
                boolean hidden = col.getHidden();
                double width = col == null || !col.isSetWidth() ? (double)sheet.getDefaultColumnWidth() : col.getWidth();
                double h = StyleUtil.unitToMM((double)width);
                KDSAttributeSpan span = new KDSAttributeSpan(min, max, null, (int)h, !hidden, col.getOutlineLevel(), collapsed);
                if (null == kdssheet.getColSpans()) {
                    kdssheet.setColSpans(new ArrayList());
                }
                kdssheet.getColSpans().add(span);
            }
        }
        return book;
    }

    private static int getSplitPaneIndex(int ctPane) {
        int ret = 3;
        switch (ctPane) {
            case 3: {
                ret = 2;
                break;
            }
            case 2: {
                ret = 1;
                break;
            }
            case 4: {
                ret = 0;
                break;
            }
        }
        return ret;
    }

    private static String double2String(double value) {
        return NumberUtil.double2String((double)value);
    }

    public static KDSBook parse(InputStream stream, HashMap parameter) {
        KDSBook book = null;
        try {
            POIXlsxReader.parse2(stream, parameter);
        }
        catch (FileNotFoundException e) {
            book = null;
        }
        catch (IOException e) {
            book = null;
        }
        catch (InvalidFormatException e) {
            book = null;
            e.printStackTrace();
        }
        return book;
    }

    public static KDSBook parse2(InputStream stream, HashMap parameter) throws FileNotFoundException, IOException, InvalidFormatException {
        String sImportFormula = (String)parameter.get(EXPORT_FORMULA);
        boolean importFormula = true;
        if (!StringUtil.isEmptyString((String)sImportFormula)) {
            importFormula = Boolean.valueOf(sImportFormula);
        }
        String sImportFormat = (String)parameter.get(IMPORT_FORMAT);
        boolean importFormat = true;
        if (!StringUtil.isEmptyString((String)sImportFormat)) {
            importFormat = Boolean.valueOf(sImportFormat);
        }
        String sImportStyle = (String)parameter.get(IMPORT_STYLE);
        boolean importStyle = true;
        if (!StringUtil.isEmptyString((String)sImportStyle)) {
            importStyle = Boolean.valueOf(sImportStyle);
        }
        KDSBook book = null;
        XSSFWorkbook wb = null;
        OPCPackage pkg = OPCPackage.open((InputStream)stream);
        wb = new XSSFWorkbook(pkg);
        book = new KDSBook("aa");
        for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
            CTCols ctCol;
            List cols;
            XSSFSheet sheet = wb.getSheetAt(k);
            KDSSheet kdssheet = new KDSSheet(book, wb.getSheetName(k));
            try {
                book.addSheet(null, kdssheet);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            int lastCol = 0;
            int rows = sheet.getLastRowNum();
            PaneInformation paneinfo = sheet.getPaneInformation();
            if (paneinfo.isFreezePane()) {
                ViewSplitInfoVO info = new ViewSplitInfoVO();
                info.setFreezed(true);
                info.setColSplit(paneinfo.getVerticalSplitPosition());
                info.setActivePane(POIXlsxReader.getSplitPaneIndex(paneinfo.getActivePane() + 1));
                info.setRowSplit(paneinfo.getHorizontalSplitPosition());
                info.setColFixLine(paneinfo.getVerticalSplitLeftColumn());
                info.setRowFixLine(paneinfo.getHorizontalSplitTopRow());
                kdssheet.setViewSplitInfo(info);
            }
            for (int r = 0; r <= rows; ++r) {
                XSSFRow row = sheet.getRow(r);
                if (row == null) {
                    kdssheet.getRows().setRowHeight(r, (float)(StyleUtil.ptToLom((double)(sheet.getDefaultRowHeight() / 20)) / 10.0));
                    continue;
                }
                float h = (float)(StyleUtil.ptToLom((double)(row.getHeight() / 20)) / 10.0);
                if (row.getOutlineLevel() != 0) {
                    KDSAttributeSpan span = new KDSAttributeSpan(r, r, null, (int)h, !row.getCTRow().isSetHidden(), row.getOutlineLevel(), row.getCTRow().isSetCollapsed());
                    if (null == kdssheet.getRowSpans()) {
                        kdssheet.setRowSpans(new ArrayList());
                    }
                    kdssheet.getRowSpans().add(span);
                } else {
                    kdssheet.getRows().setRowHeight(r, h);
                }
                int cols2 = row.getLastCellNum() + 1;
                if (cols2 > lastCol) {
                    lastCol = cols2;
                }
                for (int c = 0; c < cols2; ++c) {
                    XSSFCell cell = row.getCell((int)((short)c));
                    if (cell == null) {
                        if (c != cols2 - 1) continue;
                        lastCol = cols2 - 1;
                        continue;
                    }
                    CellType type = CellType.NUMERIC;
                    Object value = null;
                    String formula = null;
                    switch (cell.getCellTypeEnum().getCode()) {
                        case 0: {
                            if (POIXlsxReader.isValidExcelDate(wb, cell)) {
                                value = cell.getDateCellValue();
                                Date dateValue = (Date)value;
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(dateValue);
                                value = cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5);
                                if (cal.get(12) != 0 || cal.get(11) != 0) {
                                    value = value + " " + cal.get(11) + ":" + cal.get(12);
                                }
                                type = CellType.NUMERIC;
                                break;
                            }
                            Double d = new Double(cell.getNumericCellValue());
                            value = new BigDecimal(d.toString()).toString();
                            value = NumberUtil.cutZero((String)((String)value));
                            type = CellType.NUMERIC;
                            break;
                        }
                        case 1: {
                            value = cell.getStringCellValue();
                            type = CellType.STRING;
                            break;
                        }
                        case 2: {
                            value = Double.isNaN(cell.getNumericCellValue()) ? (cell.getCachedFormulaResultType() == CellType.STRING ? cell.getStringCellValue() : "") : (cell.getCachedFormulaResultType() == CellType.NUMERIC ? String.valueOf(cell.getNumericCellValue()) : "");
                            formula = cell.getCellFormula();
                            String[] returnValue = POIXlsxReader.convertFormula(formula);
                            if (returnValue[1].equals("1")) {
                                value = returnValue[2];
                            }
                            formula = returnValue[0];
                            type = CellType.FORMULA;
                            break;
                        }
                        case 4: {
                            value = String.valueOf(cell.getBooleanCellValue());
                            type = CellType.FORMULA;
                            break;
                        }
                        default: {
                            value = cell.getStringCellValue();
                            type = CellType.STRING;
                        }
                    }
                    ICells kdscells = kdssheet.getCells();
                    XSSFCellStyle hssfcellstyle = cell.getCellStyle();
                    StyleAttributes kdsa = POIXlsxReader.hssfstyle2kdStyleAttribute(wb, hssfcellstyle, importFormat, importStyle, type);
                    int colIndex = cell.getColumnIndex();
                    if (!kdsa.isEmpty()) {
                        if (formula != null && importFormula) {
                            kdscells.setCell(r, colIndex, value, formula, Styles.getSSA((StyleAttributes)kdsa));
                            continue;
                        }
                        kdscells.setCell(r, colIndex, value, "", Styles.getSSA((StyleAttributes)kdsa));
                        continue;
                    }
                    if (formula != null && importFormula) {
                        kdssheet.getCell(r, colIndex, true).setFormula(formula);
                    }
                    kdscells.setCellValue(r, colIndex, value);
                }
            }
            POIXlsxReader.parseMergeCell(sheet, kdssheet);
            for (int i = 0; i < lastCol; ++i) {
                int tempWidth = sheet.getColumnWidth(i);
                if (tempWidth == 8) {
                    tempWidth = 2340;
                }
                kdssheet.setColumnWidth(i, (float)((double)tempWidth / 140.0));
            }
            CTWorksheet ctSheet = sheet.getCTWorksheet();
            List ctCols = ctSheet.getColsList();
            if (null == ctCols || ctCols.isEmpty() || null == (cols = (ctCol = (CTCols)ctCols.get(0)).getColList())) continue;
            for (int i = 0; i < cols.size(); ++i) {
                CTCol col = (CTCol)cols.get(i);
                if (null == col) continue;
                int min = (int)(col.getMin() - 1L);
                int max = (int)(col.getMax() - 1L);
                boolean collapsed = col.getCollapsed();
                boolean hidden = col.getHidden();
                double width = col == null || !col.isSetWidth() ? (double)sheet.getDefaultColumnWidth() : col.getWidth();
                double h = StyleUtil.unitToMM((double)width);
                KDSAttributeSpan span = new KDSAttributeSpan(min, max, null, (int)h, !hidden, col.getOutlineLevel(), collapsed);
                if (null == kdssheet.getColSpans()) {
                    kdssheet.setColSpans(new ArrayList());
                }
                kdssheet.getColSpans().add(span);
            }
        }
        return book;
    }

    public static String[] convertFormula(String formula) {
        int pos;
        String tmpFormula = formula;
        String[] returnValue = new String[3];
        returnValue[1] = "0";
        String formulaValue = "";
        if (tmpFormula.indexOf(KD_FORMULA_SPLIT) != -1 && tmpFormula.toLowerCase().indexOf("mid(\"") != -1) {
            tmpFormula = tmpFormula.replace("\"&\"", "");
            int beginIndex = tmpFormula.toLowerCase().indexOf("mid(\"") + "mid(\"".length();
            int endIndex = tmpFormula.indexOf(KD_FORMULA_SPLIT);
            int valueIndex = tmpFormula.lastIndexOf(",");
            formulaValue = tmpFormula.substring(0, valueIndex - 1);
            valueIndex = formulaValue.lastIndexOf(",") - 1;
            formula = tmpFormula.substring(beginIndex, endIndex);
            String sValue = tmpFormula.substring(endIndex + KD_FORMULA_SPLIT.length(), valueIndex);
            formula = POIXlsxReader.convertFormulaSpecialString(formula);
            sValue = POIXlsxReader.convertFormulaSpecialString(sValue);
            returnValue[1] = "1";
            returnValue[2] = sValue;
        }
        int iNullIndex = formula.indexOf(NULL_FORMULA);
        int iNullLen = NULL_FORMULA.length();
        while (iNullIndex != -1) {
            formula = formula.substring(0, iNullIndex) + formula.substring(iNullIndex + iNullLen);
            iNullIndex = formula.indexOf(NULL_FORMULA);
        }
        if (formula != null && (pos = formula.indexOf("!")) > 0) {
            String sheetName = formula.substring(0, pos);
            try {
                Double.parseDouble(sheetName);
                formula = KD_DOUBLE_COMMA + sheetName + KD_DOUBLE_COMMA + formula.substring(pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        returnValue[0] = formula;
        return returnValue;
    }

    public static String convertFormulaSpecialString(String formula) {
        formula = formula.replace(KD_SINGLE_COMMA, KD_EXCHANGE_COMMA);
        formula = formula.replace(KD_DOUBLE_COMMA, "\"");
        formula = formula.replace(KD_EXCHANGE_COMMA, KD_DOUBLE_COMMA);
        return formula;
    }

    private static boolean isValidExcelDate(XSSFWorkbook wb, XSSFCell cell) {
        boolean isValid = false;
        isValid = DateUtil.isCellDateFormatted((Cell)cell);
        XSSFCellStyle style = cell.getCellStyle();
        short i = style.getDataFormat();
        XSSFDataFormat workFormat = wb.createDataFormat();
        String formatStr = workFormat.getFormat(i);
        if (!isValid && extendDateFormat.contains(formatStr)) {
            isValid = true;
        }
        return isValid;
    }

    static void parseMergeCell(XSSFSheet sheet, KDSSheet kdssheet) {
        int merges = sheet.getNumMergedRegions();
        IMerges kdsmerges = kdssheet.getMerges();
        for (int i = 0; i < merges; ++i) {
            CellRangeAddress mergeRegion = sheet.getMergedRegion(i);
            int row = mergeRegion.getFirstRow();
            int col = mergeRegion.getFirstColumn();
            kdsmerges.addMerge(row, col, mergeRegion.getLastRow(), mergeRegion.getLastColumn());
            XSSFCell cell = sheet.getRow(row).getCell(col);
            if (null == cell || null == cell.getHyperlink()) continue;
            HyperLink hyper = new HyperLink();
            if (cell.getHyperlink().getAddress().indexOf("#") != -1) {
                hyper.setLinkTo(cell.getHyperlink().getAddress());
            } else {
                hyper.setLinkTo("#" + cell.getHyperlink().getAddress());
            }
            kdssheet.getCell(row, col, false).setHyperLink(hyper);
        }
    }

    static StyleAttributes hssfstyle2kdStyleAttribute(XSSFWorkbook wb, XSSFCellStyle hssfstyle, boolean importFormat, boolean importStyle, CellType valueType) {
        StyleAttributes sa = Styles.getEmptySA();
        ShareStyleAttributes defaultssa = Styles.getDefaultSSA();
        if (importStyle) {
            XSSFFont hssffont = wb.getFontAt(hssfstyle.getFontIndex());
            POIXlsxReader.font2SA(defaultssa, sa, hssffont);
            POIXlsxReader.alignment2SA(defaultssa, sa, hssfstyle, valueType);
            POIXlsxReader.protection2SA(defaultssa, sa, hssfstyle);
            POIXlsxReader.borders2SA(defaultssa, sa, hssfstyle);
            POIXlsxReader.interior2SA(defaultssa, sa, hssfstyle);
        }
        if (importFormat && hssfstyle.getDataFormat() != 0) {
            try {
                XSSFDataFormat dataFormat = wb.createDataFormat();
                String format = dataFormat.getFormat(hssfstyle.getDataFormat());
                if (!StringUtil.isEmptyString((String)format) && format.indexOf(40) == 0 && format.indexOf("_);") != -1) {
                    format = format.substring(1);
                }
                sa.setNumberFormat(format);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sa;
    }

    private static void font2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFFont hssffont) {
        String fontName = hssffont.getFontName();
        if (!defaultssa.getFontName().equals(fontName)) {
            sa.setFontName(fontName);
        }
        short fontSize = hssffont.getFontHeightInPoints();
        sa.setFontSize((int)fontSize);
        Color awtclr = POIXlsxReader.getAWTColor(hssffont.getXSSFColor());
        if (!defaultssa.getFontColor().equals(awtclr)) {
            sa.setFontColor(awtclr);
        }
        boolean bvalue = hssffont.getBold();
        if (defaultssa.isBold() != bvalue) {
            sa.setBold(bvalue);
        }
        bvalue = hssffont.getItalic();
        if (defaultssa.isItalic() != bvalue) {
            sa.setItalic(bvalue);
        }
        bvalue = hssffont.getStrikeout();
        if (defaultssa.isStrikeThrough() != bvalue) {
            sa.setStrikeThrough(bvalue);
        }
        boolean bl = bvalue = hssffont.getUnderline() != 0;
        if (defaultssa.isUnderline() != bvalue) {
            sa.setUnderline(bvalue);
        }
    }

    private static void alignment2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle hssfstyle, CellType valueType) {
        Styles.VerticalAlignment valign;
        Styles.HorizontalAlignment align;
        short ali = hssfstyle.getAlignment().getCode();
        switch (ali) {
            case 1: {
                align = Styles.HorizontalAlignment.LEFT;
                break;
            }
            case 2: {
                align = Styles.HorizontalAlignment.RIGHT;
                break;
            }
            case 3: {
                align = Styles.HorizontalAlignment.CENTER;
                break;
            }
            default: {
                Styles.HorizontalAlignment horizontalAlignment = align = valueType == CellType.NUMERIC ? Styles.HorizontalAlignment.RIGHT : Styles.HorizontalAlignment.NORMAL;
            }
        }
        if (align != null) {
            sa.setHorizontalAlign(align);
        }
        short agn = hssfstyle.getVerticalAlignment().getCode();
        switch (agn) {
            case 1: {
                valign = Styles.VerticalAlignment.TOP;
                break;
            }
            case 2: {
                valign = Styles.VerticalAlignment.MIDDLE;
                break;
            }
            case 3: {
                valign = Styles.VerticalAlignment.BOTTOM;
                break;
            }
            default: {
                valign = Styles.VerticalAlignment.BOTTOM;
            }
        }
        if (defaultssa.getVerticalAlign() != valign) {
            sa.setVerticalAlign(valign);
        }
        boolean bwraptext = hssfstyle.getWrapText();
        if (defaultssa.isWrapText() != bwraptext) {
            sa.setWrapText(bwraptext);
        }
        short roration = hssfstyle.getRotation();
        if (defaultssa.getRotation() != roration) {
            sa.setRotation((int)roration);
        }
    }

    private static void borders2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle hssfstyle) {
        Color awtbordercolor = POIXlsxReader.getAWTColor(hssfstyle.getLeftBorderXSSFColor());
        if (awtbordercolor != null && !defaultssa.getBorderColor(Styles.Position.LEFT).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.LEFT, awtbordercolor);
        }
        if ((awtbordercolor = POIXlsxReader.getAWTColor(hssfstyle.getRightBorderXSSFColor())) != null && !defaultssa.getBorderColor(Styles.Position.RIGHT).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.RIGHT, awtbordercolor);
        }
        awtbordercolor = POIXlsxReader.getAWTColor(hssfstyle.getTopBorderXSSFColor());
        if (!defaultssa.getBorderColor(Styles.Position.TOP).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.TOP, awtbordercolor);
        }
        awtbordercolor = POIXlsxReader.getAWTColor(hssfstyle.getBottomBorderXSSFColor());
        if (!defaultssa.getBorderColor(Styles.Position.BOTTOM).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.BOTTOM, awtbordercolor);
        }
        POIXlsxReader.borderstyle2sa(sa, Styles.Position.BOTTOM, hssfstyle.getBorderBottom().getCode());
        POIXlsxReader.borderstyle2sa(sa, Styles.Position.LEFT, hssfstyle.getBorderLeft().getCode());
        POIXlsxReader.borderstyle2sa(sa, Styles.Position.RIGHT, hssfstyle.getBorderRight().getCode());
        POIXlsxReader.borderstyle2sa(sa, Styles.Position.TOP, hssfstyle.getBorderTop().getCode());
    }

    static void borderstyle2sa(StyleAttributes sa, Styles.Position pos, short hssfborder) {
        if (hssfborder == BorderStyle.NONE.getCode()) {
            sa.setBorderLineStyle(pos, LineStyle.NULL_LINE);
        } else if (hssfborder == BorderStyle.THIN.getCode()) {
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
            sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
        } else if (hssfborder == BorderStyle.DASH_DOT.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOTDOT);
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
        } else if (hssfborder == BorderStyle.DASH_DOT_DOT.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
        } else if (hssfborder == BorderStyle.DASHED.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DOT);
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
        } else if (hssfborder == BorderStyle.DOTTED.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_CONTINUOUS);
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
        } else if (hssfborder == BorderStyle.MEDIUM.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
            sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
        } else if (hssfborder == BorderStyle.MEDIUM_DASHED.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DOT);
            sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
        } else if (hssfborder == BorderStyle.MEDIUM_DASH_DOT.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOTDOT);
            sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
        } else if (hssfborder == BorderStyle.MEDIUM_DASH_DOT_DOT.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
            sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
        } else {
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
            sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
        }
    }

    private static void protection2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle hssfstyle) {
        boolean bLock = hssfstyle.getLocked();
        if (defaultssa.isLocked() != bLock) {
            sa.setLocked(bLock);
        }
        boolean bhide = hssfstyle.getHidden();
        if (defaultssa.isHided() != bhide) {
            sa.setHided(bhide);
        }
    }

    private static void interior2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle hssfstyle) {
        short backmode = hssfstyle.getFillPattern().getCode();
        Pattern pn = POIXlsxReader.getkdpattern(backmode);
        if (pn != Pattern.None) {
            if (pn == Pattern.Solid) {
                double tint;
                Color awtcolor = POIXlsxReader.getAWTColor(hssfstyle.getFillForegroundColorColor());
                if (!defaultssa.getBackground().equals(awtcolor)) {
                    sa.setBackground(awtcolor);
                }
                if ((tint = hssfstyle.getFillForegroundXSSFColor().getTint()) == 0.0) {
                    sa.setBackground(POIXlsxReader.wrapperColor(hssfstyle.getFillForegroundXSSFColor()));
                } else {
                    byte[] rgbWithTint = hssfstyle.getFillForegroundXSSFColor().getRGBWithTint();
                    sa.setBackground(new Color(POIXlsxReader.changeRGB(rgbWithTint[0]), POIXlsxReader.changeRGB(rgbWithTint[1]), POIXlsxReader.changeRGB(rgbWithTint[2])));
                }
            } else {
                double tint;
                Color awtcolor = POIXlsxReader.getAWTColor(hssfstyle.getFillBackgroundColorColor());
                if (!defaultssa.getBackground().equals(awtcolor)) {
                    sa.setBackground(awtcolor);
                }
                if ((tint = hssfstyle.getFillForegroundXSSFColor().getTint()) == 0.0) {
                    sa.setBackground(POIXlsxReader.wrapperColor(hssfstyle.getFillForegroundXSSFColor()));
                } else {
                    byte[] rgbWithTint = hssfstyle.getFillForegroundXSSFColor().getRGBWithTint();
                    sa.setBackground(new Color(POIXlsxReader.changeRGB(rgbWithTint[0]), POIXlsxReader.changeRGB(rgbWithTint[1]), POIXlsxReader.changeRGB(rgbWithTint[2])));
                }
                awtcolor = POIXlsxReader.getAWTColor(hssfstyle.getFillForegroundColorColor());
                if (!defaultssa.getPatternColor().equals(awtcolor)) {
                    sa.setPatternColor(awtcolor);
                }
            }
        }
        sa.setPattern(pn);
    }

    private static int changeRGB(int number) {
        return ((number & 0xFF) >> 4) * 16 + (number & 0xF);
    }

    private static Color wrapperColor(XSSFColor borderColor) {
        Color color = new Color(0, 0, 0);
        if (null != borderColor && borderColor.getARGBHex() != null) {
            color = ColorUtil.parseColor((String)("#" + borderColor.getARGBHex().substring(2)));
        }
        return color;
    }

    private static Pattern getkdpattern(short backmode) {
        Pattern pn;
        switch (backmode) {
            case 1: {
                pn = Pattern.Solid;
                break;
            }
            case 2: {
                pn = Pattern.Percent50;
                break;
            }
            case 3: {
                pn = Pattern.Percent25;
                break;
            }
            case 4: {
                pn = Pattern.Percent70;
                break;
            }
            case 5: {
                pn = Pattern.DarkHorizontal;
                break;
            }
            case 6: {
                pn = Pattern.DarkVertical;
                break;
            }
            case 7: {
                pn = Pattern.DarkDownwardDiagonal;
                break;
            }
            case 8: {
                pn = Pattern.DarkUpwardDiagonal;
                break;
            }
            case 9: {
                pn = Pattern.SmallCheckerBoard;
                break;
            }
            case 10: {
                pn = Pattern.Trellis;
                break;
            }
            case 11: {
                pn = Pattern.Percent60;
                break;
            }
            case 12: {
                pn = Pattern.LightVertical;
                break;
            }
            case 13: {
                pn = Pattern.LightDownwardDiagonal;
                break;
            }
            case 14: {
                pn = Pattern.LightUpwardDiagonal;
                break;
            }
            case 15: {
                pn = Pattern.SmallGrid;
                break;
            }
            case 16: {
                pn = Pattern.Percent30;
                break;
            }
            case 17: {
                pn = Pattern.Percent20;
                break;
            }
            case 18: {
                pn = Pattern.Percent10;
                break;
            }
            default: {
                pn = Pattern.None;
            }
        }
        return pn;
    }

    private static Color getAWTColor(XSSFColor color) {
        byte[] rgb;
        Color awtcolor = null;
        if (color != null && (rgb = color.getRGB()) != null) {
            int r = rgb[0] < 0 ? rgb[0] + 256 : rgb[0];
            int g = rgb[1] < 0 ? rgb[1] + 256 : rgb[1];
            int b = rgb[2] < 0 ? rgb[2] + 256 : rgb[2];
            awtcolor = new Color(r, g, b);
        }
        return awtcolor;
    }

    private static final Color getAWTColor(HSSFColor clr) {
        short[] rgb = clr.getTriplet();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    private static final Color getAWTColor(int index, Color deflt) {
        HSSFColor clr = (HSSFColor)colors.get(new Integer(index));
        if (clr == null) {
            return deflt;
        }
        return POIXlsxReader.getAWTColor(clr);
    }

    private static final Color getAWTColor(int index) {
        HSSFColor clr = (HSSFColor)colors.get(new Integer(index));
        if (clr == null) {
            return null;
        }
        return POIXlsxReader.getAWTColor(clr);
    }

    public static Date getDate(double numValue) {
        if (numValue < 61.0) {
            numValue += 1.0;
        }
        int offsetDays = 25569;
        double utcDays = numValue - (double)offsetDays;
        long utcValue = Math.round(utcDays * 8.64E7);
        return new Date(utcValue);
    }

    public static int getColumnNumber(HSSFRow row) {
        int colNum = 0;
        short tempColNum = 0;
        if (row != null && row.getCell((int)(tempColNum = (short)((colNum = (int)row.getLastCellNum()) + 1))) != null) {
            ++colNum;
        }
        return colNum;
    }

    static {
        extendDateFormat.add("[$-F800]dddd\\,\\ mmmm\\ dd\\,\\ yyyy");
        extendDateFormat.add("yyyy\"\u5e74\"m\"\u6708\"d\"\u65e5\";@");
        extendDateFormat.add("yyyy\"\u5e74\"m\"\u6708\";@");
        extendDateFormat.add("m\"\u6708\"d\"\u65e5\";@");
        extendDateFormat.add("yyyy/m/d;@");
        extendDateFormat.add("[$-409]yyyy/m/d\\ h:mm\\ AM/PM;@");
        extendDateFormat.add("yyyy/m/d\\ h:mm;@");
        extendDateFormat.add("yy/m/d;@");
        extendDateFormat.add("m/d;@");
        extendDateFormat.add("m/d/yy;@");
        extendDateFormat.add("mm/dd/yy;@");
        extendDateFormat.add("[$-F400]h:mm:ss\\ AM/PM");
        extendDateFormat.add("h:mm;@");
        extendDateFormat.add("[$-409]h:mm\\ AM/PM;@");
        extendDateFormat.add("h:mm:ss;@");
        extendDateFormat.add("h\"\u65f6\"mm\"\u5206\";@");
        extendDateFormat.add("h\"\u65f6\"mm\"\u5206\"ss\"\u79d2\";@");
        extendDateFormat.add("\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\";@");
        extendDateFormat.add("\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\"ss\"\u79d2\";@");
        extendDateFormat.add("[DBNum1][$-804]h\"\u65f6\"mm\"\u5206\";@");
        extendDateFormat.add("[DBNum1][$-804]\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\";@");
    }
}

