/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.bim.reportimpl.table;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.report.forapp.bim.reportimpl.table.IKDTableRptExecutor;
import com.kingdee.bos.ctrl.report.forapp.bim.reportimpl.table.KDTableRptExecutor;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.KDTDesignerPanel;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.RTException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.browse.AReportBrowser;
import com.kingdee.bos.ctrl.reportone.reportimpl.xdata.DataBindUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class KDTableRptBrowser
extends AReportBrowser {
    private static final Logger log = LogUtil.getPackageLogger(KDTableRptBrowser.class);
    private KDTable kdtable;

    public KDTableRptBrowser(Component owner) {
        super(owner);
    }

    public static HashMap makeExecuteArgs(RequestRowSetEvent e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)DataBindUtil.makeString((RequestRowSetEvent)e));
        }
        int start = (Integer)e.getParam1();
        int end = (Integer)e.getParam2();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(KDTableRptExecutor.ARG_String_fullPath, e.getDataSourceID());
        args.put(KDTableRptExecutor.ARG_StringA_fieldNames, e.getFields());
        args.put(KDTableRptExecutor.ARG_Integer_start, e.getParam1());
        args.put(KDTableRptExecutor.ARG_Integer_length, new Integer(end - start + 1));
        return args;
    }

    public Component getComponent() {
        return this.kdtable;
    }

    public void browse(HashMap params) throws ReportException {
        ByteArrayInputStream tpl;
        if (this.kdtable != null) {
            return;
        }
        this.getReportExecutor().execute(params);
        log.debug((Object)"Load KDTable template ...");
        try {
            tpl = new ByteArrayInputStream(((IKDTableRptExecutor)this.getReportExecutor()).readTemplate());
        }
        catch (ReportException ex) {
            throw ReportException.makeException((Throwable)ex);
        }
        log.debug((Object)"Create KDTable browser ...");
        this.kdtable = new KDTable();
        KDTableDataListener dataLisnter = new KDTableDataListener();
        this.kdtable.addRequestRowSetListener((RequestRowSetListener)dataLisnter);
        this.kdtable.addKDTDataFillListener((KDTDataFillListener)dataLisnter);
        this.kdtable.setFormatXml((InputStream)tpl);
        this.kdtable.checkParsed();
        KDTDesignerPanel.convertChinese(this.kdtable);
        this.kdtable.getDataRequestManager().setDataRequestMode(1);
    }

    public void print() throws ReportException {
        this.browse(null);
        this.kdtable.getPrintManager().print();
    }

    public void printPreview() throws ReportException {
        this.browse(null);
        this.kdtable.getPrintManager().printPreview();
    }

    private class KDTableDataListener
    implements RequestRowSetListener,
    KDTDataFillListener {
        private IRowSet rs;

        private KDTableDataListener() {
        }

        public void doRequestRowSet(RequestRowSetEvent e) {
            HashMap args = KDTableRptBrowser.makeExecuteArgs(e);
            try {
                this.rs = (IRowSet)((IKDTableRptExecutor)KDTableRptBrowser.this.getReportExecutor()).getPage(args);
            }
            catch (ReportException ex) {
                log.error((Object)ex, (Throwable)ex);
                throw new RTException((Throwable)ex);
            }
            e.setRowSet(this.rs);
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            try {
                this.rs.first();
                DataBindUtil.fillKDTableGrouping((KDTable)KDTableRptBrowser.this.kdtable, (int)e.getFirstRow(), (ResultSet)this.rs);
            }
            catch (SQLException ex) {
                log.error((Object)ex, (Throwable)ex);
                throw new RTException((Throwable)ex);
            }
            this.rs = null;
        }
    }
}

