/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

class NotePaperSettingConfig {
    private static final Logger log = LogUtil.getLogger(NotePaperSettingConfig.class);
    private static final String FILENAME = "NotePaperSettingConfig.data";
    private Properties _properties = new Properties();

    public PaperInfo getInfo(String key) {
        String value = this._properties.getProperty(key);
        if (value != null) {
            return new PaperInfo(value);
        }
        return null;
    }

    public void setInfo(String key, PaperInfo info) {
        this._properties.setProperty(key, info.toString());
    }

    public void removeInfo(String key) {
        this._properties.remove(key);
    }

    public boolean contains(String key) {
        return this._properties.containsKey(key);
    }

    public void updateDate(String key) {
        PaperInfo info = this.getInfo(key);
        if (info != null) {
            info.updateDate();
            this.setInfo(key, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotePaperSettingConfig load(IBizStorage sto) {
        NotePaperSettingConfig config = new NotePaperSettingConfig();
        String configPathText = PathUtil.makeChildPath((String)FILENAME);
        ByteArrayInputStream inputStream = null;
        try {
            byte[] bs = BizStorageUtil.readFile((IBizStorage)sto, (String)configPathText);
            inputStream = new ByteArrayInputStream(bs);
            config._properties.load(inputStream);
        }
        catch (NotFoundException ex1) {
            log.debug((Object)("\u5957\u6253\u9875\u9762\u8bbe\u7f6e\u5b58\u50a8\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8fd9\u662f\u9884\u671f\u7684\u5f02\u5e38\u3002" + configPathText));
        }
        catch (Exception ex) {
            log.error((Object)"\u8bfb\u53d6\u5957\u6253\u9875\u9762\u8bbe\u7f6e\u5b58\u50a8\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.debug((Object)"\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38\u3002", (Throwable)e);
                }
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IBizStorage sto) {
        this.check();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this._properties.store(outputStream, null);
            String configPathText = PathUtil.makeChildPath((String)FILENAME);
            if (!sto.isExist(configPathText)) {
                BizStorageUtil.create((IBizStorage)sto, (String)configPathText, (HashMap)BizStorageUtil.SET_FILE_TYPE);
            }
            byte[] bs = outputStream.toByteArray();
            BizStorageUtil.writeFile((IBizStorage)sto, (String)configPathText, (byte[])bs);
            log.debug((Object)("\u4fdd\u5b58\u5957\u6253\u9875\u9762\u8bbe\u7f6e\u5b58\u50a8\u6587\u4ef6\u6210\u529f\uff1a\u8def\u5f84/" + configPathText));
        }
        catch (Exception ex) {
            log.error((Object)"\u4fdd\u5b58\u5957\u6253\u9875\u9762\u8bbe\u7f6e\u5b58\u50a8\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)ex);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.debug((Object)"\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private void check() {
        Calendar now = Calendar.getInstance();
        String[] keys = this._properties.keySet().toArray(new String[0]);
        for (int i = keys.length - 1; i >= 0; --i) {
            String key = keys[i];
            PaperInfo info = this.getInfo(key);
            if (info == null || !info.isInvalidate() && !info.isTooOld(now)) continue;
            this.removeInfo(key);
        }
    }

    static class PaperInfo {
        private static final String CUSTOM_PAPER = "custom";
        private static final String LANDSCAPE = "landscape";
        private static final String PORTRAIT = "portrait";
        private static final String AUTO_SELECT = "auto_select";
        private Calendar calendar;
        private String paperName;
        private float paperWidth;
        private float paperHeight;
        private String orientation;
        private double scale = 1.0;
        private String mediaTray;

        public PaperInfo() {
            this.calendar = Calendar.getInstance();
        }

        public PaperInfo(String value) {
            if (value != null) {
                String[] strValues = value.split(",");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/M/d");
                Date date = null;
                try {
                    date = dateFormat.parse(strValues[0]);
                }
                catch (ParseException e) {
                    return;
                }
                this.calendar = Calendar.getInstance();
                this.calendar.setTime(date);
                if (strValues[1].startsWith(CUSTOM_PAPER)) {
                    this.paperName = CUSTOM_PAPER;
                    String[] ps = strValues[1].split("_");
                    if (ps.length == 3) {
                        this.paperWidth = Float.parseFloat(ps[1]);
                        this.paperHeight = Float.parseFloat(ps[2]);
                    }
                } else {
                    this.paperName = strValues[1];
                }
                if (LANDSCAPE.equals(strValues[2])) {
                    this.orientation = LANDSCAPE;
                } else if (PORTRAIT.equals(strValues[2])) {
                    this.orientation = PORTRAIT;
                }
                this.scale = Double.parseDouble(strValues[3]);
                this.mediaTray = strValues.length > 4 ? strValues[4] : AUTO_SELECT;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.calendar.get(1));
            sb.append("/");
            sb.append(this.calendar.get(2) + 1);
            sb.append("/");
            sb.append(this.calendar.get(5));
            sb.append(",");
            if (this.isCustomPaper()) {
                sb.append(CUSTOM_PAPER);
                sb.append("_");
                sb.append(this.paperWidth);
                sb.append("_");
                sb.append(this.paperHeight);
            } else {
                sb.append(this.paperName);
            }
            sb.append(",");
            sb.append(this.orientation);
            sb.append(",");
            sb.append(this.scale);
            sb.append(",");
            sb.append(this.mediaTray);
            return sb.toString();
        }

        boolean isInvalidate() {
            return this.paperName == null || this.orientation == null || this.paperName == CUSTOM_PAPER && (this.paperWidth == 0.0f || this.paperHeight == 0.0f);
        }

        boolean isTooOld(Calendar now) {
            int year = this.calendar.get(1);
            int yearNow = now.get(1);
            int day = this.calendar.get(6);
            int dayNow = now.get(6);
            long days = (yearNow - year) * 365 + dayNow - day;
            return days > 400L;
        }

        public void setPaperName(String paperName) {
            this.paperName = paperName;
        }

        public String getPaperName() {
            return this.paperName;
        }

        public boolean isCustomPaper() {
            return CUSTOM_PAPER.equals(this.paperName);
        }

        public void setCustomPaper(float w, float h) {
            this.paperName = CUSTOM_PAPER;
            this.paperWidth = w;
            this.paperHeight = h;
        }

        public float getPaperWidth() {
            return this.paperWidth;
        }

        public float getPaperHeight() {
            return this.paperHeight;
        }

        public void setScale(double scale) {
            this.scale = scale;
        }

        public double getScale() {
            return this.scale;
        }

        public void setLandscape() {
            this.orientation = LANDSCAPE;
        }

        public void setPortrait() {
            this.orientation = PORTRAIT;
        }

        public void setMediaTray(String mediaTray) {
            this.mediaTray = mediaTray;
        }

        public String getMediaTray() {
            return this.mediaTray;
        }

        public boolean isLandscape() {
            return LANDSCAPE.equals(this.orientation);
        }

        public boolean isPortrait() {
            return PORTRAIT.equals(this.orientation);
        }

        public void updateDate() {
            this.calendar = Calendar.getInstance();
        }

        public boolean infoEquals(PaperInfo another) {
            if (another != null && StringUtil.equals((String)this.getPaperName(), (String)another.getPaperName()) && StringUtil.equals((String)this.orientation, (String)another.orientation) && StringUtil.equals((String)this.mediaTray, (String)another.mediaTray) && this.getScale() == another.getScale()) {
                if (this.isCustomPaper()) {
                    return this.getPaperWidth() == another.getPaperWidth() && this.getPaperHeight() == another.getPaperHeight();
                }
                return true;
            }
            return false;
        }
    }
}

