/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.upgrade;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.ExceptionUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.io.IMeta2Xml;
import com.kingdee.bos.ctrl.data.meta.io.Kdm2Meta;
import com.kingdee.bos.ctrl.data.meta.io.Meta2Xml;
import com.kingdee.bos.ctrl.data.meta.io.Xml2Meta;
import com.kingdee.bos.ctrl.report.forapp.kdnote.upgrade.Meta2Storage;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizResource;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ContentCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.KdrsConfigure;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.StoredObjectFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class UpgradeEasNote {
    private static final Logger log = LogUtil.getPackageLogger(UpgradeEasNote.class);
    private static final String UPGRADE_FLAT = "/kdnote/upgrade.xml";

    public static void doUpgrade(IStorage srcSto, IStorage targetSto) throws KDRSException {
        InputStream is = null;
        try {
            is = GlobalLocator.getInstance().locateResourceFileStream("/server/kdrs/Storage.properties");
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        String mark = null;
        if (is != null) {
            Properties properties = new Properties();
            try {
                properties.load(is);
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
            }
            mark = properties.getProperty("autoDeploy");
            if (mark != null) {
                mark = mark.trim();
            }
        }
        if ("true".equalsIgnoreCase(mark)) {
            UpgradeEasNote.core_doUpgrade(srcSto, targetSto);
        }
    }

    private static void core_doUpgrade(IStorage srcSto, IStorage targetSto) throws KDRSException {
        Path easNotePrjPath = Path.valueOf((String)"/EAS_Note.kdrs");
        if (targetSto.isExist(easNotePrjPath)) {
            Path flag;
            Path p = Path.valueOf((String)"/kdnote/template");
            if (srcSto.isExist(p) && !srcSto.isExist(flag = Path.valueOf((String)UPGRADE_FLAT))) {
                UpgradeEasNote.merge(srcSto, targetSto);
                srcSto.create(flag, ResourceType.FILE, new HashMap());
            }
        } else {
            UpgradeEasNote.upgrade(srcSto, targetSto);
        }
        if (!srcSto.equals(targetSto)) {
            UpgradeEasNote.copyFolderFiles(srcSto, Path.ROOT, targetSto, Path.ROOT);
        }
    }

    private static void copyFolderFiles(IStorage srcSto, Path srcFolderPath, IStorage targetSto, Path targetFolderPath) throws KDRSException {
        String[] children = srcSto.listChildren(srcFolderPath);
        for (int i = 0; i < children.length; ++i) {
            Path childPath = srcFolderPath.getChild(children[i]);
            if (ResourceType.FILE != srcSto.getType(childPath)) continue;
            StorageUtil.copyFile((IStorage)srcSto, (Path)childPath, (IStorage)targetSto, (Path)targetFolderPath.getChild(children[i]));
        }
    }

    public static void merge(IStorage fromSto, IStorage toSto) throws KDRSException {
        log.info((Object)"Merge EAS-Note fs->db");
        BizStorage fromBizSto = new BizStorage(fromSto);
        BizContent toBizCnt = new BizContent(new StoredObjectFactory(toSto, KdrsConfigure.typesConf, "category"));
        UpgradeEasNote.upgrade((IBizStorage)fromBizSto, "/kdnote/template", (IBizContent)toBizCnt, "/EAS_Note.kdrs", false);
    }

    public static void upgrade(IStorage fromSto, IStorage toSto) throws KDRSException {
        BizStorage fromBizSto = new BizStorage(fromSto);
        if (fromBizSto.isExist("/kdnote/template")) {
            log.info((Object)"Upgrade EAS-Note fs->db");
            BizContent toBizCnt = new BizContent(new StoredObjectFactory(toSto, KdrsConfigure.typesConf, "category"));
            HashMap<String, String> atts = new HashMap<String, String>();
            atts.put("category", ContentCategory.KDRS_PROJECT.getName());
            atts.put("alias", "#1");
            String alias = BizResource.getString((String)"res_18");
            atts.put("alias.zh_CN", alias);
            atts.put("alias.zh_TW", STConverter.sc2tc((String)alias));
            try {
                toBizCnt.create("/EAS_Note.kdrs", atts);
            }
            catch (AlreadyExistsException ex) {
                BizStorageUtil.setAttribute((IBizStorage)toBizCnt, (String)"/EAS_Note.kdrs", (String)"category", (String)ContentCategory.KDRS_PROJECT.getName());
            }
            UpgradeEasNote.upgrade((IBizStorage)fromBizSto, "/kdnote/template", (IBizContent)toBizCnt, "/EAS_Note.kdrs", true);
            try {
                fromSto.create(Path.valueOf((String)UPGRADE_FLAT), ResourceType.FILE, new HashMap());
            }
            catch (KDRSException kDRSException) {}
        } else {
            log.info((Object)"Not exist /kdnote/template, ignore upgrade.");
        }
    }

    private static void upgradeFolder(IBizStorage fromBizSto, String childPath1, IBizContent toBizCnt, String childPath2, boolean isOverwirte) throws KDRSException {
        if (isOverwirte) {
            BizStorageUtil.create((IBizStorage)fromBizSto, (String)childPath1, (IBizStorage)toBizCnt, (String)childPath2, (int)16);
        } else {
            try {
                BizStorageUtil.create((IBizStorage)fromBizSto, (String)childPath1, (IBizStorage)toBizCnt, (String)childPath2, (int)33);
            }
            catch (AlreadyExistsException alreadyExistsException) {
                // empty catch block
            }
        }
        UpgradeEasNote.upgrade(fromBizSto, childPath1, toBizCnt, childPath2, isOverwirte);
    }

    private static void upgrade(IBizStorage fromBizSto, String fromPath, IBizContent toBizCnt, String toPath, boolean isOverwirte) throws KDRSException {
        log.info((Object)("EAS-Note Tmeplates: " + fromPath));
        HashMap rv = fromBizSto.list(fromPath, BizStorageUtil.LIST_NAME);
        String[] names = (String[])rv.get("name");
        for (int i = 0; i < names.length; ++i) {
            String category1;
            String childPath2;
            HashMap atts;
            String childName1 = names[i];
            String childPath1 = PathUtil.makeChildPath((String)fromPath, (String)childName1);
            try {
                atts = fromBizSto.getAttributes(childPath1, null);
            }
            catch (NotFoundException ex) {
                log.error((Object)ExceptionUtil.findMessage((Throwable)ex));
                continue;
            }
            atts.remove("name");
            atts.remove("size");
            atts.remove("time");
            atts.remove("creator");
            atts.remove("last-access");
            atts.remove("last-modified");
            String type = (String)atts.get("type");
            if (StorageCategory.FOLDER.getName().equals(type)) {
                childPath2 = PathUtil.makeChildPath((String)toPath, (String)childName1);
                UpgradeEasNote.upgradeFolder(fromBizSto, childPath1, toBizCnt, childPath2, isOverwirte);
                continue;
            }
            if ("Metadata.kdm".equals(childName1) || !"r1-print".equals(category1 = FullPath.getCategory((String)childName1)) && !"kdrs-form".equals(category1) && !"bos-query".equals(category1) && !"note-dynquery".equals(category1)) continue;
            atts.put("category", category1);
            childPath2 = PathUtil.makeChildPath((String)toPath, (String)childName1);
            int cp = isOverwirte ? 12 : 32;
            atts.put("create_policy", new Integer(cp));
            boolean toCopy = isOverwirte;
            if (!isOverwirte) {
                boolean isExist = toBizCnt.isExist(childPath2);
                toCopy = !isExist;
            }
            try {
                toBizCnt.create(childPath2, atts);
                if (!toCopy) continue;
                byte[] template = BizStorageUtil.readFile((IBizStorage)fromBizSto, (String)childPath1);
                if (template == null || template.length == 0) {
                    log.error((Object)("Source template is empty:" + childPath1));
                }
                toBizCnt.writeTemplate(childPath2, template);
                continue;
            }
            catch (KDRSException kDRSException) {
                // empty catch block
            }
        }
    }

    public static void upgradeMeta(IBizStorage fromBizSto, String fromMetaPath, IBizContent toBizCnt, String toMetaFolder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Upgrade MetaData:" + fromMetaPath));
        }
        try {
            byte[] data = BizStorageUtil.readFile((IBizStorage)fromBizSto, (String)fromMetaPath);
            Element root = XmlUtil.loadXmlBytes((byte[])data);
            String tagName = root.getName();
            if ("DBMeta".equals(tagName)) {
                MetaLibrary ml = Kdm2Meta.parseDBMeta((Element)root);
                Meta2Xml.makeLibrary((MetaLibrary)ml, (IMeta2Xml)new Meta2Storage(toBizCnt, toMetaFolder));
            } else if ("Class".equals(tagName)) {
                MetaClass mc = Xml2Meta.parseClass((Element)root);
                Meta2Xml.makeClass((MetaClass)mc, (IMeta2Xml)new Meta2Storage(toBizCnt, toMetaFolder));
            }
        }
        catch (Exception ex) {
            log.error((Object)(BizResource.getString((String)"res_19") + fromMetaPath), (Throwable)ex);
            return;
        }
    }
}

