/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.base.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.log4j.Logger;

public class FileUtil {
    private static Logger logger = Logger.getLogger(FileUtil.class);

    public static final String getFileContent(RandomAccessFile raConfigFile, String encoding) {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int count = 0;
        try {
            while ((count = raConfigFile.read(buf)) != -1) {
                byteArray.write(buf, 0, count);
            }
            return new String(byteArray.toByteArray(), encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFileContent(File file, String encoding) {
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        StringBuilder sb = new StringBuilder();
        try {
            fis = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)fis, encoding);
            char[] cbuf = new char[1024];
            int count = 0;
            while ((count = reader.read(cbuf)) != -1) {
                sb.append(cbuf, 0, count);
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("\u627e\u4e0d\u5230\u6587\u4ef6:" + file), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("\u8bfb\u53d6\u6587\u4ef6" + file + "\u5f02\u5e38"), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public static final void saveFile(RandomAccessFile raConfigFile, String content, String encoding) throws IOException {
        raConfigFile.setLength(0L);
        raConfigFile.seek(0L);
        raConfigFile.write(content.getBytes(encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveFile(File configFile, String content, String encoding) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(configFile);){
            fos.write(content.getBytes(encoding));
            fos.flush();
        }
    }

    public static final void createFile(String fileName, String content) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            File p = file.getParentFile();
            if (!p.exists()) {
                p.mkdirs();
            }
            file.createNewFile();
            FileUtil.saveFile(file, content, "UTF-8");
        }
    }

    public static final void getChildFiles(File path, List files) {
        File[] filelist = path.listFiles();
        if (filelist == null) {
            return;
        }
        for (int i = 0; i < filelist.length; ++i) {
            if (filelist[i].isFile()) {
                files.add(filelist[i]);
                continue;
            }
            FileUtil.getChildFiles(filelist[i], files);
        }
    }
}

