/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.BillDataStatus;
import com.kingdee.eas.csinterface.agent.service.work.basedata.DataColumn;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.DataRow;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredTableData;
import com.kingdee.eas.csinterface.agent.service.work.basedata.process.StructuredDataFactory;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.FlatData;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.FlatDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.IBufferedDataProvider;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.DBTransformUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.ObjectPKInfo;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.RecordBaseDataLogInfo;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.BaseDataSaver;
import com.kingdee.eas.csinterface.agent.service.work.basedata.snapshot.ChangefulBillData;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.DiskBufferedQueue;
import com.kingdee.eas.csinterface.agent.servlet.processor.BaseDataServlet;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHelper;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSpecialSQLCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSpecialSQLFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSpecialSQLInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTypeMapInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapFactory;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataResourceholder;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.EIPConfiguration;
import com.kingdee.eas.csinterface.basedatasyn.app.util.KeyTableUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BufferedBillDataProvider
implements IBufferedDataProvider {
    private static final Logger logger = Logger.getLogger(BufferedBillDataProvider.class);
    public static final int MAX_FETCH_SIZE = 5000;
    public static final int DEFAULT_FETCH_SIZE = 10;
    public static final String CHANGE_ADD = "add";
    public static final String CHANGE_UPDATE = "update";
    public static final String CHANGE_DELETE = "del";
    private Connection connection;
    private StructuredDataModel dataModel;
    private DataColumn[] flatDataColumns;
    private BaseDataSynTableInfo baseDataSynInfo;
    private PreparedStatement insertReadBillDataIDStm;
    private PreparedStatement updateIDStatusStm;
    private String queryString;
    private String fid;
    private String srcWhere;
    private String relateSQL;
    private Statement readingStatement;
    private int headpkIndex;
    private int entrypkIndex;
    private int pageNum;
    private int pageSize;
    private int beginIndex;
    private boolean isMaintTable;
    private String transmitSerialNumber;
    private String agentId;
    private Context ctx;
    private boolean getId;
    private List<DataRow> sendDataRows = new ArrayList<DataRow>();
    private List<FlatData.FlatDataRow> flatDataRows = new ArrayList<FlatData.FlatDataRow>();
    private String changeType;
    private DiskBufferedQueue<DataRow> bufferQueue;
    private List<ObjectPKInfo> readBillBase = new ArrayList<ObjectPKInfo>();
    private FlatDataModel flatDataModel;
    private RecordBaseDataLogInfo recordInfo;

    public BufferedBillDataProvider(BaseDataSynTableInfo baseDataSynInfo) {
        this.baseDataSynInfo = baseDataSynInfo;
    }

    @Override
    public List<DataRow> getSendDataRows() {
        return this.sendDataRows;
    }

    @Override
    public List<ObjectPKInfo> getReadBillBase() {
        return this.readBillBase;
    }

    public BufferedBillDataProvider(StructuredDataModel dataModel, DiskBufferedQueue<DataRow> bufferQueue, int pageNum, int pageSize, String agentId) throws EASBizException, BOSException {
        this.dataModel = dataModel;
        this.baseDataSynInfo = (BaseDataSynTableInfo)this.dataModel.getProperty("baseDataSynInfo");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int j = 0; j < tableModels[1].columns.length; ++j) {
            DataColumn column = new DataColumn(tableModels[1].columns[j].name, tableModels[1].columns[j].alias);
            flatDataColumns.add(column);
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.beginIndex = (pageNum - 1) * pageSize + 1;
        this.bufferQueue = bufferQueue;
        this.agentId = agentId;
        this.initQueryString(null);
    }

    public BufferedBillDataProvider(StructuredDataModel dataModel, DiskBufferedQueue<DataRow> bufferQueue, String agentId, String fid, String transmitSerialNumber, int transmitChunkedNumber) {
        this.dataModel = dataModel;
        this.baseDataSynInfo = (BaseDataSynTableInfo)this.dataModel.getProperty("baseDataSynInfo");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int j = 0; j < tableModels[1].columns.length; ++j) {
            DataColumn column = new DataColumn(tableModels[1].columns[j].name, tableModels[1].columns[j].alias);
            flatDataColumns.add(column);
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.bufferQueue = bufferQueue;
        this.agentId = agentId;
        this.fid = fid;
        this.transmitSerialNumber = transmitSerialNumber;
        this.pageNum = transmitChunkedNumber;
        this.initQuery4IDS(null);
    }

    public BufferedBillDataProvider(StructuredDataModel dataModel, String connectionId, String fid, String ksql) {
        this.dataModel = dataModel;
        this.baseDataSynInfo = (BaseDataSynTableInfo)this.dataModel.getProperty("baseDataSynInfo");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int j = 0; j < tableModels[1].columns.length; ++j) {
            DataColumn column = new DataColumn(tableModels[1].columns[j].name, tableModels[1].columns[j].alias);
            flatDataColumns.add(column);
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.agentId = connectionId;
        this.fid = fid;
        this.transmitSerialNumber = "-1";
        this.pageNum = -1;
        this.queryString = ksql;
        this.recordInfo = ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog();
        this.recordInfo.recordTableExecInfo("\u6267\u884c\u7684KSQL\uff1a" + ksql + "\r");
    }

    public BufferedBillDataProvider(StructuredDataModel dataModel, DiskBufferedQueue<DataRow> bufferQueue, int pageNum, int pageSize, String connId, String fid, String srcWhere, String relateSQL, boolean isQueryCount, String transmitSerialNumber, Context ctx, boolean getId) throws EASBizException, BOSException {
        this.getId = getId;
        this.dataModel = dataModel;
        this.ctx = ctx;
        this.baseDataSynInfo = (BaseDataSynTableInfo)this.dataModel.getProperty("baseDataSynInfo");
        this.isMaintTable = this.baseDataSynInfo.isMainTable();
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int j = 0; j < tableModels[1].columns.length; ++j) {
            DataColumn column = new DataColumn(tableModels[1].columns[j].name, tableModels[1].columns[j].alias);
            flatDataColumns.add(column);
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.beginIndex = (pageNum - 1) * pageSize + 1;
        this.bufferQueue = bufferQueue;
        this.agentId = connId;
        if (fid != null && fid.indexOf(",") > -1) {
            fid = fid.substring(0, fid.length() - 1);
        }
        this.fid = fid;
        this.srcWhere = srcWhere;
        this.relateSQL = relateSQL;
        this.transmitSerialNumber = transmitSerialNumber;
        if (isQueryCount) {
            this.initQueryStringForTableCount(null);
        } else {
            this.initQueryString(null);
        }
    }

    public BufferedBillDataProvider(StructuredDataModel dataModel, DiskBufferedQueue<DataRow> bufferQueue, int pageNum, int pageSize, String connId, String fid, String srcWhere, String relateSQL, boolean isQueryCount, String transmitSerialNumber, Context ctx, String oprtType) throws Exception {
        this.dataModel = dataModel;
        this.ctx = ctx;
        this.baseDataSynInfo = (BaseDataSynTableInfo)this.dataModel.getProperty("baseDataSynInfo");
        this.isMaintTable = this.baseDataSynInfo.isMainTable();
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int j = 0; j < tableModels[1].columns.length; ++j) {
            DataColumn column = new DataColumn(tableModels[1].columns[j].name, tableModels[1].columns[j].alias);
            flatDataColumns.add(column);
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.beginIndex = (pageNum - 1) * pageSize + 1;
        this.bufferQueue = bufferQueue;
        this.agentId = connId;
        if (fid != null && fid.indexOf(",") > -1) {
            fid = fid.substring(0, fid.length() - 1);
        }
        this.fid = fid;
        this.srcWhere = srcWhere;
        this.relateSQL = relateSQL;
        this.transmitSerialNumber = transmitSerialNumber;
        this.initAllMainQueryString(oprtType);
    }

    private void initAllMainQueryString(String oprtType) throws Exception {
        if (CHANGE_UPDATE.equals(oprtType)) {
            // empty if block
        }
    }

    @Override
    public FlatDataModel execChangeSQL(BaseDataSynTableInfo tableInfo, String connId, String mainChangeIds, boolean isTree) throws Exception {
        boolean isMainTable = tableInfo.isMainTable();
        HashMap idDataMap = new HashMap();
        FlatDataModel flatDataModel = new FlatDataModel();
        String tableName = tableInfo.getTableName();
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        this.queryString = null;
        this.initMainTableUpdateQueryString();
        this.recordInfo = ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog();
        this.recordInfo.recordTableExecInfo("\u6267\u884c\u7684KSQL\uff1a" + this.queryString + "\r");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        JSONObject hashCodeObj = new JSONObject();
        try {
            conn = DBUtils.getConnection(this.ctx);
            String s = this.queryString;
            stmt = conn.createStatement();
            long beginExecTime = System.currentTimeMillis();
            rs = stmt.executeQuery(s);
            long endExecTime = System.currentTimeMillis();
            ArrayList<String> addIds = new ArrayList<String>(100);
            ArrayList<String> updateIds = new ArrayList<String>(100);
            ArrayList<String> deleteIds = new ArrayList<String>(100);
            ArrayList<String> insertColumns = new ArrayList<String>(100);
            ArrayList<String> updateColumns = new ArrayList<String>(100);
            ArrayList<String> allColumns = new ArrayList<String>(100);
            String pkField = "";
            for (int i = 0; i < entry.columns.length; ++i) {
                String columnName = entry.columns[i].name;
                if (entry.columns[i].isPk) {
                    pkField = columnName;
                }
                allColumns.add(columnName);
                if (entry.columns[i].isNeedSyn) {
                    insertColumns.add(columnName);
                }
                if (!entry.columns[i].isChangeSyn) continue;
                updateColumns.add(columnName);
            }
            String[] sortedChangefulFields = null;
            sortedChangefulFields = isMainTable ? ChangefulBillData.getSortedChangefulFields4BaseData(this.dataModel) : ChangefulBillData.getSortedChangefulFields(this.dataModel);
            String changeTime = "";
            if (isMainTable) {
                BaseDataSynColumnInfo info = BaseDataSynColumnFactory.getLocalInstance(this.ctx).getBaseDataSynColumnInfo(" where parent = '" + tableInfo.getParent().getId().toString() + "' and pkTime = 1 and tableName='" + tableName + "'");
                changeTime = info.getColName();
            }
            ChangefulBillData changefulBillData = new ChangefulBillData(sortedChangefulFields, true, DBUtil.isOracle((Connection)conn));
            int rowCount = 0;
            long beginExecDataTime = System.currentTimeMillis();
            while (rs.next()) {
                ++rowCount;
                if (isMainTable) {
                    String headpk = rs.getString("headPk");
                    String fid = rs.getString("fid");
                    changefulBillData.appendFieldBytes4MainTable(rs);
                    changefulBillData.snapshot4MainTable();
                    String newChangeTime = changefulBillData.getNewChangeTime();
                    if (StringUtils.isEmpty((String)headpk)) continue;
                    if (StringUtils.isEmpty((String)fid)) {
                        if (deleteIds.contains(headpk)) continue;
                        deleteIds.add(headpk);
                        continue;
                    }
                    if (rs.getString("changeTime") == null && rs.getString(changeTime) != null || rs.getString("changeTime") != null && rs.getString(changeTime) == null) {
                        if (!updateIds.contains(headpk)) {
                            updateIds.add(headpk);
                        }
                        hashCodeObj.put(headpk, newChangeTime);
                        continue;
                    }
                    if (rs.getString("changeTime") == null || rs.getString(changeTime) == null || rs.getString("changeTime").equals(rs.getString(changeTime))) continue;
                    if (!updateIds.contains(headpk)) {
                        updateIds.add(headpk);
                    }
                    hashCodeObj.put(headpk, newChangeTime);
                    continue;
                }
                String headPK = rs.getString("headpk");
                String oldhashCode = rs.getString("hashCode");
                String pkValue = rs.getString(pkField);
                changefulBillData.appendFieldBytes(rs);
                changefulBillData.snapshot();
                String newHashCode = changefulBillData.getNewHashCode();
                if (StringUtils.isEmpty((String)headPK)) {
                    if (!addIds.contains(pkValue)) {
                        addIds.add(pkValue);
                    }
                    hashCodeObj.put(pkValue, newHashCode);
                    continue;
                }
                if (StringUtils.isEmpty((String)pkValue)) {
                    if (deleteIds.contains(headPK)) continue;
                    deleteIds.add(headPK);
                    continue;
                }
                if (StringUtils.equals((String)oldhashCode, (String)newHashCode)) continue;
                if (!updateIds.contains(headPK)) {
                    updateIds.add(headPK);
                }
                hashCodeObj.put(pkValue, newHashCode);
            }
            long endExecDataTime = System.currentTimeMillis();
            StringBuffer execMsg = new StringBuffer();
            execMsg.append("\u6267\u884c\u60c5\u51b5\uff1a\u603b\u884c\u6570\uff1a" + rowCount + "\uff0c\u8017\u65f6\uff1a" + (endExecTime - beginExecTime) + "ms \r");
            execMsg.append("\u8ba1\u7b97\u53d8\u5316\uff0c\u5e76\u7ed3\u6784\u5316\u6570\u636e\u8017\u65f6\uff1a" + (endExecDataTime - beginExecDataTime) + "ms \r");
            if (!isMainTable) {
                long beginDeleteTime = System.currentTimeMillis();
                String pkTableName = tableInfo.getPkTableName().replace("\"", "");
                StringBuffer deleteBuf = new StringBuffer();
                deleteBuf.append("select p.headpk from ").append(pkTableName).append(" p ").append(" where not exists (").append(" select 1 from ").append(tableInfo.getTableName()).append(" where p.headpk = ").append(pkField).append(" ) and p.").append("mainPK").append(" in (").append(this.fid).append(") ");
                String deleteSQL = deleteBuf.toString();
                if (conn == null || conn.isClosed()) {
                    conn = null;
                    conn = DBUtils.getConnection(this.ctx);
                }
                s = DBUtils.translateKSQL(conn, deleteSQL);
                stmt = conn.createStatement();
                rs = stmt.executeQuery(s);
                while (rs.next()) {
                    String headpk = rs.getString("headpk");
                    deleteIds.add(headpk);
                }
                long endDeleteTime = System.currentTimeMillis();
                execMsg.append("\u5220\u9664\u6267\u884c\u7684KSQL\uff1a" + deleteSQL + "\r");
                execMsg.append("\u975e\u4e3b\u8868\u83b7\u53d6\u5220\u9664\u6570\u636e\uff1a\u603b\u884c\u6570\uff1a" + deleteIds.size() + "\uff0c\u8017\u65f6\uff1a" + (endDeleteTime - beginDeleteTime) + "ms \r");
            }
            this.recordInfo.recordTableExecInfo(execMsg.toString());
            flatDataModel.setTableInfo(this.baseDataSynInfo);
            flatDataModel.setAddIds(addIds);
            flatDataModel.setUpdateIds(updateIds);
            flatDataModel.setDeleteIds(deleteIds);
            flatDataModel.setAllColumn(insertColumns);
            flatDataModel.setUpdateColumn(updateColumns);
            flatDataModel.setAddColumn(allColumns);
            if (!isMainTable && !StringUtils.isEmpty((String)mainChangeIds)) {
                String[] mainIdArr = mainChangeIds.split(",");
                flatDataModel.setMainUpdateIds(Arrays.asList(mainIdArr));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u6267\u884csql\u5931\u8d25\uff01", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        this.flatDataModel = flatDataModel;
        return flatDataModel;
    }

    private void initMainTableUpdateQueryString() {
        if (this.queryString == null) {
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
            StructuredDataModel.TableModel header = tableModels[0];
            StructuredDataModel.TableModel entry = tableModels[1];
            StringBuilder sqlBuf = new StringBuilder();
            sqlBuf.append("select ");
            String headPkName = null;
            Object entryPkName = null;
            int colHeadNum = 0;
            boolean colEntryNum = false;
            String AS_NAME = "t1.";
            String ALIAS_NAME = "t1";
            HashSet<String> sql = new HashSet<String>();
            for (int i = 0; i < header.columns.length; ++i) {
                if (sql.contains(header.columns[i].name)) continue;
                if (colHeadNum > 0) {
                    sqlBuf.append(", ");
                }
                if (header.columns[i].isPk) {
                    headPkName = header.columns[i].name;
                    this.headpkIndex = colHeadNum + 1;
                }
                sqlBuf.append(AS_NAME).append(header.columns[i].name);
                ++colHeadNum;
                sql.add(header.columns[i].name);
            }
            sqlBuf.append(" , p.").append("headpk");
            sqlBuf.append(" , p.hashCode ");
            sqlBuf.append(" , p.changeTime ");
            sqlBuf.append(" from ").append(this.baseDataSynInfo.getTableName()).append(" " + ALIAS_NAME);
            sqlBuf.append(" left outer join ").append(this.baseDataSynInfo.getPkTableName().replaceAll("\"", "")).append(" p");
            sqlBuf.append(" on t1.").append(headPkName).append(" = p.").append("headpk");
            sqlBuf.append(" and p.agentid = '").append(this.agentId).append("' ");
            this.relateSQL = this.baseDataSynInfo.getRelateSQL();
            if (!StringUtils.isEmpty((String)this.relateSQL)) {
                this.relateSQL = this.relateSQL.replace(this.baseDataSynInfo.getTableName() + ".", AS_NAME);
                this.relateSQL = this.relateSQL.replace("${fid}", this.fid);
                sqlBuf.append(this.relateSQL);
            } else {
                sqlBuf.append(" where 1=1 ");
            }
            String filterString = this.baseDataSynInfo.getSrcWhere();
            if (!StringUtils.isEmpty((String)filterString)) {
                if (StringUtils.startsWithIgnoreCase((String)(filterString = filterString.trim()), (String)"where")) {
                    filterString = StringUtils.replaceIgnoreCase((String)filterString, (String)"where", (String)"");
                }
                if (!filterString.matches("(?im)^and.*")) {
                    sqlBuf.append(" and ");
                }
                sqlBuf.append(filterString);
            }
            if (this.baseDataSynInfo.isMainTable()) {
                String specialSQL = this.getConnectionSQL();
                if (!StringUtils.isEmpty((String)specialSQL)) {
                    if (StringUtils.startsWithIgnoreCase((String)specialSQL, (String)"where")) {
                        specialSQL = StringUtils.replaceIgnoreCase((String)specialSQL, (String)"where", (String)"");
                    }
                    if (specialSQL.matches("(?im)^and.*")) {
                        sqlBuf.append(" ").append(specialSQL);
                    } else {
                        sqlBuf.append(" and ").append(specialSQL);
                    }
                }
                sqlBuf.append(" and ").append(AS_NAME).append("fid in (" + this.fid + ") ");
            }
            this.queryString = sqlBuf.toString();
        }
    }

    public BufferedBillDataProvider(StructuredDataModel dataModel, DiskBufferedQueue<DataRow> bufferQueue, String agentId, String fid, int pageSize, int pageNum) {
        this.dataModel = dataModel;
        this.baseDataSynInfo = (BaseDataSynTableInfo)this.dataModel.getProperty("baseDataSynInfo");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int j = 0; j < tableModels[1].columns.length; ++j) {
            DataColumn column = new DataColumn(tableModels[1].columns[j].name, tableModels[1].columns[j].alias);
            flatDataColumns.add(column);
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.beginIndex = (pageNum - 1) * pageSize + 1;
        this.bufferQueue = bufferQueue;
        this.agentId = agentId;
        this.fid = fid;
        this.initUpdateQueryString(null);
    }

    public BufferedBillDataProvider(StructuredDataModel dataModel, DiskBufferedQueue<DataRow> bufferQueue, String agentId, String fid, int pageSize, int pageNum, Context ctx) {
        this.dataModel = dataModel;
        this.baseDataSynInfo = (BaseDataSynTableInfo)this.dataModel.getProperty("baseDataSynInfo");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int j = 0; j < tableModels[1].columns.length; ++j) {
            DataColumn column = new DataColumn(tableModels[1].columns[j].name, tableModels[1].columns[j].alias);
            flatDataColumns.add(column);
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.beginIndex = (pageNum - 1) * pageSize + 1;
        this.bufferQueue = bufferQueue;
        this.agentId = agentId;
        this.fid = fid;
        this.ctx = ctx;
        this.initUpdateQueryString(null);
    }

    public BufferedBillDataProvider(StructuredDataModel dataModel, DiskBufferedQueue<DataRow> bufferQueue, int pageNum, int pageSize, String connId, String fid, String srcWhere, String relateSQL, boolean isTree, String changeType, FlatDataModel flatDataModel, Context ctx) throws Exception {
        this.ctx = ctx;
        this.flatDataModel = flatDataModel;
        this.changeType = changeType;
        this.dataModel = dataModel;
        this.baseDataSynInfo = (BaseDataSynTableInfo)this.dataModel.getProperty("baseDataSynInfo");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int j = 0; j < tableModels[1].columns.length; ++j) {
            DataColumn column = new DataColumn(tableModels[1].columns[j].name, tableModels[1].columns[j].alias);
            flatDataColumns.add(column);
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.beginIndex = (pageNum - 1) * pageSize + 1;
        this.bufferQueue = bufferQueue;
        this.agentId = connId;
        this.fid = fid;
        this.srcWhere = srcWhere;
        this.relateSQL = relateSQL;
        this.execChangeSQL(this.baseDataSynInfo, connId, this.flatDataModel.getMainUpdateIdsAsString(), isTree);
    }

    public BufferedBillDataProvider(StructuredDataModel dataModel, DiskBufferedQueue<DataRow> bufferQueue, int pageNum, int pageSize, String agentId, String fid, String srcWhere, String relateSQL, boolean isMainTable, boolean isOrganation, String changeType) throws Exception {
        this.changeType = changeType;
        this.dataModel = dataModel;
        this.baseDataSynInfo = (BaseDataSynTableInfo)this.dataModel.getProperty("baseDataSynInfo");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int j = 0; j < tableModels[1].columns.length; ++j) {
            DataColumn column = new DataColumn(tableModels[1].columns[j].name, tableModels[1].columns[j].alias);
            flatDataColumns.add(column);
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.beginIndex = (pageNum - 1) * pageSize + 1;
        this.bufferQueue = bufferQueue;
        this.agentId = agentId;
        this.fid = fid;
        this.srcWhere = srcWhere;
        this.relateSQL = relateSQL;
        if (isMainTable) {
            if (isOrganation) {
                if (!CHANGE_UPDATE.equals(changeType) && !CHANGE_UPDATE.equals(changeType) && CHANGE_DELETE.equals(changeType)) {
                    // empty if block
                }
            } else {
                this.intSQL4MainNotOrg(null);
            }
        } else {
            this.initQueryStringSubChange(null);
        }
    }

    public BufferedBillDataProvider(StructuredDataModel dataModel, int pageNum, int pageSize, String agentId, String fid, String srcWhere, String relateSQL, boolean isMainTable, boolean isOrganation, String changeType) throws Exception {
        this.changeType = changeType;
        this.dataModel = dataModel;
        this.baseDataSynInfo = (BaseDataSynTableInfo)this.dataModel.getProperty("baseDataSynInfo");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int j = 0; j < tableModels[1].columns.length; ++j) {
            DataColumn column = new DataColumn(tableModels[1].columns[j].name, tableModels[1].columns[j].alias);
            flatDataColumns.add(column);
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.beginIndex = (pageNum - 1) * pageSize + 1;
        this.agentId = agentId;
        this.fid = fid;
        this.srcWhere = srcWhere;
        this.relateSQL = relateSQL;
        if (isMainTable) {
            if (isOrganation) {
                if (!CHANGE_UPDATE.equals(changeType) && !CHANGE_UPDATE.equals(changeType) && CHANGE_DELETE.equals(changeType)) {
                    // empty if block
                }
            } else {
                this.intSQL4MainNotOrg(null);
            }
        } else {
            this.initQueryStringSubChangeJDBC(null);
        }
    }

    private void initUpdateQueryString(String filterString) {
        if (this.queryString == null) {
            String specialSQL;
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
            StructuredDataModel.TableModel header = tableModels[0];
            StructuredDataModel.TableModel entry = tableModels[1];
            StringBuilder sqlBuf = new StringBuilder();
            sqlBuf.append("select ");
            Object headPkName = null;
            String entryPkName = null;
            boolean colHeadNum = false;
            int colEntryNum = 0;
            String AS_NAME = "t1.";
            String ALIAS_NAME = "t1";
            for (int i = 0; i < entry.columns.length; ++i) {
                if (colEntryNum > 0) {
                    sqlBuf.append(", ");
                }
                if (entry.columns[i].isPk) {
                    entryPkName = entry.columns[i].name;
                    this.entrypkIndex = colEntryNum + 1;
                }
                if (!entry.columns[i].isChangeSyn) continue;
                sqlBuf.append(AS_NAME).append(entry.columns[i].name);
                ++colEntryNum;
            }
            sqlBuf.append(" from ").append(this.baseDataSynInfo.getTableName()).append(" " + ALIAS_NAME);
            sqlBuf.append(" where " + AS_NAME + "fid in (" + this.fid + ") ");
            if (!StringUtils.isEmpty((String)filterString)) {
                if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                    sqlBuf.append(" and ");
                }
                sqlBuf.append(filterString);
            }
            if (this.baseDataSynInfo.isMainTable() && !StringUtils.isEmpty((String)(specialSQL = this.getAgentSQL()))) {
                if (StringUtils.startsWithIgnoreCase((String)specialSQL, (String)"where")) {
                    specialSQL = StringUtils.replaceIgnoreCase((String)specialSQL, (String)"where", (String)"");
                }
                if (specialSQL.matches("(?im)^and.*")) {
                    sqlBuf.append(" ").append(specialSQL);
                } else {
                    sqlBuf.append(" and ").append(specialSQL);
                }
            }
            this.queryString = sqlBuf.toString();
        }
    }

    private void initQuery4IDS(String filterString) {
        if (this.queryString == null) {
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
            StructuredDataModel.TableModel header = tableModels[0];
            StructuredDataModel.TableModel entry = tableModels[1];
            StringBuilder sqlBuf = new StringBuilder();
            sqlBuf.append("select ");
            Object headPkName = null;
            String entryPkName = null;
            boolean colHeadNum = false;
            int colEntryNum = 0;
            String AS_NAME = "t1.";
            String ALIAS_NAME = "t1";
            for (int i = 0; i < entry.columns.length; ++i) {
                if (colEntryNum > 0) {
                    sqlBuf.append(", ");
                }
                if (entry.columns[i].isPk) {
                    entryPkName = entry.columns[i].name;
                    this.entrypkIndex = colEntryNum + 1;
                }
                sqlBuf.append(AS_NAME).append(entry.columns[i].name);
                ++colEntryNum;
            }
            sqlBuf.append(" from ").append(this.baseDataSynInfo.getTableName()).append(" " + ALIAS_NAME);
            sqlBuf.append(" where " + AS_NAME + entryPkName + " in (" + this.fid + ") ");
            this.queryString = sqlBuf.toString();
        }
    }

    private void initQueryString(String filterString) throws EASBizException, BOSException {
        if (this.queryString == null) {
            String specialSQL;
            String mainTableField;
            int i;
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
            StructuredDataModel.TableModel header = tableModels[0];
            StructuredDataModel.TableModel entry = tableModels[1];
            StringBuilder sqlBuf = new StringBuilder();
            sqlBuf.append("select top ").append(this.pageSize).append(" ");
            Object headPkName = null;
            String entryPkName = null;
            boolean colHeadNum = false;
            int colEntryNum = 0;
            String AS_NAME = "t1.";
            String ALIAS_NAME = "t1";
            if (this.getId) {
                for (i = 0; i < entry.columns.length; ++i) {
                    if (StringUtils.isEmpty((String)entry.columns[i].name) || !entry.columns[i].isPk) continue;
                    entryPkName = entry.columns[i].name;
                    this.entrypkIndex = colEntryNum + 1;
                    sqlBuf.append(AS_NAME).append(entry.columns[i].name);
                    ++colEntryNum;
                }
            } else {
                for (i = 0; i < entry.columns.length; ++i) {
                    if (StringUtils.isEmpty((String)entry.columns[i].name)) continue;
                    if (colEntryNum > 0) {
                        sqlBuf.append(", ");
                    }
                    if (entry.columns[i].isPk) {
                        entryPkName = entry.columns[i].name;
                        this.entrypkIndex = colEntryNum + 1;
                    }
                    sqlBuf.append(AS_NAME).append(entry.columns[i].name);
                    ++colEntryNum;
                }
            }
            if (!(StringUtils.isEmpty((String)this.relateSQL) || StringUtils.isEmpty((String)(mainTableField = this.relateSQL.substring(this.relateSQL.lastIndexOf("where") + 5, this.relateSQL.lastIndexOf("in(")))) || StringUtils.endsWithIgnoreCase((String)this.relateSQL, (String)mainTableField))) {
                sqlBuf.append(" , ").append(mainTableField).append(" ").append("mainPK");
            }
            sqlBuf.append(" from ").append(this.baseDataSynInfo.getTableName()).append(" " + ALIAS_NAME);
            if (!StringUtils.isEmpty((String)this.relateSQL)) {
                this.relateSQL = this.relateSQL.replace(this.baseDataSynInfo.getTableName() + ".", AS_NAME);
                if (this.relateSQL != null) {
                    this.relateSQL = this.relateSQL.replace("${fid}", this.fid);
                    sqlBuf.append(this.relateSQL);
                }
            }
            if (StringUtils.isEmpty((String)this.relateSQL) || this.relateSQL.indexOf(" where ") == -1) {
                sqlBuf.append(" where ");
            } else {
                sqlBuf.append(" and ");
            }
            if (this.isMaintTable && !StringUtils.isEmpty((String)this.fid)) {
                sqlBuf.append(" " + ALIAS_NAME + ".fid in (" + this.fid + ") and ");
            }
            ColumnModel pkColumn = null;
            for (int i2 = 0; i2 < entry.columns.length; ++i2) {
                if (!entry.columns[i2].isPk) continue;
                pkColumn = entry.columns[i2];
                break;
            }
            if (pkColumn == null) {
                throw new NullPointerException();
            }
            if (pkColumn.baseDataType != null) {
                BaseDataSynTypeMapInfo info = (BaseDataSynTypeMapInfo)pkColumn.baseDataType;
                IObjectPK[] pks = BaseDataSynValueMapFactory.getLocalInstance(this.ctx).getPKList("where baseDataType.id ='" + info.getId().toString() + "'");
                StringBuilder valueMapIds = new StringBuilder();
                for (int i3 = 0; i3 < pks.length; ++i3) {
                    if (i3 > 0) {
                        valueMapIds.append(",");
                    }
                    valueMapIds.append("'").append(pks[i3].toString()).append("'");
                }
                StringBuilder noExistSql = new StringBuilder();
                noExistSql.append(" not exists (").append(" select 1 from T_SYN_BaseDataSynValueMapEntry where " + ALIAS_NAME + "." + pkColumn.name + "=T_SYN_BaseDataSynValueMapEntry.FSrcID").append(" and T_SYN_BaseDataSynValueMapEntry.FParentId in (" + valueMapIds).append("))").append(" and ");
                sqlBuf.append(noExistSql.toString());
            }
            sqlBuf.append("  not exists(select 1 from ").append(this.baseDataSynInfo.getPkTableName().replaceAll("\"", "")).append(" p").append(" where " + AS_NAME).append(entryPkName).append(" = p.").append("headpk AND p.agentId = '" + this.agentId + "'");
            if (null != BaseDataSynUtil.localHasWhere.get() && ((Boolean)BaseDataSynUtil.localHasWhere.get()).booleanValue()) {
                sqlBuf.append(" AND  p.status =  " + BillDataStatus.ack.getValue());
            }
            sqlBuf.append(" )");
            String tableName = this.baseDataSynInfo.getTableName();
            if (this.baseDataSynInfo.isMainTable()) {
                String cTableName = BaseDataSynHelper.calc2ExistTableName(tableName);
                if (!BaseDataSynUtil.existCTable.containsKey(tableName)) {
                    Boolean flag = false;
                    try {
                        flag = KeyTableUtil.existKeyTable((Context)this.ctx, (String)cTableName);
                    }
                    catch (Exception e) {
                        String message = "\u5224\u65adC\u8868\u662f\u5426\u5b58\u5728\u5f02\u5e38\uff0c\u8868\u540d\uff1a" + cTableName;
                        logger.error((Object)message, (Throwable)e);
                        throw new BOSException(message, (Throwable)e);
                    }
                    BaseDataSynUtil.existCTable.put(tableName, flag);
                }
                if (((Boolean)BaseDataSynUtil.existCTable.get(tableName)).booleanValue()) {
                    sqlBuf.append(" and not exists(select 1 from ").append(cTableName).append(" c").append(" where " + AS_NAME).append(entryPkName).append(" = c.").append("headpk AND c.agentId = '" + this.agentId + "'").append(")");
                }
                BaseDataResourceholder.put((Context)this.ctx);
                BaseDataResourceholder.putBaseDataSynTableInfo((BaseDataSynTableInfo)this.baseDataSynInfo);
            }
            if (this.getId && this.baseDataSynInfo.isMainTable()) {
                sqlBuf.append(" and not exists(select 1 from ").append(" T_EIP_BaseDataSynPreCheckLog ").append(" l ").append(" where " + AS_NAME).append(entryPkName).append(" = l.").append("fsrcValue").append(")");
            }
            if (!StringUtils.isEmpty((String)this.srcWhere)) {
                if (StringUtils.startsWithIgnoreCase((String)this.srcWhere, (String)"where")) {
                    this.srcWhere = StringUtils.replaceIgnoreCase((String)this.srcWhere, (String)"where", (String)"");
                    this.srcWhere = this.srcWhere.replace(this.baseDataSynInfo.getTableName() + ".", AS_NAME);
                }
                if (this.srcWhere.matches("(?im)^and.*")) {
                    sqlBuf.append(" ").append(this.srcWhere);
                } else {
                    sqlBuf.append(" and ").append(this.srcWhere);
                }
            }
            if (this.baseDataSynInfo.isMainTable() && !StringUtils.isEmpty((String)(specialSQL = this.getConnectionSQL()))) {
                if (StringUtils.startsWithIgnoreCase((String)specialSQL, (String)"where")) {
                    specialSQL = StringUtils.replaceIgnoreCase((String)specialSQL, (String)"where", (String)"");
                }
                if (specialSQL.matches("(?im)^and.*")) {
                    sqlBuf.append(" ").append(specialSQL);
                } else {
                    sqlBuf.append(" and ").append(specialSQL);
                }
            }
            if (!StringUtils.isEmpty((String)filterString)) {
                if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                    sqlBuf.append(" and ");
                }
                sqlBuf.append(filterString);
            }
            this.queryString = sqlBuf.toString();
        }
    }

    public void initQueryStringForTableCount(String filterString) {
        if (this.queryString == null) {
            String specialSQL;
            String srcWhere = null;
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
            StructuredDataModel.TableModel header = tableModels[0];
            StructuredDataModel.TableModel entry = tableModels[1];
            StringBuilder sqlBuf = new StringBuilder();
            sqlBuf.append("select count(*) count ");
            Object headPkName = null;
            String entryPkName = null;
            boolean colHeadNum = false;
            int colEntryNum = 0;
            String AS_NAME = "v1.";
            String ALIAS_NAME = "v1";
            for (int i = 0; i < entry.columns.length; ++i) {
                if (colEntryNum > 0) {
                    sqlBuf.append(", ");
                }
                if (entry.columns[i].isPk) {
                    entryPkName = entry.columns[i].name;
                    this.entrypkIndex = colEntryNum + 1;
                }
                sqlBuf.append(AS_NAME).append(entry.columns[i].name);
                ++colEntryNum;
            }
            sqlBuf.append(" from ").append(this.baseDataSynInfo.getTableName()).append(" " + ALIAS_NAME);
            sqlBuf.append(" where ");
            sqlBuf.append(" not exists(select 1 from ").append(this.baseDataSynInfo.getPkTableName().replace("\"", "")).append(" p").append(" where " + AS_NAME).append(entryPkName).append(" = p.").append("headpk").append(") AND p.agentId = '" + this.agentId + "'");
            if (!StringUtils.isEmpty(srcWhere)) {
                if (StringUtils.startsWithIgnoreCase(srcWhere, (String)"where")) {
                    srcWhere = StringUtils.replaceIgnoreCase((String)srcWhere, (String)"where", (String)"");
                }
                if (srcWhere.matches("(?im)^and.*")) {
                    sqlBuf.append(" ").append(srcWhere);
                } else {
                    sqlBuf.append(" and ").append(srcWhere);
                }
            }
            if (!StringUtils.isEmpty((String)filterString)) {
                if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                    sqlBuf.append(" and ");
                }
                sqlBuf.append(filterString);
            }
            if (this.baseDataSynInfo.isMainTable() && !StringUtils.isEmpty((String)(specialSQL = this.getAgentSQL()))) {
                if (StringUtils.startsWithIgnoreCase((String)specialSQL, (String)"where")) {
                    specialSQL = StringUtils.replaceIgnoreCase((String)specialSQL, (String)"where", (String)"");
                }
                if (specialSQL.matches("(?im)^and.*")) {
                    sqlBuf.append(" ").append(specialSQL);
                } else {
                    sqlBuf.append(" and ").append(specialSQL);
                }
            }
            this.queryString = sqlBuf.toString();
        }
    }

    private void initQueryStringSubChange(String filterString) {
        if (this.queryString == null) {
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
            StructuredDataModel.TableModel header = tableModels[0];
            StructuredDataModel.TableModel entry = tableModels[1];
            StringBuilder sqlBuf = new StringBuilder();
            sqlBuf.append("select top ").append(this.pageSize).append(" ");
            Object headPkName = null;
            String entryPkName = null;
            boolean colHeadNum = false;
            int colEntryNum = 0;
            String AS_NAME = "t1.";
            String ALIAS_NAME = "t1";
            for (int i = 0; i < entry.columns.length; ++i) {
                if (colEntryNum > 0) {
                    sqlBuf.append(", ");
                }
                if (entry.columns[i].isPk) {
                    entryPkName = entry.columns[i].name;
                    this.entrypkIndex = colEntryNum + 1;
                }
                sqlBuf.append(AS_NAME).append(entry.columns[i].name);
                ++colEntryNum;
            }
            sqlBuf.append(" , p.").append("headpk");
            sqlBuf.append(" , p.hashCode ");
            sqlBuf.append(" from ").append(this.baseDataSynInfo.getTableName()).append(" " + ALIAS_NAME);
            if (!StringUtils.isEmpty((String)this.relateSQL)) {
                this.relateSQL = this.relateSQL.replace(this.baseDataSynInfo.getTableName() + ".", AS_NAME);
                this.relateSQL = this.relateSQL.replace("${fid}", this.fid);
                sqlBuf.append(this.relateSQL);
            }
            sqlBuf.append(" left outer join ").append(this.baseDataSynInfo.getPkTableName().replaceAll("\"", "")).append(" p");
            sqlBuf.append(" on t1.").append(entryPkName).append(" = p.").append("headpk");
            if (!StringUtils.isEmpty((String)this.srcWhere)) {
                sqlBuf.append(" where 1 = 1 ");
                if (StringUtils.startsWithIgnoreCase((String)this.srcWhere, (String)"where")) {
                    this.srcWhere = StringUtils.replaceIgnoreCase((String)this.srcWhere, (String)"where", (String)"");
                }
                this.srcWhere = this.srcWhere.replace(this.baseDataSynInfo.getTableName() + ".", AS_NAME);
                if (this.srcWhere.matches("(?im)^and.*")) {
                    sqlBuf.append(" ").append(this.srcWhere);
                } else {
                    sqlBuf.append(" and ").append(this.srcWhere);
                }
            }
            sqlBuf.append(" and p.status = 2 and p.agentId= '" + this.agentId + "' ");
            this.queryString = sqlBuf.toString();
        }
    }

    private void initQueryStringSubChangeJDBC(String filterString) {
        if (this.queryString == null) {
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
            StructuredDataModel.TableModel header = tableModels[0];
            StructuredDataModel.TableModel entry = tableModels[1];
            StringBuilder sqlBuf = new StringBuilder();
            sqlBuf.append("select top ").append(this.pageSize).append(" ");
            Object headPkName = null;
            String entryPkName = null;
            boolean colHeadNum = false;
            int colEntryNum = 0;
            String AS_NAME = "t1.";
            String ALIAS_NAME = "t1";
            for (int i = 0; i < entry.columns.length; ++i) {
                if (colEntryNum > 0) {
                    sqlBuf.append(", ");
                }
                if (entry.columns[i].isPk) {
                    entryPkName = entry.columns[i].name;
                    this.entrypkIndex = colEntryNum + 1;
                }
                sqlBuf.append(AS_NAME).append(entry.columns[i].name);
                ++colEntryNum;
            }
            sqlBuf.append(" , p.").append("headpk");
            sqlBuf.append(" , p.hashCode ");
            sqlBuf.append(" from ").append(this.baseDataSynInfo.getTableName()).append(" " + ALIAS_NAME);
            if (!StringUtils.isEmpty((String)this.relateSQL)) {
                this.relateSQL = this.relateSQL.replace(this.baseDataSynInfo.getTableName() + ".", AS_NAME);
                this.relateSQL = this.relateSQL.replace("${fid}", this.fid);
                sqlBuf.append(this.relateSQL);
            }
            if (this.relateSQL.indexOf(" where ") == -1) {
                sqlBuf.append(" where ");
            }
            sqlBuf.append(" left outer join ").append(this.baseDataSynInfo.getPkTableName().replaceAll("\"", "")).append(" p");
            sqlBuf.append(" on t1.").append(entryPkName).append(" = p.").append("headpk");
            if (!StringUtils.isEmpty((String)this.srcWhere)) {
                sqlBuf.append(" where 1 = 1 ");
                if (StringUtils.startsWithIgnoreCase((String)this.srcWhere, (String)"where")) {
                    this.srcWhere = StringUtils.replaceIgnoreCase((String)this.srcWhere, (String)"where", (String)"");
                    this.srcWhere = this.srcWhere.replace(this.baseDataSynInfo.getTableName() + ".", AS_NAME);
                }
                if (this.srcWhere.matches("(?im)^and.*")) {
                    sqlBuf.append(" ").append(this.srcWhere);
                } else {
                    sqlBuf.append(" and ").append(this.srcWhere);
                }
            }
            sqlBuf.append(" and p.status = 2 and p.agentId= '" + this.agentId + "' ");
            sqlBuf.append(" and p.").append("mainPK").append(" in (").append(this.fid).append(") ");
            this.queryString = sqlBuf.toString();
        }
    }

    private void intSQL4MainNotOrg(String filterString) throws Exception {
        if (this.queryString == null) {
            String specialSQL;
            String tableName = this.baseDataSynInfo.getTableName();
            String pkTable = this.baseDataSynInfo.getPkTableName().replace("\"", "");
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
            StructuredDataModel.TableModel header = tableModels[0];
            if (header.columns.length == 0) {
                logger.error((Object)("\u65b9\u6848\u7684\u4e3b\u8868(" + tableName + ")\u672a\u914d\u7f6e\u65f6\u95f4\u6233\u5b57\u6bb5\u3002"));
                throw new RuntimeException("\u65b9\u6848\u7684\u4e3b\u8868(" + tableName + ")\u672a\u914d\u7f6e\u65f6\u95f4\u6233\u5b57\u6bb5\u3002");
            }
            String lastUpdateTime = BaseDataResourceholder.getPKColumn();
            if (lastUpdateTime == null) {
                for (int i = 0; i < header.columns.length; ++i) {
                    if (!header.columns[i].isPkTime) continue;
                    lastUpdateTime = header.columns[i].name;
                    break;
                }
            }
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append(" select top ").append(this.pageSize).append("  * from (");
            sqlBuf.append(" select ");
            sqlBuf.append(" p.headpk, t1.fid, p.changeTime, t1." + lastUpdateTime + " ");
            sqlBuf.append(" from " + tableName + "  t1");
            sqlBuf.append(" left join " + pkTable + "  p");
            sqlBuf.append(" on t1.fid = p.headpk ");
            sqlBuf.append(" where 1 = 1  ");
            if (!StringUtils.isEmpty((String)this.srcWhere)) {
                if (StringUtils.startsWithIgnoreCase((String)this.srcWhere, (String)"where")) {
                    this.srcWhere = StringUtils.replaceIgnoreCase((String)this.srcWhere, (String)"where", (String)"");
                    this.srcWhere = this.srcWhere.replace(this.baseDataSynInfo.getTableName() + ".", "t1.");
                }
                if (this.srcWhere.matches("(?im)^and.*")) {
                    sqlBuf.append(" ").append(this.srcWhere);
                } else {
                    sqlBuf.append(" and ").append(this.srcWhere);
                }
            }
            if (this.baseDataSynInfo.isMainTable() && !StringUtils.isEmpty((String)(specialSQL = this.getConnectionSQL()))) {
                if (StringUtils.startsWithIgnoreCase((String)specialSQL, (String)"where")) {
                    specialSQL = StringUtils.replaceIgnoreCase((String)specialSQL, (String)"where", (String)"");
                }
                if (specialSQL.matches("(?im)^and.*")) {
                    sqlBuf.append(" ").append(specialSQL);
                } else {
                    sqlBuf.append(" and ").append(specialSQL);
                }
            }
            sqlBuf.append(" and p.status = 2 AND p.agentId = '" + this.agentId + "'");
            sqlBuf.append(" ) t2 where t2.changeTime <> t2." + lastUpdateTime + " ");
            this.queryString = sqlBuf.toString();
        }
    }

    @Override
    public void open(Context ctx) throws Exception {
        try {
            this.ctx = ctx;
            this.connection = SQLUtil.getKSQLConnection(ctx);
        }
        catch (SQLException e) {
            throw new Exception("\u6253\u5f00\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e.getMessage(), e);
        }
        catch (SQLDataException e1) {
            throw new Exception("\u6253\u5f00\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e1.getMessage(), e1);
        }
    }

    @Override
    public void feedback(List<Object> idList, String transmitSerialNumber, int transmitChunkedNumber, BillDataStatus billDataStatus) throws Exception {
        try {
            this.updateIDStatusStm = this.connection.prepareStatement("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set transmitSerialNumber=?,transmitChunkedNumber=?,status=? where " + "headpk" + " = ?");
        }
        catch (Exception e) {
            throw new BOSException("EIP,\u6267\u884cfeedback\u64cd\u4f5c\uff0c\u66f4\u65b0\u8868\uff1a" + this.baseDataSynInfo.getPkTableName().replace("\"", "") + "\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        try {
            for (int i = 0; i < idList.size(); ++i) {
                this.updateIDStatusStm.setObject(1, transmitSerialNumber);
                this.updateIDStatusStm.setObject(2, transmitChunkedNumber);
                this.updateIDStatusStm.setObject(3, billDataStatus.getValue());
                this.updateIDStatusStm.setObject(4, idList.get(i));
                this.updateIDStatusStm.addBatch();
            }
            this.updateIDStatusStm.executeBatch();
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw new BOSException("EIP,\u6267\u884cfeedback\u64cd\u4f5c\uff0c\u6279\u91cf\u66f4\u65b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void feedback(int transmitChunkedNumber, String transmitSerialNumber, BillDataStatus billDataStatus, boolean isDelete) throws Exception {
        if (isDelete) {
            try {
                if (billDataStatus.equals((Object)BillDataStatus.ack)) {
                    this.updateIDStatusStm = this.connection.prepareStatement("delete from " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " where headpk in (?)");
                    this.updateIDStatusStm.setObject(1, transmitSerialNumber);
                    this.updateIDStatusStm.addBatch();
                    this.updateIDStatusStm.executeBatch();
                    this.connection.commit();
                    return;
                }
                if (!billDataStatus.equals((Object)BillDataStatus.invalid)) return;
                this.updateIDStatusStm = this.connection.prepareStatement("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set status = ? where headpk in (?)");
                this.updateIDStatusStm.setObject(1, billDataStatus.getValue());
                this.updateIDStatusStm.setObject(2, transmitSerialNumber);
                this.updateIDStatusStm.addBatch();
                this.updateIDStatusStm.executeBatch();
                this.connection.commit();
                return;
            }
            catch (Exception e) {
                this.connection.rollback();
                throw new BOSException("EIP\uff0c\u5e7f\u57df\u7f51\u57fa\u7840\u8d44\u6599\u540c\u6b65-\u65b0\u589e-\u53cd\u5199\u589e\u91cf\u8868\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
        }
        long beginTime = System.currentTimeMillis();
        try {
            this.updateIDStatusStm = this.connection.prepareStatement("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set status=? where transmitChunkedNumber = ? and transmitSerialNumber=?");
        }
        catch (Exception e) {
            throw new BOSException("EIP,\u5e7f\u57df\u7f51\u57fa\u7840\u8d44\u6599\u540c\u6b65-\u65b0\u589e-\u53cd\u5199\u589e\u91cf\u8868\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        try {
            this.updateIDStatusStm.setObject(1, billDataStatus.getValue());
            this.updateIDStatusStm.setObject(2, transmitChunkedNumber);
            this.updateIDStatusStm.setObject(3, transmitSerialNumber);
            this.updateIDStatusStm.addBatch();
            this.updateIDStatusStm.executeBatch();
            return;
        }
        catch (SQLException e) {
            throw new BOSException("EIP,\u5e7f\u57df\u7f51\u57fa\u7840\u8d44\u6599\u540c\u6b65-\u65b0\u589e-\u53cd\u5199\u589e\u91cf\u8868\uff0c\u8bbe\u7f6ePreparedStatement\u5bf9\u8c61\u4fe1\u606f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            long endTime = System.currentTimeMillis();
            StringBuffer feedbackMsg = new StringBuffer();
            feedbackMsg.append("\u53cd\u5199\u589e\u91cf\u8868\u8017\u65f6\uff1a" + (endTime - beginTime) + "ms \r");
            if (this.recordInfo != null) {
                this.recordInfo.recordTableExecInfo(feedbackMsg.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void feedback(int transmitChunkedNumber, List<Object> idList, String connectionId, BillDataStatus billDataStatus, boolean isDelete) throws Exception {
        if (isDelete) {
            try {
                if (billDataStatus.equals((Object)BillDataStatus.ack)) {
                    this.updateIDStatusStm = this.connection.prepareStatement("delete from " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " where headpk in (?) and agentId = ?");
                    for (Object id : idList) {
                        this.updateIDStatusStm.setObject(1, id);
                        this.updateIDStatusStm.setObject(2, connectionId);
                        this.updateIDStatusStm.addBatch();
                        this.updateIDStatusStm.executeBatch();
                    }
                    return;
                }
                if (!billDataStatus.equals((Object)BillDataStatus.invalid)) return;
                this.updateIDStatusStm = this.connection.prepareStatement("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set status = ? where headpk in (?) and agentId = ?");
                for (Object id : idList) {
                    this.updateIDStatusStm.setObject(1, billDataStatus.getValue());
                    this.updateIDStatusStm.setObject(2, id);
                    this.updateIDStatusStm.setString(3, connectionId);
                    this.updateIDStatusStm.addBatch();
                }
                this.updateIDStatusStm.executeBatch();
                return;
            }
            catch (Exception e) {
                this.connection.rollback();
                throw new BOSException("EIP,\u5c40\u57df\u7f51\u57fa\u7840\u8d44\u6599\u540c\u6b65-\u65b0\u589e - \u53cd\u5199\u589e\u91cf\u8868,\u6279\u91cf\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
        }
        long beginTime = System.currentTimeMillis();
        try {
            this.updateIDStatusStm = this.connection.prepareStatement("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set status=? where headpk = ? and agentid = ?");
        }
        catch (Exception e) {
            throw new BOSException("EIP,\u5c40\u57df\u7f51\u57fa\u7840\u8d44\u6599\u540c\u6b65-\u65b0\u589e - \u53cd\u5199\u589e\u91cf\u8868,\u8bbe\u7f6e\u9884\u5904\u7406\u5bf9\u8c61\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        try {
            for (Object id : idList) {
                this.updateIDStatusStm.setObject(1, billDataStatus.getValue());
                this.updateIDStatusStm.setObject(2, id);
                this.updateIDStatusStm.setString(3, connectionId);
                this.updateIDStatusStm.addBatch();
            }
            this.updateIDStatusStm.executeBatch();
            return;
        }
        catch (SQLException e) {
            throw new BOSException("EIP,\u5c40\u57df\u7f51\u57fa\u7840\u8d44\u6599\u540c\u6b65-\u65b0\u589e - \u53cd\u5199\u589e\u91cf\u8868,\u6267\u884c\u6279\u91cf\u66f4\u65b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            long endTime = System.currentTimeMillis();
            StringBuffer feedbackMsg = new StringBuffer();
            feedbackMsg.append("\u53cd\u5199\u589e\u91cf\u8868\u8017\u65f6\uff1a" + (endTime - beginTime) + "ms \r");
            this.recordInfo.recordTableExecInfo(feedbackMsg.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void feedback4Change(int transmitChunkedNumber, String transmitSerialNumber, BillDataStatus billDataStatus, boolean isDelete, Context context) throws Exception {
        EipUserInfo userInfo = BaseDataServlet.getEipUser(context);
        String agentId = userInfo.getId().toString();
        if (isDelete) {
            try {
                if (billDataStatus.equals((Object)BillDataStatus.ack)) {
                    this.updateIDStatusStm = this.connection.prepareStatement("delete from " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " where headpk in(" + transmitSerialNumber + ") and agentId= '" + agentId + "' ");
                    this.updateIDStatusStm.executeUpdate();
                    this.connection.commit();
                    return;
                }
                if (!billDataStatus.equals((Object)BillDataStatus.invalid)) return;
                this.updateIDStatusStm = this.connection.prepareStatement("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set changeStatus = ? where transmitChunkedNumber = ? and changeTransmitNumber=? and agentId= '" + agentId + "'");
                this.updateIDStatusStm.setObject(1, BillDataStatus.invalid.getValue());
                this.updateIDStatusStm.setObject(2, transmitChunkedNumber);
                this.updateIDStatusStm.setObject(3, transmitSerialNumber);
                this.updateIDStatusStm.addBatch();
                this.updateIDStatusStm.executeBatch();
                this.connection.commit();
                return;
            }
            catch (Exception e) {
                this.connection.rollback();
                throw new BOSException("EIP,\u68c0\u6d4b\u53d8\u5316\u72b6\u6001\u53cd\u9988\uff0c\u6279\u91cf\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
        }
        boolean fail = BillDataStatus.invalid.equals((Object)billDataStatus);
        if (!fail) {
            try {
                this.updateIDStatusStm = this.connection.prepareStatement("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set changeStatus=? where transmitChunkedNumber = ? and changeTransmitNumber=?");
            }
            catch (Exception e) {
                throw new BOSException("EIP,\u68c0\u6d4b\u53d8\u5316\u72b6\u6001\u53cd\u9988\uff0c\u8bbe\u7f6e\u9884\u5904\u7406\u5bf9\u8c61\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
            try {
                this.updateIDStatusStm.setObject(1, billDataStatus.getValue());
                this.updateIDStatusStm.setObject(2, transmitChunkedNumber);
                this.updateIDStatusStm.setObject(3, transmitSerialNumber);
                this.updateIDStatusStm.addBatch();
                this.updateIDStatusStm.executeBatch();
                this.connection.commit();
                return;
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw new BOSException("EIP,\u68c0\u6d4b\u53d8\u5316\u72b6\u6001\u53cd\u9988\uff0c\u6267\u884c\u6279\u91cf\u66f4\u65b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
        }
        try {
            this.updateIDStatusStm = this.connection.prepareStatement("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set changeStatus=?,hashCode='' where transmitChunkedNumber = ? and changeTransmitNumber=?");
        }
        catch (Exception e) {
            throw new BOSException("EIP,\u68c0\u6d4b\u53d8\u5316\u72b6\u6001\u53cd\u9988\uff0c\u8bbe\u7f6e\u9884\u5904\u7406\u5bf9\u8c61\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        try {
            this.updateIDStatusStm.setObject(1, billDataStatus.getValue());
            this.updateIDStatusStm.setObject(2, transmitChunkedNumber);
            this.updateIDStatusStm.setObject(3, transmitSerialNumber);
            this.updateIDStatusStm.addBatch();
            this.updateIDStatusStm.executeBatch();
            this.connection.commit();
            return;
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw new BOSException("EIP,\u68c0\u6d4b\u53d8\u5316\u72b6\u6001\u53cd\u9988\uff0c\u6267\u884c\u6279\u91cf\u66f4\u65b0\u64cd\u4f5c\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
    }

    private void processIgnoreHeadPK(String transmitSerialNumber, Object ignoreHeadPK) throws Exception {
        if (null == ignoreHeadPK) {
            logger.info((Object)"BufferedBillDataProvider\u3002processIgnoreHeadPK\uff1a\u9700\u8981\u5220\u9664\u88ab\u8fc7\u6ee4\u7684\u5355\u636e=null");
            return;
        }
        logger.info((Object)("BufferedBillDataProvider\u3002processIgnoreHeadPK\uff1a\u9700\u8981\u5220\u9664\u88ab\u8fc7\u6ee4\u7684\u5355\u636e=[" + ignoreHeadPK.toString() + "]"));
        String headPKStr = ignoreHeadPK.toString();
        String[] headpks = StringUtils.split((String)headPKStr, (String)",");
        if (null == headpks || headpks.length == 0) {
            return;
        }
        ArrayList<Object> idList = new ArrayList<Object>();
        for (int i = 0; i < headpks.length; ++i) {
            if (StringUtils.isEmpty((String)headpks[i])) continue;
            idList.add(headpks[i]);
        }
        this.feedback(idList, transmitSerialNumber, BillDataStatus.ack);
        logger.info((Object)("delete PKtable\u3010\u9700\u8981\u5220\u9664\u3011  :transmitSerialNumber=" + transmitSerialNumber + " ,headPK= " + ((Object)idList).toString()));
    }

    private void deleteReadOutLastTime() throws SQLException {
        Statement delStm = this.connection.createStatement();
        try {
            delStm.executeUpdate("delete from " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " where status = " + BillDataStatus.read.getValue());
            this.connection.commit();
        }
        finally {
            SQLUtil.cleanup(delStm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> selectLastTimeToAck() throws SQLException {
        ArrayList<String> arrayList;
        ResultSet rs = null;
        ArrayList<String> toAckTransmitSerialNumbers = new ArrayList<String>();
        Statement toAckStatement = this.connection.createStatement();
        try {
            rs = toAckStatement.executeQuery("select distinct(transmitSerialNumber) from " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " where status = " + BillDataStatus.waitAck.getValue());
            while (rs.next()) {
                toAckTransmitSerialNumbers.add(rs.getString(1));
            }
            arrayList = toAckTransmitSerialNumbers;
        }
        catch (Throwable throwable) {
            SQLUtil.cleanup(rs);
            SQLUtil.cleanup(toAckStatement);
            throw throwable;
        }
        SQLUtil.cleanup(rs);
        SQLUtil.cleanup(toAckStatement);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public void fillBuffer() throws Exception {
        block18: {
            if (!this.bufferQueue.isWritable()) {
                return;
            }
            sortedChangefulFields = ChangefulBillData.getSortedChangefulFields(this.dataModel);
            t = System.currentTimeMillis();
            this.readingStatement = this.connection.createStatement(1003, 1007);
            rs = null;
            flatData = null;
            readBillBase = new LinkedList<ObjectPKInfo>();
            rowCount = 0;
            try {
                s = "";
                if (!(this.connection instanceof KDConnection)) {
                    dbType = 0;
                    if (DBUtil.isOracle((Connection)this.connection)) {
                        dbType = 2;
                    } else if (DBUtil.isDB2((Connection)this.connection)) {
                        dbType = 1;
                    } else if (DBUtil.isMSSQL((Connection)this.connection)) {
                        dbType = 3;
                    }
                    s = TransUtil.Translate((String)this.queryString.toString(), (int)dbType);
                } else {
                    s = this.queryString.toString();
                }
                rs = this.readingStatement.executeQuery(s);
                tableModels = this.dataModel.getPriorityTables();
                columnCount = tableModels[1].columns.length;
                headpkVal = null;
                changefulBillData = new ChangefulBillData(sortedChangefulFields, false, DBUtil.isOracle((Connection)this.connection));
                flatData = new FlatData(this.flatDataColumns);
lbl31:
                // 2 sources

                while (rs.next()) {
                    columnIndex = 1;
                    ++rowCount;
                    headpkVal = rs.getObject(this.entrypkIndex == 0 ? 1 : this.entrypkIndex);
                    if (headpkVal == null) {
                        throw new NullPointerException("headpk column value is null!");
                    }
                    if (changefulBillData != null) {
                        changefulBillData.appendFieldBytes(rs);
                        changefulBillData.snapshot();
                        if (flatData != null && !this.enQueue(readBillBase, flatData, changefulBillData.getNewHashCode())) {
                            t = System.currentTimeMillis() - t;
                            BufferedBillDataProvider.logger.info((Object)("fetch " + readBillBase.size() + " rows, elapsed time : " + t + " ms"));
                            this.insertReadIDS(readBillBase, this.agentId);
                            break block18;
                        }
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl62
            }
            catch (Throwable var16_16) {
                SQLUtil.cleanup(rs, this.readingStatement, this.connection);
                throw var16_16;
            }
        }
        SQLUtil.cleanup(rs, this.readingStatement, this.connection);
        return;
lbl-1000:
        // 1 sources

        {
            flatDataRow = flatData.createFlatDataRow();
            while (columnIndex <= columnCount) {
                val = rs.getObject(columnIndex);
                flatDataRow.set(columnIndex - 1, val);
                ++columnIndex;
            }
            flatData.addDataRow(flatDataRow);
            ** GOTO lbl31
lbl62:
            // 1 sources

            if (flatData != null && flatData.getDataRows() != null && flatData.getDataRows().size() > 0 && this.enQueue(readBillBase, flatData, "ADAAFAFAFFA")) {
                this.bufferQueue.finishWrite();
            }
            this.insertReadIDS(readBillBase, this.agentId);
            if (readBillBase.size() == 0) {
                this.bufferQueue.finishWrite();
            }
            t = System.currentTimeMillis() - t;
            BufferedBillDataProvider.logger.info((Object)("fetch " + rowCount + " rows, elapsed time : " + t + " ms"));
        }
        SQLUtil.cleanup(rs, this.readingStatement, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void fillBuffer(boolean isMainTable) throws Exception {
        if (!this.bufferQueue.isWritable()) {
            return;
        }
        String[] sortedChangefulFields = null;
        sortedChangefulFields = isMainTable ? ChangefulBillData.getSortedChangefulFields4BaseData(this.dataModel) : ChangefulBillData.getSortedChangefulFields(this.dataModel);
        long t = System.currentTimeMillis();
        this.readingStatement = this.connection.createStatement(1003, 1007);
        ResultSet rs = null;
        FlatData flatData = null;
        LinkedList<ObjectPKInfo> readBillBase = new LinkedList<ObjectPKInfo>();
        int rowCount = 0;
        try {
            String s = "";
            if (!(this.connection instanceof KDConnection)) {
                int dbType = 0;
                if (DBUtil.isOracle((Connection)this.connection)) {
                    dbType = 2;
                } else if (DBUtil.isDB2((Connection)this.connection)) {
                    dbType = 1;
                } else if (DBUtil.isMSSQL((Connection)this.connection)) {
                    dbType = 3;
                }
                s = TransUtil.Translate((String)this.queryString.toString(), (int)dbType);
            } else {
                s = this.queryString.toString();
            }
            rs = this.readingStatement.executeQuery(s);
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getTables();
            int columnCount = tableModels[1].columns.length;
            Object headpkVal = null;
            ChangefulBillData changefulBillData = new ChangefulBillData(sortedChangefulFields, true, DBUtil.isOracle((Connection)this.connection));
            ArrayList<String> hashCodeList = new ArrayList<String>();
            ArrayList<String> changeTimeList = new ArrayList<String>();
            flatData = new FlatData(this.flatDataColumns);
            while (rs.next()) {
                int columnIndex = 1;
                ++rowCount;
                headpkVal = rs.getObject(this.entrypkIndex == 0 ? 1 : this.entrypkIndex);
                if (headpkVal == null) {
                    throw new NullPointerException("headpk column value is null!");
                }
                if (changefulBillData != null) {
                    if (isMainTable) {
                        changefulBillData.appendFieldBytes4MainTable(rs);
                        changefulBillData.snapshot4MainTable();
                    } else {
                        changefulBillData.appendFieldBytes(rs);
                        changefulBillData.snapshot();
                    }
                    hashCodeList.add(changefulBillData.getNewHashCode());
                    changeTimeList.add(changefulBillData.getNewChangeTime());
                }
                FlatData.FlatDataRow flatDataRow = flatData.createFlatDataRow();
                while (columnIndex <= columnCount) {
                    Object val = rs.getObject(columnIndex);
                    flatDataRow.set(columnIndex - 1, val);
                    ++columnIndex;
                }
                flatData.addDataRow(flatDataRow);
            }
            if (flatData != null && flatData.getDataRows() != null && flatData.getDataRows().size() > 0 && this.enQueue(readBillBase, flatData, hashCodeList, changeTimeList)) {
                this.bufferQueue.finishWrite();
            }
            this.insertReadIDS(readBillBase, this.agentId, this.transmitSerialNumber, this.pageNum);
            if (readBillBase.size() == 0) {
                this.bufferQueue.finishWrite();
            }
            t = System.currentTimeMillis() - t;
            logger.info((Object)("fetch " + rowCount + " rows, elapsed time : " + t + " ms"));
            SQLUtil.cleanup(rs, this.readingStatement, this.connection);
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
        }
        finally {
            SQLUtil.cleanup(rs, this.readingStatement, this.connection);
        }
    }

    @Override
    public void fillBufferBase(boolean isMainTable) throws Exception {
        if (!this.bufferQueue.isWritable()) {
            return;
        }
        String[] sortedChangefulFields = null;
        sortedChangefulFields = isMainTable ? ChangefulBillData.getSortedChangefulFields4BaseData(this.dataModel) : ChangefulBillData.getSortedChangefulFields(this.dataModel);
        long t = System.currentTimeMillis();
        this.readingStatement = this.connection.createStatement(1003, 1007);
        ResultSet rs = null;
        FlatData flatData = null;
        LinkedList<ObjectPKInfo> readBillBase = new LinkedList<ObjectPKInfo>();
        int rowCount = 0;
        try {
            String sql = BufferedBillDataProvider.translateSQL(this.connection, this.queryString.toString());
            rs = this.readingStatement.executeQuery(sql);
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getTables();
            int columnCount = tableModels[1].columns.length;
            Object headpkVal = null;
            ChangefulBillData changefulBillData = new ChangefulBillData(sortedChangefulFields, true, DBUtil.isOracle((Connection)this.connection));
            ArrayList<String> hashCodeList = new ArrayList<String>();
            ArrayList<String> changeTimeList = new ArrayList<String>();
            flatData = new FlatData(this.flatDataColumns);
            while (rs.next()) {
                int columnIndex = 1;
                ++rowCount;
                headpkVal = rs.getObject(this.entrypkIndex == 0 ? 1 : this.entrypkIndex);
                if (headpkVal == null) {
                    throw new NullPointerException("headpk column value is null!");
                }
                if (changefulBillData != null) {
                    if (isMainTable) {
                        changefulBillData.appendFieldBytes4MainTable(rs);
                        changefulBillData.snapshot4MainTable();
                    } else {
                        changefulBillData.appendFieldBytes(rs);
                        changefulBillData.snapshot();
                    }
                    hashCodeList.add(changefulBillData.getNewHashCode());
                    changeTimeList.add(changefulBillData.getNewChangeTime());
                }
                FlatData.FlatDataRow flatDataRow = flatData.createFlatDataRow();
                while (columnIndex <= columnCount) {
                    Object val = rs.getObject(columnIndex);
                    flatDataRow.set(columnIndex - 1, val);
                    ++columnIndex;
                }
                flatData.addDataRow(flatDataRow);
            }
            if (flatData != null && flatData.getDataRows() != null && flatData.getDataRows().size() > 0 && this.enQueue(readBillBase, flatData, hashCodeList, changeTimeList)) {
                this.bufferQueue.finishWrite();
            }
            this.insertReadIDS(readBillBase, this.agentId, this.transmitSerialNumber, this.pageNum);
            if (readBillBase.size() == 0) {
                this.bufferQueue.finishWrite();
            }
            t = System.currentTimeMillis() - t;
            logger.info((Object)("fetch " + rowCount + " rows, elapsed time : " + t + " ms"));
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException("EIP,\u6267\u884c\u540c\u6b65(\u5e7f\u57df\u7f51) -- \u521d\u59cb\u5316\u589e\u91cf\u8868\uff0c\u51c6\u5907\u53d1\u9001\u6570\u636e\u65b9\u6cd5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(rs, this.readingStatement, this.connection);
                throw throwable;
            }
        }
        SQLUtil.cleanup(rs, this.readingStatement, this.connection);
    }

    @Override
    public void fillBufferBaseJDBC(boolean isMainTable) throws Exception {
        String[] sortedChangefulFields = null;
        sortedChangefulFields = isMainTable ? ChangefulBillData.getSortedChangefulFields4BaseData(this.dataModel) : ChangefulBillData.getSortedChangefulFields(this.dataModel);
        long t = System.currentTimeMillis();
        this.readingStatement = this.connection.createStatement(1003, 1007);
        ResultSet rs = null;
        FlatData flatData = null;
        LinkedList<ObjectPKInfo> readBillBase = new LinkedList<ObjectPKInfo>();
        int rowCount = 0;
        long beginTime = System.currentTimeMillis();
        try {
            String sql = this.queryString.toString();
            if (!DBUtils.isPostgresSQL(this.connection) && !DBUtil.isOracle((Connection)this.connection)) {
                sql = DBUtils.translateKSQL(this.connection, this.queryString.toString());
            }
            StringBuffer execMsg = new StringBuffer();
            rs = this.readingStatement.executeQuery(sql);
            long endTime = System.currentTimeMillis();
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getTables();
            int columnCount = tableModels[1].columns.length;
            Object headpkVal = null;
            ChangefulBillData changefulBillData = new ChangefulBillData(sortedChangefulFields, true, DBUtil.isOracle((Connection)this.connection));
            ArrayList<String> hashCodeList = new ArrayList<String>(10000);
            ArrayList<String> changeTimeList = new ArrayList<String>(10000);
            HashMap<String, Object> mainPKMap = new HashMap<String, Object>();
            flatData = new FlatData(this.flatDataColumns);
            HashSet<String> idSet = new HashSet<String>();
            String fid = null;
            boolean newWay = false;
            if (null != this.baseDataSynInfo) {
                newWay = EIPConfiguration.Instance().isBigDataEntryTable(this.baseDataSynInfo.getTableName());
            }
            ArrayList<String> pkList = new ArrayList<String>();
            while (rs.next()) {
                fid = rs.getString("FID");
                pkList.add(fid);
                int columnIndex = 1;
                ++rowCount;
                if (idSet.contains(fid)) continue;
                idSet.add(fid);
                headpkVal = rs.getObject(this.entrypkIndex == 0 ? 1 : this.entrypkIndex);
                if (headpkVal == null) {
                    throw new NullPointerException("headpk column value is null!");
                }
                if (changefulBillData != null) {
                    if (isMainTable) {
                        changefulBillData.appendFieldBytes4MainTable(rs);
                        changefulBillData.snapshot4MainTable();
                    } else if (newWay) {
                        if (null != this.baseDataSynInfo) {
                            changefulBillData.recordChangeTime(rs, this.baseDataSynInfo.getTableName(), isMainTable);
                        } else {
                            changefulBillData.recordChangeTime(rs);
                        }
                    } else {
                        changefulBillData.appendFieldBytes(rs);
                        changefulBillData.snapshot();
                    }
                    hashCodeList.add(changefulBillData.getNewHashCode());
                    changeTimeList.add(changefulBillData.getNewChangeTime());
                }
                if (!isMainTable) {
                    mainPKMap.put(headpkVal.toString(), rs.getObject(columnCount + 1));
                }
                FlatData.FlatDataRow flatDataRow = flatData.createFlatDataRow();
                while (columnIndex <= columnCount) {
                    ColumnModel model = tableModels[1].columns[columnIndex - 1];
                    Object val = DBTransformUtil.getValue(rs, columnIndex, model.sqlType);
                    flatDataRow.set(columnIndex - 1, val);
                    ++columnIndex;
                }
                flatData.addDataRow(flatDataRow);
            }
            execMsg.append("\u6267\u884c\u60c5\u51b5\uff1a\u603b\u884c\u6570\uff1a" + rowCount + "\uff0c\u8017\u65f6\uff1a" + (endTime - beginTime) + "ms \r");
            this.recordInfo.recordTableExecInfo(execMsg.toString());
            if (!isMainTable) {
                BaseDataSynUtil.addBeforeSQLCheck((Context)this.ctx, pkList, (String)this.agentId, (BaseDataSynTableInfo)this.baseDataSynInfo, (String)sql, (String)this.baseDataSynInfo.getBeforeSQL());
                List dataRows = flatData.getDataRows();
                Iterator it = dataRows.iterator();
                while (it.hasNext()) {
                    FlatData.FlatDataRow row = (FlatData.FlatDataRow)it.next();
                    String tempFid = (String)row.get("FID");
                    if ((pkList.size() <= 0 || pkList.contains(tempFid)) && pkList.size() != 0) continue;
                    it.remove();
                }
            }
            if (flatData == null || flatData.getDataRows() == null || flatData.getDataRows().size() <= 0 || this.enQueue(readBillBase, flatData, hashCodeList, changeTimeList)) {
                // empty if block
            }
            for (ObjectPKInfo pkInfo : readBillBase) {
                pkInfo.mainPK = mainPKMap.get(pkInfo.headpk);
            }
            long flatTime = System.currentTimeMillis();
            execMsg = new StringBuffer();
            execMsg.append("\u8ba1\u7b97\u53d8\u5316\uff0c\u5e76\u7ed3\u6784\u5316\u6570\u636e\u8017\uff1a" + (flatTime - endTime) + "ms \r");
            this.recordInfo.recordTableExecInfo(execMsg.toString());
            this.insertReadIDS(readBillBase, this.agentId, this.transmitSerialNumber, this.pageNum);
            long pkTableTime = System.currentTimeMillis();
            execMsg = new StringBuffer();
            execMsg.append("\u521d\u59cb\u5316\u589e\u91cf\u8868\u8017\u65f6\uff1a" + (pkTableTime - flatTime) + "ms \r");
            this.recordInfo.recordTableExecInfo(execMsg.toString());
            if (readBillBase.size() == 0) {
                // empty if block
            }
            t = System.currentTimeMillis() - t;
            logger.info((Object)("fetch " + rowCount + " rows, elapsed time : " + t + " ms"));
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException("EIP,\u6267\u884c\u540c\u6b65-\u65b0\u589e(\u5c40\u57df\u7f51)-\u521d\u59cb\u5316\u589e\u91cf\u8868\uff0c\u51c6\u5907\u53d1\u9001\u6570\u636e\u65b9\u6cd5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(rs, this.readingStatement, this.connection);
                throw throwable;
            }
        }
        SQLUtil.cleanup(rs, this.readingStatement, this.connection);
    }

    @Override
    public void fillChangeBuffer(String transmitSerialNumber, int transmitChunkedNumber, String type, boolean isMainTable) throws Exception {
        if (!this.bufferQueue.isWritable()) {
            return;
        }
        String[] sortedChangefulFields = null;
        sortedChangefulFields = isMainTable ? ChangefulBillData.getSortedChangefulFields4BaseData(this.dataModel) : ChangefulBillData.getSortedChangefulFields(this.dataModel);
        long t = System.currentTimeMillis();
        this.readingStatement = this.connection.createStatement(1003, 1007);
        ResultSet rs = null;
        FlatData flatData = null;
        LinkedList<ObjectPKInfo> readBillBase = new LinkedList<ObjectPKInfo>();
        int rowCount = 0;
        ArrayList<String> hashCodeList = new ArrayList<String>();
        ArrayList<String> changeTimeList = new ArrayList<String>();
        ChangefulBillData changefulBillData = new ChangefulBillData(sortedChangefulFields, true, DBUtil.isOracle((Connection)this.connection));
        flatData = new FlatData(this.flatDataColumns);
        try {
            String s = "";
            if (!(this.connection instanceof KDConnection)) {
                int dbType = 0;
                if (DBUtil.isOracle((Connection)this.connection)) {
                    dbType = 2;
                } else if (DBUtil.isDB2((Connection)this.connection)) {
                    dbType = 1;
                } else if (DBUtil.isMSSQL((Connection)this.connection)) {
                    dbType = 3;
                }
                s = TransUtil.Translate((String)this.queryString.toString(), (int)dbType);
            } else {
                s = this.queryString.toString();
            }
            rs = this.readingStatement.executeQuery(s);
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getTables();
            int columnCount = tableModels[1].columns.length;
            Object headpkVal = null;
            flatData = new FlatData(this.flatDataColumns);
            while (rs.next()) {
                int columnIndex = 1;
                ++rowCount;
                if (changefulBillData != null) {
                    if (isMainTable) {
                        changefulBillData.appendFieldBytes4MainTable(rs);
                        changefulBillData.snapshot4MainTable();
                    } else {
                        changefulBillData.appendFieldBytes(rs);
                        changefulBillData.snapshot();
                    }
                    hashCodeList.add(changefulBillData.getNewHashCode());
                    changeTimeList.add(changefulBillData.getNewChangeTime());
                }
                FlatData.FlatDataRow flatDataRow = flatData.createFlatDataRow();
                while (columnIndex <= columnCount) {
                    Object val = rs.getObject(columnIndex);
                    flatDataRow.set(columnIndex - 1, val);
                    ++columnIndex;
                }
                flatData.addDataRow(flatDataRow);
            }
            if (flatData != null && flatData.getDataRows() != null && flatData.getDataRows().size() > 0 && this.enQueueChange(readBillBase, flatData, hashCodeList, changeTimeList)) {
                this.bufferQueue.finishWrite();
            }
            if (StringUtils.equals((String)type, (String)CHANGE_UPDATE)) {
                this.updateReadIDS(readBillBase, this.agentId, transmitSerialNumber, transmitChunkedNumber);
            } else if (StringUtils.equals((String)type, (String)CHANGE_ADD)) {
                this.insertReadIDS4Change(readBillBase, this.agentId, transmitSerialNumber, transmitChunkedNumber);
            }
            if (readBillBase.size() == 0) {
                this.bufferQueue.finishWrite();
            }
            t = System.currentTimeMillis() - t;
            logger.info((Object)("fetch " + rowCount + " rows, elapsed time : " + t + " ms"));
        }
        catch (Exception e) {
            try {
                System.out.println(e.getStackTrace());
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(rs, this.readingStatement, this.connection);
                throw throwable;
            }
        }
        SQLUtil.cleanup(rs, this.readingStatement, this.connection);
    }

    @Override
    public void fillChangeBufferJDBC(String transmitSerialNumber, int transmitChunkedNumber, String type, boolean isMainTable) throws Exception {
        try {
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getTables();
            int columnCount = tableModels[1].columns.length;
            String[] sortedChangefulFields = null;
            sortedChangefulFields = isMainTable ? ChangefulBillData.getSortedChangefulFields4BaseData(this.dataModel) : ChangefulBillData.getSortedChangefulFields(this.dataModel);
            this.initUpdateDataJDBCInsert(sortedChangefulFields, columnCount);
            this.initUpdateDataJDBCUpdate(sortedChangefulFields, columnCount);
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
            throw new Exception(e);
        }
        finally {
            SQLUtil.cleanup(this.readingStatement, this.connection);
        }
    }

    @Override
    public void initUpdateDataJDBCInsert(String[] sortedChangefulFields, int columnCount) throws Exception {
        String tableName = this.baseDataSynInfo.getTableName();
        ResultSet rs = null;
        FlatData flatData = null;
        LinkedList<ObjectPKInfo> readBillBase = new LinkedList<ObjectPKInfo>();
        try {
            this.open(this.ctx);
            long t = System.currentTimeMillis();
            String insertSQL = this.getChangeSQLJDBC(this.flatDataModel.getAddIdsAsString(), true);
            String s = DBUtils.translateKSQL(this.connection, insertSQL);
            this.readingStatement = this.connection.createStatement(1003, 1007);
            long beginInsertTime = System.currentTimeMillis();
            rs = this.readingStatement.executeQuery(s);
            long endInsertTime = System.currentTimeMillis();
            Object headpkVal = null;
            int rowCount = 0;
            ArrayList<String> hashCodeList = new ArrayList<String>();
            ArrayList<String> changeTimeList = new ArrayList<String>();
            ChangefulBillData changefulBillData = new ChangefulBillData(sortedChangefulFields, true, DBUtil.isOracle((Connection)this.connection));
            flatData = new FlatData(this.flatDataColumns);
            HashMap<String, Object> mainPKMap = new HashMap<String, Object>();
            boolean newWay = EIPConfiguration.Instance().isBigDataEntryTable(tableName);
            while (rs.next()) {
                ++rowCount;
                int columnIndex = 1;
                headpkVal = rs.getObject(this.entrypkIndex == 0 ? 1 : this.entrypkIndex);
                if (headpkVal == null) {
                    throw new NullPointerException("headpk column value is null!");
                }
                if (changefulBillData != null) {
                    if (this.isMaintTable) {
                        changefulBillData.appendFieldBytes4MainTable(rs);
                        changefulBillData.snapshot4MainTable();
                    } else if (newWay) {
                        changefulBillData.recordChangeTime(rs);
                    } else {
                        changefulBillData.appendFieldBytes(rs);
                        changefulBillData.snapshot();
                    }
                    hashCodeList.add(changefulBillData.getNewHashCode());
                    changeTimeList.add(changefulBillData.getNewChangeTime());
                }
                FlatData.FlatDataRow flatDataRow = flatData.createFlatDataRow();
                for (int i = 0; i < this.flatDataColumns.length; ++i) {
                    Object val = rs.getObject(this.flatDataColumns[i].name);
                    flatDataRow.set(i, val);
                    ++columnIndex;
                }
                if (!this.isMaintTable) {
                    mainPKMap.put(headpkVal.toString(), rs.getObject(columnCount + 1));
                }
                flatData.addDataRow(flatDataRow);
            }
            StringBuffer recordMsg = new StringBuffer();
            recordMsg.append("\u6267\u884c\u60c5\u51b5\uff1a\u603b\u884c\u6570\uff1a" + rowCount + "\uff0c\u8017\u65f6\uff1a" + (endInsertTime - beginInsertTime) + "ms \r");
            if (flatData == null || flatData.getDataRows() == null || flatData.getDataRows().size() <= 0 || this.enQueueChange(readBillBase, flatData, hashCodeList, changeTimeList)) {
                // empty if block
            }
            for (ObjectPKInfo pkInfo : readBillBase) {
                pkInfo.mainPK = mainPKMap.get(pkInfo.headpk);
            }
            long endDataTime = System.currentTimeMillis();
            recordMsg.append("\u8ba1\u7b97\u53d8\u5316\uff0c\u5e76\u7ed3\u6784\u5316\u6570\u636e\u8017\u65f6\uff1a" + (endDataTime - endInsertTime) + "ms \r");
            this.insertReadIDS4Change(readBillBase, this.agentId, "-1", -1);
            long endPKTableTime = System.currentTimeMillis();
            recordMsg.append("\u521d\u59cb\u5316\u589e\u91cf\u8868\u8017\u65f6\uff1a" + (endPKTableTime - endDataTime) + "ms \r");
            if (this.recordInfo == null) {
                this.recordInfo = ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog();
            }
            this.recordInfo.recordTableExecInfo(recordMsg.toString());
            t = System.currentTimeMillis() - t;
            logger.info((Object)("fetch insert " + rowCount + " rows, elapsed time : " + t + " ms"));
        }
        catch (Exception e) {
            try {
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                this.close();
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        this.close();
        SQLUtils.cleanup((ResultSet)rs);
    }

    @Override
    public void initUpdateDataJDBCUpdate(String[] sortedChangefulFields, int columnCount) throws Exception {
        String tableName = this.baseDataSynInfo.getTableName();
        ResultSet rs = null;
        FlatData flatData = null;
        LinkedList<ObjectPKInfo> readBillBase = new LinkedList<ObjectPKInfo>();
        try {
            long t = System.currentTimeMillis();
            String updateSQL = this.getChangeSQLJDBC(this.flatDataModel.getUpdateIdsAsString(), false);
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = null;
                this.open(this.ctx);
            }
            String s = DBUtils.translateKSQL(this.connection, updateSQL);
            this.readingStatement = this.connection.createStatement(1003, 1007);
            long beginGetTime = System.currentTimeMillis();
            rs = this.readingStatement.executeQuery(s);
            long endGetTime = System.currentTimeMillis();
            Object headpkVal = null;
            int rowCount = 0;
            ArrayList<String> hashCodeList = new ArrayList<String>();
            ArrayList<String> changeTimeList = new ArrayList<String>();
            ChangefulBillData changefulBillData = new ChangefulBillData(sortedChangefulFields, true, DBUtil.isOracle((Connection)this.connection));
            ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
            ArrayList<ColumnModel> changeColumns = new ArrayList<ColumnModel>(this.dataModel.getTables()[0].columns.length);
            ColumnModel model = null;
            for (int j = 0; j < this.dataModel.getTables()[0].columns.length; ++j) {
                model = this.dataModel.getTables()[0].columns[j];
                if (!model.isChangeSyn) continue;
                DataColumn column = new DataColumn(model.name, model.alias);
                flatDataColumns.add(column);
                changeColumns.add(model);
            }
            this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
            flatData = new FlatData(this.flatDataColumns);
            boolean newWay = EIPConfiguration.Instance().isBigDataEntryTable(tableName);
            while (rs.next()) {
                ++rowCount;
                if (changefulBillData != null) {
                    if (this.baseDataSynInfo.isMainTable()) {
                        changefulBillData.appendFieldBytes4MainTable(rs);
                        changefulBillData.snapshot4MainTable();
                    } else if (newWay) {
                        changefulBillData.recordChangeTime(rs);
                    } else {
                        changefulBillData.appendFieldBytes(rs);
                        changefulBillData.snapshot();
                    }
                    hashCodeList.add(changefulBillData.getNewHashCode());
                    changeTimeList.add(changefulBillData.getNewChangeTime());
                }
                FlatData.FlatDataRow flatDataRow = flatData.createFlatDataRow();
                for (int i = 0; i < flatDataColumns.size(); ++i) {
                    try {
                        Object val = DBTransformUtil.getValue(rs, i + 1, ((ColumnModel)changeColumns.get((int)i)).sqlType);
                        flatDataRow.set(i, val);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u5bf9\u5e94\u8868\uff1a" + tableName));
                        logger.error((Object)("\u5177\u4f53rs\u503c\uff1a" + rs.toString()));
                        logger.error((Object)("\u5217\u7d22\u5f15\uff1a" + i + 1 + "\r\n\u5217\u7c7b\u578b" + ((ColumnModel)changeColumns.get((int)i)).sqlType + "\r\n\u76ee\u6807\u7cfb\u7edf\u5b57\u6bb5\u540d\uff1a" + ((ColumnModel)changeColumns.get((int)i)).destName + " \r\n\u5217\u5bf9\u8c61" + ((ColumnModel)changeColumns.get(i)).toString()));
                        throw e;
                    }
                }
                flatData.addDataRow(flatDataRow);
            }
            if (flatData == null || flatData.getDataRows() == null || flatData.getDataRows().size() <= 0 || this.enQueueChange(readBillBase, flatData, hashCodeList, changeTimeList)) {
                // empty if block
            }
            long endDataTime = System.currentTimeMillis();
            this.feedbackChangeForJDBC(readBillBase, this.agentId, "-1", -1, BillDataStatus.waitAck);
            long feedbackTime = System.currentTimeMillis();
            StringBuffer execMsg = new StringBuffer();
            execMsg.append("\u6267\u884c\u60c5\u51b5\uff1a\u603b\u884c\u6570\uff1a" + rowCount + "\uff0c\u8017\u65f6\uff1a" + (endGetTime - beginGetTime) + "ms \r");
            execMsg.append("\u8ba1\u7b97\u53d8\u5316\uff0c\u5e76\u7ed3\u6784\u5316\u6570\u636e\u8017\u65f6\uff1a" + (endDataTime - endGetTime) + "ms \r");
            execMsg.append("\u53cd\u5199\u589e\u91cf\u8868\u8017\u65f6\uff1a" + (feedbackTime - endDataTime) + "ms \r");
            if (this.recordInfo == null) {
                this.recordInfo = ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog();
            }
            this.recordInfo.recordTableExecInfo(execMsg.toString());
            t = System.currentTimeMillis() - t;
            logger.info((Object)("fetch update" + rowCount + " rows, elapsed time : " + t + " ms"));
            this.readBillBase = readBillBase;
        }
        catch (Exception e) {
            try {
                throw new BOSException("EIP,\u5c40\u57df\u7f51\u66f4\u65b0 -\u521d\u59cb\u5316-\u4ece\u8868\u7684\u66f4\u65b0\u6570\u636e\u7684\u589e\u91cf\u8868\uff0c\u5e76\u51c6\u5907\u597d\u540c\u6b65\u7684\u6570\u636e\u65b9\u6cd5\u6267\u884c\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)this.readingStatement, (Connection)this.connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)this.readingStatement, (Connection)this.connection);
    }

    @Override
    public void initUpdateDataJDBCDelete() throws Exception {
        HashSet<String> deleteSet = new HashSet<String>();
        deleteSet.addAll(this.flatDataModel.getDeleteIds());
        BaseDataSaver saver = null;
        BaseDataSynHeadInfo headInfo = null;
        try {
            headInfo = BaseDataSynHeadFactory.getLocalInstance(this.ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(this.baseDataSynInfo.getParent().getId().toString()));
            long t = System.currentTimeMillis();
            ConnectionInfo connection = ConnectionFactory.getLocalInstance(this.ctx).getConnectionInfo(CommonUtil.convert2PK(this.agentId));
            saver = new BaseDataSaver(connection);
            saver.deleteByNativeJDBCBatch(this.baseDataSynInfo, this.flatDataModel.getDeleteIds());
            StringBuffer deleteSQL = new StringBuffer();
            deleteSQL.append("delete from ").append(this.baseDataSynInfo.getPkTableName()).append(" where headpk = ?").append(" and agentid = '" + this.agentId + "'");
            ArrayList<String[]> idList = new ArrayList<String[]>();
            for (String id : this.flatDataModel.getDeleteIds()) {
                String[] param = new String[]{id};
                idList.add(param);
            }
            DbUtil.executeBatch((Context)this.ctx, (String)deleteSQL.toString(), idList);
            t = System.currentTimeMillis() - t;
            logger.info((Object)("fetch update" + this.flatDataModel.getDeleteIds().size() + " rows, elapsed time : " + t + " ms"));
            saver.setSuccessNumber(deleteSet);
        }
        catch (Exception e) {
            saver.setExistNumber(deleteSet);
            throw new BOSException("EIP,\u6267\u884c\u5c40\u57df\u7f51\u66f4\u65b0 -\u76f4\u63a5\u5220\u9664\u5bf9\u5e94\u7684\u6570\u636e\u65b9\u6cd5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (headInfo != null) {
                    SubMonitorLogFactory.getLocalInstance(this.ctx).addLogWithoutTrans(saver, this.baseDataSynInfo.getTableName(), CHANGE_DELETE, this.baseDataSynInfo.isMainTable(), headInfo.getNumber());
                }
            }
            catch (Exception e) {
                throw new BOSException("EIP,\u6267\u884c\u6570\u636e\u5220\u9664\u7ed3\u679c\u65b9\u6cd5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
        }
    }

    public static void saveSubMonitorlog(Context ctx, BaseDataSaver saver, String tableName, String type, boolean isMainTable, String planNumber) throws Exception {
        SubMonitorLogInfo logInfo = new SubMonitorLogInfo();
        String monitorLogId = MonitorManager.getCurrentBaseDataDown().getId().toString();
        try {
            String successNumber = saver.getSuccessNumber();
            String failureNumber = saver.getFailureNumber();
            String existNumber = saver.getExistNumber();
            int successCount = BufferedBillDataProvider.getNumberCount(successNumber);
            int failureCount = BufferedBillDataProvider.getNumberCount(failureNumber);
            int existCount = BufferedBillDataProvider.getNumberCount(existNumber);
            if (failureCount > 0) {
                successCount = 0;
                successNumber = "";
            }
            logInfo.setCmd(type);
            logInfo.setSuccess(successNumber);
            logInfo.setFailure(failureNumber);
            logInfo.setTableName(tableName);
            logInfo.setMonitorLogId(monitorLogId);
            logInfo.setSuccessCount(successCount);
            logInfo.setFailureCount(failureCount);
            logInfo.setExistCount(existCount);
            logInfo.setMainTable(isMainTable);
            logInfo.setPlanNumber(planNumber.toString());
            SubMonitorLogFactory.getLocalInstance(ctx).addnew(logInfo);
        }
        catch (Exception e) {
            logger.error((Object)"EIP\u751f\u6210\u5b50\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }

    public static final int getNumberCount(String obj) {
        int count = 0;
        if (StringUtils.isEmpty((String)obj)) {
            return count;
        }
        try {
            count = obj.split(",").length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    private String getChangeSQLJDBC(String fid, boolean isAddNew) throws Exception {
        int i;
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getTables();
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("select ");
        String headPkName = null;
        String entryPkName = null;
        int colHeadNum = 0;
        int colEntryNum = 0;
        String AS_NAME = "t1.";
        String ALIAS_NAME = "t1";
        if (isAddNew) {
            for (i = 0; i < tableModels[1].columns.length; ++i) {
                if (colEntryNum > 0) {
                    insertSQL.append(", ");
                }
                if (tableModels[1].columns[i].isPk) {
                    entryPkName = tableModels[1].columns[i].name;
                    this.entrypkIndex = colEntryNum + 1;
                }
                insertSQL.append(AS_NAME).append(tableModels[1].columns[i].name);
                ++colEntryNum;
            }
        } else {
            for (i = 0; i < tableModels[0].columns.length; ++i) {
                if (StringUtils.isEmpty((String)tableModels[0].columns[i].destName)) continue;
                if (colHeadNum > 0) {
                    insertSQL.append(", ");
                }
                if (tableModels[0].columns[i].isPk) {
                    headPkName = tableModels[0].columns[i].name;
                    this.headpkIndex = colHeadNum + 1;
                }
                insertSQL.append(AS_NAME).append(tableModels[0].columns[i].name);
                ++colHeadNum;
            }
            if (EIPConfiguration.Instance().isBigDataEntryTable(this.baseDataSynInfo.getTableName())) {
                boolean hasTimeField = false;
                for (int i2 = 0; i2 < tableModels[0].columns.length; ++i2) {
                    if (!"flastupdatetime".equalsIgnoreCase(tableModels[0].columns[i2].name)) continue;
                    hasTimeField = true;
                    break;
                }
                if (!hasTimeField) {
                    insertSQL.append(", ");
                    insertSQL.append(AS_NAME).append("flastupdatetime ");
                }
            }
        }
        String relateSQL = null;
        String mainTableField = null;
        this.relateSQL = this.baseDataSynInfo.getRelateSQL();
        if (!StringUtils.isEmpty((String)this.relateSQL)) {
            this.relateSQL = this.relateSQL.replace(this.baseDataSynInfo.getTableName() + ".", AS_NAME);
            relateSQL = this.relateSQL.substring(0, this.relateSQL.lastIndexOf("where"));
            mainTableField = this.relateSQL.substring(this.relateSQL.lastIndexOf("where") + 5, this.relateSQL.lastIndexOf("in("));
        }
        if (!StringUtils.isEmpty(mainTableField)) {
            insertSQL.append(",").append(mainTableField).append(" ").append("mainPK");
        }
        insertSQL.append(" from ").append(this.baseDataSynInfo.getTableName()).append(" " + ALIAS_NAME);
        if (!StringUtils.isEmpty(relateSQL)) {
            insertSQL.append(" ").append(relateSQL).append(" ");
        }
        insertSQL.append(" where t1.fid in(" + fid + ")");
        if (!StringUtils.isEmpty(mainTableField) && null != this.flatDataModel.mainUpdateIds && this.flatDataModel.mainUpdateIds.size() > 0) {
            insertSQL.append(" and " + mainTableField + " in(" + this.converList2String(this.flatDataModel.mainUpdateIds, "") + ")");
        }
        return insertSQL.toString();
    }

    private String converList2String(List<String> list, String split) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(split).append(list.get(i)).append(split);
        }
        return result.toString();
    }

    private boolean enQueue(List<ObjectPKInfo> readBillBase, FlatData flatData, String hashCode) throws Exception {
        StructuredTableData structuredTableData = StructuredDataFactory.transformFlat2Structured(this.dataModel, flatData);
        List<DataRow> dataRows = structuredTableData.getFirstTableRows();
        for (DataRow dataRow : dataRows) {
            this.sendDataRows.add(dataRow);
            readBillBase.add(new ObjectPKInfo(dataRow.getValues().get(dataRow.pkColumn), hashCode, ""));
        }
        return true;
    }

    private boolean enQueue(List<ObjectPKInfo> readBillBase, FlatData flatData, List<String> hashCodeList, List<String> changeTimeList) throws Exception {
        StructuredTableData structuredTableData = StructuredDataFactory.transformFlat2Structured(this.dataModel, flatData);
        List<DataRow> dataRows = structuredTableData.getFirstTableRows();
        int i = 0;
        Map timeMap = null;
        if (MonitorManager.getCurrentBaseDataDown() != null) {
            timeMap = MonitorManager.getCurrentBaseDataDown().getMainId_ChangeTime_map();
        }
        String time = null;
        Object pkValue = null;
        for (DataRow dataRow : dataRows) {
            pkValue = dataRow.getValues().get(dataRow.pkColumn);
            if (timeMap != null) {
                if (pkValue != null) {
                    time = (String)timeMap.get(pkValue);
                }
            } else {
                time = null;
            }
            if (time == null) {
                time = changeTimeList.get(i);
            }
            readBillBase.add(new ObjectPKInfo(dataRow.getValues().get(dataRow.pkColumn), hashCodeList.get(i), time, dataRow.getValues().get("mainPK")));
            ++i;
            this.sendDataRows.add(dataRow);
        }
        return true;
    }

    private boolean enQueueChange(List<ObjectPKInfo> readBillBase, FlatData flatData, List<String> hashCodeList, List<String> changeTimeList) throws Exception {
        StructuredTableData structuredTableData = StructuredDataFactory.transformFlat2Structured(this.dataModel, flatData);
        List<DataRow> dataRows = structuredTableData.getFirstTableRows();
        int i = 0;
        Map timeMap = MonitorManager.getCurrentBaseDataDown().getMainId_ChangeTime_map();
        String time = null;
        Object pkValue = null;
        for (DataRow dataRow : dataRows) {
            pkValue = dataRow.getValues().get(dataRow.pkColumn);
            if (pkValue != null) {
                time = (String)timeMap.get(pkValue);
            }
            if (time == null) {
                time = changeTimeList.get(i);
            }
            readBillBase.add(new ObjectPKInfo(dataRow.getValues().get(dataRow.pkColumn), hashCodeList.get(i), time, dataRow.getValues().get("mainPK")));
            ++i;
            this.sendDataRows.add(dataRow);
        }
        return true;
    }

    private void insertReadIDS(List<ObjectPKInfo> readBillBase, String agentId) throws SQLException {
        this.insertReadBillDataIDStm = this.connection.prepareStatement("insert into " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + "(" + "headpk" + "," + "transmitChunkedNumber," + "hashCode" + ", " + "changeTime" + ", " + "changeStatus," + "changeTransmitNumber," + "agentId" + ") values (?,?,?,?,?,?,?)");
        if (readBillBase != null && readBillBase.size() > 0) {
            long t = System.currentTimeMillis();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                for (int i = 0; i < readBillBase.size(); ++i) {
                    this.insertReadBillDataIDStm.setObject(1, readBillBase.get((int)i).headpk);
                    this.insertReadBillDataIDStm.setInt(2, 0);
                    this.insertReadBillDataIDStm.setString(3, readBillBase.get((int)i).hashCode);
                    Date date = new Date(t);
                    try {
                        date = sdf.parse(readBillBase.get((int)i).changeTime);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    this.insertReadBillDataIDStm.setTimestamp(4, new Timestamp(date.getTime()));
                    this.insertReadBillDataIDStm.setInt(5, BillDataStatus.read.getValue());
                    this.insertReadBillDataIDStm.setString(6, this.transmitSerialNumber);
                    this.insertReadBillDataIDStm.setString(7, agentId);
                    this.insertReadBillDataIDStm.addBatch();
                }
                this.insertReadBillDataIDStm.executeBatch();
                this.connection.commit();
                this.insertReadBillDataIDStm.clearBatch();
                t = System.currentTimeMillis() - t;
                logger.info((Object)("insert " + readBillBase.size() + " elapsed time : " + t + " ms"));
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
            finally {
                SQLUtil.cleanup(this.connection);
            }
        }
    }

    private void updateReadIDS(List<ObjectPKInfo> readBillBase, String agentId, String transmitSerialNumber, int transmitChunkedNumber) throws SQLException {
        this.feedbackChangeForJDBC(readBillBase, agentId, transmitSerialNumber, transmitChunkedNumber, BillDataStatus.read);
    }

    @Override
    public void feedbackChangeForJDBC(List<ObjectPKInfo> readBillBase, String agentId, String transmitSerialNumber, int transmitChunkedNumber, BillDataStatus billDataStatus) throws SQLException {
        this.updateIDStatusStm = this.connection.prepareStatement("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set changeTransmitNumber = ? ," + " transmitChunkedNumber = ? ," + " changeStatus = ? , " + "hashCode= ? ," + "changeTime= ? , " + "createTime= ?" + " where agentId = ? and headpk = ? ");
        if (readBillBase != null && readBillBase.size() > 0) {
            long t = System.currentTimeMillis();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Date date = new Date(t);
            Timestamp nowTime = new Timestamp(date.getTime());
            for (int i = 0; i < readBillBase.size(); ++i) {
                this.updateIDStatusStm.setObject(1, transmitSerialNumber);
                this.updateIDStatusStm.setObject(2, transmitChunkedNumber);
                this.updateIDStatusStm.setInt(3, billDataStatus.getValue());
                this.updateIDStatusStm.setString(4, readBillBase.get((int)i).hashCode);
                try {
                    date = sdf.parse(readBillBase.get((int)i).changeTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.updateIDStatusStm.setTimestamp(5, new Timestamp(date.getTime()));
                this.updateIDStatusStm.setTimestamp(6, nowTime);
                this.updateIDStatusStm.setString(7, this.agentId);
                this.updateIDStatusStm.setObject(8, readBillBase.get((int)i).headpk);
                this.updateIDStatusStm.addBatch();
            }
            this.updateIDStatusStm.executeBatch();
            t = System.currentTimeMillis() - t;
            logger.info((Object)("insert change records " + readBillBase.size() + " elapsed time : " + t + " ms"));
        }
    }

    private void insertReadIDS(List<ObjectPKInfo> readBillBase, String agentId, String transmitSerialNumber, int transmitChunkedNumber) throws SQLException {
        this.insertReadBillDataIDStm = this.connection.prepareStatement("insert into " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + "(" + "headpk" + "," + "transmitChunkedNumber," + "transmitSerialNumber," + "hashCode" + ", " + "changeTime" + ", " + "status," + "agentId," + "createTime" + ", " + "mainPK" + ") values (?,?,?,?,?,?,?,?,?)");
        if (readBillBase != null && readBillBase.size() > 0) {
            long t = System.currentTimeMillis();
            Date date = new Date(t);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Timestamp nowTimes = new Timestamp(date.getTime());
            try {
                for (int i = 0; i < readBillBase.size(); ++i) {
                    int index = 1;
                    this.insertReadBillDataIDStm.setObject(index++, readBillBase.get((int)i).headpk);
                    this.insertReadBillDataIDStm.setInt(index++, transmitChunkedNumber);
                    this.insertReadBillDataIDStm.setString(index++, transmitSerialNumber);
                    this.insertReadBillDataIDStm.setString(index++, readBillBase.get((int)i).hashCode);
                    boolean nullTime = readBillBase.get((int)i).changeTime == null;
                    try {
                        if (!nullTime) {
                            date = sdf.parse(readBillBase.get((int)i).changeTime);
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    this.insertReadBillDataIDStm.setTimestamp(index++, nullTime ? null : new Timestamp(date.getTime()));
                    this.insertReadBillDataIDStm.setInt(index++, BillDataStatus.waitAck.getValue());
                    this.insertReadBillDataIDStm.setString(index++, agentId);
                    this.insertReadBillDataIDStm.setTimestamp(index++, nowTimes);
                    this.insertReadBillDataIDStm.setObject(index++, readBillBase.get((int)i).mainPK);
                    this.insertReadBillDataIDStm.addBatch();
                }
                this.insertReadBillDataIDStm.executeBatch();
                try {
                    this.connection.commit();
                }
                catch (Exception i) {
                    // empty catch block
                }
                this.insertReadBillDataIDStm.clearBatch();
                t = System.currentTimeMillis() - t;
                logger.info((Object)("insert " + readBillBase.size() + " elapsed time : " + t + " ms"));
            }
            catch (SQLException e) {
                try {
                    this.connection.rollback();
                }
                catch (Exception e1) {
                    logger.error((Object)"\u4e8b\u52a1\u56de\u6eda\u5931\u8d25\uff01");
                }
                StringBuffer str = new StringBuffer();
                if (this.baseDataSynInfo != null && this.baseDataSynInfo.getPkTableName() != null) {
                    str.append("\u589e\u91cf\u8868\u6570\u636e\u63d2\u5165\u5931\u8d25,\u589e\u91cf\u8868[" + this.baseDataSynInfo == null ? "" : this.baseDataSynInfo.getPkTableName() + "]");
                }
                logger.error((Object)str.toString());
                throw new SQLException(str.toString(), e);
            }
            finally {
                SQLUtil.cleanup(this.connection);
            }
        }
    }

    private void insertReadIDS4Change(List<ObjectPKInfo> readBillBase, String agentId, String transmitSerialNumber, int transmitChunkedNumber) throws SQLException {
        this.insertReadBillDataIDStm = this.connection.prepareStatement("insert into " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + "(" + "headpk" + "," + "transmitChunkedNumber," + "hashCode" + ", " + "changeTime" + ", " + "status," + "agentId," + "changeStatus," + "changeTransmitNumber," + "createTime" + ", " + "mainPK" + ") values (?,?,?,?,?,?,?,?,?,?)");
        if (readBillBase != null && readBillBase.size() > 0) {
            long t = System.currentTimeMillis();
            Date date = new Date(t);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                Timestamp nowTimes = new Timestamp(date.getTime());
                for (int i = 0; i < readBillBase.size(); ++i) {
                    int beginIndex = 1;
                    this.insertReadBillDataIDStm.setObject(beginIndex++, readBillBase.get((int)i).headpk);
                    this.insertReadBillDataIDStm.setInt(beginIndex++, transmitChunkedNumber);
                    this.insertReadBillDataIDStm.setString(beginIndex++, readBillBase.get((int)i).hashCode);
                    try {
                        date = sdf.parse(readBillBase.get((int)i).changeTime);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    this.insertReadBillDataIDStm.setTimestamp(beginIndex++, new Timestamp(date.getTime()));
                    this.insertReadBillDataIDStm.setInt(beginIndex++, BillDataStatus.ack.getValue());
                    this.insertReadBillDataIDStm.setString(beginIndex++, agentId);
                    this.insertReadBillDataIDStm.setInt(beginIndex++, BillDataStatus.read.getValue());
                    this.insertReadBillDataIDStm.setString(beginIndex++, transmitSerialNumber);
                    this.insertReadBillDataIDStm.setTimestamp(beginIndex++, nowTimes);
                    this.insertReadBillDataIDStm.setObject(beginIndex++, readBillBase.get((int)i).mainPK);
                    this.insertReadBillDataIDStm.addBatch();
                }
                this.insertReadBillDataIDStm.executeBatch();
                try {
                    this.connection.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.insertReadBillDataIDStm.clearBatch();
                t = System.currentTimeMillis() - t;
                logger.info((Object)("insert " + readBillBase.size() + " elapsed time : " + t + " ms"));
            }
            catch (SQLException e) {
                try {
                    this.connection.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                SQLUtil.cleanup(this.insertReadBillDataIDStm, this.connection);
            }
        }
    }

    @Override
    public void feedback(String ids, BillDataStatus billDataStatus, boolean isDelete) throws Exception {
        Statement delStm = null;
        try {
            if (isDelete) {
                delStm = this.connection.createStatement();
                delStm.executeUpdate("delete from " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " where headpk in (" + ids + ")");
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(delStm);
                throw throwable;
            }
        }
        SQLUtil.cleanup(delStm);
    }

    @Deprecated
    public void finishUpdate(List<ObjectPKInfo> readBillBase, BillDataStatus billDataStatus, String agentId, boolean isDelete) throws Exception {
        this.updateIDStatusStm = this.connection.prepareStatement("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + "set " + "headpk" + "," + "transmitChunkedNumber," + "hashCode" + ", " + "changeTime" + ", " + "status," + "agentId," + "changeStatus," + "changeTransmitNumber" + ") values (?,?,?,?,?,?,?,?)");
        if (readBillBase != null && readBillBase.size() > 0) {
            long t = System.currentTimeMillis();
            boolean index = true;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                for (int i = 0; i < readBillBase.size(); ++i) {
                    int beginIndex = 1;
                    this.insertReadBillDataIDStm.setObject(beginIndex++, readBillBase.get((int)i).headpk);
                    this.insertReadBillDataIDStm.setInt(beginIndex++, -1);
                    this.insertReadBillDataIDStm.setString(beginIndex++, readBillBase.get((int)i).hashCode);
                    Date date = new Date(t);
                    try {
                        date = sdf.parse(readBillBase.get((int)i).changeTime);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    this.insertReadBillDataIDStm.setTimestamp(beginIndex++, new Timestamp(date.getTime()));
                    this.insertReadBillDataIDStm.setInt(beginIndex++, BillDataStatus.ack.getValue());
                    this.insertReadBillDataIDStm.setString(beginIndex++, agentId);
                    this.insertReadBillDataIDStm.setInt(beginIndex++, BillDataStatus.read.getValue());
                    this.insertReadBillDataIDStm.setString(beginIndex++, this.transmitSerialNumber);
                    this.insertReadBillDataIDStm.addBatch();
                }
                this.insertReadBillDataIDStm.executeBatch();
                this.connection.commit();
                this.insertReadBillDataIDStm.clearBatch();
                t = System.currentTimeMillis() - t;
                logger.info((Object)("insert " + readBillBase.size() + " elapsed time : " + t + " ms"));
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
            finally {
                SQLUtil.cleanup(this.insertReadBillDataIDStm, this.connection);
            }
        }
        try {
            if (readBillBase != null && readBillBase.size() > 0) {
                StringBuffer fidBuffer = new StringBuffer();
                for (int i = 0; i < readBillBase.size(); ++i) {
                    if (i <= 0) continue;
                    fidBuffer.append(",");
                    fidBuffer.append("'" + readBillBase.get((int)i).headpk + "'");
                }
                this.insertReadBillDataIDStm.executeUpdate("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set changestatus=" + billDataStatus.getValue() + " where headpk in (" + fidBuffer.toString() + ") and agentid = '" + agentId + "'");
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtil.cleanup(this.insertReadBillDataIDStm);
        }
    }

    @Override
    public void feedback(List<Object> idList, String transmitSerialNumber, BillDataStatus billDataStatus) throws Exception {
        PreparedStatement delStm = null;
        if (null == idList || idList.size() == 0) {
            return;
        }
        try {
            String delstr = "delete from " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " where " + "headpk" + " =? ";
            if (!StringUtils.isEmpty((String)transmitSerialNumber)) {
                delstr = delstr + " and transmitSerialNumber = ?";
            }
            delStm = this.connection.prepareStatement(delstr);
            for (int i = 0; i < idList.size(); ++i) {
                delStm.setObject(1, idList.get(i));
                if (!StringUtils.isEmpty((String)transmitSerialNumber)) {
                    delStm.setObject(2, transmitSerialNumber);
                }
                delStm.addBatch();
            }
            int[] ok = delStm.executeBatch();
            this.connection.commit();
            logger.info((Object)("SQL\u5220\u9664\u6267\u884c\u7ed3\u679c\uff1a" + (ok == null ? "null" : Arrays.toString(ok))));
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    @Override
    public void feedback(String transmitSerialNumber, int transmitChunkedNumber, int chunkedNumberCompareOperator, BillDataStatus billDataStatus, boolean isDelete) throws Exception {
        block15: {
            Statement stm = this.connection.createStatement();
            Statement delStm = null;
            try {
                String operator;
                if (3 == chunkedNumberCompareOperator) {
                    operator = ">";
                } else if (1 == chunkedNumberCompareOperator) {
                    operator = "<";
                } else if (4 == chunkedNumberCompareOperator) {
                    operator = ">=";
                } else if (2 == chunkedNumberCompareOperator) {
                    operator = "<=";
                } else {
                    throw new Exception("unknow chunkedNumberCompareOperator : " + chunkedNumberCompareOperator);
                }
                if (transmitChunkedNumber > 0) {
                    stm.executeUpdate("update " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " set status=" + billDataStatus.getValue() + " where transmitSerialNumber = '" + transmitSerialNumber + "' and transmitChunkedNumber " + operator + transmitChunkedNumber);
                    break block15;
                }
                if (transmitChunkedNumber == 0) {
                    stm.executeUpdate("delete from " + this.baseDataSynInfo.getPkTableName().replace("\"", "") + " where transmitSerialNumber = '" + transmitSerialNumber + "' and transmitChunkedNumber " + operator + transmitChunkedNumber);
                    break block15;
                }
                throw new Exception("unsuported transmitChunkedNumber : " + transmitChunkedNumber);
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
            finally {
                SQLUtil.cleanup(stm);
                SQLUtil.cleanup(delStm);
            }
        }
    }

    @Override
    public void close() throws Exception {
        SQLUtil.cleanup(this.insertReadBillDataIDStm);
        SQLUtil.cleanup(this.updateIDStatusStm);
        SQLUtil.cleanup(this.readingStatement);
        SQLUtils.cleanup((Connection)this.connection);
    }

    @Override
    public void clear() {
        this.sendDataRows = null;
        this.dataModel = null;
    }

    @Override
    public void recover(Map param) throws Exception {
    }

    public static String translateSQL(Connection conn, String ksql) throws Exception {
        String sql = "";
        try {
            if (!(conn instanceof KDConnection)) {
                int dbType = 0;
                if (DBUtil.isOracle((Connection)conn)) {
                    dbType = 2;
                } else if (DBUtil.isDB2((Connection)conn)) {
                    dbType = 1;
                } else if (DBUtil.isMSSQL((Connection)conn)) {
                    dbType = 3;
                }
                sql = TransUtil.Translate((String)ksql, (int)dbType);
            } else {
                sql = ksql;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        return sql;
    }

    public String getAgentSQL() {
        String sql = null;
        EntityViewInfo view = new EntityViewInfo();
        try {
            Iterator it;
            String headId = this.baseDataSynInfo.getParent().getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)headId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("agent.id", (Object)this.agentId, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            view.setFilter(filter);
            BaseDataSynSpecialSQLCollection coll = BaseDataSynSpecialSQLFactory.getLocalInstance(this.ctx).getBaseDataSynSpecialSQLCollection(view);
            if (coll.size() > 0 && (it = coll.iterator()).hasNext()) {
                BaseDataSynSpecialSQLInfo specialSQL = (BaseDataSynSpecialSQLInfo)it.next();
                sql = specialSQL.getSql();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"EIP,\u6267\u884cgetAgentSQL\u65b9\u6cd5\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        return sql;
    }

    public String getConnectionSQL() {
        String sql = null;
        EntityViewInfo view = new EntityViewInfo();
        try {
            Iterator it;
            BaseDataSynSpecialSQLCollection coll;
            String headId = this.baseDataSynInfo.getParent().getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)headId, CompareType.EQUALS));
            BaseDataDownMonitorLogInfo logInfo = (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
            if (logInfo != null && !StringUtils.isEmpty((String)logInfo.getExtendedProperty("wsserviceId"))) {
                filter.getFilterItems().add(new FilterItemInfo("wsservice.id", (Object)this.agentId, CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("connnection.id", (Object)this.agentId, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("agent.id", (Object)this.agentId, CompareType.EQUALS));
            }
            filter.setMaskString("#0 and (#1 or #2)");
            view.setFilter(filter);
            if (this.ctx == null) {
                this.ctx = BaseDataResourceholder.getContext();
            }
            if ((coll = BaseDataSynSpecialSQLFactory.getLocalInstance(this.ctx).getBaseDataSynSpecialSQLCollection(view)).size() > 0 && (it = coll.iterator()).hasNext()) {
                BaseDataSynSpecialSQLInfo specialSQL = (BaseDataSynSpecialSQLInfo)it.next();
                sql = specialSQL.getSql();
            }
        }
        catch (BOSException e) {
            logger.error((Object)("EIP:do specialSQL fail![baseDataSynId:" + this.baseDataSynInfo.getParent().getId().toString() + ""));
        }
        return sql;
    }

    @Override
    public String getQueryString(String tableName) {
        return this.queryString;
    }

    @Override
    public List<FlatData.FlatDataRow> getFlatDataRows() {
        return this.flatDataRows;
    }

    @Override
    public String getQueryString4Change(String tableName) {
        return this.queryString;
    }

    @Override
    public StructuredDataModel getDataModel() {
        return this.dataModel;
    }

    public void fixChangeTime(String tableName, List<Object> idList, String agentId, String changetime) throws Exception {
        Connection con = null;
        PreparedStatement preStatement = null;
        try {
            con = DBUtils.getConnection(this.ctx);
            preStatement = con.prepareStatement("update " + tableName.replace("\"", "") + " set changetime =  ?  where agentid = ? and headpk = ?");
            for (int i = 0; i < idList.size(); ++i) {
                preStatement.setObject(1, changetime);
                preStatement.setObject(2, agentId);
                preStatement.setObject(3, idList.get(i));
                preStatement.addBatch();
            }
            preStatement.executeBatch();
            con.commit();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStatement, (Connection)con);
    }

    @Override
    public FlatDataModel getFlatDataModel() {
        return this.flatDataModel;
    }

    @Override
    public void setFlatDataModel(FlatDataModel flatDataModel) {
        this.flatDataModel = flatDataModel;
    }
}

