/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.csinterface.agent.base.Encoding;
import com.kingdee.eas.csinterface.agent.base.ResultInfo;
import com.kingdee.eas.csinterface.agent.service.json.JSONException;
import com.kingdee.eas.csinterface.agent.service.json.JSONObject;
import com.kingdee.eas.csinterface.agent.service.work.basedata.BillDataStatus;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.DataRow;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.process.impl.BaseDataSynConvertFilter;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.BaseDataBatchInsertHelper;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.BaseDataBatchUpdateHelper;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.BaseDataSaver;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataRunner;
import com.kingdee.eas.csinterface.agent.servlet.PacketsEncoder;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.EIPConfiguration;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BaseDataSynSender {
    private static Logger logger = Logger.getLogger(BaseDataSynSender.class);
    protected BaseDataRunner baseDataThread;
    protected String transmitSequenceNumber;
    protected ConcurrentHashMap<String, List<Object>> chunkedWaitAckIDs;
    protected StructuredDataModel dataModel;
    static long timeout = 5L;
    private String charset = "UTF-8";
    static int count = 0;
    int transmitCount;
    protected Context ctx;
    protected int transmitChunkedNumber;
    Integer chunkedIndex = 0;
    protected String encryptKey;
    protected Encoding encoding;
    protected HttpServletResponse response;
    protected Map<String, String> resultMap;
    protected String connectionId;

    public Map<String, String> getResultMap() {
        return this.resultMap;
    }

    public BaseDataSynSender(HttpServletResponse response, String entrykey, Encoding encoding, BaseDataRunner baseDataThread, String transmitSerialNumber, int transmitChunkedNumber) {
        this.response = response;
        this.encryptKey = entrykey;
        this.encoding = encoding;
        this.baseDataThread = baseDataThread;
        this.transmitSequenceNumber = transmitSerialNumber;
        this.transmitChunkedNumber = transmitChunkedNumber;
        this.chunkedWaitAckIDs = new ConcurrentHashMap();
        this.dataModel = baseDataThread.dataModel;
        this.ctx = baseDataThread.getContext();
    }

    public BaseDataSynSender(BaseDataRunner baseDataThread, Map<String, String> resultMap, String connectionId) {
        this.response = this.response;
        this.encryptKey = this.encryptKey;
        this.encoding = this.encoding;
        this.baseDataThread = baseDataThread;
        this.transmitSequenceNumber = "-1";
        this.transmitChunkedNumber = -1;
        this.chunkedWaitAckIDs = new ConcurrentHashMap();
        this.dataModel = baseDataThread.dataModel;
        this.ctx = baseDataThread.getContext();
        this.resultMap = resultMap;
        this.connectionId = connectionId;
    }

    public String send() throws Exception {
        ResultInfo resultInfo = null;
        JSONObject json = new JSONObject();
        try {
            LinkedList idList = new LinkedList();
            ArrayList<Map<String, Object>> billDataList = null;
            JSONObject mappingJson = new JSONObject();
            LinkedList<Map<String, Object>> entryRowJSONList = new LinkedList<Map<String, Object>>();
            for (DataRow dataRow : this.baseDataThread.bufferDataProvider.getSendDataRows()) {
                if (billDataList == null) {
                    billDataList = new ArrayList<Map<String, Object>>();
                }
                try {
                    this.wrapJsonData(billDataList, dataRow, entryRowJSONList);
                }
                catch (JSONException e) {
                    throw new IOException("send error by JSONException : " + e.getMessage());
                }
                idList.add(dataRow.getValues().get(dataRow.pkColumn));
            }
            this.chunkedWaitAckIDs.put(this.transmitSequenceNumber, idList);
            resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
            this.baseDataThread.bufferDataProvider.open(this.ctx);
            this.baseDataThread.bufferDataProvider.feedback(this.transmitChunkedNumber, this.transmitSequenceNumber, BillDataStatus.waitAck, false);
            this.chunkedWaitAckIDs.remove(this.transmitSequenceNumber);
            mappingJson.put("transmitSerialNumber", this.transmitSequenceNumber);
            mappingJson.put("entrys", entryRowJSONList);
            mappingJson.put("colType", this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
            resultInfo.setData(mappingJson.toString());
            resultInfo.setTableName(this.baseDataThread.baseDataSynInfo.getTableName());
            json = new JSONObject(resultInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            resultInfo = (ResultInfo)ResultInfo.STATUS_ERROR.clone();
            resultInfo.setStatusMsg(e.getMessage());
            json = new JSONObject(resultInfo);
        }
        return json.toString();
    }

    public boolean sendJDBC() throws Exception {
        try {
            BaseDataSynConvertFilter filter = new BaseDataSynConvertFilter(this.ctx, this.dataModel);
            filter.doFilter(this.baseDataThread.bufferDataProvider.getSendDataRows());
            LinkedList<Object> idList = new LinkedList<Object>();
            ArrayList<Map<String, Object>> billDataList = null;
            LinkedList<Map<String, Object>> entryRowJSONList = new LinkedList<Map<String, Object>>();
            for (DataRow dataRow : this.baseDataThread.bufferDataProvider.getSendDataRows()) {
                if (billDataList == null) {
                    billDataList = new ArrayList<Map<String, Object>>();
                }
                try {
                    this.wrapJsonData(billDataList, dataRow, entryRowJSONList);
                }
                catch (JSONException e) {
                    throw new IOException("send error by JSONException : " + e.getMessage());
                }
                idList.add(dataRow.getValues().get(dataRow.pkColumn));
            }
            this.insertIntoDescDB(entryRowJSONList);
            this.chunkedWaitAckIDs.put(this.transmitSequenceNumber, idList);
            this.baseDataThread.bufferDataProvider.open(this.ctx);
            this.baseDataThread.bufferDataProvider.feedback(this.transmitChunkedNumber, idList, this.connectionId, BillDataStatus.ack, false);
            this.chunkedWaitAckIDs.remove(this.transmitSequenceNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                this.baseDataThread.bufferDataProvider.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean sendUpdateJDBC() throws Exception {
        try {
            BaseDataSynConvertFilter filter = new BaseDataSynConvertFilter(this.ctx, this.dataModel);
            filter.doFilter(this.baseDataThread.bufferDataProvider.getSendDataRows());
            LinkedList idList = new LinkedList();
            ArrayList<Map<String, Object>> billDataList = null;
            LinkedList<Map<String, Object>> entryRowJSONList = new LinkedList<Map<String, Object>>();
            for (DataRow dataRow : this.baseDataThread.bufferDataProvider.getSendDataRows()) {
                if (billDataList == null) {
                    billDataList = new ArrayList<Map<String, Object>>();
                }
                try {
                    this.wrapJsonData4Change(billDataList, dataRow, entryRowJSONList);
                }
                catch (JSONException e) {
                    throw new IOException("send error by JSONException : " + e.getMessage());
                }
                idList.add(dataRow.getValues().get(dataRow.pkColumn));
            }
            this.updateIntoDescDB(entryRowJSONList);
            this.chunkedWaitAckIDs.put(this.transmitSequenceNumber, idList);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private void insertIntoDescDB(List<Map<String, Object>> dataList) throws Exception {
        StructuredDataModel.TableModel entryModel = this.baseDataThread.dataModel.getPriorityTables()[1];
        StructuredDataModel.TableModel newModel = this.baseDataThread.dataModel.getPriorityTables()[2];
        Object[] entryColumnModels = entryModel.columns;
        Object[] newColumnModels = newModel.columns;
        List colNameList = Arrays.asList((Object[])ArrayUtils.addAll((Object[])entryColumnModels, (Object[])newColumnModels));
        String tableName = this.baseDataThread.baseDataSynInfo.getDestTableName();
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = this.baseDataThread.baseDataSynInfo.getTableName();
        }
        BaseDataBatchInsertHelper.prepare(tableName, colNameList);
        BaseDataBatchInsertHelper insertHelper = BaseDataBatchInsertHelper.getInstance();
        BaseDataSynHeadInfo headInfo = BaseDataSynHeadFactory.getLocalInstance(this.ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(this.baseDataThread.baseDataSynInfo.getParent().getId().toString()));
        String connectionId = MonitorManager.getCurrent().getExtendedProperty("connId");
        ConnectionInfo connection = ConnectionFactory.getLocalInstance(this.ctx).getConnectionInfo(CommonUtil.convert2PK(connectionId));
        BaseDataSaver saver = new BaseDataSaver(connection);
        long beginInsertTime = System.currentTimeMillis();
        StringBuffer execMsg = new StringBuffer();
        try {
            saver.insertByNativeJDBCBatch(dataList, tableName, colNameList, insertHelper, this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
            boolean flag = false;
            boolean bl = flag = this.baseDataThread.baseDataSynInfo.isMainTable() || EIPConfiguration.Instance().isBigDataEntryTable(tableName);
            if (saver.getexistIdSet() != null && saver.getexistIdSet().size() > 0) {
                this.fixChangeTime(this.baseDataThread.baseDataSynInfo.getPkTableName(), saver.getexistIdSet(), connectionId, flag);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            long endInsertTime = System.currentTimeMillis();
            execMsg.append("\u63d2\u5165\u76ee\u6807\u6570\u636e\u5e93\u8017\u65f6\uff1a" + (endInsertTime - beginInsertTime) + "ms \r");
            SubMonitorLogFactory.getLocalInstance(this.ctx).addLogWithoutTrans(saver, tableName, "add", this.baseDataThread.baseDataSynInfo.isMainTable(), headInfo.getNumber());
            long subLogTime = System.currentTimeMillis();
            execMsg.append("\u8bb0\u5f55\u5b50\u65e5\u5fd7\u8017\u65f6\uff1a" + (subLogTime - endInsertTime) + "ms \r");
            ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo(execMsg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIntoDescDB(List<Map<String, Object>> dataList) throws Exception {
        StructuredDataModel.TableModel headModel = this.baseDataThread.dataModel.getPriorityTables()[0];
        ColumnModel[] entryColumnModels = headModel.columns;
        ArrayList<String> colList = new ArrayList<String>();
        for (ColumnModel column : entryColumnModels) {
            String columnName = column.destName;
            if (StringUtils.isEmpty((String)columnName)) {
                columnName = column.name;
            }
            colList.add(columnName);
        }
        String connectionId = MonitorManager.getCurrent().getExtendedProperty("connId");
        ConnectionInfo connection = ConnectionFactory.getLocalInstance(this.ctx).getConnectionInfo(CommonUtil.convert2PK(connectionId));
        String tableName = this.baseDataThread.baseDataSynInfo.getDestTableName();
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = this.baseDataThread.baseDataSynInfo.getTableName();
        }
        BaseDataBatchUpdateHelper.prepare(tableName, colList, "-1");
        BaseDataBatchUpdateHelper updateHelp = BaseDataBatchUpdateHelper.getInstance();
        BaseDataSynHeadInfo headInfo = BaseDataSynHeadFactory.getLocalInstance(this.ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(this.baseDataThread.baseDataSynInfo.getParent().getId().toString()));
        long beginUpdateTime = System.currentTimeMillis();
        BaseDataSaver saver = new BaseDataSaver(connection);
        saver.updateByNativeJDBCBatch(dataList, tableName, colList, updateHelp, this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
        long endUpdateTime = System.currentTimeMillis();
        try {
            this.baseDataThread.bufferDataProvider.open(this.ctx);
            this.baseDataThread.bufferDataProvider.feedbackChangeForJDBC(this.baseDataThread.bufferDataProvider.getReadBillBase(), connectionId, "-1", -1, BillDataStatus.ack);
        }
        finally {
            SubMonitorLogFactory.getLocalInstance(this.ctx).addLogWithoutTrans(saver, tableName, "update", this.baseDataThread.baseDataSynInfo.isMainTable(), headInfo.getNumber());
            StringBuffer execMsg = new StringBuffer();
            execMsg.append("\u66f4\u65b0\u76ee\u6807\u6570\u636e\u5e93\u8017\u65f6\uff1a" + (endUpdateTime - beginUpdateTime) + "ms \r");
            ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo(execMsg.toString());
            long subLogTime = System.currentTimeMillis();
            execMsg.append("\u8bb0\u5f55\u5b50\u65e5\u5fd7\u8017\u65f6\uff1a" + (subLogTime - endUpdateTime) + "ms \r");
        }
    }

    private void setResult2Map(BaseDataSaver saver) {
        String hasSuccess = this.resultMap.get("success");
        String hasExist = this.resultMap.get("exist");
        String hasFailure = this.resultMap.get("failure");
        String success = saver.getSuccessNumber();
        String exist = saver.getExistNumber();
        String failure = saver.getFailureNumber();
        StringBuffer successBuffer = new StringBuffer(1000);
        StringBuffer existBuffer = new StringBuffer(1000);
        StringBuffer failureBuffer = new StringBuffer(1000);
        if (StringUtils.isNotEmpty((String)hasSuccess)) {
            successBuffer.append(hasSuccess).append(",").append(success);
        } else {
            successBuffer.append(success);
        }
        if (StringUtils.isNotEmpty((String)hasExist)) {
            existBuffer.append(hasExist).append(",").append(exist);
        } else {
            existBuffer.append(exist);
        }
        if (StringUtils.isNotEmpty((String)hasFailure)) {
            failureBuffer.append(hasFailure).append(",").append(failure);
        } else {
            failureBuffer.append(failure);
        }
        this.resultMap.put("success", successBuffer.toString());
        this.resultMap.put("exist", existBuffer.toString());
        this.resultMap.put("failure", failureBuffer.toString());
    }

    public Map<String, String> getColumnTypes(BaseDataSynTableInfo tableInfo) throws Exception {
        HashMap<String, String> colType = new HashMap<String, String>();
        String tableName = tableInfo.getTableName();
        String headId = tableInfo.getParent().getId().toString();
        BaseDataSynColumnCollection coll = BaseDataSynColumnFactory.getLocalInstance(this.ctx).getBaseDataSynColumnCollection("where parent='" + headId + "' and tableName='" + tableName + "'");
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            BaseDataSynColumnInfo info = (BaseDataSynColumnInfo)it.next();
            String key = info.getDestColName();
            String type = info.getDestColDataType();
            if (StringUtils.isEmpty((String)key)) {
                key = info.getColName();
                type = info.getColDataType();
            }
            colType.put(key.toUpperCase(), type.toUpperCase());
        }
        return colType;
    }

    public String send4Change() throws Exception {
        ResultInfo resultInfo = null;
        JSONObject json = new JSONObject();
        try {
            LinkedList idList = new LinkedList();
            ArrayList<Map<String, Object>> billDataList = null;
            JSONObject mappingJson = new JSONObject();
            LinkedList<Map<String, Object>> entryRowJSONList = new LinkedList<Map<String, Object>>();
            for (DataRow dataRow : this.baseDataThread.bufferDataProvider.getSendDataRows()) {
                if (billDataList == null) {
                    billDataList = new ArrayList<Map<String, Object>>();
                }
                try {
                    this.wrapJsonData(billDataList, dataRow, entryRowJSONList);
                }
                catch (JSONException e) {
                    throw new IOException("send error by JSONException : " + e.getMessage());
                }
                idList.add(dataRow.getValues().get(dataRow.pkColumn));
            }
            this.chunkedWaitAckIDs.put(this.transmitSequenceNumber, idList);
            resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
            this.baseDataThread.bufferDataProvider.open(this.ctx);
            this.baseDataThread.bufferDataProvider.feedback4Change(this.transmitChunkedNumber, this.transmitSequenceNumber, BillDataStatus.waitAck, false, this.ctx);
            this.chunkedWaitAckIDs.remove(this.transmitSequenceNumber);
            mappingJson.put("transmitSerialNumber", this.transmitSequenceNumber);
            mappingJson.put("entrys", entryRowJSONList);
            mappingJson.put("colType", this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
            resultInfo.setData(mappingJson.toString());
            resultInfo.setTableName(this.baseDataThread.baseDataSynInfo.getTableName());
            json = new JSONObject(resultInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            resultInfo = (ResultInfo)ResultInfo.STATUS_ERROR.clone();
            resultInfo.setStatusMsg(e.getMessage());
            json = new JSONObject(resultInfo);
        }
        return json.toString();
    }

    public String sendPackage(HttpServletResponse response, int begin, int pageSize) throws Exception {
        ResultInfo resultInfo = null;
        JSONObject json = new JSONObject();
        try {
            LinkedList idList = new LinkedList();
            ArrayList<Map<String, Object>> billDataList = null;
            HashMap<String, Object> mappingJson = new HashMap<String, Object>();
            LinkedList<Map<String, Object>> entryRowJSONList = new LinkedList<Map<String, Object>>();
            List<DataRow> rows = this.baseDataThread.bufferDataProvider.getSendDataRows();
            pageSize = pageSize > rows.size() ? rows.size() : pageSize;
            List<DataRow> subList = rows.subList(begin, pageSize);
            for (DataRow dataRow : subList) {
                if (billDataList == null) {
                    billDataList = new ArrayList<Map<String, Object>>();
                }
                try {
                    this.wrapJsonData(billDataList, dataRow, entryRowJSONList);
                }
                catch (JSONException e) {
                    throw new IOException("send error by JSONException : " + e.getMessage());
                }
                idList.add(dataRow.getValues().get(dataRow.pkColumn));
            }
            this.chunkedWaitAckIDs.put(this.transmitSequenceNumber, idList);
            resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
            this.baseDataThread.bufferDataProvider.open(this.ctx);
            this.baseDataThread.bufferDataProvider.feedback(this.chunkedWaitAckIDs.get(this.transmitSequenceNumber), this.transmitSequenceNumber, this.transmitChunkedNumber, BillDataStatus.waitAck);
            this.chunkedWaitAckIDs.remove(this.transmitSequenceNumber);
            mappingJson.put("transmitSerialNumber", this.transmitSequenceNumber);
            mappingJson.put("entrys", entryRowJSONList);
            resultInfo.setData(mappingJson);
            json = new JSONObject(resultInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (json.toString() != null) {
            byte[] responseBody = PacketsEncoder.encodeOuputStream(json.toString().getBytes(this.charset), this.encryptKey, "GZIP_AND_ENCRYPT");
            response.getOutputStream().write(responseBody);
            response.getOutputStream().flush();
            response.flushBuffer();
        }
        return null;
    }

    public String send1() throws Exception {
        int chunkedBillCount = 0;
        LinkedList idList = new LinkedList();
        ResultInfo resultInfo = null;
        JSONObject json = new JSONObject();
        HashMap<String, Object> mappingJson = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> billDataList = null;
        LinkedList<Map<String, Object>> entryRowJSONList = new LinkedList<Map<String, Object>>();
        while (true) {
            DataRow dataRow;
            try {
                dataRow = this.baseDataThread.bufferedQueue.take();
            }
            catch (InterruptedException e) {
                logger.info((Object)"Send Thread is Interrupted");
                dataRow = null;
            }
            if (dataRow == null) {
                this.chunkedWaitAckIDs.put(this.chunkedIndex.toString(), idList);
                if (billDataList != null && billDataList.size() > 0) {
                    this.sendChunked((OutputStream)this.response.getOutputStream(), entryRowJSONList);
                }
                return null;
            }
            ++count;
            ++chunkedBillCount;
            if (billDataList == null) {
                billDataList = new ArrayList<Map<String, Object>>();
            }
            try {
                this.wrapJsonData(billDataList, dataRow, entryRowJSONList);
            }
            catch (JSONException e) {
                throw new IOException("send error by JSONException : " + e.getMessage());
            }
            idList.add(dataRow.getValues().get(dataRow.pkColumn));
            if (chunkedBillCount >= BaseDataRunner.TRANSMIT_BILL_COUNT) {
                this.chunkedWaitAckIDs.put(this.transmitSequenceNumber, idList);
                this.writeStatusBack();
                this.sendChunked((OutputStream)this.response.getOutputStream(), entryRowJSONList);
                this.response.flushBuffer();
                Integer n = this.chunkedIndex;
                Integer n2 = this.chunkedIndex = Integer.valueOf(this.chunkedIndex + 1);
                idList = new LinkedList();
                billDataList = new ArrayList();
                chunkedBillCount = 0;
                mappingJson.put("transmitSerialNumber", this.transmitSequenceNumber);
                mappingJson.put("entrys", entryRowJSONList);
                resultInfo.setData(mappingJson);
                json = new JSONObject(resultInfo);
                return json.toString();
            }
            if (count % 499 != 1 || !logger.isDebugEnabled()) continue;
            logger.debug((Object)("\u5171\u6d88\u8d39\u4e86\uff1a" + count + "\u6761"));
        }
    }

    private void writeStatusBack() throws Exception {
        this.baseDataThread.bufferDataProvider.open(this.ctx);
        this.baseDataThread.bufferDataProvider.feedback(this.chunkedWaitAckIDs.get(this.transmitSequenceNumber), this.transmitSequenceNumber, this.transmitChunkedNumber, BillDataStatus.waitAck);
    }

    private void sendChunked(OutputStream out, List<Map<String, Object>> billDataList) throws IOException {
        try {
            byte[] toSendData;
            JSONArray billDataJSON = new JSONArray(billDataList);
            String billDataJSONString = billDataJSON.toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u53d1\u9001chunked\u6570\u636e\uff1a" + billDataJSONString));
            }
            try {
                toSendData = billDataJSONString.getBytes(this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("send error by UnsupportedEncodingException : " + e.getMessage());
            }
            toSendData = PacketsEncoder.encodeOuputStream(toSendData, this.encryptKey, this.encoding);
            out.write(toSendData);
            out.flush();
        }
        catch (IOException e) {
            if (e.getMessage() != null && e.getMessage().indexOf("Software caused connection abort") != -1) {
                this.baseDataThread.shouldAbortSend.set(true);
                logger.error((Object)"send data error, may be cause by server error, send task will abort!", (Throwable)e);
            } else {
                logger.error((Object)"send bill data error", (Throwable)e);
            }
            throw e;
        }
    }

    protected void wrapJsonData(List<Map<String, Object>> billDataList, DataRow dataRow, List<Map<String, Object>> entryRowJSONList) throws JSONException {
        String destName;
        Object columnVal;
        String key;
        StructuredDataModel.TableModel entryModel = this.baseDataThread.dataModel.getPriorityTables()[1];
        StructuredDataModel.TableModel newModel = this.baseDataThread.dataModel.getPriorityTables()[2];
        HashMap entryRowJSON = new HashMap();
        HashMap newRowJSON = new HashMap();
        Map data = dataRow.getValues();
        ColumnModel[] entryColumnModels = entryModel.columns;
        ColumnModel[] newColumnModels = newModel.columns;
        for (ColumnModel entryColumnModel : entryColumnModels) {
            key = entryColumnModel.name;
            if (StringUtils.isEmpty((String)key)) {
                key = entryColumnModel.destName;
            }
            columnVal = data.get(key);
            destName = entryColumnModel.destName;
            if (StringUtils.isEmpty((String)destName)) {
                destName = entryColumnModel.name;
            }
            entryRowJSON.put(destName, columnVal);
        }
        for (ColumnModel newColumnModel : newColumnModels) {
            key = newColumnModel.name;
            if (StringUtils.isEmpty((String)key)) {
                key = newColumnModel.destName;
            }
            columnVal = data.get(key);
            destName = newColumnModel.destName;
            if (StringUtils.isEmpty((String)destName)) {
                destName = newColumnModel.name;
            }
            entryRowJSON.put(destName, columnVal);
        }
        entryRowJSONList.add(entryRowJSON);
    }

    protected void wrapJsonData4Change(List<Map<String, Object>> billDataList, DataRow dataRow, List<Map<String, Object>> entryRowJSONList) throws JSONException {
        String destName;
        Object columnVal;
        String key;
        StructuredDataModel.TableModel headModel = this.baseDataThread.dataModel.getPriorityTables()[0];
        StructuredDataModel.TableModel entryModel = this.baseDataThread.dataModel.getPriorityTables()[1];
        StructuredDataModel.TableModel newModel = this.baseDataThread.dataModel.getPriorityTables()[2];
        HashMap headRowJSON = new HashMap();
        HashMap entryRowJSON = new HashMap();
        Map data = dataRow.getValues();
        ColumnModel[] entryColumnModels = headModel.columns;
        ColumnModel[] newColumnModels = newModel.columns;
        for (ColumnModel entryColumnModel : entryColumnModels) {
            key = entryColumnModel.name;
            if (StringUtils.isEmpty((String)key)) {
                key = entryColumnModel.destName;
            }
            columnVal = data.get(key);
            destName = entryColumnModel.destName;
            if (StringUtils.isEmpty((String)destName)) {
                destName = entryColumnModel.name;
            }
            entryRowJSON.put(destName, columnVal);
        }
        for (ColumnModel newColumnModel : newColumnModels) {
            key = newColumnModel.name;
            if (StringUtils.isEmpty((String)key)) {
                key = newColumnModel.destName;
            }
            columnVal = data.get(key);
            destName = newColumnModel.destName;
            if (StringUtils.isEmpty((String)destName)) {
                destName = newColumnModel.name;
            }
            entryRowJSON.put(destName, columnVal);
        }
        entryRowJSONList.add(entryRowJSON);
    }

    public void fixChangeTime(String tableName, Set<String> idLset, String agentId, boolean ismainTable) throws Exception {
        Connection con = null;
        PreparedStatement preStatement = null;
        try {
            con = DBUtils.getConnection(this.ctx);
            if (ismainTable) {
                preStatement = con.prepareStatement("update " + tableName.replace("\"", "") + " set changetime =  ?  where agentid = ? and headpk = ?");
                Iterator<String> it = idLset.iterator();
                while (it.hasNext()) {
                    String str = it.next().toString();
                    preStatement.setTimestamp(1, Timestamp.valueOf("1900-01-01 00:00:00"));
                    preStatement.setObject(2, agentId);
                    preStatement.setString(3, str);
                    preStatement.addBatch();
                }
            } else {
                preStatement = con.prepareStatement("update " + tableName.replace("\"", "") + " set HASHCODE =  ?  where agentid = ? and headpk = ?");
                Iterator<String> it = idLset.iterator();
                while (it.hasNext()) {
                    String str = it.next().toString();
                    preStatement.setString(1, "0");
                    preStatement.setObject(2, agentId);
                    preStatement.setString(3, str);
                    preStatement.addBatch();
                }
            }
            preStatement.executeBatch();
            if (ismainTable) {
                MonitorManager.getCurrent().setExtendedProperty("isUpdate", "1");
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStatement, (Connection)con);
    }
}

