/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet;

import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.csinterface.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletHelper {
    public static void sendRsp(HttpServletRequest req, HttpServletResponse rsp, String rspMessage) throws ServletException, IOException {
        rsp.getOutputStream().println(rspMessage);
    }

    public static String getReqContent(HttpServletRequest request) throws Exception {
        ServletInputStream inputStream = request.getInputStream();
        String content = IOUtils.readFully((InputStream)inputStream, "UTF-8");
        return content;
    }

    public static String getValue(JSONObject jsonObject, String key, String defaultValue) throws Exception {
        String value = ServletHelper.getValue(jsonObject, key);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public static String getValue(JSONObject jsonObject, String key) throws Exception {
        String value = null;
        Object object = jsonObject.opt(key);
        if (object != null && object instanceof String) {
            value = (String)object;
        }
        return value;
    }

    public static String getValueNotNull(JSONObject jsonObject, String key) throws Exception {
        return jsonObject.getString(key);
    }

    public static String getParameterValue(HttpServletRequest request, String paraName) {
        return request.getParameter(paraName);
    }

    public static String getParameterValueNullAsBlank(HttpServletRequest request, String paraName) {
        return ServletHelper.getParameterValue(request, paraName, "");
    }

    public static String getParameterValue(HttpServletRequest request, String paraName, String defaultValue) {
        String value = ServletHelper.getParameterValue(request, paraName);
        return null == value ? defaultValue : value;
    }
}

