/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet.processor;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.bos.webservice.WSConfig;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.csinterface.agent.EipUserCollection;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.IEipUser;
import com.kingdee.eas.csinterface.agent.base.ResultInfo;
import com.kingdee.eas.csinterface.agent.servlet.RequestProcessor;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.base.cache.SessionUtil;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoginServlet
extends RequestProcessor {
    private static final long serialVersionUID = 5407133815057315564L;
    private static final Logger logger = Logger.getLogger(LoginServlet.class);
    public static boolean ALL_HASH_UPDATE = false;

    @Override
    public String getTargetURI() {
        return "/user/login";
    }

    @Override
    public String process(Map<String, String> params, String reqContent) throws Exception {
        JSONObject result = new JSONObject();
        JSONObject reqJSONObject = JSONObject.parseObject((String)reqContent);
        String tokenId = this.getLoginSession(reqContent);
        Context context = SessionUtil.getContextByToken(tokenId);
        String bDValue = reqJSONObject.getString("isBaseData");
        boolean isBaseData = StringUtils.equals((String)bDValue, (String)"1");
        try {
            EIPLicenseCheckUtil.checkLicenseEnough((Context)context);
        }
        catch (Exception e) {
            this.response.setStatus(403);
            return e.getMessage();
        }
        UserInfo userInfo = null;
        try {
            String status = null != tokenId ? ResultInfo.STATUS_SUCCESS.getStatus() : ResultInfo.STATUS_ERROR.getStatus();
            result.put("status", (Object)status);
            result.put("sessionId", (Object)("" + tokenId));
            userInfo = this.selectUserInfoIntoEipUser(context, reqJSONObject);
            result.put("userId", (Object)userInfo.getId().toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
            result.put("status", (Object)"error");
            if (e.getCause() != null && e.getCause() instanceof UserException) {
                result.put("statusMsg", (Object)e.getCause().getMessage());
            }
            result.put("statusMsg", (Object)ThrowableHelper.toString(e));
        }
        result.put("agentId", context.get((Object)"eipUserId"));
        context.put((Object)"agentId", context.get((Object)"eipUserId"));
        return result.toString();
    }

    private String getLoginSession(String reqContent) throws Exception {
        JSONObject reqJSONObject = JSONObject.parseObject((String)reqContent);
        String userName = reqJSONObject.getString("username");
        String password = reqJSONObject.getString("password");
        String dcName = reqJSONObject.getString("dcName");
        String dbType = reqJSONObject.getString("dbType");
        String slnName = reqJSONObject.getString("slnName");
        String slnNameStr = slnName == null ? "eas" : slnName.toString();
        String language = reqJSONObject.getString("language");
        String languageStr = language == null ? "l2" : language.toString();
        String authPattern = reqJSONObject.getString("authPattern");
        String authPatternStr = authPattern == null ? "BaseDB" : authPattern.toString();
        return SessionUtil.getTokenId(userName, password, dcName, languageStr, slnNameStr, authPatternStr);
    }

    private String encodePassword(String userName, String password) throws BOSException {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (CryptException e) {
            logger.error((Object)e);
        }
        if (StringUtils.isEmpty((String)encodedPassword)) {
            throw new BOSException("\u52a0\u5bc6\u5bc6\u7801\u5931\u8d25\uff01\u5bc6\u7801\u4e0d\u80fd\u8bbe\u5b9a\u4e3a\u7a7a\u5b57\u7b26\u4e32\u3002");
        }
        return encodedPassword;
    }

    private ILoginModule getLoginModule(String url) throws BOSException {
        if (WSConfig.getRomoteLocate() == null || WSConfig.getRomoteLocate().equals("true")) {
            return LoginModuleFactory.getRemoteInstance((String)url);
        }
        return LoginModuleFactory.getLocalInstance(null);
    }

    private String getDbType(char dbType) {
        switch (dbType) {
            case '0': {
                return "MS SQL Server";
            }
            case '1': {
                return "DB2 UDB";
            }
            case '2': {
                return "Oracle";
            }
        }
        return "MS SQL Server";
    }

    private EipUserInfo getEipUserInfo(Context context, JSONObject reqJSONObject) throws Exception {
        IEipUser eipUser = EipUserFactory.getLocalInstance(context);
        EipUserInfo eipUserInfo = null;
        UserInfo userInfo = null;
        for (Object obj : context.getUserDefineFieldKeySet()) {
            if (!(context.get(obj) instanceof UserInfo)) continue;
            userInfo = (UserInfo)context.get(obj);
        }
        try {
            String dBIP = reqJSONObject.getString("dbIP");
            String dBPort = reqJSONObject.getString("dbPort");
            String dbType = reqJSONObject.getString("srcDBType");
            String dbName = reqJSONObject.getString("srcDBName");
            EipUserCollection coll = null;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (userInfo == null) {
                throw new NullPointerException();
            }
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)userInfo.getNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("dBIP", (Object)dBIP, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("dBPort", (Object)dBPort, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("dbName", (Object)dbName, CompareType.EQUALS));
            ev.setFilter(filter);
            coll = eipUser.getEipUserCollection(ev);
            if (coll.size() == 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)userInfo.getNumber(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("dBIP", null, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("dBPort", null, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("dbName", null, CompareType.EQUALS));
                ev.setFilter(filter);
                coll = eipUser.getEipUserCollection(ev);
            }
            if (coll.size() > 0) {
                eipUserInfo = coll.get(0);
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return eipUserInfo;
    }

    private UserInfo selectUserInfoIntoEipUser(Context context, JSONObject reqJSONObject) throws Exception {
        long now = new Date().getTime();
        IUser userBizUnit = UserFactory.getLocalInstance((Context)context);
        IEipUser eipUser = EipUserFactory.getLocalInstance(context);
        UserInfo userInfo = userBizUnit.getUserByID(context.getCaller());
        EipUserInfo eipUserInfo = this.getEipUserInfo(context, reqJSONObject);
        if (eipUserInfo == null) {
            eipUserInfo = new EipUserInfo();
            eipUserInfo.setNumber(userInfo.getNumber());
            eipUserInfo.setType(userInfo.getType().getAlias());
            eipUserInfo.setName(userInfo.getName());
            eipUserInfo.setOrgUnitName(userInfo.getCU().getName());
            eipUserInfo.setFirstLoginTime(new Timestamp(now));
            eipUserInfo.setLastLoginTime(new Timestamp(now));
            eipUserInfo.setBoolean("notFromUIClient", true);
            eipUserInfo.setDescription(userInfo.getDescription());
            eipUserInfo.setPulsInterval("180");
            eipUserInfo.setIpInfo(Uuid.randomUUID().toString());
            String dBIP = reqJSONObject.getString("dbIP");
            String dBPort = reqJSONObject.getString("dbPort");
            String dbType = reqJSONObject.getString("srcDBType");
            String dbName = reqJSONObject.getString("srcDBName");
            eipUserInfo.setDBIP(dBIP);
            eipUserInfo.setDBPort(dBPort);
            eipUserInfo.setDBType(dbType);
            eipUserInfo.setDbName(dbName);
            eipUser.addnew((CoreBaseInfo)eipUserInfo);
        } else {
            eipUserInfo.setLastLoginTime(new Timestamp(now));
            eipUserInfo.setBoolean("notFromUIClient", true);
            eipUserInfo.setDescription(userInfo.getDescription());
            String dBIP = reqJSONObject.getString("dbIP");
            String dBPort = reqJSONObject.getString("dbPort");
            String dbType = reqJSONObject.getString("srcDBType");
            String dbName = reqJSONObject.getString("srcDBName");
            eipUserInfo.setDBIP(dBIP);
            eipUserInfo.setDBPort(dBPort);
            eipUserInfo.setDBType(dbType);
            eipUserInfo.setDbName(dbName);
            eipUser.update(CommonUtil.convert2PK(eipUserInfo.getId().toString()), (CoreBaseInfo)eipUserInfo);
        }
        context.put((Object)"eipUserId", (Object)eipUserInfo.getId().toString());
        return userInfo;
    }
}

