/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet.processor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.util.TypeUtil;
import com.kingdee.eas.csinterface.agent.service.base.util.AES;
import com.kingdee.eas.csinterface.agent.servlet.RequestProcessor;
import com.kingdee.eas.csinterface.agent.servlet.openapi.model.APIReturnModel;
import com.kingdee.eas.csinterface.agent.servlet.processor.WebAPILoginServlet;
import com.kingdee.eas.csinterface.agent.util.WebUtil;
import com.kingdee.eas.csinterface.base.cache.SessionUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.app.util.ReturnDataService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebAPIMetadataServlet
extends RequestProcessor {
    private static final Logger logger = Logger.getLogger(WebAPIMetadataServlet.class);
    public static boolean ALL_HASH_UPDATE = false;
    private Context ctx = null;

    @Override
    public String getTargetURI() {
        return "/openapi/metadata";
    }

    @Override
    public String process(Map<String, String> params, String reqContent) throws Exception {
        String result = null;
        String token = this.request.getParameter("token");
        if (token == null) {
            token = params.get("token");
        }
        try {
            this.ctx = SessionUtil.getContextByToken(token);
        }
        catch (Throwable e) {
            return WebAPILoginServlet.reLogin();
        }
        this.ctx.setClientHostIP("127.0.0.1");
        String uri = this.request.getRequestURI();
        logger.info((Object)("[EIP]request URI : " + uri));
        uri = WebUtil.relative("/easportal/eip", uri);
        uri = uri.startsWith("/") ? uri : "/" + uri;
        String method = uri.replace(this.getTargetURI() + "/", "");
        String bosTypeStr = params.get("bostype");
        String execId = params.get("execid");
        BOSObjectType bosType = WebAPIMetadataServlet.decodeBosType(bosTypeStr);
        try {
            HashMap data = new HashMap();
            if ("all".equalsIgnoreCase(method)) {
                EntityObjectCollection entityCollection = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntityCollection();
                Iterator ite = entityCollection.iterator();
                EntityObjectInfo entityObj = null;
                Object name = null;
                Object alias = null;
                Object packageName = null;
                JSONObject json = new JSONObject();
                while (ite.hasNext()) {
                    entityObj = (EntityObjectInfo)ite.next();
                }
                result = ReturnDataService.format((APIReturnModel)APIReturnModel.valueOf(0, true, " ", execId, json, " "));
            } else if ("one".equalsIgnoreCase(method)) {
                EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(bosType);
                JSONObject metadata = new JSONObject();
                metadata.put("bostype", (Object)WebAPIMetadataServlet.encodeBosType(entity));
                metadata.put("name", (Object)entity.getName());
                metadata.put("alias", (Object)entity.getAlias());
                List<Map<String, Object>> dataOne = WebAPIMetadataServlet.getProperties(this.ctx, entity);
                metadata.put("fields", dataOne);
                result = ReturnDataService.format((APIReturnModel)APIReturnModel.valueOf(0, true, " ", execId, metadata, " "));
            }
        }
        catch (Exception e) {
            result = ReturnDataService.format((APIReturnModel)APIReturnModel.valueOf(-1, false, e.getMessage(), execId, new JSONObject(), ThrowableHelper.toString(e)));
        }
        return result;
    }

    private static List<Map<String, Object>> getProperties(Context ctx, EntityObjectInfo en) {
        PropertyCollection properties = en.getInheritedNoDuplicatedProperties();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(properties.size());
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo p = properties.get(i);
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("name", p.getName());
            String title = p.getAlias();
            String title2 = title == null ? p.getName() : title;
            linkedHashMap.put("alias", title2);
            Map<String, Object> d = WebAPIMetadataServlet.getDataType(ctx, p, en);
            linkedHashMap.putAll(d);
            linkedHashMap.put("primary", p.getName().equals("id"));
            linkedHashMap.put("nullable", p.isNull());
            list.add(linkedHashMap);
        }
        WebAPIMetadataServlet.sortProperties(list);
        int index = 0;
        for (Map map : list) {
            map.put("index", ++index);
        }
        return list;
    }

    private static void sortProperties(List<Map<String, Object>> list) {
        Collections.sort(list, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> a, Map<String, Object> b) {
                String ta = (String)a.get("alias");
                String tb = (String)b.get("alias");
                return ta.compareTo(tb);
            }
        });
    }

    public static Map<String, Object> getDataType(Context ctx, PropertyInfo p, EntityObjectInfo me) {
        LinkedHashMap<String, Object> data_type = new LinkedHashMap<String, Object>();
        if (p instanceof LinkPropertyInfo) {
            EntityObjectInfo supplierObject;
            RelationshipInfo rs = ((LinkPropertyInfo)p).getRelationship();
            CardinalityType type = rs.getSupplierCardinality();
            EntityObjectInfo entityObjectInfo = supplierObject = rs == null ? null : rs.getSupplierObject();
            if (type == CardinalityType.ONE || type == CardinalityType.ZERO_TO_ONE) {
                if (supplierObject != null) {
                    data_type.put("bostype", WebAPIMetadataServlet.encodeBosType(supplierObject));
                }
                data_type.put("datatype", "REF");
            } else if (supplierObject != null) {
                if (me.getFullName().equals(supplierObject.getFullName())) {
                    EntityObjectInfo clientObject = rs.getClientObject();
                    data_type.put("bostype", WebAPIMetadataServlet.encodeBosType(clientObject));
                    data_type.put("datatype", "REF");
                    data_type.put("is_master", true);
                } else {
                    data_type.put("bostype", WebAPIMetadataServlet.encodeBosType(supplierObject));
                    data_type.put("datatype", "ENTRIES");
                    data_type.put("fields", WebAPIMetadataServlet.getProperties(ctx, MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(supplierObject.getType())));
                }
            }
        } else if (p instanceof OwnPropertyInfo) {
            data_type.put("datatype", ((OwnPropertyInfo)p).getDataType().toString().toUpperCase());
            if (((OwnPropertyInfo)p).isMultilingual()) {
                data_type.put("name", p.getName());
                data_type.put("alias", p.getAlias());
                data_type.put("datatype", "MULTILANG");
                data_type.put("data_schema", "i_MultiLang");
            } else {
                DataType t = ((OwnPropertyInfo)p).getDataType();
                com.kingdee.bos.workflow.define.DataType dt = TypeUtil.convertMDataTypeToDataType((DataType)t);
                String name = dt.toString().toLowerCase();
                if (name.equals("enum")) {
                    data_type.put("datatype", "ENUM");
                    BizEnumInfo enumType = ((OwnPropertyInfo)p).getEnumType();
                    if (enumType != null) {
                        String fullName = enumType.getFullName();
                        BizEnumInfo enumInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)fullName));
                        BizEnumValueCollection values = enumInfo.getEnumValue();
                        Iterator ite = values.iterator();
                        HashMap<Object, String> valueMap = new HashMap<Object, String>(values.size());
                        BizEnumValueInfo enumValue = null;
                        while (ite.hasNext()) {
                            enumValue = (BizEnumValueInfo)ite.next();
                            valueMap.put(enumValue.getValue(), enumValue.getAlias() == null ? enumValue.getName() : enumValue.getAlias());
                        }
                        data_type.put("values", valueMap);
                    } else {
                        data_type.put("data_schema", ((OwnPropertyInfo)p).getMetaDataRef());
                    }
                }
            }
        }
        return data_type;
    }

    private static String encodeBosType(EntityObjectInfo entity) {
        if (entity == null) {
            return "";
        }
        String name = entity.getName();
        String alias = entity.getAlias() == null ? name : entity.getAlias();
        String bosType = entity.getType().toString();
        return name + "_" + alias + "(" + bosType + ")";
    }

    private static BOSObjectType decodeBosType(String type) throws Exception {
        BOSObjectType bosType = null;
        if (type == null) {
            return null;
        }
        try {
            bosType = BOSObjectType.create((String)type);
            return bosType;
        }
        catch (Exception exception) {
            int beginIndex = type.indexOf("(");
            int endIndex = type.indexOf(")");
            if (beginIndex == -1 && endIndex > -1 || beginIndex > -1 && endIndex == -1) {
                throw new Exception("\u672a\u80fd\u6b63\u786e\u8bc6\u522b\u5143\u6570\u636e\uff0c\u8bf7\u786e\u5b9e\u662f\u5426\u6b63\u786e\uff1a" + type);
            }
            try {
                if (beginIndex == -1) {
                    bosType = BOSObjectType.create((String)AES.decryptToString(type, "EIP"));
                } else {
                    String encodeType = type.substring(beginIndex + 1, endIndex);
                    bosType = BOSObjectType.create((String)AES.decryptToString(encodeType, "EIP"));
                }
            }
            catch (Exception e) {
                throw new Exception("\u672a\u80fd\u6b63\u786e\u8bc6\u522b\u5143\u6570\u636e\uff0c\u8bf7\u786e\u5b9e\u662f\u5426\u6b63\u786e\uff1a" + type);
            }
            return bosType;
        }
    }

    public static void getOneMetaData(Context ctx) throws Exception {
        block0: {
            EntityObjectCollection entityCollection = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntityCollection();
            Iterator ite = entityCollection.iterator();
            EntityObjectInfo entityObj = null;
            String bosType = null;
            String name = null;
            String alias = null;
            String packageName = null;
            JSONArray array = new JSONArray();
            if (!ite.hasNext()) break block0;
            entityObj = (EntityObjectInfo)ite.next();
            bosType = entityObj.getBOSType().toString();
            name = entityObj.getName();
            alias = entityObj.getAlias();
            packageName = entityObj.getPackage();
            JSONObject json = new JSONObject();
            json.put("bosType", (Object)bosType);
            json.put("name", (Object)name);
            json.put("alias", (Object)alias);
            json.put("packageName", (Object)packageName);
            array.add((Object)json);
        }
    }

    public static void getAllMetaData(Context ctx) throws Exception {
        block0: {
            EntityObjectCollection entityCollection = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntityCollection();
            Iterator ite = entityCollection.iterator();
            EntityObjectInfo entityObj = null;
            String bosType = null;
            String name = null;
            String alias = null;
            String packageName = null;
            JSONArray array = new JSONArray();
            if (!ite.hasNext()) break block0;
            entityObj = (EntityObjectInfo)ite.next();
            bosType = entityObj.getBOSType().toString();
            name = entityObj.getName();
            alias = entityObj.getAlias();
            packageName = entityObj.getPackage();
            JSONObject json = new JSONObject();
            json.put("bosType", (Object)bosType);
            json.put("name", (Object)name);
            json.put("alias", (Object)alias);
            json.put("packageName", (Object)packageName);
            array.add((Object)json);
        }
    }

    private static void getTreeMap(Context ctx, EntityObjectInfo entity, Map data) {
        data.put("bostype", entity.getType().toString());
        data.put("id", entity.getFullName());
        data.put("name", entity.getName());
        data.put("alias", entity.getAlias());
        BusinessObjectBriefView entityView = WebAPIMetadataServlet.getMetaDataLoader(ctx).getBusinessObjectBriefView((IMetaDataPK)MetaDataPK.create((String)entity.getFullName()));
        WebAPIMetadataServlet.getTreeMap(entityView.getViewRoot(), data);
    }

    private static void getTreeMap(IBriefViewTreeNode root, Map data) {
        data.put("alias", root.getAlias());
        if (root.getBOType() != null) {
            data.put("bostype", root.getBOType().toString());
        }
        if (root.getFullName() != null) {
            data.put("id", root.getFullName());
        }
        if (root.getMetaDataType() != null) {
            data.put("type", root.getMetaDataType());
        }
        if (root.getName() != null) {
            data.put("name", root.getName());
        }
        data.put("isLeaf", root.isLeaf());
        if (root.getChildCount() <= 0) {
            return;
        }
        ArrayList childrens = new ArrayList();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            IBriefViewTreeNode node = (IBriefViewTreeNode)root.getChildAt(i);
            HashMap childMap = new HashMap();
            WebAPIMetadataServlet.getTreeMap(node, childMap);
            childrens.add(childMap);
        }
        data.put("children", childrens);
    }

    private static IMetaDataLoader getMetaDataLoader(Context ctx) {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
    }
}

