/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.task.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.agent.EipTaskInfo;
import com.kingdee.eas.csinterface.agent.TaskStatus;
import com.kingdee.eas.csinterface.agent.task.EipTaskManager;
import com.kingdee.eas.csinterface.agent.task.TaskAction;
import com.kingdee.eas.csinterface.agent.task.TaskReportHandler;
import com.kingdee.eas.csinterface.agent.task.TaskType;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.json.JSONArray;
import com.kingdee.eas.csinterface.json.JSONException;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BillDataDeleteHandler
extends TaskReportHandler {
    private static Logger logger = Logger.getLogger(BillDataDeleteHandler.class);

    @Override
    public TaskType getType() {
        return TaskType.BILLDATA;
    }

    @Override
    public TaskAction getAction() {
        return TaskAction.BILLDATA_DELETE;
    }

    @Override
    public void handle(Context ctx, EipTaskInfo taskInfo, long taskVersion, TaskStatus taskStatus, String result) throws BOSException, EASBizException {
        String billNumber = null;
        ArrayList<String> ids = null;
        try {
            JSONObject paramJSON = new JSONObject(taskInfo.getParams());
            billNumber = paramJSON.getString("number");
            JSONArray headIdList = paramJSON.getJSONArray("midIdList");
            ids = new ArrayList<String>(headIdList.length());
            for (int i = 0; i < headIdList.length(); ++i) {
                ids.add(headIdList.getString(i));
            }
        }
        catch (JSONException e) {
            throw new BOSException("json\u683c\u5f0f\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
        DIPMetadata dm = new DIPMetadata(billNumber);
        MetaDataPK pk = MetaDataPK.create((String)dm.getHeaderEntityPK());
        IDynamicBillTemplate dynamicBillTemplate = (IDynamicBillTemplate)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)pk);
        Object[] successPKs = dynamicBillTemplate.deleteBatchMidBill(billNumber, ids.toArray(new String[0]), true);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u6210\u529f\u5220\u9664" + successPKs.length + "\u4e2a\u5355\u636e:" + StringUtils.arrayToString((Object[])successPKs, (String)",")));
        }
        ArrayList<String> headpks = new ArrayList<String>();
        boolean flag = false;
        try {
            JSONObject paramJSON = new JSONObject(taskInfo.getParams());
            flag = paramJSON.getBoolean("reGenerate");
            JSONArray headpkList = paramJSON.getJSONArray("srcIdList");
            for (int i = 0; i < headpkList.length(); ++i) {
                headpks.add(headpkList.getString(i));
            }
        }
        catch (JSONException e) {
            throw new BOSException("json\u683c\u5f0f\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
        BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo(" where number='" + billNumber + "'");
        if (billMappingInfo.isSrcChangeReGenerate() && flag) {
            EipTaskManager.orderReGenerateBillData(ctx, billMappingInfo, headpks.toArray(new String[0]), (String[])successPKs);
        }
    }
}

