/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.util;

import com.kingdee.eas.csinterface.util.AES;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class PacketsUtil {
    public static final byte[] gzip(String str, String charset) throws Exception {
        if (str == null) {
            throw new NullPointerException("gzip input is null!");
        }
        return PacketsUtil.gzip(str.getBytes(charset));
    }

    public static final byte[] gzip(byte[] input) throws Exception {
        if (input == null || input.length == 0) {
            return input;
        }
        GZIPOutputStream gzipOut = null;
        ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
        gzipOut = new GZIPOutputStream(arrayOut);
        try {
            gzipOut.write(input);
            gzipOut.finish();
            gzipOut.flush();
        }
        finally {
            gzipOut.close();
            arrayOut.close();
        }
        return arrayOut.toByteArray();
    }

    public static final byte[] gzipAndEncrypt(byte[] input, String encryptKey) throws Exception {
        if (input == null || input.length == 0) {
            return input;
        }
        input = PacketsUtil.gzip(input);
        return AES.encrypt(input, encryptKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] ungzip(byte[] input) throws Exception {
        if (input == null || input.length == 0) {
            return input;
        }
        GZIPInputStream gzipIn = new GZIPInputStream(new ByteArrayInputStream(input));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = gzipIn.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            gzipIn.close();
            out.close();
        }
        return out.toByteArray();
    }

    public static final byte[] decryptAndUngzip(byte[] input, String encryptKey) throws Exception {
        if (input == null || input.length == 0) {
            return input;
        }
        byte[] decrypted = AES.decrypt(input, encryptKey);
        byte[] ungziped = PacketsUtil.ungzip(decrypted);
        return ungziped;
    }
}

