/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableCollection;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.csinterface.basedatasyn.client.AbstractAllTableListUI;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataSynEditUI;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataSynLaunchedEditUI;
import com.kingdee.eas.csinterface.basedatasyn.client.TableNameEditUI;
import com.kingdee.eas.csinterface.syncdatabase.ISQLFacade;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.util.DataTypeConverter;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllTableListUI
extends AbstractAllTableListUI {
    private static final Logger logger = CoreUIObject.getLogger(AllTableListUI.class);
    private int selectRowIndex = 0;
    List kdTableDataList = new ArrayList();
    private static final String folderPath = System.getProperty("EAS_HOME") + File.separator + "client" + File.separator + "cache" + File.separator + "tableCache";
    private static final String filePath = folderPath + File.separator + "tableCache.txt";
    private static Map<String, String> tableMap = new LinkedHashMap<String, String>();
    private static int tableMapSize = 0;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void onNoResult() {
        super.onNoResult();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRefresh.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnView.setVisible(false);
        this.updateData.setEnabled(true);
        this.readFile(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(String filePath) throws Exception {
        if (!tableMap.isEmpty()) {
            for (String key : tableMap.keySet()) {
                Object[] columnValues = new Object[]{key, tableMap.get(key)};
                this.kdTableDataList.add(columnValues);
            }
            KDTableHelper.initTable((KDTable)this.tblMain, null, (Object[][])null, (Object[][])((Object[][])this.kdTableDataList.toArray((T[])new Object[0][0])));
            return;
        }
        FileInputStream fis = null;
        InputStreamReader read = null;
        BufferedReader bufferedReader = null;
        try {
            File folder = new File(folderPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            this.kdTableDataList = new ArrayList();
            File file = new File(filePath);
            String encoding = "UTF-8";
            if (file.isFile() && file.exists()) {
                fis = new FileInputStream(file);
                read = new InputStreamReader(fis);
                bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    try {
                        String[] str = lineTxt.split(",");
                        Object[] columnValues = new Object[]{str[0], str[1]};
                        this.kdTableDataList.add(columnValues);
                        tableMap.put(str[0], str[1]);
                    }
                    catch (Exception exception) {}
                }
                tableMapSize = tableMap.size();
                read.close();
            } else {
                file.createNewFile();
                System.out.println("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            System.out.println("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519");
            e.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (read != null) {
                try {
                    read.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        KDTableHelper.initTable((KDTable)this.tblMain, null, (Object[][])null, (Object[][])((Object[][])this.kdTableDataList.toArray((T[])new Object[0][0])));
    }

    @Override
    public void updateData_actionPerformed(ActionEvent e) throws Exception {
        super.updateData_actionPerformed(e);
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", "\u66f4\u65b0\u6570\u636e,\u8bf7\u7a0d\u540e...");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec() throws Exception {
                OutputStreamWriter fileWriter = null;
                BufferedWriter writer = null;
                try {
                    tableMap = new HashMap();
                    ISQLFacade sqlFacader = SQLFacadeFactory.getRemoteInstance();
                    String ksql = "select KSQL_TABNAME from KSQL_USERTABLES";
                    IRowSet rowset = sqlFacader.getRowset(ksql);
                    ArrayList<String> tables = new ArrayList<String>();
                    while (rowset.next()) {
                        tables.add(rowset.getString("KSQL_TABNAME").toUpperCase());
                    }
                    DataTableCollection tableColl = MetaDataLoaderFactory.getRemoteMetaDataLoader().getDataTableCollection();
                    StringBuffer buf = new StringBuffer();
                    ArrayList<TableDesc> list = new ArrayList<TableDesc>();
                    for (int i = 0; i < tableColl.size(); ++i) {
                        DataTableInfo string = tableColl.get(i);
                        String name = string.getName();
                        String nameUper = name.toUpperCase();
                        String desc = string.getDescription();
                        if (StringUtils.isEmpty((String)desc) && StringUtils.isEmpty((String)(desc = string.getAlias()))) {
                            desc = name;
                        }
                        if (!tables.contains(nameUper)) continue;
                        list.add(new TableDesc(name, desc));
                    }
                    Collections.sort(list, (Comparator)new Comparator<TableDesc>(){

                        @Override
                        public int compare(TableDesc o1, TableDesc o2) {
                            return o1.getName().compareToIgnoreCase(o2.getName());
                        }
                    });
                    for (TableDesc tableDesc : list) {
                        buf.append(tableDesc.getName()).append(",").append(tableDesc.getDesc()).append("\r\n");
                        tableMap.put(tableDesc.getName(), tableDesc.getDesc());
                    }
                    tableMapSize = tableMap.size();
                    File file = new File(filePath);
                    fileWriter = new FileWriter(file);
                    writer = new BufferedWriter(fileWriter);
                    writer.write(buf.toString());
                    String string = "success";
                    return string;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.exception = exc;
                    String string = "fail";
                    return string;
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            logger.error((Object)e.getMessage());
                        }
                    }
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (IOException e) {
                            logger.error((Object)e.getMessage());
                        }
                    }
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (null == this.exception) {
                    MsgBox.showInfo((String)"\u6570\u636e\u66f4\u65b0\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u3002");
                    AllTableListUI.this.destroyWindow();
                } else {
                    MsgBox.showError((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff1a", (String)this.exception.getMessage());
                }
            }
        });
        dialog.show();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            IRow editRow;
            IRowSet rowset;
            ISQLFacade sqlFacader;
            String ksql;
            DataTypeConverter converter;
            String tableName;
            IRow row;
            EditUI editUI;
            int currenteSelectedRow = e.getRowIndex();
            Object obj = this.getUIContext().get("Owner");
            if (obj != null && obj instanceof BaseDataSynEditUI) {
                editUI = (BaseDataSynEditUI)obj;
                row = this.tblMain.getRow(currenteSelectedRow);
                tableName = row.getCell("name").getValue().toString();
                if (editUI.getExistTable().contains(tableName)) {
                    MsgBox.showInfo((String)"\u8be5\u8868\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
                    return;
                }
                converter = new DataTypeConverter();
                ksql = converter.getColumnDefinedSql(tableName);
                sqlFacader = SQLFacadeFactory.getRemoteInstance();
                rowset = sqlFacader.getRowset(ksql);
                if (0 == rowset.size()) {
                    MsgBox.showInfo((String)"\u8be5\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
                    this.tblMain.removeRow(currenteSelectedRow);
                    tableMap.remove(tableName);
                    return;
                }
                if (editUI.kDTables.getRowCount() == 0) {
                    editUI.setAddFirstTable(true);
                }
                this.destroyWindow();
                editRow = editUI.kDTables.addRow();
                editRow.getCell("tableName").setValue((Object)tableName);
                editRow.getCell("tableAlias").setValue(row.getCell("number").getValue());
                editRow.getCell("mainTable").setValue((Object)false);
                editRow.getCell("level").setValue((Object)0);
                KDTableUtil.setSelectedRow((KDTable)editUI.kDTables, (int)editRow.getRowIndex());
                editUI.setSelectRow(editRow.getRowIndex());
                editUI.setHasModified(true);
            }
            if (obj != null && obj instanceof BaseDataSynLaunchedEditUI) {
                editUI = (BaseDataSynLaunchedEditUI)obj;
                row = this.tblMain.getRow(currenteSelectedRow);
                tableName = row.getCell("name").getValue().toString();
                if (editUI.getExistTable().contains(tableName)) {
                    MsgBox.showInfo((String)"\u8be5\u8868\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
                    return;
                }
                converter = new DataTypeConverter();
                ksql = converter.getColumnDefinedSql(tableName);
                sqlFacader = SQLFacadeFactory.getRemoteInstance();
                rowset = sqlFacader.getRowset(ksql);
                if (0 == rowset.size()) {
                    MsgBox.showInfo((String)"\u8be5\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
                    this.tblMain.removeRow(currenteSelectedRow);
                    tableMap.remove(tableName);
                    return;
                }
                if (editUI.kDTables.getRowCount() == 0) {
                    editUI.setAddFirstTable(true);
                }
                this.destroyWindow();
                editRow = editUI.kDTables.addRow();
                editRow.getCell("tableName").setValue((Object)tableName);
                editRow.getCell("tableAlias").setValue(row.getCell("number").getValue());
                editRow.getCell("mainTable").setValue((Object)false);
                editRow.getCell("level").setValue((Object)0);
                KDTableUtil.setSelectedRow((KDTable)editUI.kDTables, (int)editRow.getRowIndex());
                editUI.setSelectRow(editRow.getRowIndex());
                editUI.setHasModified(true);
            }
            if (obj != null && obj instanceof TableNameEditUI) {
                editUI = (TableNameEditUI)((Object)obj);
                row = this.tblMain.getRow(currenteSelectedRow);
                tableName = row.getCell("name").getValue().toString();
                IRow editRow2 = editUI.kdtEntrys.addRow();
                editRow2.getCell("TableName").setValue((Object)tableName);
                this.destroyWindow();
            }
            return;
        }
    }

    public boolean destroyWindow() {
        if (!tableMap.isEmpty() && tableMap.size() != tableMapSize) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BufferedWriter writer = null;
                    try {
                        StringBuffer buf = new StringBuffer();
                        writer = new BufferedWriter(new FileWriter(new File(filePath)));
                        for (String key : tableMap.keySet()) {
                            buf.append(key).append(",").append((String)tableMap.get(key)).append("\r\n");
                        }
                        writer.write(buf.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        return super.destroyWindow();
    }

    protected String getKeyFieldName() {
        return "name";
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        return super.prepareActionEdit(itemAction);
    }

    public RequestContext prepareActionView(IItemAction itemAction) throws Exception {
        return super.prepareActionView(itemAction);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    class TableDesc {
        private String name;
        private String desc;

        public TableDesc(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

