/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynPublisherFacadeFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTreeInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTypeEnum;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynHead;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynPublisherFacade;
import com.kingdee.eas.csinterface.basedatasyn.SynDirection;
import com.kingdee.eas.csinterface.basedatasyn.client.AbstractBaseDataMultiPlanEditUI;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataExecuteTypeUI;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataSynLaunchedTreeListUI;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataTreeListUI;
import com.kingdee.eas.csinterface.basedatasyn.client.util.PlanLevelUtil;
import com.kingdee.eas.csinterface.schedule.client.ScheduleConfigListUI;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.client.util.OptionalPromptDataSourceType;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BaseDataMultiPlanEditUI
extends AbstractBaseDataMultiPlanEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BaseDataMultiPlanEditUI.class);
    private Set<String> scheduleIdset = new HashSet<String>();
    private String oldAgentName = "";
    private String oldConnName = "";
    boolean isAlreadyLaunched = false;

    public BaseDataMultiPlanEditUI() throws Exception {
        this.txtDsType = OptionalPromptDataSourceType.initDataSourceType(new Object[]{DataSourceType.jdbc, DataSourceType.agent}, this.dataBinder);
        this.txtDsType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseDataMultiPlanEditUI.this.dsTypeChanged();
            }
        });
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("treeid", (BaseDataSynTreeInfo)this.getUIContext().get("ParentNode"));
            this.editData.put("multiPlan", 1);
        }
    }

    private void dsTypeChanged() {
        boolean enable = this.editData.isPublished();
        if (enable) {
            this.comDsType.setEnabled(!enable);
            this.txtDsType.setEditable(!enable);
            this.contAgent.setEnabled(!enable);
            this.contConn.setEnabled(!enable);
            return;
        }
        DataSourceType dsType = (DataSourceType)((Object)this.txtDsType.getSelectedItem());
        if (dsType == null) {
            return;
        }
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            this.prmtAgent.setValue(null);
            this.prmtAgent.setEditable(false);
            this.contAgent.setEnabled(false);
            this.contConn.setEnabled(true);
        } else if (DataSourceType.agent.equals((Object)dsType)) {
            this.prmtConn.setValue(null);
            this.prmtConn.setEditable(false);
            this.contConn.setEnabled(false);
            this.contAgent.setEnabled(true);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8d44\u6e90\u7c7b\u522b'" + dsType.getAlias() + "'");
        }
    }

    public void initPrmtState() {
        this.prmtConn.setEditable(false);
        this.prmtAgent.setEditable(false);
        this.prmtConn.setHistoryRecordEnabled(false);
        this.prmtAgent.setHistoryRecordEnabled(false);
    }

    public void onLoad() throws Exception {
        Object obj = this.getUIContext().get("Owner");
        if (obj != null && obj instanceof BaseDataSynLaunchedTreeListUI) {
            this.isAlreadyLaunched = true;
        }
        this.kdtEntrys.checkParsed();
        this.kdSchedule.checkParsed();
        super.onLoad();
        this.prmtAgent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    BaseDataMultiPlanEditUI.this.initEntryTable();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.prmtConn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    BaseDataMultiPlanEditUI.this.initEntryTable();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.kdtEntrys.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BaseDataMultiPlanEditUI.this.kdtEntrys_editStopped(e);
                }
                catch (Exception exc) {
                    BaseDataMultiPlanEditUI.this.handUIException(exc);
                }
            }
        });
        this.comboDirection.setSelectedIndex(0);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtDsType.setSelectedItem((Object)DataSourceType.jdbc);
            this.contAgent.setEnabled(false);
            this.prmtAgent.setEditable(false);
            this.contConn.setEnabled(true);
        }
        this.initPrmtState();
        this.btnPublish.setVisible(false);
        KDTable kdtMergeEntryTable = this.kdtEntrys;
        kdtMergeEntryTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent selectEvent) {
                int currenteSelectedRow = selectEvent.getSelectBlock().getBeginRow();
                BaseDataMultiPlanEditUI.this.ctrlTableBth(currenteSelectedRow);
            }
        });
    }

    private void ctrlTableBth(int rowIndex) {
        this.upTable.setEnabled(rowIndex != 0);
        this.downTable.setEnabled(rowIndex != this.kdtEntrys.getRowCount() - 1);
    }

    public void onShow() throws Exception {
        if (!this.getOprtState().equals(OprtState.ADDNEW) && this.prmtAgent.getData() != null) {
            this.oldAgentName = ((EipUserInfo)this.prmtAgent.getData()).getId().toString();
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW) && this.prmtConn.getData() != null) {
            this.oldConnName = ((ConnectionInfo)this.prmtConn.getData()).getId().toString();
        }
        super.onShow();
        this.initEntryTable();
        int n = this.kdSchedule.getRowCount();
        for (int i = 0; i < n; ++i) {
            String value1;
            IRow iRow = this.kdSchedule.getRow(i);
            ICell scheduleCell = iRow.getCell("scheduleId");
            if (scheduleCell == null || StringUtils.isEmpty((String)(value1 = (String)iRow.getCell("scheduleId").getValue()))) continue;
            this.scheduleIdset.add(value1);
        }
    }

    @Override
    public void loadFields() {
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        super.loadFields();
        this.btnSchedule.setEnabled(!this.getOprtState().equals(OprtState.ADDNEW));
        this.btnExecute.setEnabled(!this.getOprtState().equals(OprtState.ADDNEW));
        boolean enable = this.editData.getId() != null && this.editData.isEnabled();
        this.btnRemove.setEnabled(!enable);
        this.loadTableValue();
    }

    protected final void initEntryTable() throws ParserException, BOSException {
        int rs;
        int count;
        BaseDataSynHeadInfo plan = this.editData;
        if (null == plan) {
            return;
        }
        EipUserInfo agent = (EipUserInfo)this.prmtAgent.getData();
        ConnectionInfo conn = (ConnectionInfo)this.prmtConn.getData();
        if (agent != null && !StringUtils.equals((String)this.oldAgentName, (String)agent.getId().toString())) {
            count = this.kdtEntrys.getRowCount();
            if (count > 0) {
                rs = MsgBox.showConfirm2((String)"\u6267\u884c\u8be5\u64cd\u4f5c\u53ef\u80fd\u4f1a\u5220\u9664\u5206\u5f55\u4e2d\u6240\u6709\u7684\u8bb0\u5f55\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u6267\u884c\u5417\uff1f");
                if (rs != 0) {
                    try {
                        this.prmtAgent.setData((Object)EipUserFactory.getRemoteInstance().getEipUserInfo(CommonUtil.convert2PK(this.oldAgentName)));
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                        this.prmtAgent.setData(null);
                    }
                    return;
                }
                this.kdtEntrys.removeRows(true);
            }
            this.oldAgentName = agent.getId().toString();
        }
        if (conn != null && !StringUtils.equals((String)this.oldConnName, (String)conn.getId().toString())) {
            count = this.kdtEntrys.getRowCount();
            if (count > 0) {
                rs = MsgBox.showConfirm2((String)"\u6267\u884c\u8be5\u64cd\u4f5c\u53ef\u80fd\u4f1a\u5220\u9664\u5206\u5f55\u4e2d\u6240\u6709\u7684\u8bb0\u5f55\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u6267\u884c\u5417\uff1f");
                if (rs != 0) {
                    try {
                        this.prmtConn.setData((Object)ConnectionFactory.getRemoteInstance().getConnectionInfo(CommonUtil.convert2PK(this.oldConnName)));
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                        this.prmtConn.setData(null);
                    }
                    return;
                }
                this.kdtEntrys.removeRows(true);
            }
            this.oldConnName = conn.getId().toString();
        }
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setQueryInfo("com.kingdee.eas.csinterface.basedatasyn.app.BaseDataSynQuery");
        if (this.isAlreadyLaunched) {
            promptBox.setQueryInfo("com.kingdee.eas.csinterface.basedatasyn.app.BaseDataSynLaunchedQuery");
        }
        promptBox.setVisible(true);
        promptBox.setEditable(true);
        promptBox.setDisplayFormat("$number$");
        promptBox.setEditFormat("$number$");
        promptBox.setCommitFormat("$id$");
        EntityViewInfo ev = new EntityViewInfo();
        if (null == ev.getFilter()) {
            ev.setFilter(new FilterInfo());
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (this.editData.getId() != null) {
            fic.add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        fic.add(new FilterItemInfo("enabled", (Object)"1", CompareType.EQUALS));
        fic.add(new FilterItemInfo("planLevel", (Object)1, CompareType.LESS_EQUALS));
        if (fic.size() > 0) {
            ev.getFilter().mergeFilter(filter, "AND");
        }
        promptBox.setEntityViewInfo(ev);
        IColumn destIDColumn = this.kdtEntrys.getColumn("number");
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)promptBox);
        destIDColumn.setEditor((ICellEditor)editor);
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat((IDataFormat)new BizDataFormat("$number$"));
        destIDColumn.setRenderer((IBasicRender)render);
    }

    @Override
    public void downTable_actionPerformed(ActionEvent e) throws Exception {
        super.downTable_actionPerformed(e);
        try {
            int[] seltIndex = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys);
            for (int i = seltIndex.length - 1; i > -1; --i) {
                if (seltIndex[seltIndex.length - 1] == this.kdtEntrys.getRowCount() - 1) {
                    return;
                }
                this.kdtEntrys.moveRow(seltIndex[i], seltIndex[i] + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void upTable_actionPerformed(ActionEvent e) throws Exception {
        super.upTable_actionPerformed(e);
        try {
            int[] seltIndex = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys);
            for (int i = 0; i < seltIndex.length; ++i) {
                if (seltIndex[0] == 0) {
                    return;
                }
                this.kdtEntrys.moveRow(seltIndex[i], seltIndex[i] - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublish_actionPerformed(e);
    }

    @Override
    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        IBaseDataSynPublisherFacade facade;
        String checkMsg;
        super.actionExecute_actionPerformed(e);
        SynDirection direction = (SynDirection)((Object)this.comboDirection.getSelectedItem());
        if (!SynDirection.ParentToBranch.equals((Object)direction) && !SynDirection.BranchToParent.equals((Object)direction)) {
            throw new BOSException("\u4e0d\u652f\u6301\u7684\u8d44\u6e90\u7c7b\u522b'" + direction.getAlias() + "'");
        }
        if (this.isModify()) {
            super.actionSubmit_actionPerformed(e);
        }
        if (!StringUtils.isEmpty((String)(checkMsg = (facade = BaseDataSynPublisherFacadeFactory.getRemoteInstance()).checkHasPublish(this.editData)))) {
            MsgBox.showInfo((String)checkMsg);
            SysUtil.abort();
        }
        this.connectionActionExecute();
    }

    private void connectionActionExecute() throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("Owner", (Object)this);
        uiContext.put("baseData", this.editData);
        IUIWindow uiWindow = uiFactory.create(BaseDataExecuteTypeUI.class.getName(), uiContext, this.dataObjects, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionSchedule_actionPerformed(ActionEvent e) throws Exception {
        super.actionSchedule_actionPerformed(e);
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("Owner", (Object)this);
        uiContext.put("BDID", this.editData.getId());
        uiContext.put("SCID", this.scheduleIdset);
        HashMap dataObjects = new HashMap();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ScheduleConfigListUI.class.getName(), uiContext, dataObjects, OprtState.EDIT);
        KDDialog dlg = (KDDialog)uiWindow;
        dlg.setPreferredSize(new Dimension(1200, 700));
        dlg.setResizable(true);
        dlg.show();
        uiContext.clear();
    }

    public void getBackEditDataId(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        if (!this.scheduleIdset.contains(id)) {
            this.scheduleIdset.add(id);
            IRow row = this.kdSchedule.addRow();
            row.getCell("scheduleId").setValue((Object)id);
        }
    }

    public void getBackEditDataId2Romeve(Set<String> idSet) {
        if (idSet.size() == 0) {
            this.kdSchedule.removeRows(true);
        } else {
            for (int i = 0; i < this.kdSchedule.getRowCount(); ++i) {
                IRow row = this.kdSchedule.getRow(i);
                Object id = row.getCell("scheduleId").getValue();
                if (idSet.contains(id)) continue;
                this.kdSchedule.removeRow(i);
            }
        }
    }

    protected void loadTableValue() {
        try {
            Map map = new HashMap();
            Set<String> idSet = this.getFidSet();
            if (!idSet.isEmpty()) {
                String[] idArray = idSet.toArray(new String[0]);
                IBaseDataSynHead instance = BaseDataSynHeadFactory.getRemoteInstance();
                map = instance.convertId2CoreBaseInfo(idArray);
            }
            int n = this.kdtEntrys.getRowCount();
            for (int i = 0; i < n; ++i) {
                String fid = (String)this.kdtEntrys.getRow(i).getCell("planId").getValue();
                BaseDataSynHeadInfo coreBase = (BaseDataSynHeadInfo)map.get(fid);
                if (coreBase == null) continue;
                IRow iRow = this.kdtEntrys.getRow(i);
                iRow.getCell("planId").setValue((Object)fid);
                iRow.getCell("number").setValue((Object)coreBase.getNumber().toString());
                iRow.getCell("name").setValue((Object)coreBase.getName().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Set<String> getFidSet() {
        HashSet<String> idSet = new HashSet<String>();
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            String planId = (String)this.kdtEntrys.getCell(i, "planId").getValue();
            if (StringUtils.isEmpty((String)planId)) continue;
            idSet.add(planId);
        }
        return idSet;
    }

    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        if (e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
            int index = e.getRowIndex();
            ICell nameCell = this.kdtEntrys.getCell(index, "name");
            ICell numberCell = this.kdtEntrys.getCell(index, "number");
            ICell planIdCell = this.kdtEntrys.getCell(index, "planId");
            IObjectValue destID = (IObjectValue)numberCell.getValue();
            String planId = UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)destID, (String)"id"));
            String name = UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)destID, (String)"name"));
            HashSet<String> existPlanSet = new HashSet<String>();
            Object obj = "";
            for (int i = 0; i < index - 1; ++i) {
                ICell existPlanCell = this.kdtEntrys.getCell(i, "planId");
                obj = existPlanCell.getValue();
                if (obj == null) continue;
                existPlanSet.add(obj.toString());
            }
            if (existPlanSet.contains(planId)) {
                numberCell.setValue(null);
                MsgBox.showInfo((String)"\u65b9\u6848\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u9009\u62e9\u3002");
                SysUtil.abort();
            }
            nameCell.setValue((Object)name);
            planIdCell.setValue((Object)planId);
        }
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.oprtState)) {
            this.txtNumber.setEnabled(true);
            this.txtName.setEnabled(true);
            this.prmtAgent.setEnabled(true);
        } else if ("EDIT".equals(this.oprtState)) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.prmtAgent.setEnabled(false);
        } else if ("VIEW".equals(this.oprtState)) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.prmtAgent.setEnabled(false);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setNumber(this.txtNumber.getText());
        this.editData.setName(this.txtName.getText());
        this.txtNumber.requestFocus();
        BaseDataSynHeadFactory.getRemoteInstance().checkNumberBlank((DataBaseInfo)this.editData);
        this.txtName.requestFocus();
        BaseDataSynHeadFactory.getRemoteInstance().checkNameBlank((DataBaseInfo)this.editData);
        this.txtComment.requestFocus();
        this.txtNumber.requestFocus();
        BaseDataSynHeadFactory.getRemoteInstance().checkNumberDup((DataBaseInfo)this.editData);
        this.txtName.requestFocus();
        BaseDataSynHeadFactory.getRemoteInstance().checkNameDup((DataBaseInfo)this.editData);
        Object obj = "";
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            ICell planIdCell = this.kdtEntrys.getCell(i, "planId");
            obj = planIdCell.getValue();
            if (obj != null && !StringUtils.isEmpty((String)obj.toString())) continue;
            this.kdtEntrys.removeRow(i);
        }
        PlanLevelUtil.updatePlanLevel(this.editData, this.kdtEntrys);
        super.actionSubmit_actionPerformed(e);
        this.txtComment.requestFocus();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.txtNumber.setText("");
        this.txtName.setText("");
        this.scheduleIdset = new HashSet<String>();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtDsType.setSelectedItem((Object)DataSourceType.jdbc);
            this.contAgent.setEnabled(false);
            this.prmtAgent.setEditable(false);
            this.contConn.setEnabled(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.prmtAgent.setEditable(false);
        this.prmtConn.setEditable(false);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BaseDataSynHeadFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BaseDataMultiPlanEditUI.class.getName();
    }

    protected IObjectValue createNewData() {
        BaseDataSynHeadInfo objectValue = new BaseDataSynHeadInfo();
        return objectValue;
    }

    public boolean destroyWindow() {
        Object obj = this.getUIContext().get("Owner");
        if (null != obj && obj instanceof BaseDataTreeListUI) {
            BaseDataTreeListUI listUI = (BaseDataTreeListUI)((Object)obj);
            try {
                listUI.refreshList();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.destroyWindow();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void applyDefaultValue(IObjectValue vo) {
        if (this.isAlreadyLaunched) {
            vo.put("baseDataSynType", (Object)BaseDataSynTypeEnum.alreadyLaunch);
        } else {
            vo.put("baseDataSynType", (Object)BaseDataSynTypeEnum.newLaunch);
        }
    }
}

