/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UINewTabFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynCheckDiffFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynCheckDiffInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.client.AbstractBaseDataSynCheckDiffUI;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataSynCompareUI;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BaseDataSynCheckDiffUI
extends AbstractBaseDataSynCheckDiffUI {
    private static final Logger logger = CoreUIObject.getLogger(BaseDataSynCheckDiffUI.class);
    private BaseDataSynCheckDiffInfo checkDiffInfo = null;
    ConnectionInfo destDB = null;
    private long expireTime = 0L;
    public static boolean isDialog = false;
    private Map<String, String> whereSqlMap = new HashMap<String, String>();

    public void onLoad() throws Exception {
        FilterInfo filterInfo;
        super.onLoad();
        BaseDataSynHeadInfo headInfo = (BaseDataSynHeadInfo)this.getUIContext().get("baseData");
        String headId = headInfo.getId().toString();
        try {
            this.checkDiffInfo = BaseDataSynCheckDiffFactory.getRemoteInstance().getBaseDataSynCheckDiffInfo(" where SynHeadID='" + headId + "'");
            this.destDB = ConnectionFactory.getRemoteInstance().getConnectionInfo(CommonUtil.convert2PK(this.checkDiffInfo.getDestDB().getId()));
            this.prmtConn.setValue((Object)this.destDB);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (null != this.checkDiffInfo) {
            this.prmtTabs.setValue((Object)this.checkDiffInfo.getCheckTabs());
            this.mainSQL.setText(this.checkDiffInfo.getFilterSql());
            this.labStatus.setText(this.getStatusInfo(this.checkDiffInfo.getStatus()));
        } else {
            this.checkDiffInfo = new BaseDataSynCheckDiffInfo();
            this.checkDiffInfo.setStatus(-1);
        }
        this.checkDiffInfo.setSynheadID(headId);
        EntityViewInfo evMidtoCtx = this.prmtTabs.getEntityViewInfo();
        if (null == evMidtoCtx) {
            evMidtoCtx = new EntityViewInfo();
        }
        if (null == (filterInfo = evMidtoCtx.getFilter())) {
            filterInfo = new FilterInfo();
            evMidtoCtx.setFilter(filterInfo);
        }
        FilterItemCollection filterColl = filterInfo.getFilterItems();
        filterColl.clear();
        filterColl.add(new FilterItemInfo("parentID", (Object)headId, CompareType.EQUALS));
        this.prmtTabs.setEntityViewInfo(evMidtoCtx);
        int status = this.checkDiffInfo.getStatus();
        if (status == 1) {
            this.statusModify(false);
        }
        this.expireTime = System.currentTimeMillis();
        this.fillMap();
        this.prmtTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BaseDataSynCheckDiffUI.this.adjustMainSql();
            }
        });
        this.mainSQL.removeMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
                BaseDataSynCheckDiffUI.this.fillMap();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }
        });
    }

    private void fillMap() {
        String[] arrTab;
        String mainSql = this.mainSQL.getText();
        for (String tabSql : arrTab = mainSql.split(";")) {
            if (tabSql.replaceAll("\r|\n", "").trim().isEmpty()) continue;
            String[] whereSql = tabSql.split(":");
            this.whereSqlMap.put(whereSql[0], whereSql[1]);
        }
    }

    private void adjustMainSql() {
        String tabs = this.prmtTabs.getText();
        String[] arrTab = tabs.replace(" ", "").split(";");
        StringBuilder builder = new StringBuilder();
        for (String table : arrTab) {
            builder.append(table).append(":");
            String whereSql = this.whereSqlMap.get(table);
            if (StringUtils.isEmpty((String)whereSql)) {
                builder.append("#sql#");
            } else {
                builder.append(whereSql);
            }
            builder.append(";\r\n");
        }
        this.mainSQL.setText(builder.toString());
    }

    private String getStatusInfo(int status) {
        StringBuilder statusInfo = new StringBuilder("\u72b6\u6001\u4e3a\uff1a");
        switch (status) {
            case 0: {
                statusInfo.append("\u672a\u6267\u884c");
            }
            case 1: {
                statusInfo.append("\u6b63\u6267\u884c\u6bd4\u5bf9");
            }
            case 2: {
                statusInfo.append("\u6bd4\u5bf9\u7ed3\u675f");
            }
        }
        return statusInfo.toString();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        if (this.checkDiffInfo.getStatus() == -1) {
            this.checkDiffInfo.setStatus(0);
        }
        this.storedData();
        this.saveData();
        this.destroyWindow();
    }

    @Override
    public void actionExecCompare_actionPerformed(ActionEvent e) throws Exception {
        this.checkDiffInfo.setStatus(4);
        this.storedData();
        this.saveData();
        if ("overSize".equalsIgnoreCase(BaseDataSynCheckDiffFactory.getRemoteInstance().doAction("RUNCOMPARE", this.checkDiffInfo))) {
            MsgBox.showInfo((String)"\u5f53\u524d\u6267\u884c\u961f\u5217\u5df2\u6ee1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return;
        }
        this.labStatus.setText(this.getStatusInfo(1));
        MsgBox.showInfo((String)"\u5df2\u8fdb\u5165\u540e\u53f0\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6bd4\u5bf9\u7ed3\u679c");
        this.statusModify(false);
    }

    private void statusModify(boolean status) {
        this.prmtConn.setEditable(status);
        this.prmtTabs.setEditable(status);
        this.mainSQL.setEditable(status);
        this.prmtConn.setEnabled(status);
        this.prmtTabs.setEnabled(status);
        this.mainSQL.setEnabled(status);
        this.btnExecCompare.setEnabled(status);
        this.btnCheckResult.setEnabled(status);
    }

    @Override
    public void actionCheckResult_actionPerformed(ActionEvent e) throws Exception {
        this.storedData();
        Object uiContext = null;
        IUIFactory uiFactory = null;
        IUIWindow windUI = null;
        if (isDialog) {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            uiContext = new HashMap();
            uiContext.put("Owner", this);
            uiContext.put("entityInfo", this.checkDiffInfo);
            windUI = uiFactory.create(BaseDataSynCompareUI.class.getName(), (Map)uiContext, this.dataObjects, OprtState.ADDNEW);
        } else {
            uiContext = new UIContext((Object)this);
            uiContext.put("entityInfo", this.checkDiffInfo);
            String name = "com.kingdee.eas.csinterface.basedatasyn.client.BaseDataSynCompareUI";
            uiFactory = UIFactory.createUIFactory((String)UINewTabFactory.class.getName());
            windUI = uiFactory.create(name, (Map)uiContext, null, null);
            this.destroyWindow();
        }
        windUI.show();
    }

    private void storedData() throws EASBizException, BOSException {
        this.checkDiffInfo.setDestDB(this.destDB);
        this.checkDiffInfo.setDestDB((ConnectionInfo)this.prmtConn.getValue());
        this.checkDiffInfo.setCheckTabs(this.convertColl(this.prmtTabs.getValue()));
        this.checkDiffInfo.setFilterSql(this.mainSQL.getText());
    }

    private void saveData() throws EASBizException, BOSException {
        IObjectPK pk = BaseDataSynCheckDiffFactory.getRemoteInstance().save((CoreBaseInfo)this.checkDiffInfo);
        if (null == this.checkDiffInfo.getId()) {
            this.checkDiffInfo.setId(BOSUuid.read((String)pk.toString()));
        }
    }

    private String convertColl(Object tabs) {
        if (tabs instanceof String) {
            return tabs.toString();
        }
        Object[] colls = (Object[])tabs;
        StringBuilder builder = new StringBuilder();
        int size = colls.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(((BaseDataSynTableInfo)colls[i]).getTableName());
        }
        return builder.toString();
    }

    @Override
    public void btnRefreshStatus_actionPerformed(ActionEvent e) throws Exception {
        long currTime = System.currentTimeMillis();
        long compareTime = (currTime - this.expireTime) / 1000L;
        int status = this.checkDiffInfo.getStatus();
        if (status == 1 || status == 4) {
            if (compareTime < 45L) {
                MsgBox.showInfo((String)("\u5f53\u524d\u5237\u65b0\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7" + (45L - compareTime) + "s\u540e\u518d\u8bd5"));
                return;
            }
            this.checkDiffInfo = BaseDataSynCheckDiffFactory.getRemoteInstance().getBaseDataSynCheckDiffInfo(" where SynHeadID='" + this.checkDiffInfo.getSynheadID() + "'");
            status = this.checkDiffInfo.getStatus();
            if (status == 2) {
                this.statusModify(true);
                this.labStatus.setText(this.getStatusInfo(2));
            }
        } else {
            return;
        }
        this.expireTime = currTime;
        MsgBox.showInfo((String)"\u5237\u65b0\u6210\u529f");
    }
}

