/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTypeMapInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapEntryCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapEntryInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapInfo;
import com.kingdee.eas.csinterface.basedatasyn.client.AbstractBaseDataSynValueMapEditUI;
import com.kingdee.eas.csinterface.basedatasyn.dataFile.DataFile;
import com.kingdee.eas.csinterface.converter.core.DefaultStream;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.IConnection;
import com.kingdee.eas.csinterface.syncdatabase.ISQLFacade;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.syncdatabase.client.BaseDataMappingImportUI;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataInfoUtil;
import com.kingdee.eas.csinterface.util.CSCheck;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ComponentHelper;
import com.kingdee.eas.csinterface.util.ExcelHelper;
import com.kingdee.eas.csinterface.util.Export2FileUtil;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.csinterface.utils.BaseDataMappingUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jxl.Workbook;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class BaseDataSynValueMapEditUI
extends AbstractBaseDataSynValueMapEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BaseDataSynValueMapEditUI.class);
    ConnectionInfo conn = null;
    BaseDataSynTypeMapInfo BaseDataSynTypeMapInfo = null;
    private static String FILE_PATH = "";
    private static IUIWindow UI_WINDOW = null;
    public static int DESC_MATCH_MAX_SIZE = 1000;

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadOrgUnit();
        this.loadTableValue();
        this.updatePrmtbaseDataTypeAndPrmtOrgUnit2EnableOrNot();
    }

    private void loadOrgUnit() {
        BaseDataSynTypeMapInfo baseDataType = (BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData();
        if (null == baseDataType) {
            this.prmtOrgUnit.setEnabled(false);
            return;
        }
        Context ctx = this.getUserContext();
        OrgType orgType = BaseDataSynValueMapEditUI.getOrgType(baseDataType);
        String orgId = this.editData.getOrgUnit();
        CommonUtil.fillOrgUnitF7(ctx, orgType, this.prmtOrgUnit, (CoreUI)this, orgId);
    }

    @Override
    public void storeFields() {
        this.editData.copyNewToOld();
        super.storeFields();
        OrgUnitInfo orgUnit = (OrgUnitInfo)this.prmtOrgUnit.getData();
        if (null != orgUnit) {
            String orgId = orgUnit.getId().toString();
            this.editData.setOrgUnit(orgId);
        }
        this.storeTableValue();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.cust_validate_passed()) {
            return;
        }
        this.checkDupNumber();
        if (this.isSaveCurrentData()) {
            this.removeUnCompletedLine();
            super.actionSave_actionPerformed(e);
        }
    }

    private boolean cust_validate_passed() throws Exception {
        if (CSCheck.chenkTxtFieldNotPassed(this.txtNumber, -1, "\u7f16\u7801")) {
            this.txtNumber.requestFocus();
            return false;
        }
        if (CSCheck.checkF7NotPassed(this.prmtBaseDataSynTypeMap.getData(), "\u57fa\u7840\u8d44\u6599\u540c\u6b65\u7c7b\u578b\u6620\u5c04")) {
            this.prmtBaseDataSynTypeMap.requestFocus();
            return false;
        }
        return true;
    }

    public void checkDupNumber() throws EASBizException, BOSException {
        this.checkDup("number", this.txtNumber.getText(), "\u7f16\u7801");
    }

    public void checkDup(String column, String fieldValue, String fieldName) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(column, (Object)fieldValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS));
        boolean isExist = BaseDataSynValueMapFactory.getRemoteInstance().exists(filter);
        if (isExist) {
            MsgBox.showInfo((String)(fieldName + " : " + fieldValue + "\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u3002"));
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        DataSourceType dsType;
        super.onLoad();
        if (this.prmtBaseDataSynTypeMap.getData() != null && DataSourceType.jdbc.equals((Object)(dsType = ((BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData()).getDsType())) && this.getOprtState().equals(OprtState.EDIT)) {
            this.btnUpdateDestData.setEnabled(true);
        }
        this.btnImport.setEnabled(true);
        this.btnExport.setEnabled(true);
        ComponentHelper.setVisible(new JComponent[]{this.btnAttachment, this.btnSubmit, this.btnFirst, this.btnPre, this.btnNext, this.btnLast, this.btnPrint, this.btnPrintPreview, this.btnWorkFlowG, this.btnCreateFrom, this.btnCreateTo, this.btnAuditResult, this.btnMultiapprove, this.btnNextPerson, this.btnInsertLine, this.btnAddLine, this.btnCopyLine}, false);
        this.prmtBaseDataSynTypeMap.setEditable(false);
        this.prmtOrgUnit.setEnabled(false);
        this.prmtBaseDataSynTypeMap.setAccessAuthority(0);
        this.prmtOrgUnit.setAccessAuthority(0);
        this.kdtEntrys.addAfterActionListener(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                switch (e.getType()) {
                    case 0: 
                    case 1: {
                        BaseDataSynValueMapEditUI.this.updatePrmtbaseDataTypeAndPrmtOrgUnit2EnableOrNot();
                        break;
                    }
                }
            }
        });
        this.prmtBaseDataSynTypeMap.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BaseDataSynValueMapEditUI.this.initPrmtOrgUnit();
                BaseDataSynTypeMapInfo BaseDataSynTypeMapInfo2 = (BaseDataSynTypeMapInfo)BaseDataSynValueMapEditUI.this.prmtBaseDataSynTypeMap.getData();
                if (BaseDataSynTypeMapInfo2 == null || !DataSourceType.jdbc.equals((Object)BaseDataSynTypeMapInfo2.getDsType())) {
                    BaseDataSynValueMapEditUI.this.btnUpdateDestData.setEnabled(false);
                } else {
                    BaseDataSynValueMapEditUI.this.btnUpdateDestData.setEnabled(true);
                }
                try {
                    BaseDataSynValueMapEditUI.this.initEntryTable();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.initEntryTable();
    }

    private void updatePrmtbaseDataTypeAndPrmtOrgUnit2EnableOrNot() {
        boolean enabled = 0 == this.kdtEntrys.getRowCount();
        this.prmtBaseDataSynTypeMap.setEnabled(enabled);
        this.prmtOrgUnit.setEnabled(enabled);
        if (null == this.prmtOrgUnit.getData()) {
            this.prmtOrgUnit.setEnabled(false);
        }
    }

    protected void initPrmtOrgUnit() {
        BaseDataSynTypeMapInfo baseDataType = (BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData();
        if (null != baseDataType) {
            OrgType orgType = BaseDataSynValueMapEditUI.getOrgType(baseDataType);
            CommonUtil.initOrgUnitF7(this.getUserContext(), orgType, this.prmtOrgUnit, (CoreUI)this);
        }
    }

    private static OrgType getOrgType(BaseDataSynTypeMapInfo baseDataType) {
        BaseDataInfo baseData = baseDataType.getSrcBaseData();
        IObjectPK pk = CommonUtil.convert2PK(baseData.getId().toString());
        try {
            baseData = BaseDataFactory.getRemoteInstance().getBaseDataInfo(pk);
        }
        catch (Exception e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        String queryName = baseData.getQueryName();
        OrgType orgType = CommonUtil.getOrgTypeByQueryName(queryName);
        return orgType;
    }

    protected void initEntryTable() throws ParserException, BOSException {
        BaseDataSynTypeMapInfo baseDataType = (BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData();
        if (null == baseDataType) {
            return;
        }
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setQueryInfo(BaseDataInfoUtil.getQueryName(baseDataType));
        promptBox.setVisible(true);
        promptBox.setEditable(true);
        promptBox.setDisplayFormat("$" + baseDataType.getSrcID() + "$");
        promptBox.setEditFormat("$" + baseDataType.getSrcID() + "$");
        promptBox.setCommitFormat("$" + baseDataType.getSrcID() + "$");
        EntityViewInfo ev = null;
        String where = this.srcWhere.getText();
        if (StringUtils.isEmpty((String)where)) {
            ev = new EntityViewInfo();
        } else {
            if (!StringUtils.startsWithIgnoreCase((String)where, (String)"where")) {
                where = " where " + where;
            }
            ev = new EntityViewInfo(where);
        }
        if (null == ev.getFilter()) {
            ev.setFilter(new FilterInfo());
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        this.filtWithOrgUnitInfo(fic);
        if (fic.size() > 0) {
            ev.getFilter().mergeFilter(filter, "AND");
        }
        promptBox.setEntityViewInfo(ev);
        IColumn destIDColumn = this.kdtEntrys.getColumn("srcID");
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)promptBox);
        destIDColumn.setEditor((ICellEditor)editor);
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat((IDataFormat)new BizDataFormat("$" + baseDataType.getSrcID() + "$"));
        destIDColumn.setRenderer((IBasicRender)render);
    }

    private void filtWithOrgUnitInfo(FilterItemCollection fic) {
        OrgUnitInfo orgUnitInfo;
        Object object;
        OrgUnitInfo cuid = (OrgUnitInfo)this.prmtOrgUnit.getData();
        if (null == cuid) {
            return;
        }
        BaseDataSynTypeMapInfo baseDataType = (BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData();
        if (null == baseDataType) {
            return;
        }
        String destOrgField = baseDataType.getSrcOrgField();
        if (StringUtils.isEmpty((String)destOrgField)) {
            return;
        }
        String orgUnitId = cuid.getId().toString();
        fic.add(new FilterItemInfo(destOrgField, (Object)orgUnitId, CompareType.EQUALS));
        OrgType orgType = BaseDataSynValueMapEditUI.getOrgType(baseDataType);
        if (this.isAccountBaseType(baseDataType) && OrgType.Company.equals((Object)orgType) && (object = (orgUnitInfo = (OrgUnitInfo)this.prmtOrgUnit.getData()).get("accounttable")) != null) {
            try {
                String accountTableIDValue = this.getAccountTableInfoId(object);
                fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTableIDValue, CompareType.EQUALS));
                fic.add(new FilterItemInfo("isleaf", (Object)1, CompareType.EQUALS));
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
    }

    private String getAccountTableInfoId(Object object) {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.kingdee.eas.basedata.master.account.AccountTableInfo");
            Method getId = clazz.getMethod("getId", new Class[0]);
            BOSUuid bosUuid = (BOSUuid)getId.invoke(object, new Object[0]);
            return bosUuid.toString();
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
            return null;
        }
    }

    private boolean isAccountBaseType(BaseDataSynTypeMapInfo baseDataType) {
        BaseDataInfo baseDataInfo = baseDataType.getSrcBaseData();
        if (null != baseDataInfo) {
            try {
                String id = baseDataInfo.getId().toString();
                BaseDataInfo o = BaseDataFactory.getRemoteInstance().getBaseDataInfo((IObjectPK)new ObjectUuidPK(id));
                if (null != o) {
                    return "com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery".equalsIgnoreCase(o.getQueryName());
                }
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
        return false;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BaseDataSynValueMapEntryInfo baseDataSynValueMapEntryInfo = new BaseDataSynValueMapEntryInfo();
        return baseDataSynValueMapEntryInfo;
    }

    protected void loadTableValue() {
        BaseDataSynTypeMapInfo BaseDataSynTypeMapInfo2 = (BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData();
        if (null == BaseDataSynTypeMapInfo2) {
            return;
        }
        try {
            String srcDisplay = BaseDataSynTypeMapInfo2.getSrcDisplay();
            Set<String> idSet = this.getFidSet();
            if (idSet.isEmpty()) {
                return;
            }
            Map<String, CoreBaseInfo> map = BaseDataMappingUtil.convertFid2CoreBase(idSet);
            if (map == null) {
                return;
            }
            int n = this.kdtEntrys.getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow iRow = this.kdtEntrys.getRow(i);
                String fid = String.valueOf(iRow.getCell("srcID").getValue());
                CoreBaseInfo coreBase = map.get(fid);
                if (coreBase == null) continue;
                iRow.getCell("srcID").setValue((Object)coreBase);
                Object value = coreBase.get(srcDisplay);
                iRow.getCell("srcDisplay").setValue(value);
                iRow.getCell("destNum").setValue((Object)coreBase.getId().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Set<String> getFidSet() {
        HashSet<String> idSet = new HashSet<String>();
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            String destID = String.valueOf(this.kdtEntrys.getCell(i, "srcID").getValue());
            if (StringUtils.isEmpty((String)destID)) {
                destID = String.valueOf(this.kdtEntrys.getCell(i, "srcID").getValue());
            }
            if (StringUtils.isEmpty((String)destID)) continue;
            idSet.add(destID);
        }
        return idSet;
    }

    @Override
    protected void kdtEntrys_editStoped(KDTEditEvent e) throws Exception {
        if (e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
            int index = e.getRowIndex();
            ICell srcDisplayCell = this.kdtEntrys.getCell(index, "srcDisplay");
            ICell srcIDCell = this.kdtEntrys.getCell(index, "srcID");
            IObjectValue srcID = (IObjectValue)srcIDCell.getValue();
            BaseDataSynTypeMapInfo BaseDataSynTypeMapInfo2 = (BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData();
            String srcDisplay = BaseDataSynTypeMapInfo2.getSrcDisplay();
            String value = UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)srcID, (String)srcDisplay));
            srcDisplayCell.setValue((Object)value);
            ICell temp = this.kdtEntrys.getCell(index, "destNum");
            temp.setValue((Object)UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)srcID, (String)"id")));
        } else if (e.getValue() == null) {
            int index = e.getRowIndex();
            ICell srcDisplayCell = this.kdtEntrys.getCell(index, "srcDisplay");
            srcDisplayCell.setValue(null);
            ICell temp = this.kdtEntrys.getCell(index, "destNum");
            temp.setValue(null);
        }
    }

    protected void storeTableValue() {
        int result;
        BaseDataSynValueMapEntryCollection coll = this.editData.getEntrys();
        BaseDataSynTypeMapInfo BaseDataSynTypeMapInfo2 = (BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData();
        HashMap<Object, CoreBaseInfo> map = new HashMap<Object, CoreBaseInfo>();
        IRow iRow = null;
        int errorCount = 0;
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            iRow = this.kdtEntrys.getRow(i);
            Object object = iRow.getCell("srcID").getValue();
            if (object != null && object instanceof CoreBaseInfo) {
                CoreBaseInfo info = (CoreBaseInfo)iRow.getCell("srcID").getValue();
                map.put(info.getId().toString(), info);
                continue;
            }
            ++errorCount;
            map.put(object, null);
        }
        if (errorCount > 0 && (result = MsgBox.showConfirm2((String)"\u90e8\u5206\u201c\u5f53\u524d\u7cfb\u7edf\u5b57\u6bb5\u503c\u201d\u4e0d\u5b58\u5728\uff0c\u5df2\u6e05\u7a7a\u3002\u5982\u679c\u9700\u8981\u5220\u9664\u8fd9\u4e9b\u76ee\u6807\u7cfb\u7edf\u503c\u4e3a\u7a7a\u7684\u884c\uff0c\u8bf7\u70b9\u201c\u786e\u5b9a\u201d\u3002\n\u5982\u679c\u9700\u8981\u7ef4\u62a4\u76ee\u6807\u7cfb\u7edf\u503c\u4e3a\u7a7a\u7684\u884c\uff0c\u8bf7\u70b9\u201c\u53d6\u6d88\u201d\uff0c\u7136\u540e\u901a\u8fc7\u5bf9\u76ee\u6807\u7cfb\u7edf\u503c\u8fdb\u884c\u6392\u5e8f\u627e\u5230\u4e3a\u7a7a\u7684\u884c\u3002")) == 2) {
            SysUtil.abort();
        }
        BaseDataSynValueMapEntryInfo baseDataMapingEntryInfo = null;
        int n2 = coll.size();
        for (int i = 0; i < n2; ++i) {
            baseDataMapingEntryInfo = coll.get(i);
            if (map.get(baseDataMapingEntryInfo.getDestNum()) == null) continue;
            CoreBaseInfo coreBaseInfo = (CoreBaseInfo)map.get(baseDataMapingEntryInfo.getDestNum());
            baseDataMapingEntryInfo.setSrcID(coreBaseInfo.getId().toString());
            baseDataMapingEntryInfo.setSrcDisplay(coreBaseInfo.get(BaseDataSynTypeMapInfo2.getSrcDisplay()).toString());
        }
    }

    private boolean isSaveCurrentData() {
        int rowNumber = this.kdtEntrys.getRowCount();
        HashSet<String> srcIdSet = new HashSet<String>();
        HashSet<String> repectSrcId = new HashSet<String>();
        int result = -1;
        boolean flag = false;
        for (int i = 0; i < rowNumber; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            Object value = row.getCell("srcID").getValue();
            if (value != null && value instanceof CoreBaseInfo) {
                value = ((CoreBaseInfo)value).getId().toString();
            }
            if (value != null && !srcIdSet.add(value.toString())) {
                repectSrcId.add(value.toString());
            }
            if (flag || !this.checkCellIsNoValue(row, "srcID") && !this.checkCellIsNoValue(row, "destID")) continue;
            result = MsgBox.showConfirm2New((Component)((Object)this), (String)"\u4fdd\u5b58\u65f6\u4f1a\u81ea\u52a8\u5220\u9664\u6e90\u7cfb\u7edf\u6807\u8bc6\u503c\u6216\u76ee\u6807\u7cfb\u7edf\u6807\u8bc6\u503c\u4e3a\u7a7a\u7684\u884c\u3002\u4fdd\u5b58\u540e\u53ef\u4ee5\u901a\u8fc7\u70b9\u51fb\u66f4\u65b0\u6e90\u7cfb\u7edf\u6570\u636e\u91cd\u65b0\u5217\u51fa\u5df2\u5220\u9664\u7684\u884c\u3002\u786e\u5b9a\u4fdd\u5b58\uff1f");
            flag = true;
        }
        if (repectSrcId.size() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u5f53\u524d\u7cfb\u7edf\u6807\u8bc6\u5b58\u5728\u91cd\u590d\u503c\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)((Object)repectSrcId).toString(), (int)1);
            return false;
        }
        if (flag) {
            return 0 == result;
        }
        return true;
    }

    private boolean checkCellIsNoValue(IRow row, String key) {
        ICell cell = row.getCell(key);
        return null == cell || null == cell.getValue();
    }

    private void removeUnCompletedLine() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int rowNumber = this.kdtEntrys.getRowCount();
        for (int i = 0; i < rowNumber; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            if (null == row || !this.checkCellIsNoValue(row, "srcID") && !this.checkCellIsNoValue(row, "destID")) continue;
            list.add(i);
        }
        Object[] selectRowsIndex = list.toArray(new Integer[0]);
        Arrays.sort(selectRowsIndex);
        for (int i = selectRowsIndex.length - 1; i >= 0; --i) {
            MyKDTableUtil.removeRow(this.kdtEntrys, (Integer)selectRowsIndex[i]);
        }
    }

    @Override
    public void updateDestSysData_actionPerformed(ActionEvent e) throws Exception {
        BaseDataSynTypeMapInfo BaseDataSynTypeMapInfo2 = (BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData();
        if (null == BaseDataSynTypeMapInfo2) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u57fa\u7840\u8d44\u6599\u540c\u6b65\u7c7b\u578b\u6620\u5c04");
            this.prmtBaseDataSynTypeMap.requestFocus();
            return;
        }
        this.BaseDataSynTypeMapInfo = BaseDataSynTypeMapInfo2;
        IConnection connection = ConnectionFactory.getRemoteInstance();
        this.conn = BaseDataSynTypeMapInfo2.getConn();
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(this.conn.getId().toString());
        }
        catch (NullPointerException ex) {
            MsgBox.showInfo((String)"\u6240\u9009\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e2d\u5f15\u7528\u7684\u8fde\u63a5\u5df2\u4e0d\u5b58\u5728\u3002");
            return;
        }
        if (!connection.exists((IObjectPK)pk)) {
            MsgBox.showInfo((String)"\u6240\u9009\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e2d\u5f15\u7528\u7684\u8fde\u63a5\u5df2\u4e0d\u5b58\u5728\u3002");
            return;
        }
        this.conn = connection.getConnectionInfo((IObjectPK)new ObjectUuidPK(this.conn.getId().toString()));
        ISQLFacade intance = SQLFacadeFactory.getRemoteInstance();
        Object rs = null;
        String normalMsg = "\u6b63\u5728\u83b7\u53d6\u6570\u636e";
        final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", "\u6b63\u5728\u83b7\u53d6\u6570\u636e,\u8bf7\u7a0d\u540e...");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec() throws Exception {
                try {
                    DBType type = BaseDataSynValueMapEditUI.this.conn.getDBType();
                    int dbType = 0;
                    if (DBType.Oracle.equals((Object)type)) {
                        dbType = 2;
                    } else if (DBType.DB2.equals((Object)type)) {
                        dbType = 1;
                    } else if (DBType.SQLServer.equals((Object)type)) {
                        dbType = 3;
                    }
                    ISQLFacade intance = SQLFacadeFactory.getRemoteInstance();
                    IRowSet rs = null;
                    dialog.updateMsg("\u6b63\u5728\u83b7\u53d6\u6570\u636e(1/1)");
                    String sql = TransUtil.Translate((String)BaseDataSynValueMapEditUI.this.getSrcSql((BaseDataSynTypeMapInfo)BaseDataSynValueMapEditUI.this.prmtBaseDataSynTypeMap.getData(), 1, 0), (int)dbType);
                    rs = intance.getTargetRowset(BaseDataSynValueMapEditUI.this.conn, sql);
                    BaseDataSynValueMapEditUI.this.updateEntryTable(rs);
                    String string = "success";
                    return string;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.exception = exc;
                    String string = "fail";
                    return string;
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (this.exception != null) {
                    MsgBox.showDetailAndOK((Component)((Object)dialog), (String)"\u66f4\u65b0\u6e90\u7cfb\u7edf\u6570\u636e\u5931\u8d25\u3002", (String)ThrowableHelper.toString(this.exception), (int)1);
                }
            }
        });
        dialog.show();
    }

    private String getSrcSql(BaseDataSynTypeMapInfo baseDataSynTypeMapInfo, int pageSize, int page) {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct ");
        sql.append(baseDataSynTypeMapInfo.getDestID());
        if (baseDataSynTypeMapInfo.getSrcDisplay() != null) {
            sql.append(",");
            sql.append(baseDataSynTypeMapInfo.getDestDisplay());
        }
        sql.append(" from " + baseDataSynTypeMapInfo.getDestTable() + " ");
        String srcWhere = this.destWhere.getText();
        if (!StringUtils.isEmpty((String)srcWhere)) {
            int beginIndex = 0;
            for (int i = 0; i < srcWhere.length(); ++i) {
                if (" ".equals(String.valueOf(srcWhere.charAt(i)))) {
                    ++beginIndex;
                    continue;
                }
                srcWhere = srcWhere.substring(beginIndex);
                break;
            }
            if (!StringUtils.startsWithIgnoreCase((String)srcWhere, (String)"where")) {
                srcWhere = " where " + srcWhere;
            }
        }
        if (!StringUtils.isEmpty((String)srcWhere)) {
            srcWhere = srcWhere.trim();
            sql.append(srcWhere);
        }
        sql.append(" order by " + baseDataSynTypeMapInfo.getDestID() + " ");
        return sql.toString();
    }

    private void updateEntryTable(IRowSet rowset) throws SQLException {
        List srcIDList = this.getSrcIDRowList();
        if (null != rowset) {
            while (rowset.next()) {
                if (srcIDList.contains(rowset.getString(1))) continue;
                IRow iRow = this.kdtEntrys.addRow();
                iRow.getCell("destID").setValue((Object)rowset.getString(1));
                iRow.getCell("destDisplay").setValue((Object)rowset.getString(2));
            }
        }
    }

    private List getSrcIDRowList() {
        ArrayList srcIDList = new ArrayList();
        Set<Object> set = new HashSet<Object>();
        int entryCount = this.kdtEntrys.getRowCount();
        for (int i = 0; i < entryCount; ++i) {
            set.add(this.kdtEntrys.getCell(i, "destID").getValue());
        }
        set = this.getSrcIDRowListFromTable(set);
        srcIDList.addAll(set);
        return srcIDList;
    }

    private Set getSrcIDRowListFromTable(Set set) {
        if (set == null) {
            set = new HashSet<String>();
        }
        BaseDataSynTypeMapInfo typeInfo = (BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData();
        try {
            FilterItemInfo filterItem;
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            BOSUuid id = this.editData.getId();
            if (id != null) {
                filterItem = new FilterItemInfo("id", (Object)id.toString(), CompareType.NOTEQUALS);
                view.getFilter().getFilterItems().add(filterItem);
            }
            filterItem = new FilterItemInfo("baseDataType.id", (Object)typeInfo.getId().toString(), CompareType.EQUALS);
            view.getFilter().getFilterItems().add(filterItem);
            BaseDataSynValueMapCollection coll = BaseDataSynValueMapFactory.getRemoteInstance().getBaseDataSynValueMapCollection(view);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                BaseDataSynValueMapInfo mapping = (BaseDataSynValueMapInfo)it.next();
                Iterator entries = mapping.getEntrys().iterator();
                while (entries.hasNext()) {
                    BaseDataSynValueMapEntryInfo entry = (BaseDataSynValueMapEntryInfo)entries.next();
                    set.add(entry.getDestID());
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return set;
    }

    @Override
    public void importAction_actionPerformed(ActionEvent e) throws Exception {
        if (CSCheck.checkF7NotPassed(this.prmtBaseDataSynTypeMap.getData(), "\u57fa\u7840\u8d44\u6599\u540c\u6b65\u7c7b\u578b\u6620\u5c04")) {
            this.prmtBaseDataSynTypeMap.requestFocus();
            return;
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        HashMap<String, BaseDataSynValueMapEditUI> uiContext = new HashMap<String, BaseDataSynValueMapEditUI>();
        uiContext.put("Owner", this);
        HashMap dataObjects = new HashMap();
        IUIWindow uiWindow = uiFactory.create(BaseDataMappingImportUI.class.getName(), uiContext, dataObjects, OprtState.ADDNEW);
        BaseDataMappingImportUI baseDataMappingImportUI = (BaseDataMappingImportUI)uiWindow.getUIObject();
        baseDataMappingImportUI.builderInfo(DataFile.class, "BaseDataSynValueMapExportTemplate.xls", "\u57fa\u7840\u8d44\u6599\u540c\u6b65\u503c\u6620\u5c04");
        uiWindow.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportAction_actionPerformed(ActionEvent e) throws Exception {
        if (CSCheck.checkF7NotPassed(this.prmtBaseDataSynTypeMap.getData(), "\u57fa\u7840\u8d44\u6599\u540c\u6b65\u7c7b\u578b\u6620\u5c04")) {
            this.prmtBaseDataSynTypeMap.requestFocus();
            return;
        }
        File file = Export2FileUtil.getExportFileWithOverrideTip((Component)((Object)this), "\u57fa\u7840\u8d44\u6599\u540c\u6b65\u503c\u6620\u5c04\u5bfc\u51fa", "\u4fdd\u5b58", new String[]{"xls"}, "Excel 1997\u62162003\u7248\u672c", "\u57fa\u7840\u8d44\u6599\u540c\u6b65\u503c\u6620\u5c04\u5bfc\u51fa.xls");
        if (null == file) {
            return;
        }
        MarshallingContext marshallingContext = DefaultStream.getInstance().getMarshallingContext();
        WritableWorkbook writableWorkbook = null;
        InputStream is = null;
        try {
            is = DataFile.class.getResourceAsStream("BaseDataSynValueMapExportTemplate.xls");
            Workbook copy = Workbook.getWorkbook((InputStream)is);
            writableWorkbook = Workbook.createWorkbook((File)file, (Workbook)copy);
            marshallingContext.put("WritableWorkbook", writableWorkbook);
            marshallingContext.put("kdtEntrys", this.kdtEntrys);
            marshallingContext.marshall(this.getDataObject());
            writableWorkbook.write();
            MsgBox.showInfo((Component)((Object)this), (String)"\u57fa\u7840\u8d44\u6599\u540c\u6b65\u503c\u6620\u5c04\u5bfc\u51fa\u6210\u529f\u3002");
        }
        catch (Exception ex) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u57fa\u7840\u8d44\u6599\u540c\u6b65\u503c\u6620\u5c04\u5bfc\u51fa\u5931\u8d25\u3002", (String)ex.getMessage(), (int)8188);
        }
        finally {
            marshallingContext.remove("WritableWorkbook");
            marshallingContext.remove("kdtEntrys");
            try {
                if (null != writableWorkbook) {
                    writableWorkbook.close();
                }
            }
            catch (Exception ex) {}
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    public void loadDataFromExcel(String filePath) throws Exception {
        FILE_PATH = filePath;
        if (null != UI_WINDOW) {
            UI_WINDOW.close();
        }
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", "\u6b63\u5728\u5bfc\u5165\u57fa\u7840\u8d44\u6599,\u8bf7\u7a0d\u540e...");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec() throws Exception {
                HashMap valueMap = new HashMap();
                HashMap<String, String> rowMap = new HashMap<String, String>();
                ArrayList<String> importIdList = new ArrayList<String>();
                try {
                    String[] lineData;
                    int i;
                    String[][] execlData = ExcelHelper.getStringData(FILE_PATH, 0, 0, Integer.MAX_VALUE, 0, 3);
                    BaseDataSynTypeMapInfo BaseDataSynTypeMapInfo2 = (BaseDataSynTypeMapInfo)BaseDataSynValueMapEditUI.this.prmtBaseDataSynTypeMap.getData();
                    String srcDisplay = BaseDataSynTypeMapInfo2.getSrcDisplay();
                    for (i = 1; i < execlData.length; ++i) {
                        lineData = execlData[i];
                        if (CommonUtil.isBlankLineData(lineData)) continue;
                        rowMap.put(lineData[2], lineData[0]);
                        importIdList.add(lineData[2]);
                    }
                    if (importIdList.size() != 0) {
                        BaseDataSynValueMapEditUI.this.getEntryBaseDataInfos(valueMap, rowMap, importIdList);
                        for (i = 1; i < execlData.length; ++i) {
                            lineData = execlData[i];
                            if (CommonUtil.isBlankLineData(lineData)) continue;
                            IRow iRow = BaseDataSynValueMapEditUI.this.kdtEntrys.addRow();
                            iRow.getCell("destID").setValue((Object)lineData[0]);
                            iRow.getCell("destDisplay").setValue((Object)lineData[1]);
                            IObjectValue ojectValue = (IObjectValue)valueMap.get(lineData[2]);
                            if (null == ojectValue) continue;
                            iRow.getCell("srcID").setValue((Object)ojectValue);
                            String value = UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)ojectValue, (String)srcDisplay));
                            iRow.getCell("srcDisplay").setValue((Object)value);
                            String id = UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)ojectValue, (String)"id"));
                            iRow.getCell("destNum").setValue((Object)id);
                        }
                    }
                    String string = "success";
                    return string;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.exception = exc;
                    String string = "fail";
                    return string;
                }
                finally {
                    valueMap.clear();
                    rowMap.clear();
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (null != this.exception) {
                    MsgBox.showError((String)"\u57fa\u7840\u8d44\u6599\u5bfc\u5165\u5931\u8d25\uff1a", (String)this.exception.getMessage());
                } else {
                    MsgBox.showInfo((String)"\u57fa\u7840\u8d44\u6599\u5bfc\u5165\u6210\u529f\u3002");
                }
            }
        });
        dialog.show();
    }

    private void getEntryBaseDataInfos(Map<String, IObjectValue> valueMap, Map<String, String> rowMap, List srcIDList) throws Exception {
        BaseDataSynTypeMapInfo BaseDataSynTypeMapInfo2 = (BaseDataSynTypeMapInfo)this.prmtBaseDataSynTypeMap.getData();
        String queryName = BaseDataInfoUtil.getQueryName(BaseDataSynTypeMapInfo2);
        MetaDataPK queryPK = MetaDataPK.create((String)queryName);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)queryPK, (Context)this.getMainOrgContext());
        IFilterInfoProducer producer = FilterInfoProducerFactory.getControlTypeFilterInfoProducer((String)queryName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)queryPK);
        SelectorItemCollection sic = new SelectorItemCollection();
        ArrayList resultArray = new ArrayList();
        try {
            SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
            SubEntityInfo mainEntityInfo = null;
            if (mainObjectInfo instanceof SubEntityInfo) {
                mainEntityInfo = (SubEntityInfo)mainObjectInfo;
                mainEntityInfo.getEntityRef();
            }
            BOSObjectType type = null;
            if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
                type = mainEntityInfo.getEntityRef().getType();
            }
            int listSize = srcIDList.size();
            int page = listSize / DESC_MATCH_MAX_SIZE;
            int expl = listSize % DESC_MATCH_MAX_SIZE;
            if (expl > 0) {
                ++page;
            }
            List tmpList = null;
            int endSize = 0;
            int i = 0;
            IDynamicObject instance = DynamicObjectFactory.getRemoteInstance();
            for (i = 0; i < page; ++i) {
                endSize = (i + 1) * DESC_MATCH_MAX_SIZE > listSize ? listSize : (i + 1) * DESC_MATCH_MAX_SIZE;
                tmpList = srcIDList.subList(i * DESC_MATCH_MAX_SIZE, endSize);
                FilterInfo filter = (FilterInfo)producer.getFilterInfo().clone();
                FilterItemInfo filterItem = new FilterItemInfo();
                filterItem.setPropertyName(BaseDataSynTypeMapInfo2.getSrcID());
                filterItem.setCompareValue((Object)tmpList.toString());
                filterItem.setCompareType(CompareType.INCLUDE);
                filter.getFilterItems().add(filterItem);
                EntityViewInfo view = null;
                String where = this.srcWhere.getText();
                view = StringUtils.isEmpty((String)where) ? new EntityViewInfo() : new EntityViewInfo(where);
                if (null == view.getFilter()) {
                    view.setFilter(new FilterInfo());
                }
                this.filtWithOrgUnitInfo(filter.getFilterItems());
                if (filter.getFilterItems().size() > 0) {
                    view.getFilter().mergeFilter(filter, "AND");
                }
                exec.setObjectView(view);
                IObjectCollection coll = instance.getCollection(type, view);
                int count = coll.size();
                for (int j = 0; j < count; ++j) {
                    IObjectValue object = coll.getObject(j);
                    String number = String.valueOf(object.get(BaseDataSynTypeMapInfo2.getSrcID()));
                    if (!srcIDList.contains(number) || valueMap.containsKey(number)) continue;
                    valueMap.put(number, object);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnUpdateDestData.setEnabled(true);
    }
}

