/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynExecuteAPIFacadeFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynExecuteAPIFacade;
import com.kingdee.eas.csinterface.basedatasyn.client.AbstractInitBaseDataPKTableUI;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class InitBaseDataPKTableUI
extends AbstractInitBaseDataPKTableUI {
    private static final Logger logger = CoreUIObject.getLogger(InitBaseDataPKTableUI.class);
    private String connNum = null;
    private String agentNum = null;
    private String userNum = null;
    private String dbType = null;
    private List<String> planNumList = null;

    public InitBaseDataPKTableUI() throws Exception {
        this.typeCombox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InitBaseDataPKTableUI.this.dsTypeChanged();
            }
        });
    }

    private void dsTypeChanged() {
        DataSourceType dsType = (DataSourceType)((Object)this.typeCombox.getSelectedItem());
        if (dsType == null) {
            return;
        }
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            this.agentTxt.setValue(null);
            this.agentTxt.setEnabled(false);
            this.connTxt.setEnabled(true);
            this.connTxt.setRequired(true);
        } else if (DataSourceType.agent.equals((Object)dsType)) {
            this.connTxt.setValue(null);
            this.connTxt.setEnabled(false);
            this.agentTxt.setEnabled(true);
            this.agentTxt.setRequired(true);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8d44\u6e90\u7c7b\u522b'" + dsType.getAlias() + "'");
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.typeCombox.removeItem((Object)DataSourceType.file);
        this.typeCombox.setSelectedIndex(0);
        this.btnUpgrade.setEnabled(true);
        this.btnInitData.setEnabled(true);
        this.initPlanList();
        this.setTableColumnsLocked();
    }

    private void setTableColumnsLocked() {
        this.setColumnLocked("number");
        this.setColumnLocked("name");
        this.setColumnLocked("desc");
        this.setColumnLocked("sql");
    }

    private void setColumnLocked(String columnName) {
        MyKDTableUtil.setColumnLocked(this.tblMain, columnName);
        MyKDTableUtil.setColumnLockedBackground(this.tblMain, columnName);
    }

    protected void onNoResult() {
        super.onNoResult();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnExecute.setEnabled(true);
    }

    @Override
    protected void selectAll_actionPerformed(ActionEvent e) throws Exception {
        super.selectAll_actionPerformed(e);
        this.selectAllPlan(true);
    }

    @Override
    protected void unSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.unSelectAll_actionPerformed(e);
        this.selectAllPlan(false);
    }

    private void selectAllPlan(boolean value) {
        int rowCount = this.tblMain.getRowCount();
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            row.setChange(true);
            row.getCell("check").setValue((Object)value);
        }
    }

    private void initPlanList() throws Exception {
        ArrayList<Object[]> kdTableDataList = new ArrayList<Object[]>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("number");
        selector.add("name");
        selector.add("description");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("planLevel", (Object)"0", CompareType.EQUALS));
        view.setSelector(selector);
        view.setFilter(filter);
        BaseDataSynHeadCollection planColl = BaseDataSynHeadFactory.getRemoteInstance().getBaseDataSynHeadCollection(view);
        Iterator planIte = planColl.iterator();
        while (planIte.hasNext()) {
            BaseDataSynHeadInfo plan = (BaseDataSynHeadInfo)planIte.next();
            Object[] columnValues = new Object[]{false, plan.getNumber(), plan.getName(), plan.getDescription()};
            kdTableDataList.add(columnValues);
        }
        KDTableHelper.initTable((KDTable)this.tblMain, null, (Object[][])null, (Object[][])((Object[][])kdTableDataList.toArray((T[])new Object[0][0])));
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.reLayoutAndPaint();
        this.tblMain.setRowCount(kdTableDataList.size());
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    protected void initAnyway_actionPerformed(ActionEvent e) throws Exception {
        super.initAnyway_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void updateData_actionPerformed(ActionEvent e) throws Exception {
        super.updateData_actionPerformed(e);
        this.connNum = null;
        this.agentNum = null;
        this.userNum = null;
        this.dbType = null;
        this.planNumList = null;
        ConnectionInfo connInfo = (ConnectionInfo)this.connTxt.getValue();
        EipUserInfo agentInfo = (EipUserInfo)this.agentTxt.getValue();
        DataSourceType dsType = (DataSourceType)((Object)this.typeCombox.getSelectedItem());
        this.dbType = dsType.getValue();
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            if (connInfo == null) {
                MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u8fde\u63a5");
                SysUtil.abort();
            }
            this.connNum = connInfo.getNumber();
        } else if (DataSourceType.agent.equals((Object)dsType)) {
            if (agentInfo == null) {
                MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u5ba2\u6237\u7aef\u4ee3\u7406");
                SysUtil.abort();
            }
            this.agentNum = agentInfo.getNumber();
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8d44\u6e90\u7c7b\u522b'" + dsType.getAlias() + "'");
        }
        this.userNum = this.userList.getText();
        this.planNumList = new ArrayList<String>();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Boolean hasCheck;
            IRow row = this.tblMain.getRow(i);
            if (!row.isChange() || !(hasCheck = Boolean.valueOf(row.getCell("check").getValue().toString())).booleanValue()) continue;
            String number = String.valueOf(row.getCell("number").getValue());
            this.planNumList.add(number);
        }
        if (this.planNumList.size() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u9700\u8981\u540c\u6b65\u7684\u65b9\u6848\u5217\u8868");
            SysUtil.abort();
        }
        String normalMsg = "\u6b63\u5728\u6267\u884c\u57fa\u7840\u8d44\u6599\u540c\u6b65\u521d\u59cb\u5316";
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", normalMsg + ",\u8bf7\u7a0d\u540e...");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;

            @Override
            public Object exec() throws Exception {
                try {
                    IBaseDataSynExecuteAPIFacade instance = BaseDataSynExecuteAPIFacadeFactory.getRemoteInstance();
                    instance.initBaseDataPlanPKTable(InitBaseDataPKTableUI.this.planNumList, InitBaseDataPKTableUI.this.initAnyway.isSelected(), 0, InitBaseDataPKTableUI.this.dbType, InitBaseDataPKTableUI.this.connNum, InitBaseDataPKTableUI.this.agentNum, InitBaseDataPKTableUI.this.userNum, null, null);
                    String string = "success";
                    return string;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.exception = exc;
                    String string = "fail";
                    return string;
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (null == this.exception) {
                    MsgBox.showInfo((String)"\u57fa\u7840\u8d44\u6599\u65b9\u6848\u521d\u59cb\u5316\u6210\u529f");
                } else {
                    Exception cause = this.exception;
                    MsgBox.showDetailAndOK((Component)InitBaseDataPKTableUI.this.tblMain, (String)"\u57fa\u7840\u8d44\u6599\u65b9\u6848\u521d\u59cb\u5316\u5931\u8d25", (String)ThrowableHelper.toString((Throwable)cause), (int)1);
                }
            }
        });
        dialog.show();
    }

    @Override
    public void upgradePKTable_actionPerformed(ActionEvent e) throws Exception {
        super.upgradePKTable_actionPerformed(e);
        String normalMsg = "\u6b63\u5728\u6267\u884c\u57fa\u7840\u8d44\u6599\u540c\u6b65\u589e\u91cf\u8868\u7ed3\u6784\u5347\u7ea7";
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", normalMsg + ",\u8bf7\u7a0d\u540e...");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            String resultMsg = "";
            long totalTimes = 0L;
            private Exception exception;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec() throws Exception {
                try {
                    long beginTime = System.currentTimeMillis();
                    this.resultMsg = BaseDataSynExecuteAPIFacadeFactory.getRemoteInstance().upgradePKTable();
                    long endTime = System.currentTimeMillis();
                    this.totalTimes = endTime - beginTime;
                    String string = "success";
                    return string;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.exception = exc;
                    String string = "fail";
                    return string;
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (null == this.exception) {
                    MsgBox.showDetailAndOK((Component)InitBaseDataPKTableUI.this.tblMain, (String)("\u5347\u7ea7\u6210\u529f\uff0c\u5171\u8017\u65f6\uff1a" + this.totalTimes + "ms"), (String)this.resultMsg, (int)1);
                } else {
                    Exception cause = this.exception;
                    MsgBox.showDetailAndOK((Component)InitBaseDataPKTableUI.this.tblMain, (String)"\u5347\u7ea7\u5931\u8d25", (String)ThrowableHelper.toString((Throwable)cause), (int)1);
                }
            }
        });
        dialog.show();
    }

    @Override
    public void btnInitTableData_actionPerformed(ActionEvent e) throws Exception {
        super.btnInitTableData_actionPerformed(e);
        String normalMsg = "\u6b63\u5728\u6267\u884c\u57fa\u7840\u8d44\u6599\u540c\u6b65\u589e\u91cf\u8868\u6570\u636e\u521d\u59cb\u5316";
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", normalMsg + ",\u8bf7\u7a0d\u540e...");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            String resultMsg = "";
            long totalTimes = 0L;
            private Exception exception;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec() throws Exception {
                try {
                    long beginTime = System.currentTimeMillis();
                    this.resultMsg = BaseDataSynExecuteAPIFacadeFactory.getRemoteInstance().upgradePKTableData();
                    long endTime = System.currentTimeMillis();
                    this.totalTimes = endTime - beginTime;
                    String string = "success";
                    return string;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.exception = exc;
                    String string = "fail";
                    return string;
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (null == this.exception) {
                    MsgBox.showDetailAndOK((Component)InitBaseDataPKTableUI.this.tblMain, (String)("\u521d\u59cb\u5316\u5347\u7ea7\u6210\u529f\uff0c\u5171\u8017\u65f6\uff1a" + this.totalTimes + "ms"), (String)this.resultMsg, (int)1);
                } else {
                    Exception cause = this.exception;
                    MsgBox.showDetailAndOK((Component)InitBaseDataPKTableUI.this.tblMain, (String)"\u521d\u59cb\u5316\u5347\u7ea7\u5931\u8d25", (String)ThrowableHelper.toString((Throwable)cause), (int)1);
                }
            }
        });
        dialog.show();
    }

    protected String getKeyFieldName() {
        return "number";
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

