/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.extract;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.csinterface.biz.DataSourceInfo;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.exception.EIPException;
import com.kingdee.eas.csinterface.biz.extract.AbstractDataBaseExtract;
import com.kingdee.eas.csinterface.biz.extract.OperateStatus;
import com.kingdee.eas.csinterface.biz.model.PKTable;
import com.kingdee.eas.csinterface.biz.model.SQLBuilder;
import com.kingdee.eas.csinterface.biz.util.DBUtils;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataBaseExtract
extends AbstractDataBaseExtract {
    @Override
    public TableData getSrcData(List<String> pkList, OperateStatus actionType) throws BOSException {
        TableData tableData = new TableData();
        try {
            if (pkList.isEmpty()) {
                return tableData;
            }
            Map<String, String> dataSourceResult = this.getDataSourceResult();
            DataSourceInfo dataSourceInfo = this.getDataSourceInfo();
            ConnectionInfo conn = this.getConnectionInfo();
            String mainView = dataSourceInfo.getMainView();
            SQLBuilder allDataSql = SQLBuilder.getInstance();
            SQLBuilder.Table mainTable = allDataSql.addATable(mainView);
            if (OperateStatus.DELETE.equals((Object)actionType)) {
                String headPK = dataSourceResult.get("headpk");
                mainTable.addColumn(headPK);
                tableData.addColumn(headPK);
            } else {
                String[] fields;
                String headFields = dataSourceResult.get("headFields");
                String entryFields = dataSourceResult.get("entryFields");
                for (String field : fields = (headFields + "," + entryFields).split(",")) {
                    if (StringUtils.isEmpty((String)field) || "null".equalsIgnoreCase(field)) continue;
                    mainTable.addColumn(field);
                    tableData.addColumn(field);
                }
            }
            StringBuilder newFilter = new StringBuilder(dataSourceResult.get("headpk")).append(" in (");
            for (int i = 0; i < pkList.size(); ++i) {
                newFilter.append("'").append(pkList.get(i)).append("'");
                if (i >= pkList.size() - 1) continue;
                newFilter.append(",");
            }
            newFilter.append(")");
            mainTable.appendFilter(newFilter.toString());
            IRowSet rows = DBUtils.executeQuery(conn, allDataSql.toSql());
            int size = tableData.getCloumnModels().size();
            while (rows.next()) {
                for (int i = 0; i < size; ++i) {
                    tableData.addData(rows.getString(i + 1));
                }
                tableData.enter();
            }
            SQLUtils.cleanup((ResultSet)rows);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableData;
    }

    @Override
    public Map<String, List<String>> getMainPkList() throws BOSException, SQLException {
        boolean isDelete;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        EIPContext eipContext = EIPContext.getInstance();
        ProjectInfo projectInfo = (ProjectInfo)eipContext.get("projectInfo");
        String targetFunc = projectInfo.getTargetFunc();
        JSONObject funcObj = JSONObject.parseObject((String)targetFunc);
        boolean isAdd = funcObj.get((Object)"addMethod") != null;
        boolean isUpdate = funcObj.get((Object)"updateMethod") != null;
        boolean bl = isDelete = funcObj.get((Object)"deleteMethod") != null;
        if (isAdd) {
            result.put("addList", this.getAddList());
        } else {
            result.put("addList", new ArrayList());
        }
        if (isUpdate) {
            result.put("updateList", this.getUpdateList());
        } else {
            result.put("updateList", new ArrayList());
        }
        if (isDelete) {
            result.put("deleteList", this.getDeleteList());
        } else {
            result.put("deleteList", new ArrayList());
        }
        return result;
    }

    private List<String> getAddList() throws BOSException, SQLException {
        ProjectInfo projectInfo = this.getProjectInfo();
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo();
        Map<String, String> dataSourceResult = this.getDataSourceResult();
        ConnectionInfo conn = this.getConnectionInfo();
        SQLBuilder keyDataSql = SQLBuilder.getInstance();
        SQLBuilder.Table mainTable = keyDataSql.addATable(dataSourceInfo.getMainView());
        mainTable.addColumn(dataSourceResult.get("headpk"));
        mainTable.appendFilter(projectInfo.getSrcFilter());
        SQLBuilder.Table pkTable = keyDataSql.addATable(PKTable.getPKTable(dataSourceInfo.getMainView(), conn).getPkTableName(), "headpk", mainTable.getAlias(), dataSourceResult.get("headpk"));
        pkTable.appendFilter("agentId is null or (agentId = '" + conn.getId() + "' and createTime is not null)");
        IRowSet rows = DBUtils.executeQuery(conn, keyDataSql.toSql());
        ArrayList<String> addList = new ArrayList<String>();
        while (rows.next()) {
            addList.add(rows.getString(1));
        }
        SQLUtils.cleanup((ResultSet)rows);
        return addList;
    }

    private List<String> getUpdateList() throws BOSException, SQLException {
        ProjectInfo projectInfo = this.getProjectInfo();
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo();
        Map<String, String> dataSourceResult = this.getDataSourceResult();
        ConnectionInfo conn = this.getConnectionInfo();
        String changeTimeField = dataSourceResult.get("changeTimeField");
        String checkFields = dataSourceResult.get("checkFields");
        ArrayList<String> updateList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)changeTimeField)) {
            SQLBuilder keyDataSql = SQLBuilder.getInstance();
            SQLBuilder.Table mainTable = keyDataSql.addATable(dataSourceInfo.getMainView());
            mainTable.addColumn(dataSourceResult.get("headpk"));
            mainTable.appendFilter(projectInfo.getSrcFilter());
            SQLBuilder.Table pkTable = keyDataSql.addATable(PKTable.getPKTable(dataSourceInfo.getMainView(), conn).getPkTableName(), "headpk", mainTable.getAlias(), dataSourceResult.get("headpk"));
            pkTable.appendFilter("agentId = '" + conn.getId() + "' and " + mainTable.getAlias() + "." + changeTimeField + ">" + pkTable.getAlias() + ".changeTime");
            IRowSet rows = DBUtils.executeQuery(conn, keyDataSql.toSql());
            while (rows.next()) {
                updateList.add(rows.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rows);
        } else if (StringUtils.isEmpty((String)checkFields)) {
            throw new EIPException("\u672a\u914d\u7f6e\u66f4\u65b0\u5b57\u6bb5");
        }
        return updateList;
    }

    private List<String> getDeleteList() throws BOSException, SQLException {
        ProjectInfo projectInfo = this.getProjectInfo();
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo();
        Map<String, String> dataSourceResult = this.getDataSourceResult();
        ConnectionInfo conn = this.getConnectionInfo();
        SQLBuilder keyDataSql = SQLBuilder.getInstance();
        SQLBuilder.Table pkTable = keyDataSql.addATable(PKTable.getPKTable(dataSourceInfo.getMainView(), conn).getPkTableName());
        pkTable.addColumn("headpk");
        pkTable.appendFilter("agentId = '" + conn.getId() + "'");
        SQLBuilder.Table mainTable = keyDataSql.addATable(dataSourceInfo.getMainView(), dataSourceResult.get("headpk"), pkTable.getAlias(), "headpk");
        mainTable.appendFilter(projectInfo.getSrcFilter());
        mainTable.appendFilter(dataSourceResult.get("headpk") + " is null");
        IRowSet rows = DBUtils.executeQuery(conn, keyDataSql.toSql());
        ArrayList<String> deleteList = new ArrayList<String>();
        while (rows.next()) {
            deleteList.add(rows.getString(1));
        }
        SQLUtils.cleanup((ResultSet)rows);
        return deleteList;
    }
}

