/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.mapping;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.csinterface.biz.InterfaceInfo;
import com.kingdee.eas.csinterface.biz.MappingEntryCollection;
import com.kingdee.eas.csinterface.biz.MappingEntryInfo;
import com.kingdee.eas.csinterface.biz.MappingFactory;
import com.kingdee.eas.csinterface.biz.MappingInfo;
import com.kingdee.eas.csinterface.biz.MappingResultEntryInfo;
import com.kingdee.eas.csinterface.biz.MappingResultFactory;
import com.kingdee.eas.csinterface.biz.MappingResultInfo;
import com.kingdee.eas.csinterface.biz.app.ActionType;
import com.kingdee.eas.csinterface.biz.app.DataSourceType;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.exception.EIPException;
import com.kingdee.eas.csinterface.biz.handler.IAPIProcessHandler;
import com.kingdee.eas.csinterface.biz.mapping.AbstractDataMapping;
import com.kingdee.eas.csinterface.biz.mapping.IDataMapping;
import com.kingdee.eas.csinterface.biz.model.Pair;
import com.kingdee.eas.csinterface.biz.model.Params;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataMapping
extends AbstractDataMapping
implements IDataMapping {
    private MappingResultInfo mappingResultInfo;

    public DataMapping(MappingResultInfo info) {
        this.mappingResultInfo = info;
        EIPContext eipContext = EIPContext.getInstance();
        Context ctx = eipContext.getContext();
        String baseDataMappingID = this.mappingResultInfo.getMapping().getId().toString();
        MappingInfo mappingInfo = null;
        try {
            mappingInfo = MappingFactory.getLocalInstance(ctx).getMappingInfo("select name,number,dsType,conn.id,srcTable,destBaseData.queryName,destOrgField,destTable,destType,entrys.pkField,entrys.link,entrys.efField,entrys.srcField,entrys.destField where id='" + baseDataMappingID + "'");
            this.mappingResultInfo.setMapping(mappingInfo);
        }
        catch (Exception e) {
            throw new EIPException("\u3010EIP\u3011\u6620\u5c04\u5173\u7cfb\u914d\u7f6e\u67e5\u8be2\u51fa\u9519", e);
        }
        MappingEntryCollection colls = mappingInfo.getEntrys();
        ArrayList<Pair<String, String>> queryColumns = new ArrayList<Pair<String, String>>();
        ArrayList<Pair<String, String>> effectiveColumns = new ArrayList<Pair<String, String>>();
        Pair<String, String> pkColumn = null;
        boolean isAnd = true;
        for (int i = 0; i < colls.size(); ++i) {
            MappingEntryInfo entry = colls.get(i);
            if (!entry.isPkField() && !entry.isEfField()) continue;
            Pair<String, String> column = new Pair<String, String>(entry.getSrcField(), entry.getDestField());
            queryColumns.add(column);
            if (entry.isPkField()) {
                pkColumn = column;
            }
            if (!entry.isEfField()) continue;
            effectiveColumns.add(column);
            if (!"OR".equalsIgnoreCase(entry.getLink())) continue;
            isAnd = false;
        }
        mappingInfo.setIsAnd(isAnd);
        mappingInfo.setEffectiveColumns(effectiveColumns);
        mappingInfo.setPKColumn(pkColumn);
        mappingInfo.setQueryColumns(queryColumns);
    }

    @Override
    public TableData getSrcData() throws Exception {
        EIPContext eipContext = EIPContext.getInstance();
        MappingInfo mappingInfo = this.mappingResultInfo.getMapping();
        DataSourceType dsType = mappingInfo.getDsType();
        if (DataSourceType.JDBC.equals((Object)dsType)) {
            TableData tableData = super.getDataFromConn(true);
            if ("EAS WEB".equals(eipContext.get("operatorSource"))) {
                Pair<String, String> pkColumn = mappingInfo.getPKColumn();
                List<Pair<String, String>> effectiveColumns = mappingInfo.getEffectiveColumns();
                while (tableData.next()) {
                    StringBuilder srcDisplay = new StringBuilder();
                    for (int i = 0; i < effectiveColumns.size(); ++i) {
                        srcDisplay.append(tableData.getString(effectiveColumns.get(i).getK()));
                        if (i >= effectiveColumns.size() - 1) continue;
                        srcDisplay.append(";");
                    }
                    MappingResultEntryInfo entry = new MappingResultEntryInfo();
                    entry.setSrcDisplay(srcDisplay.toString());
                    entry.setSrcID(tableData.getString(pkColumn.getK()));
                    this.mappingResultInfo.getEntrys().add(entry);
                }
            }
            return tableData;
        }
        if (DataSourceType.INTERFACE.equals((Object)dsType)) {
            InterfaceInfo interfaceInfo = mappingInfo.getApi();
            if (interfaceInfo == null) {
                throw new EIPException("\u672a\u914d\u7f6e\u63a5\u53e3\u5b9e\u73b0");
            }
            String customClass = interfaceInfo.getCustomClass();
            if (StringUtils.isEmpty((String)customClass)) {
                throw new EIPException("\u672a\u914d\u7f6e\u63a5\u53e3\u5b9e\u73b0");
            }
            List<Pair<String, String>> queryColumns = mappingInfo.getQueryColumns();
            TableData tableData = new TableData();
            for (Pair<String, String> queryColumn : queryColumns) {
                tableData.addColumn(queryColumn.getK());
            }
            IAPIProcessHandler apiProcess = (IAPIProcessHandler)Class.forName(customClass).newInstance();
            Params.APIParams apiParams = new Params.APIParams(ActionType.BASEDATAMAPPING, this.mappingResultInfo.getNumber());
            apiParams.setColumns(tableData.getCloumnModels());
            List<Map<String, Object>> srcDatas = apiProcess.getSrcData(apiParams);
            int size = tableData.getCloumnModels().size();
            for (Map<String, Object> srcData : srcDatas) {
                for (int j = 0; j < size; ++j) {
                    String columnName = tableData.getColumnModel(j).getName();
                    tableData.addData(srcData.get(columnName));
                }
            }
            return tableData;
        }
        throw new EIPException("\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b:" + dsType.getAlias());
    }

    public TableData getDestData() throws Exception {
        TableData tableData = null;
        MappingInfo mappingInfo = this.mappingResultInfo.getMapping();
        BaseDataInfo baseDataInfo = mappingInfo.getDestBaseData();
        String destTable = mappingInfo.getDestTable();
        if (baseDataInfo != null) {
            tableData = super.getDataFromQuery();
        } else if (!StringUtils.isEmpty((String)destTable)) {
            tableData = super.getDataFromConn(false);
        } else {
            throw new EIPException("\u672a\u914d\u7f6e\u76ee\u6807\u7cfb\u7edf\u5bf9\u8c61");
        }
        return tableData;
    }

    @Override
    public void getMappingData() throws Exception {
        MappingInfo mappingInfo = this.mappingResultInfo.getMapping();
        EIPContext eipContext = EIPContext.getInstance();
        String operatorSource = (String)eipContext.get("operatorSource");
        eipContext.put("operatorSource", "Schdule Task");
        TableData srcData = this.getSrcData();
        eipContext.put("operatorSource", operatorSource);
        TableData destData = this.getDestData();
        boolean isAnd = mappingInfo.isIsAnd();
        List<Pair<String, String>> effectiveColumns = mappingInfo.getEffectiveColumns();
        Pair<String, String> pkColumn = mappingInfo.getPKColumn();
        while (srcData.next()) {
            boolean flag = false;
            while (destData.next()) {
                int i;
                StringBuilder s1 = new StringBuilder();
                StringBuilder s2 = new StringBuilder();
                if (isAnd) {
                    for (i = 0; i < effectiveColumns.size(); ++i) {
                        s1.append(srcData.getString(effectiveColumns.get(i).getK()));
                        s2.append(destData.getString(effectiveColumns.get(i).getV()));
                        if (i >= effectiveColumns.size() - 1) continue;
                        s1.append(";");
                        s2.append(";");
                    }
                    if (StringUtils.equals((String)s1.toString(), (String)s2.toString())) {
                        MappingResultEntryInfo entry = new MappingResultEntryInfo();
                        entry.setSrcDisplay(s1.toString());
                        entry.setSrcID(srcData.getString(pkColumn.getK()));
                        entry.setDestDisplay(s2.toString());
                        entry.setDestID(destData.getString(pkColumn.getV()));
                        this.mappingResultInfo.getEntrys().add(entry);
                        flag = true;
                    }
                } else {
                    for (i = 0; i < effectiveColumns.size(); ++i) {
                        String s = srcData.getString(effectiveColumns.get(i).getK());
                        String d = destData.getString(effectiveColumns.get(i).getV());
                        s1.append(s);
                        s2.append(d);
                        if (StringUtils.equals((String)s, (String)d)) {
                            MappingResultEntryInfo entry = new MappingResultEntryInfo();
                            entry.setSrcDisplay(s1.toString());
                            entry.setSrcID(srcData.getString(pkColumn.getK()));
                            entry.setDestDisplay(s2.toString());
                            entry.setDestID(destData.getString(pkColumn.getV()));
                            this.mappingResultInfo.getEntrys().add(entry);
                            flag = true;
                            break;
                        }
                        if (i >= effectiveColumns.size() - 1) continue;
                        s1.append(";");
                        s2.append(";");
                    }
                }
                if (!flag) continue;
                break;
            }
            destData.reset();
        }
        if ("Schdule Task".equals(operatorSource)) {
            MappingResultFactory.getLocalInstance(eipContext.getContext()).update((IObjectPK)new ObjectUuidPK(this.mappingResultInfo.getId()), (CoreBaseInfo)this.mappingResultInfo);
        }
    }

    @Override
    public void setMappingResult(MappingResultInfo info) {
        this.mappingResultInfo = info;
    }

    @Override
    public MappingResultInfo getMappingResult() {
        return this.mappingResultInfo;
    }
}

