/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.bizbill.metadata.utils;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.util.StringUtils;

public class SqlBuilder {
    private SqlBuilder() {
    }

    public static String buildTableSql(DataTableInfo table) {
        StringBuffer sb = new StringBuffer();
        if (table != null) {
            sb.append("IF Not Exists(Select * From KSQL_USERTABLES Where KSQL_TABNAME = '" + table.getRealName() + "') \n");
            sb.append(" CREATE Table " + table.getRealName() + " (");
            for (int i = 0; i < table.getColumns().size(); ++i) {
                sb.append(DBUtils.getColSQL(table.getColumns().get(i)) + ",");
            }
            String pkname = SqlBuilder.truncateName(table.getPrimaryKey().getRealName());
            for (int i = 0; i < table.getPrimaryKey().getPKColumns().size(); ++i) {
                ColumnInfo col = table.getPrimaryKey().getPKColumns().get(i).getColumn();
                sb.append(" CONSTRAINT " + pkname + " PRIMARY KEY (" + col.getRealName() + ")");
            }
            String sql = sb.toString().trim();
            if (sql.endsWith(",")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            sql = sql + ");";
            return sql;
        }
        return "";
    }

    public static String buildUniqueIndexSql(EntityObjectInfo entityInfo, PropertyInfo pInfo) {
        DataTableInfo table = entityInfo.getTable();
        ColumnInfo column = pInfo.getMappingField();
        StringBuffer sql = new StringBuffer();
        if (column != null) {
            sql.append("create unique index IDX_EIP_" + entityInfo.getType().toString());
            sql.append(" on " + table.getRealName() + "(" + column.getRealName() + ")");
        }
        return sql.toString();
    }

    public static String buildIndexSql(EntityObjectInfo entityInfo, PropertyInfo pInfo) {
        DataTableInfo table = entityInfo.getTable();
        ColumnInfo column = pInfo.getMappingField();
        StringBuffer sql = new StringBuffer();
        if (column != null) {
            sql.append("create index IDX_EIP_" + entityInfo.getType().toString() + "_" + column.getRealName());
            sql.append(" on " + table.getRealName() + "(" + column.getRealName() + ")");
        }
        return sql.toString();
    }

    public static String buildCombineIndexSql(EntityObjectInfo entityInfo, PropertyInfo pInfo, PropertyInfo pCombineInfo) {
        DataTableInfo table = entityInfo.getTable();
        ColumnInfo column = pInfo.getMappingField();
        ColumnInfo combineColumn = pCombineInfo.getMappingField();
        StringBuffer sql = new StringBuffer();
        if (column != null) {
            String str = column.getRealName() + combineColumn.getRealName();
            sql.append("create index IDX_EIP_" + entityInfo.getType().toString() + "_" + str.hashCode() + "");
            sql.append(" on " + table.getRealName() + "(" + column.getRealName() + "," + combineColumn.getRealName() + ")");
        }
        return sql.toString();
    }

    public static final String generateIndexName(String tablName, String columnName) {
        String sPreFix = "IDX_EIP_";
        tablName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)tablName), (int)4);
        columnName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)columnName), (int)5);
        return sPreFix + tablName + "_" + columnName;
    }

    public static String buildColumnSql(AbstractTableInfo table, ColumnInfo column) {
        StringBuffer sql = new StringBuffer();
        if (column != null) {
            sql.append("IF Not Exists(Select * From KSQL_USERCOLUMNS Where KSQL_COL_TABNAME='" + table.getRealName() + "' AND KSQL_COL_NAME='" + column.getRealName() + "') \n");
            sql.append(" ALTER Table " + table.getRealName());
            sql.append(" ADD " + DBUtils.getColSQL(column));
        }
        return sql.toString();
    }

    public static String buildColumnSqlInMultiLanguage(AbstractTableInfo table, ColumnInfo column, int multilanguage) {
        StringBuffer sql = new StringBuffer();
        if (column != null) {
            sql.append("IF Not Exists(Select * From KSQL_USERCOLUMNS Where KSQL_COL_TABNAME='" + table.getRealName() + "' AND KSQL_COL_NAME='" + column.getRealName() + "_l" + multilanguage + "') \n");
            sql.append(" ALTER Table " + table.getRealName());
            sql.append(" ADD " + DBUtils.getColSQLInMultiLanguage(column, multilanguage));
        }
        return sql.toString();
    }

    private static String truncateName(String name) {
        String newName = name;
        if (name.length() > 18) {
            newName = name.substring(0, 18);
        }
        return newName;
    }
}

