/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.client;

import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.BalanceFunEnum;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.PeriodTransFacadeFactory;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BalanceRepairUtil {
    private static final Logger logger = Logger.getLogger(BalanceRepairUtil.class);

    public static void repair(String companyLongNumber, String accountNumber, KDTextArea taInfo) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct \n");
        sql.append("    c.FID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("where c.FIsBizUnit = 1 \n");
        sql.append("    and sc.FIsStart = 1 and sc.FCurrentPeriodID is not null \n");
        sql.append("    and s.FName = 6 \n");
        if (companyLongNumber != null) {
            sql.append("    and c.FLongNumber like '" + companyLongNumber + "%' \n");
        }
        sql.append("\n");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        int count = 0;
        while (rs.next()) {
            String companyId = rs.getString("FID");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyId));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            selector.add("accountTable.id");
            selector.add("accountTable.number");
            selector.add("accountTable.name");
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
            String msg = company.getName() + "(" + company.getNumber() + ")[" + count++ + "/" + rs.size() + "]";
            taInfo.setText(taInfo.getText() + "\u6b63\u5728\u5904\u7406 " + msg + " ...");
            String result = BalanceRepairUtil.repair(company, accountNumber);
            taInfo.setText(taInfo.getText() + "\u5904\u7406\u5b8c\u6210 " + msg + " " + result);
        }
    }

    private static String repair(CompanyOrgUnitInfo company, String accountNumber) throws Exception {
        String companyId = company.getId().toString();
        String tableId = null;
        DataBaseInfo tableInfo = (DataBaseInfo)company.get("accountTable");
        if (tableInfo != null && tableInfo.getId() != null) {
            tableId = tableInfo.getId().toString();
        }
        if (tableId == null) {
            return "\u6ca1\u6709\u8bbe\u7f6e\u79d1\u76ee\u8868";
        }
        String accountId = null;
        if (accountNumber != null && accountNumber.trim().length() > 0) {
            accountNumber = accountNumber.trim();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)tableId));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            view.setSelector(selector);
            AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
            if (coll.size() > 0) {
                accountId = coll.get(0).getId().toString();
            } else {
                return "\u627e\u4e0d\u5230\u79d1\u76ee";
            }
        }
        PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo start = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        if (period == null || period.getId() == null || start == null || start.getId() == null) {
            return "\u6ca1\u6709\u671f\u95f4";
        }
        return BalanceRepairUtil.doRepair(companyId, period, start, tableId, accountId);
    }

    private static String doRepair(String companyId, PeriodInfo period, PeriodInfo start, String tableId, String accountId) throws Exception {
        GLBalanceFacadeFactory.getRemoteInstance().updateVoucherBalance(new String[]{companyId});
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("company", companyId);
        params.put("function", BalanceFunEnum.CURAMOUNT);
        params.put("periodfrom", start);
        params.put("periodto", period);
        params.put("table", tableId);
        ArrayList<String> selectedAV = new ArrayList<String>();
        if (accountId != null) {
            selectedAV.add(accountId);
        }
        params.put("selectedAV", selectedAV);
        return PeriodTransFacadeFactory.getRemoteInstance().doOK(params);
    }
}

