/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.process;

import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.DataRow;
import com.kingdee.eas.csinterface.data.model.DataTable;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.model.StructuredTableData;
import com.kingdee.eas.csinterface.data.process.IBatchProcessor;
import com.kingdee.eas.csinterface.data.process.IRowProcessor;
import java.util.List;

public class DataProcessFactory {
    public static StructuredTableData process(Context ctx, StructuredTableData structuredTableData, StructuredDataModel structuredDataModel, List rowProcessors, List batchProcessors) throws DIPException {
        StructuredDataModel.TableModel headTableModel = structuredDataModel.getPriorityTables()[0];
        DataTable headDataTable = structuredTableData.getFirstDataTable();
        List firstTableRows = headDataTable.getRows();
        int pkValueState = 0;
        Object oldPkVal = null;
        Object newPkVal = null;
        if (firstTableRows != null && rowProcessors != null && rowProcessors.size() > 0) {
            for (int i = 0; i < firstTableRows.size(); ++i) {
                DataRow dataRow = (DataRow)firstTableRows.get(i);
                if (pkValueState == 0) {
                    oldPkVal = dataRow.getValues().get(headTableModel.pkColumn.destName);
                }
                DataProcessFactory.processRow(ctx, dataRow, structuredDataModel, rowProcessors);
                if (pkValueState != 0) continue;
                newPkVal = dataRow.getValues().get(headTableModel.pkColumn.destName);
                pkValueState = oldPkVal.getClass().equals(newPkVal.getClass()) ? 1 : 2;
            }
            if (pkValueState == 2) {
                headDataTable.reorder();
            }
        }
        return DataProcessFactory.processBatch(ctx, structuredTableData, batchProcessors, structuredDataModel);
    }

    private static void processRow(Context ctx, DataRow dataRow, StructuredDataModel structuredDataModel, List rowProcessors) throws DIPException {
        if (rowProcessors == null || dataRow == null) {
            return;
        }
        for (int i = 0; i < rowProcessors.size(); ++i) {
            IRowProcessor rowProcessor = (IRowProcessor)rowProcessors.get(i);
            rowProcessor.process(ctx, dataRow, structuredDataModel);
        }
    }

    private static StructuredTableData processBatch(Context ctx, StructuredTableData structuredTableData, List batchProcessors, StructuredDataModel structuredDataModel) throws DIPException {
        if (structuredTableData == null || batchProcessors == null) {
            return structuredTableData;
        }
        if (batchProcessors != null && batchProcessors.size() > 0) {
            for (int i = 0; i < batchProcessors.size(); ++i) {
                IBatchProcessor batchProcessor = (IBatchProcessor)batchProcessors.get(i);
                structuredTableData = batchProcessor.process(ctx, structuredTableData, structuredDataModel);
            }
        }
        return structuredTableData;
    }
}

