/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.snapshot;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.snapshot.ChangefulBillData;
import com.kingdee.eas.csinterface.data.snapshot.DefaultSnapshotResultProcessor;
import com.kingdee.eas.csinterface.data.snapshot.ISnapshotResultProcessor;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Snapshot {
    private static Logger logger = Logger.getLogger(Snapshot.class);
    private static ISnapshotResultProcessor resultProcessor = new DefaultSnapshotResultProcessor();
    private static final Set<String> RUNNING_BILL_SNAPSHOT = new HashSet<String>();
    private StructuredDataModel dataModel;
    BillMappingInfo billMappingInfo;
    private Connection connection;
    private PreparedStatement queryStatement;
    private PreparedStatement updateStatement;
    private int updateHashCodeCount;
    private ResultSet resultSet;
    private boolean resetSnapshot;
    private List<Object> updatePkList = new ArrayList<Object>();
    private List<Object> deletePkList = new ArrayList<Object>();
    private int rowCount;
    private int billCount;
    private String[] sortedChanglefulFields;
    private boolean isOracle;
    private Context ctx;
    private boolean isFirst = false;
    private FileOutputStream writer = null;
    private Map handledHeakPk = new HashMap();
    private String filter;

    public Snapshot(Context ctx, BillMappingInfo billMappingInfo, boolean resetSnapshot) throws Exception {
        this.ctx = ctx;
        this.dataModel = DataModelUtil.convert(billMappingInfo);
        this.billMappingInfo = billMappingInfo;
        this.resetSnapshot = resetSnapshot;
        this.isOracle = ((ConnectionInfo)this.dataModel.getProperty("srcDBConn")).getDBType().equals((Object)DBType.Oracle);
        this.isFirst = true;
    }

    public Snapshot(Context ctx, BillMappingInfo billMappingInfo, boolean resetSnapshot, String filter) throws Exception {
        this.ctx = ctx;
        this.dataModel = DataModelUtil.convert(billMappingInfo);
        this.billMappingInfo = billMappingInfo;
        this.resetSnapshot = resetSnapshot;
        this.isOracle = ((ConnectionInfo)this.dataModel.getProperty("srcDBConn")).getDBType().equals((Object)DBType.Oracle);
        this.filter = filter;
        this.isFirst = true;
    }

    public static void setChangeResultProcessor(ISnapshotResultProcessor _resultProcessor) {
        resultProcessor = _resultProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startSnapShot() {
        String billNumber = this.billMappingInfo.getNumber();
        Set<String> set = RUNNING_BILL_SNAPSHOT;
        synchronized (set) {
            if (RUNNING_BILL_SNAPSHOT.contains(billNumber)) {
                logger.info((Object)("check data change of " + this.billMappingInfo.getNumber() + " is now running, snapshot return."));
                return;
            }
            RUNNING_BILL_SNAPSHOT.add(billNumber);
        }
        long t = System.currentTimeMillis();
        try {
            String[] headPks;
            logger.info((Object)("checking data change of " + this.billMappingInfo.getNumber() + "...."));
            this.open();
            ChangefulBillData.addHashCodeColumnIfNeed(this.connection, this.billMappingInfo.getPkTableName());
            this.snapshot();
            if (this.resetSnapshot) {
                this.commitUpdate();
            }
            this.postProcessSnapshotResult(System.currentTimeMillis() - t);
            if (!this.resetSnapshot) {
                this.commitUpdate();
            }
            if (this.handledHeakPk.get("handledPK") != null) {
                for (String pk : headPks = (String[])this.handledHeakPk.get("handledPK")) {
                    this.updateHashCode(pk);
                }
                this.commitUpdate();
            }
            this.close();
            headPks = RUNNING_BILL_SNAPSHOT;
        }
        catch (Exception e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                logger.error((Object)"roll back exception", (Throwable)e1);
            }
            logger.error((Object)e);
            return;
        }
        finally {
            this.close();
            Set<String> set2 = RUNNING_BILL_SNAPSHOT;
            synchronized (set2) {
                RUNNING_BILL_SNAPSHOT.remove(billNumber);
            }
            logger.info((Object)("check over, total used time : " + (System.currentTimeMillis() - t) + " ms"));
        }
        synchronized (RUNNING_BILL_SNAPSHOT) {
            RUNNING_BILL_SNAPSHOT.remove(billNumber);
            // ** MonitorExit[headPks] (shouldn't be in output)
            logger.info((Object)("check over, total used time : " + (System.currentTimeMillis() - t) + " ms"));
            return;
        }
    }

    void snapshot() throws Exception {
        Object[] sortedChanglefulFields = ChangefulBillData.getSortedChangefulFields(this.dataModel);
        this.sortedChanglefulFields = sortedChanglefulFields;
        logger.info((Object)("check bill data '" + this.billMappingInfo.getNumber() + "' change use fields : [" + StringUtils.arrayToString((Object[])sortedChanglefulFields, (String)", ") + "]"));
        String queryString = this.getQueryString();
        this.queryStatement = this.connection.prepareStatement(queryString, 1003, 1007);
        this.queryStatement.setFetchSize(500);
        this.updateStatement = this.connection.prepareStatement(this.getUpdateString());
        this.resultSet = this.queryStatement.executeQuery();
        Object lastHeadpkVal = null;
        ChangefulBillData changefulBillData = null;
        long t = System.currentTimeMillis();
        int rowCount = 0;
        int billCount = 0;
        try {
            while (this.resultSet.next()) {
                Object headpkValOfPkTable = this.resultSet.getObject("headpk");
                if (headpkValOfPkTable == null) {
                    throw new NullPointerException("headpk column value is null!");
                }
                ++rowCount;
                if (!headpkValOfPkTable.equals(lastHeadpkVal)) {
                    if (changefulBillData != null) {
                        ++billCount;
                        this.processSnapshot(changefulBillData);
                    }
                    lastHeadpkVal = headpkValOfPkTable;
                    changefulBillData = new ChangefulBillData((String[])sortedChanglefulFields, this.isOracle, this.billMappingInfo.isNeedResetSnapshot(), this.billMappingInfo.getExtendedProperty("oldChangefulFields"));
                }
                if (changefulBillData != null) {
                    changefulBillData.appendFieldBytes(this.resultSet);
                }
                if (rowCount % 10000 != 0) continue;
                logger.info((Object)("snapshotted " + rowCount + " rows, elapsed " + (System.currentTimeMillis() - t) + " ms"));
            }
            if (changefulBillData != null) {
                ++billCount;
                this.processSnapshot(changefulBillData);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.rowCount = rowCount;
        this.billCount = billCount;
        t = System.currentTimeMillis() - t;
        logger.info((Object)("snapshot " + rowCount + " rows bill data from viewer where headpk in pkTable total used time : " + t + " ms"));
    }

    private void processSnapshot(ChangefulBillData changefulBillData) throws SQLException {
        changefulBillData.snapshot();
        if (this.resetSnapshot) {
            if (changefulBillData.isSnapShotUpdate()) {
                this.updateHashCode(changefulBillData);
            }
        } else if (changefulBillData.isNewHash()) {
            this.updateHashCode(changefulBillData);
        } else if (changefulBillData.isUpdate()) {
            this.updateHashCode(changefulBillData);
            this.updatePkList.add(changefulBillData.getHeadpkOfPkTable());
        } else if (changefulBillData.isDelete()) {
            this.deletePkList.add(changefulBillData.getHeadpkOfPkTable());
        }
    }

    private void updateHashCode(ChangefulBillData changefulBillData) throws SQLException {
        ++this.updateHashCodeCount;
        this.updateStatement.setString(1, changefulBillData.getNewHashCode());
        this.updateStatement.setObject(2, changefulBillData.getHeadpkOfPkTable());
        this.updateStatement.addBatch();
        if (this.updateHashCodeCount % 5000 == 0) {
            this.updateStatement.executeBatch();
            this.updateStatement.clearBatch();
        }
    }

    private void updateHashCode(String headPK) throws SQLException {
        this.updateStatement.setString(1, "-1");
        this.updateStatement.setObject(2, headPK);
        this.updateStatement.addBatch();
    }

    private void commitUpdate() throws SQLException {
        this.updateStatement.executeBatch();
    }

    void postProcessSnapshotResult(long snapshotTime) throws Exception {
        if (this.resetSnapshot) {
            resultProcessor.processResetSnapshotResult(this.ctx, this.billMappingInfo.getNumber(), String.valueOf(this.billMappingInfo.getLastUpdateTime().getTime()), StringUtils.arrayToString((Object[])this.sortedChanglefulFields, (String)","), snapshotTime, this.rowCount, this.billCount);
        } else {
            logger.info((Object)("check bill data '" + this.billMappingInfo.getNumber() + "' change result : update bill count " + this.updatePkList.size() + ", delete bill count " + this.deletePkList.size() + "."));
            resultProcessor.processResult(this.ctx, this.billMappingInfo.getNumber(), String.valueOf(this.billMappingInfo.getLastUpdateTime().getTime()), StringUtils.arrayToString((Object[])this.sortedChanglefulFields, (String)","), snapshotTime, this.rowCount, this.billCount, this.updatePkList, this.deletePkList, this.handledHeakPk);
        }
    }

    private String getUpdateString() throws Exception {
        String name = this.connection.getMetaData().getDatabaseProductName();
        String pkTableName = this.billMappingInfo.getPkTableName();
        if ("PostgreSQL".equalsIgnoreCase(name)) {
            pkTableName = pkTableName.replace("\"", "");
        }
        return "update " + pkTableName + " set " + "hashCode" + " = ?" + " where " + "headpk" + " = ?";
    }

    private String getQueryString() throws Exception {
        String oldFields;
        int i;
        String name = this.connection.getMetaData().getDatabaseProductName();
        String pkTableName = this.billMappingInfo.getPkTableName();
        if ("PostgreSQL".equalsIgnoreCase(name)) {
            pkTableName = pkTableName.replace("\"", "");
        }
        StringBuilder realDeletesQL = new StringBuilder();
        Boolean hasAllView = false;
        if (this.checkHasAllView().booleanValue()) {
            hasAllView = true;
            realDeletesQL.append(" (select p.").append("headpk").append(" from ").append(pkTableName).append(" as p where not exists (").append("select 1 from ").append(this.billMappingInfo.getSrcViewName().concat("_all")).append(" where ").append("headpk").append("=").append(" p.").append("headpk").append("))");
        }
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        StringBuilder sqlBuf = new StringBuilder();
        sqlBuf.append("select * from (");
        sqlBuf.append("select distinct ");
        String headPkName = null;
        String entryPkName = null;
        sqlBuf.append("p.").append("headpk");
        sqlBuf.append(", p.").append("hashCode").append(" as ").append("pktablehashcode");
        HashSet<String> selectField = new HashSet<String>();
        for (i = 0; i < header.columns.length; ++i) {
            if (header.columns[i].isPk) {
                headPkName = header.columns[i].name;
                selectField.add(header.columns[i].name.toUpperCase());
                sqlBuf.append(", v1.").append(header.columns[i].name).append(" as ").append("viewheadpk");
                continue;
            }
            if (!header.columns[i].isChangeful) continue;
            selectField.add(header.columns[i].name.toUpperCase());
            sqlBuf.append(", v1.").append(header.columns[i].name);
        }
        for (i = 0; i < entry.columns.length; ++i) {
            if (entry.columns[i].isPk) {
                entryPkName = entry.columns[i].name;
                selectField.add(entry.columns[i].name.toUpperCase());
            }
            if (!entry.columns[i].isChangeful) continue;
            selectField.add(entry.columns[i].name.toUpperCase());
            sqlBuf.append(", v1.").append(entry.columns[i].name);
        }
        if (this.billMappingInfo.isNeedResetSnapshot() && (oldFields = this.billMappingInfo.getExtendedProperty("oldChangefulFields")) != null) {
            String[] fields;
            for (String field : fields = oldFields.split(",")) {
                if (selectField.contains(field.toUpperCase())) continue;
                sqlBuf.append(", v1.").append(field);
            }
        }
        StringBuilder fromWhere = new StringBuilder();
        fromWhere.append(" from ").append("( select * from ").append(this.billMappingInfo.getSrcViewName()).append(" where 1=1 ");
        String srcWhere = this.billMappingInfo.getSrcWhere();
        if (!StringUtils.isEmpty((String)srcWhere)) {
            if (StringUtils.startsWithIgnoreCase((String)srcWhere, (String)"where")) {
                srcWhere = srcWhere.replaceAll("^(?im)where", "");
            }
            if (srcWhere.matches("(?im)^and.*")) {
                fromWhere.append(" ").append(srcWhere);
            } else {
                fromWhere.append(" and ").append(srcWhere);
            }
        }
        if (!StringUtil.isEmpty((String)this.filter)) {
            fromWhere.append(" and (").append(this.filter).append(")");
        }
        fromWhere.append(") as v1 right join ").append(pkTableName).append(" as p").append(" on v1.").append(headPkName).append(" = p.").append("headpk");
        sqlBuf.append((CharSequence)fromWhere);
        if (hasAllView.booleanValue()) {
            String oldFields2;
            int i2;
            sqlBuf.append(" where v1.").append(headPkName).append(" is not null ").append(" and v1.").append(headPkName).append(" not in ").append((CharSequence)realDeletesQL);
            sqlBuf.append(" union ");
            sqlBuf.append("select ");
            sqlBuf.append("p.").append("headpk");
            sqlBuf.append(", p.").append("hashCode").append(" as ").append("pktablehashcode");
            for (i2 = 0; i2 < header.columns.length; ++i2) {
                if (header.columns[i2].isPk) {
                    headPkName = header.columns[i2].name;
                    selectField.add(header.columns[i2].name.toUpperCase());
                    sqlBuf.append(", v1.").append(header.columns[i2].name).append(" as ").append("viewheadpk");
                    continue;
                }
                if (!header.columns[i2].isChangeful) continue;
                selectField.add(header.columns[i2].name.toUpperCase());
                sqlBuf.append(", v1.").append(header.columns[i2].name);
            }
            for (i2 = 0; i2 < entry.columns.length; ++i2) {
                if (entry.columns[i2].isPk) {
                    entryPkName = entry.columns[i2].name;
                    selectField.add(entry.columns[i2].name.toUpperCase());
                }
                if (!entry.columns[i2].isChangeful) continue;
                selectField.add(entry.columns[i2].name.toUpperCase());
                sqlBuf.append(", v1.").append(entry.columns[i2].name);
            }
            if (this.billMappingInfo.isNeedResetSnapshot() && (oldFields2 = this.billMappingInfo.getExtendedProperty("oldChangefulFields")) != null) {
                String[] fields;
                for (String field : fields = oldFields2.split(",")) {
                    if (selectField.contains(field.toUpperCase())) continue;
                    sqlBuf.append(", v1.").append(field);
                }
            }
            sqlBuf.append((CharSequence)fromWhere).append(" where ").append("p.").append("headpk").append(" in ").append((CharSequence)realDeletesQL);
        }
        sqlBuf.append(" ) r");
        sqlBuf.append(" order by ").append("r.").append("headpk").append(", r.").append(entryPkName).append(" asc");
        return sqlBuf.toString();
    }

    private Boolean checkHasAllView() throws Exception {
        String allView = this.billMappingInfo.getSrcViewName().concat("_all");
        String viewExistsSql = "select * from KSQL_USERTABLES where KSQL_TABNAME ='" + allView + "'";
        String translatedSql = null;
        int dbType = 0;
        if (DBUtil.isOracle((Connection)this.connection)) {
            dbType = 2;
        } else if (DBUtil.isDB2((Connection)this.connection)) {
            dbType = 1;
        } else if (DBUtil.isMSSQL((Connection)this.connection)) {
            dbType = 3;
        } else if (this.connection.getMetaData().getDatabaseProductName().equals("PostgreSQL")) {
            dbType = 5;
        }
        if ("mysql".equalsIgnoreCase(this.connection.getMetaData().getDatabaseProductName())) {
            dbType = 6;
        }
        translatedSql = TransUtil.Translate((String)viewExistsSql, (int)dbType);
        this.queryStatement = this.connection.prepareStatement(translatedSql, 1003, 1007);
        ResultSet result = this.queryStatement.executeQuery();
        if (result != null && result.next()) {
            return true;
        }
        return false;
    }

    void open() throws Exception {
        try {
            ConnectionInfo connectionInfo = (ConnectionInfo)this.dataModel.getProperty("srcDBConn");
            this.connection = KSQLUtil.getConnection(connectionInfo);
            this.connection.setAutoCommit(true);
        }
        catch (Exception e) {
            throw new Exception("\u6253\u5f00\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e.getMessage(), e);
        }
    }

    void close() {
        SQLUtils.cleanup((Statement)this.updateStatement);
        SQLUtils.cleanup((ResultSet)this.resultSet, (Statement)this.queryStatement, (Connection)this.connection);
    }

    private void recordChangeFulField(ChangefulBillData changefulBillData, String status) {
        try {
            StringBuffer changeFieldsBuffer = new StringBuffer();
            if (this.isFirst) {
                this.isFirst = false;
                try {
                    this.writer = new FileOutputStream(Snapshot.getFile(), true);
                    this.recordBillMappingInfo();
                    String[] sortedChanglefulFields = ChangefulBillData.getSortedChangefulFields(this.dataModel);
                    changeFieldsBuffer.append("status\t");
                    for (int i = 0; i < sortedChanglefulFields.length; ++i) {
                        changeFieldsBuffer.append(sortedChanglefulFields[i] + "\t");
                    }
                    changeFieldsBuffer.append("\r\n");
                    this.writer.write(changeFieldsBuffer.toString().getBytes());
                }
                catch (FileNotFoundException sortedChanglefulFields) {
                    // empty catch block
                }
            }
            String rowInfo = "odlHashCode:" + changefulBillData.getOldHashCode() + ";newHashCode:" + changefulBillData.getNewHashCode() + ";" + status + changefulBillData.getNewFieldValues() + "\r\n";
            this.writer.write(rowInfo.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recordDeleteField(ChangefulBillData changefulBillData, String status, String deleteId) {
        try {
            if (this.isFirst) {
                this.isFirst = false;
                try {
                    StringBuffer changeFieldsBuffer = new StringBuffer();
                    this.writer = new FileOutputStream(Snapshot.getFile(), true);
                    this.recordBillMappingInfo();
                    String[] sortedChanglefulFields = ChangefulBillData.getSortedChangefulFields(this.dataModel);
                    changeFieldsBuffer.append("status\t");
                    for (int i = 0; i < sortedChanglefulFields.length; ++i) {
                        changeFieldsBuffer.append(sortedChanglefulFields[i] + "\t");
                    }
                    changeFieldsBuffer.append("\r\n");
                    this.writer.write(changeFieldsBuffer.toString().getBytes());
                }
                catch (FileNotFoundException changeFieldsBuffer) {
                    // empty catch block
                }
            }
            String rowInfo = status + "\theadpk\t" + deleteId + "\r\n";
            this.writer.write(rowInfo.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recordBillMappingInfo() {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            StringBuffer billInfo = new StringBuffer();
            billInfo.append("\r\n");
            billInfo.append("------------------------------------------\r\n");
            billInfo.append("executeTime\t");
            billInfo.append("number\t");
            billInfo.append("pkTable\t");
            billInfo.append("viewName\t");
            billInfo.append("version\t");
            billInfo.append("\r\n");
            billInfo.append(format.format(new Date()) + "\t");
            billInfo.append(this.billMappingInfo.getNumber() + "\t");
            billInfo.append(this.billMappingInfo.getPkTableName() + "\t");
            billInfo.append(this.billMappingInfo.getSrcViewName() + "\t");
            billInfo.append(format.format(new Date(this.billMappingInfo.getLastUpdateTime().getTime())) + "\t");
            billInfo.append("\r\n\r\n");
            this.writer.write(billInfo.toString().getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static File getFile() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String fileName = format.format(new Date()) + ".txt";
        File folder = Snapshot.getChangefulLogDir();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder, fileName);
        try {
            if (!file.exists()) {
                Snapshot.clearFiles(folder);
                file.createNewFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    private static void clearFiles(File folder) {
        try {
            File[] files = folder.listFiles();
            HashMap<String, File> fileMap = new HashMap<String, File>();
            for (File file : files) {
                if (!file.isFile()) continue;
                fileMap.put(file.getName(), file);
            }
            if (fileMap.size() > 5) {
                Object[] fileNames = fileMap.keySet().toArray(new String[0]);
                Arrays.sort(fileNames);
                for (int i = 0; i < fileNames.length - 5; ++i) {
                    File tmp = (File)fileMap.get(fileNames[i]);
                    if (!tmp.exists()) continue;
                    tmp.delete();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5220\u9664\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public static File getChangefulLogDir() {
        String logPath = System.getProperty("EAS_HOME") + File.separator + "admin" + File.separator + "logs" + File.separator + "billMappingChangeLog";
        return new File(logPath);
    }
}

