/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.DataProcessType;
import com.kingdee.eas.csinterface.billmapping.IBillMapping;
import com.kingdee.eas.csinterface.billmapping.app.util.BillMappingUtil;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DataModelUtil {
    private static final String HEAD_PK = "headPK";
    private static final String ENTRY_PK = "entryPK";

    public static StructuredDataModel convertFromBillMapping(Context ctx, String mappingStrategyId) throws BOSException, EASBizException {
        BillMappingInfo mappingStrategy = DataModelUtil.readBillMappingInfo(ctx, mappingStrategyId);
        if (mappingStrategy == null) {
            throw new BOSException("mappingStrategyId not found : " + mappingStrategyId);
        }
        try {
            return DataModelUtil.convert(mappingStrategy);
        }
        catch (DIPException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static BillMappingInfo readBillMappingInfo(Context ctx, String mappingStrategyId) throws EASBizException, BOSException {
        IObjectPK pk = CommonUtil.convert2PK(mappingStrategyId);
        IBillMapping instance = BillMappingFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = BillMappingUtil.getFullSelector();
        BillMappingInfo info = instance.getBillMappingInfo(pk, selector);
        return info;
    }

    public static final StructuredDataModel convert(BillMappingInfo mapping) throws DIPException {
        return DataModelUtil.convert(mapping, false);
    }

    public static final StructuredDataModel convert(BillMappingInfo mapping, boolean filterChangeful) throws DIPException {
        if (mapping == null) {
            throw new NullPointerException("\u6620\u5c04\u4fe1\u606f\u4e3a\u7a7a!");
        }
        ArrayList<StructuredDataModel.ColumnModel> headerColumns = new ArrayList<StructuredDataModel.ColumnModel>();
        ArrayList<StructuredDataModel.ColumnModel> entryColumns = new ArrayList<StructuredDataModel.ColumnModel>();
        BillMappingEntryCollection cols = mapping.getEntrys();
        Iterator itr = cols.iterator();
        while (itr.hasNext()) {
            BillMappingEntryInfo fieldMapping = (BillMappingEntryInfo)itr.next();
            if (fieldMapping.isDropped()) continue;
            String sqlTypeName = fieldMapping.getMidFieldDataType();
            SQLType sqlType = SQLType.getEnum((String)sqlTypeName);
            boolean isPK = DataModelUtil.isPK(fieldMapping);
            StructuredDataModel.ColumnModel column = new StructuredDataModel.ColumnModel(fieldMapping.getSrcFieldName(), fieldMapping.getSrcFieldAlias(), fieldMapping.getMidFieldName(), fieldMapping.getMidFieldAlias(), sqlType, isPK, fieldMapping.getBaseDataType(), fieldMapping.isChangeful());
            if (fieldMapping.isHead()) {
                if (filterChangeful) {
                    if (!fieldMapping.isChangeful()) continue;
                    headerColumns.add(column);
                    continue;
                }
                headerColumns.add(column);
                continue;
            }
            if (filterChangeful) {
                if (!fieldMapping.isChangeful()) continue;
                entryColumns.add(column);
                continue;
            }
            entryColumns.add(column);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mapping", mapping);
        properties.put("number", mapping.getNumber());
        properties.put("mappingType", (Object)mapping.getMappingType());
        properties.put("srcWhere", mapping.getSrcWhere());
        properties.put("srcViewName", mapping.getSrcViewName());
        properties.put("srcDBConn", mapping.getSrcDBConn());
        properties.put("pkTableName", mapping.getPkTableName());
        properties.put("billMappingID", mapping.getId().toString());
        properties.put("notCheckBaseData", mapping.isNotCheckBaseData());
        DataProcessType dataProcessType = mapping.getDataProcessType();
        properties.put("dataProcessType", dataProcessType == null ? null : dataProcessType.getValue());
        properties.put("isIntegrateEasAssAcc", mapping.isIntegrateEasAssAcc());
        properties.put("assistAccountRelation", mapping.getAssistAccountRelation());
        properties.put("assistAccountType", mapping.getAssistAccountType());
        properties.put("easCashFlowRelation", mapping.getEasCashFlowRelation());
        properties.put("isIntegrateEasCashFlow", mapping.isIntergrateEASCashFlow());
        properties.put("company", mapping.getCompany());
        properties.put("companyField", mapping.getCompanyField());
        properties.put("autoMatch", mapping.getAutoMatch());
        properties.put("reportGroup", mapping.getAsstNumber());
        properties.put("reportSupportClass", mapping.getBizClass());
        properties.put("feedBackEnable", mapping.isFeedbackEnable());
        if (mapping.isFeedbackEnable()) {
            properties.put("feedBackCondition", mapping.getFeedback().getCondition());
            properties.put("feedBackConnID", mapping.getSrcDBConn().getId().toString());
            properties.put("feedBackBillMapping", mapping);
            properties.put("feedBackBillMappingID", mapping.getId().toString());
            properties.put("feedBackBillMappingNumber", mapping.getNumber());
        }
        StructuredDataModel.TableModel header = new StructuredDataModel.TableModel("header", headerColumns.toArray(new StructuredDataModel.ColumnModel[0]), null, null);
        StructuredDataModel.TableModel entry = new StructuredDataModel.TableModel("entry", entryColumns.toArray(new StructuredDataModel.ColumnModel[0]), null, null);
        StructuredDataModel.TableModel[] tms = new StructuredDataModel.TableModel[]{header, entry};
        StructuredDataModel structuredDataModel = new StructuredDataModel(mapping.getNumber(), mapping.getBillMappingName(), properties, tms, "headpk");
        structuredDataModel.addTableRelation(header, entry, 1);
        structuredDataModel.setCompleted();
        return structuredDataModel;
    }

    private static boolean isPK(BillMappingEntryInfo fieldMapping) {
        String name = fieldMapping.getSrcFieldName();
        if (fieldMapping.isHead()) {
            return HEAD_PK.equalsIgnoreCase(name);
        }
        return ENTRY_PK.equalsIgnoreCase(name);
    }
}

