/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.eipserviceplugin.execute;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.async.app.task.AsyncOrderTaskUtil;
import com.kingdee.eas.csinterface.eipserviceplugin.util.cache.ClusterClearAdaotirCacheUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.IERPLoginUtil;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.ISCAPIUtil;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.model.FieldDefineModel;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.model.ISCConnectModel;
import com.kingdee.eas.csinterface.webservice.framework.ServiceURLUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class IERPHttpClient {
    private static final Logger logger = Logger.getLogger(IERPHttpClient.class);

    protected static FieldDefineModel getPKField(Context ctx, WSServiceInfo serviceInfo, String solution) throws BOSException {
        FieldDefineModel fieldModel = null;
        HashSet<String> pkFields = new HashSet<String>();
        try {
            String url = serviceInfo.getServiceURL();
            ISCConnectModel model = new ISCConnectModel();
            model.setSolution(solution);
            model.setAction("getpkfield");
            model.setAccess(serviceInfo.getIdentification());
            model.setData((Object)"");
            String bodyStr = JSONObject.toJSONString((Object)model);
            Map resultMap = ISCAPIUtil.doPost((Context)ctx, (String)url, (WSServiceInfo)serviceInfo, null, (String)bodyStr, (boolean)true, Map.class, null);
            Boolean isSuccess = Boolean.valueOf(resultMap.get("success").toString());
            if (isSuccess.booleanValue()) {
                fieldModel = new FieldDefineModel();
                Map fieldMap = (Map)JSONObject.parseObject((String)resultMap.get("data").toString(), Map.class);
                JSONArray headfields = (JSONArray)fieldMap.get("head");
                JSONObject fieldObj = headfields.getJSONObject(0);
                if (fieldObj != null) {
                    pkFields.add(fieldObj.getString("field"));
                }
                fieldModel.setBosType(fieldMap.get("bostype") + "");
            }
        }
        catch (Throwable e) {
            logger.error((Object)("\u83b7\u53d6\u65b9\u6848\u4e3b\u952e\u5b57\u6bb5\u5b9a\u4e49\u5931\u8d25(" + solution + ")" + ThrowableHelper.toString(e)));
            pkFields.add("id");
        }
        if (fieldModel != null) {
            fieldModel.setFields(pkFields);
        }
        return fieldModel;
    }

    public static FieldDefineModel getFieldDefine(Context ctx, WSServiceInfo serviceInfo, String solution) throws BOSException {
        FieldDefineModel fieldModel = null;
        String url = serviceInfo.getServiceURL();
        ISCConnectModel model = new ISCConnectModel();
        model.setSolution(solution);
        model.setAction("getdefine");
        model.setAccess(serviceInfo.getIdentification());
        model.setData((Object)"");
        String bodyStr = JSONObject.toJSONString((Object)model);
        Map resultMap = ISCAPIUtil.doPost((Context)ctx, (String)url, (WSServiceInfo)serviceInfo, null, (String)bodyStr, (boolean)true, Map.class, null);
        Boolean isSuccess = Boolean.valueOf(resultMap.get("success").toString());
        if (!isSuccess.booleanValue()) {
            if (resultMap.get("message") != null) {
                throw new BOSException(resultMap.get("message").toString());
            }
            throw new BOSException(JSONObject.toJSONString((Object)resultMap));
        }
        HashSet<String> fields = new HashSet<String>();
        if (isSuccess.booleanValue()) {
            fieldModel = new FieldDefineModel();
            Map fieldMap = (Map)JSONObject.parseObject((String)resultMap.get("data").toString(), Map.class);
            for (String key : fieldMap.keySet()) {
                JSONObject field;
                int i;
                int j;
                JSONArray headfields;
                if (StringUtils.equalsIgnoreCase((String)"bostype", (String)key)) continue;
                if (StringUtils.equalsIgnoreCase((String)"head", (String)key)) {
                    headfields = (JSONArray)fieldMap.get(key);
                    j = headfields.size();
                    for (i = 0; i < j; ++i) {
                        field = headfields.getJSONObject(i);
                        fields.add(field.getString("field"));
                    }
                    continue;
                }
                headfields = (JSONArray)fieldMap.get(key);
                j = headfields.size();
                for (i = 0; i < j; ++i) {
                    field = headfields.getJSONObject(i);
                    String fieldName = field.getString("field");
                    String[] eachField = fieldName.split(",");
                    if (eachField.length == 1) {
                        fields.add(key + "." + field.getString("field"));
                        continue;
                    }
                    for (int m = 0; m < eachField.length; ++m) {
                        fields.add(key + "." + eachField[m]);
                    }
                }
            }
            fieldModel.setBosType(fieldMap.get("bostype") + "");
            fieldModel.setFields(fields);
        }
        return fieldModel;
    }

    protected static Map post(Context ctx, WSServiceInfo serviceInfo, String action, String afterAction, String solution, String sendData, boolean isSync, String publishId) throws BOSException {
        String bodyStr;
        Map resultMap;
        Boolean isSuccess;
        String url = ServiceURLUtil.getHost(serviceInfo) + "/kapi/app/iscb/integrate";
        ISCConnectModel model = new ISCConnectModel();
        model.setSolution(solution);
        model.setAction(action);
        model.setAccess(serviceInfo.getIdentification());
        try {
            model.setData(JSONObject.parse((String)sendData));
        }
        catch (Throwable e) {
            model.setData((Object)sendData);
        }
        model.setAfterAction(afterAction);
        if (AsyncOrderTaskUtil.getCurrentTask() != null) {
            model.setTaskId(AsyncOrderTaskUtil.getCurrentTask().getId().toString());
        }
        if (!(isSuccess = Boolean.valueOf((resultMap = ISCAPIUtil.doPost((Context)ctx, (String)url, (WSServiceInfo)serviceInfo, null, (String)(bodyStr = JSONObject.toJSONString((Object)model)), (boolean)isSync, Map.class, (String)publishId)).get("success").toString())).booleanValue()) {
            throw new BOSException((Throwable)new EASBizException(new NumericExceptionSubItem("1", "EIP\u96c6\u6210\u540c\u6b65\u9519\u8bef\uff1a[" + url + "]" + resultMap.get("message"))));
        }
        return resultMap;
    }

    public static FieldDefineModel getPKFieldCache(Context ctx, WSServiceInfo serviceInfo, String solution) throws BOSException {
        String key = "pk" + IERPLoginUtil.getCacheTokenKey((Context)ctx, (WSServiceInfo)serviceInfo) + solution;
        FieldDefineModel fieldModel = ClusterClearAdaotirCacheUtil.getMainDefineCache(key);
        if (fieldModel == null) {
            fieldModel = IERPHttpClient.getPKField(ctx, serviceInfo, solution);
            if (fieldModel == null) {
                throw new BOSException("\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a:" + solution + ",\u7684\u96c6\u6210\u65b9\u6848\u3002");
            }
            ClusterClearAdaotirCacheUtil.putMainDefineCache(key, fieldModel);
        }
        return fieldModel;
    }

    public static FieldDefineModel getFieldDefineCache(Context ctx, WSServiceInfo serviceInfo, String solution) throws BOSException {
        String key = "fields" + IERPLoginUtil.getCacheTokenKey((Context)ctx, (WSServiceInfo)serviceInfo) + solution;
        FieldDefineModel fieldModel = ClusterClearAdaotirCacheUtil.getMainDefineCache(key);
        if (fieldModel == null) {
            fieldModel = IERPHttpClient.getFieldDefine(ctx, serviceInfo, solution);
            if (fieldModel == null) {
                throw new BOSException("\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a:" + solution + ",\u7684\u96c6\u6210\u65b9\u6848\u3002");
            }
            ClusterClearAdaotirCacheUtil.putMainDefineCache(key, fieldModel);
        }
        return fieldModel;
    }
}

