/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.openapi.ierp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.openapi.OpenAPIDispatcherFactory;
import com.kingdee.eas.csinterface.openapi.OpenAPIDispatcherInfo;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationCollection;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationFactory;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationInfo;
import com.kingdee.eas.csinterface.openapi.ierp.trace.impl.IerpTrace;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EIPTraceUpUtil {
    public static Boolean traceUp(String bosType, List<String> idList, List<String> entryIdList) throws BOSException, EASBizException {
        if (idList.size() == 0) {
            return false;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destEntityId", (Object)bosType));
        String idFirst = idList.get(0);
        filter.getFilterItems().add(new FilterItemInfo("destBillId", (Object)idFirst));
        view.setFilter(filter);
        OpenDataRelationCollection colls = OpenDataRelationFactory.getRemoteInstance().getOpenDataRelationCollection(view);
        if (colls.size() == 0) {
            return false;
        }
        Iterator ites = colls.iterator();
        OpenDataRelationInfo relationInfo = null;
        IerpTrace traceService = null;
        ArrayList<String> sameBill = new ArrayList<String>();
        while (ites.hasNext()) {
            relationInfo = (OpenDataRelationInfo)ites.next();
            String desBillkey = relationInfo.getSourceEntityId() + "_" + relationInfo.getSourceBillId();
            if (sameBill.contains(desBillkey)) continue;
            sameBill.add(desBillkey);
            String openId = relationInfo.getOpenService().getId().toString();
            SelectorItemCollection serverSelector = new SelectorItemCollection();
            serverSelector.add(new SelectorItemInfo("traceService.id"));
            OpenAPIDispatcherInfo dispatcher = OpenAPIDispatcherFactory.getRemoteInstance().getOpenAPIDispatcherInfo(CommonUtil.convert2PK(openId), serverSelector);
            WSServiceInfo traceInfo = dispatcher.getTraceService();
            if (traceInfo == null) {
                throw new BOSException("\u672a\u914d\u7f6e\u5bf9\u5e94\u7684\u8054\u67e5\u670d\u52a1");
            }
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("tenantId"));
            traceInfo = WSServiceFactory.getRemoteInstance().getWSServiceInfo(CommonUtil.convert2PK(traceInfo.getId().toString()), selectors);
            if (StringUtils.isEmpty((String)traceInfo.getTenantId())) continue;
            traceService = new IerpTrace();
            traceService.traceUp(relationInfo, traceInfo);
        }
        return true;
    }

    public static Boolean traceDown(String bosType, List<String> idList, List<String> entryIdList) throws BOSException, EASBizException {
        return false;
    }
}

