/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.openapi.ierp.util;

import com.kingdee.eas.cp.eip.sso.kd.ltpa.LtpaTokenManager;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.openapi.OpenAPIDispatcherFactory;
import com.kingdee.eas.csinterface.openapi.ierp.model.OpenIERPParamModel;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class OpenIERPUtil {
    private static Logger logger = Logger.getLogger(OpenIERPUtil.class);

    public static void openIerpForm(OpenIERPParamModel param) throws Exception {
        if (null == param) {
            logger.error((Object)"eas system open ierp form,param is null.");
            throw new RuntimeException("eas system open ierp form,param is null,open ierp form failed.");
        }
        String url = OpenIERPUtil.generateIerpUrl(param);
        OpenIERPUtil.openIerpUrl(url);
    }

    private static String getToken(String user) {
        if (StringUtils.isEmpty(user)) {
            logger.error((Object)"user phone is empty,get token failed.");
            throw new RuntimeException("user phone is empty,get token failed");
        }
        return LtpaTokenManager.generate((String)user);
    }

    private static String generateIerpUrl(OpenIERPParamModel param) throws Exception {
        String token = OpenAPIDispatcherFactory.getRemoteInstance().getIERPLtapToken(param.getUser());
        StringBuilder sb = new StringBuilder();
        sb.append(param.getUrl()).append("/auth/ltpaTokenLogin.do?");
        if (!StringUtils.isEmpty(param.getTenantId())) {
            sb.append("&tenantId=").append(param.getTenantId());
        }
        if (!StringUtils.isEmpty(param.getDataCenter())) {
            sb.append("&accountId=").append(param.getDataCenter());
        }
        if (!StringUtils.isEmpty(param.getUser())) {
            sb.append("&user=").append(param.getUser());
        }
        sb.append("&token=").append(token).append("&redirect=").append(param.getUrl()).append("/#/dform");
        sb.append("?app=exp");
        if (!StringUtils.isEmpty(param.getFormId())) {
            sb.append("&formId=").append(param.getFormId());
        }
        if (!StringUtils.isEmpty(param.getPkId())) {
            sb.append("&pkId=").append(param.getPkId());
        }
        return sb.toString();
    }

    private static boolean openIerpUrl(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser != null) {
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
            }
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("eas system open ierp form failed.exception info:" + ex.getMessage()));
            throw new RuntimeException("eas system open ierp form failed.exception info:" + ex.getMessage());
        }
    }

    public static void main(String[] args) {
        OpenIERPParamModel param = new OpenIERPParamModel();
        param.setUrl("http://localhost:8080/ierp");
        param.setTenantId("bos_dev_branch");
        param.setUser("17299999999");
        param.setFormId("isc_mq");
        param.setPkId("420075964219797504");
        try {
            OpenIERPUtil.openIerpForm(param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

