/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.planmanager.converter;

import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.JDomB9Utils;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class BillMappingInfoConverter
extends AbstractDataBaseInfoConverter {
    private String[] headerStrFields = new String[]{"number", "midBillEntityMetaAlias", "billMappingName", "pkTableName", "midBillTable", "billMappingDesc", "srcViewName", "midBillEntryTable", "srcWhere", "published", "dataProcessType", "cashFlowRelation", "integrateCashFlow", "assistAccountRelation", "easCashFlowRelation", "transferType", "pageSize", "mutiMapPriority", "autoMatch", "asstNumber", "bizClass", "fieldRelation", "entrySeq", "mappingType"};
    private String[] entryStrFields = new String[]{"head", "srcFieldName", "srcFieldAlias", "srcFieldDataType", "srcFieldDataLength", "srcFieldDataPrecision", "srcFieldDataScale", "midFieldName", "midFieldAlias", "midFieldDataType", "midFieldDataLength", "midFieldDataPrecision", "midFieldDataScale", "dropped", "published", "pkField", "changeful"};

    @Override
    public boolean canConvert(Class type) {
        return BillMappingInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        BillMappingInfo info = (BillMappingInfo)source;
        Element root = new Element(info.getClass().getName());
        this.marshalHeader(root, info);
        this.marshalEntrys(root, info);
        return root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        BillMappingInfo info = new BillMappingInfo();
        List children = data.getChildren();
        this.unmarshalHeader(info, children);
        this.unmarshalEntrys(info, children);
        return info;
    }

    private void marshalHeader(Element root, BillMappingInfo info) {
        for (int i = 0; i < this.headerStrFields.length; ++i) {
            this.addChild(root, this.headerStrFields[i], info.getString(this.headerStrFields[i]));
        }
        ConnectionInfo connectionInfo = info.getSrcDBConn();
        String connNum = "";
        if (null != connectionInfo) {
            String connId = connectionInfo.getId().toString();
            try {
                ConnectionInfo connection = ConnectionFactory.getRemoteInstance().getConnectionInfo(CommonUtil.convert2PK(connId));
                if (connection != null) {
                    connNum = connection.getNumber();
                }
            }
            catch (Exception e) {
                System.out.println("\u5bfc\u51fa\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u65f6\uff0c\u627e\u4e0d\u5230\u8fde\u63a5\u914d\u7f6e");
            }
        }
        this.addChild(root, "srcDBConn", connNum);
        this.addChild(root, "integrateEasAssAcc", BillMappingInfoConverter.changeBooleanToString(info.isIntegrateEasAssAcc()));
        this.addChild(root, "intergrateEASCashFlow", BillMappingInfoConverter.changeBooleanToString(info.isIntergrateEASCashFlow()));
        this.addChild(root, "srcChangeReGenerate", BillMappingInfoConverter.changeBooleanToString(info.isSrcChangeReGenerate()));
        AssistAccountTypeInfo typeInfo = info.getAssistAccountType();
        if (typeInfo != null) {
            this.addChild(root, "assistAccountTypeID", typeInfo.getId().toString());
        }
    }

    public void unmarshalHeader(BillMappingInfo info, List<Element> children) {
        for (int i = 0; i < this.headerStrFields.length; ++i) {
            info.setString(this.headerStrFields[i], this.getElementTextByName(children, this.headerStrFields[i]));
        }
        String connNum = this.getElementTextByName(children, "srcDBConn");
        try {
            ConnectionInfo connection = ConnectionFactory.getRemoteInstance().getConnectionInfo("where number='" + connNum + "'");
            if (connection != null) {
                info.setSrcDBConn(connection);
            }
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u5165\u65b9\u6848\u65f6\uff0c\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\uff08" + connNum + "\uff09\u7684\u8fde\u63a5\u914d\u7f6e");
        }
        String assistAccountTypeID = this.getElementTextByName(children, "assistAccountTypeID");
        info.put("assistAccountTypeFID_TO_BE_REPLACED", assistAccountTypeID);
        info.setPublished(false);
        info.setPkTableName(null);
        info.setIntegrateEasAssAcc(BillMappingInfoConverter.changeStringToBoolean(this.getElementTextByName(children, "integrateEasAssAcc")));
        info.setIntergrateEASCashFlow(BillMappingInfoConverter.changeStringToBoolean(this.getElementTextByName(children, "intergrateEASCashFlow")));
        info.setSrcChangeReGenerate(BillMappingInfoConverter.changeStringToBoolean(this.getElementTextByName(children, "srcChangeReGenerate")));
    }

    private void marshalEntrys(Element root, BillMappingInfo info) {
        Element entryRoot = JDomB9Utils.addChild(root, "entrys");
        Iterator iterator = info.getEntrys().iterator();
        while (iterator.hasNext()) {
            Element entry = JDomB9Utils.addChild(entryRoot, "entry");
            BillMappingEntryInfo entryInfo = (BillMappingEntryInfo)iterator.next();
            String tmpValue = "";
            for (int i = 0; i < this.entryStrFields.length; ++i) {
                tmpValue = entryInfo.getString(this.entryStrFields[i]);
                tmpValue = StringUtils.equals((String)tmpValue, (String)"true") ? "1" : tmpValue;
                tmpValue = StringUtils.equals((String)tmpValue, (String)"false") ? "0" : tmpValue;
                this.addChild(entry, this.entryStrFields[i], tmpValue);
            }
            BaseDataTypeInfo baseDataTypeInfo = entryInfo.getBaseDataType();
            if (null == baseDataTypeInfo) continue;
            this.addChild(entry, "baseDataTypeFID", baseDataTypeInfo.getId().toString());
        }
    }

    private void unmarshalEntrys(BillMappingInfo info, List<Element> children) {
        Element entryRoot = this.getElementByName(children, "entrys");
        if (null == entryRoot) {
            return;
        }
        BillMappingEntryCollection entryCollection = new BillMappingEntryCollection();
        List entryList = entryRoot.getChildren("entry");
        boolean isOldVersion = false;
        boolean swatch = true;
        for (Element entry : entryList) {
            BillMappingEntryInfo entryInfo = new BillMappingEntryInfo();
            if (swatch) {
                swatch = false;
                isOldVersion = StringUtils.isEmpty((String)this.getElementTextByName(entry, "changeful"));
            }
            for (int i = 0; i < this.entryStrFields.length; ++i) {
                String value = this.getElementTextByName(entry, this.entryStrFields[i]);
                entryInfo.setString(this.entryStrFields[i], value);
            }
            if (isOldVersion) {
                boolean isPK = StringUtils.endsWithIgnoreCase((String)"headpk", (String)this.getElementTextByName(entry, this.entryStrFields[1])) || StringUtils.endsWithIgnoreCase((String)"entrypk", (String)this.getElementTextByName(entry, this.entryStrFields[1]));
                entryInfo.setString("changeful", isPK ? "1" : "0");
                entryInfo.setString("pkfield", isPK ? "1" : "0");
            }
            entryInfo.setHead(entryInfo.getBoolean("head"));
            entryInfo.setPublished(false);
            entryInfo.setDropped(entryInfo.getBoolean("dropped"));
            String FID = this.getElementTextByName(entry, "baseDataTypeFID");
            entryInfo.put("baseDataTypeFID_TO_BE_REPLACED", FID);
            entryCollection.add(entryInfo);
        }
        info.getEntrys().addCollection(entryCollection);
    }

    public static String changeBooleanToString(Boolean value) {
        return value != false ? "1" : "0";
    }

    public static Boolean changeStringToBoolean(String value) {
        return StringUtils.equals((String)value, (String)"1");
    }
}

