/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.planmanager.download.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataUtils;
import com.kingdee.eas.csinterface.cloud.CloudParser;
import com.kingdee.eas.csinterface.cloud.DescElement;
import com.kingdee.eas.csinterface.cloud.FileElement;
import com.kingdee.eas.csinterface.cloud.SimpleJSONUtil;
import com.kingdee.eas.csinterface.planmanager.PlanManagerInfo;
import com.kingdee.eas.csinterface.planmanager.PlanManagerTreeInfo;
import com.kingdee.eas.csinterface.planmanager.PlanmanagerFacadeFactory;
import com.kingdee.eas.csinterface.planmanager.client.PlanManagerListUI;
import com.kingdee.eas.csinterface.planmanager.download.client.AbstractPlanManagerDownloadUI;
import com.kingdee.eas.csinterface.planmanager.download.client.PlanManagerDownloadFilterUI;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.PlanManagerHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PlanManagerDownloadUI
extends AbstractPlanManagerDownloadUI {
    private static final Logger logger = CoreUIObject.getLogger(PlanManagerDownloadUI.class);
    private static String uri = "";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)UIModelDialogFactory.class.getName());
        HashMap uiContext = new HashMap();
        HashMap dataObjects = new HashMap();
        IUIWindow uiWindow = uiFactory.create(PlanManagerDownloadFilterUI.class.getName(), uiContext, dataObjects);
        uiWindow.show();
        PlanManagerDownloadFilterUI filterUI = (PlanManagerDownloadFilterUI)uiWindow.getUIObject();
        if (filterUI.isOK()) {
            this.fillTable(filterUI.getFilter());
        }
    }

    @Override
    public void actionDownload_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.table.getSelectManager().getBlocks();
        if (0 == blocks.size()) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u4e2d\u9700\u8981\u4e0b\u8f7d\u7684\u65b9\u6848.");
            return;
        }
        KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
        int rowIndex = block.getTop();
        IRow row = this.table.getRow(rowIndex);
        ICell cell = row.getCell("id");
        uri = (String)cell.getValue();
        try {
            LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", "\u6b63\u5728\u4e0b\u8f7d\u65b9\u6848,\u8bf7\u7a0d\u540e...");
            dialog.setLongTimeTask(new ILongTimeTask2(){
                private Exception exception;

                @Override
                public Object exec() throws Exception {
                    try {
                        String fileContent = PlanManagerHelper.downloadFileFromURI2StrUTF8(uri);
                        if (fileContent == null || fileContent.equals("")) {
                            throw new Exception("\u6587\u4ef6\u65e0\u6548\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
                        }
                        PlanManagerInfo info = PlanManagerHelper.convertXMLToPlan(fileContent);
                        Object tree = PlanManagerDownloadUI.this.getUIContext().get("treeId");
                        if (info != null) {
                            if (tree != null) {
                                info.setTreeid((PlanManagerTreeInfo)tree);
                            }
                            PlanmanagerFacadeFactory.getRemoteInstance().saveImportPlan(info);
                        }
                        return "success";
                    }
                    catch (Exception e) {
                        this.exception = e;
                        return "fail";
                    }
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    if (null == this.exception) {
                        MsgBox.showInfo((String)"\u4e0b\u8f7d\u6210\u529f\u3002");
                        try {
                            MetadataUtils.clearClientMetadataCache();
                            PlanManagerDownloadUI.this.refreshListUI();
                        }
                        catch (Exception exception) {}
                    } else {
                        MsgBox.showInfo((String)("\u4e0b\u8f7d\u5931\u8d25\uff0c" + this.exception.getMessage()));
                    }
                }
            });
            dialog.show();
        }
        catch (Exception exception) {
            if (exception.getMessage().indexOf("FPkFieldIllegal") > -1) {
                MsgBox.showInfo((String)"\u5f53\u524d\u8981\u5f15\u5165\u7684\u96c6\u6210\u65b9\u6848\u7248\u672c\u8fc7\u4f4e\uff0c\u8bf7\u8054\u7cfb\u603b\u90e8\u6216\u4e0b\u8f7d\u65b0\u7684\u65b9\u6848\u3002");
            } else {
                MsgBox.showDetailAndOK(null, (String)"\u65b9\u6848\u4e0b\u8f7d\u529f\u80fd\u65e0\u6cd5\u6b63\u5e38\u5b8c\u6210\u3002", (String)exception.getMessage(), (int)1);
            }
            logger.error((Object)("\u539f\u6709\u7684\u201c\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u201d\u5bfc\u51fa\u90e8\u5206\u6ca1\u6709\u5bfc\u51fa\u4e3b\u952e\u548c\u68c0\u6d4b\u53d8\u5316\uff0c\u5b57\u6bb5\u7684\u503c\u7c7b\u578b\u4e5f\u4e0d\u5bf9\uff0c\u5bfc\u81f4\u5f15\u5165\u65f6\u51fa\u9519\u3002" + exception.getMessage()), (Throwable)exception);
            exception.printStackTrace();
        }
    }

    private void refreshListUI() {
        try {
            Object object = this.getUIContext().get("Owner");
            if (null != object && object instanceof PlanManagerListUI) {
                PlanManagerListUI listUI = (PlanManagerListUI)((Object)object);
                listUI.refreshList();
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5237\u65b0\u5217\u8868\u5f02\u5e38\u3002\u53c2\u8003\u539f\u56e0:" + e.getMessage()), (Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.table.checkParsed();
        this.table.getSelectManager().setSelectMode(2);
        DescElement fileter = new DescElement();
        this.fillTable(fileter);
    }

    public void fillTable(DescElement filter) throws BOSException {
        this.table.removeRows();
        this.table.setEditable(false);
        String resoureXML = null;
        try {
            resoureXML = PlanManagerHelper.queryPlanResource();
        }
        catch (Exception exception) {
            MsgBox.showDetailAndOK(null, (String)"\u65e0\u6cd5\u83b7\u5f97\u4e91\u7aef\u65b9\u6848\u3002", (String)exception.getMessage(), (int)1);
            return;
        }
        FileElement[] files = CloudParser.parseFile(resoureXML);
        for (int i = 0; i < files.length; ++i) {
            FileElement file = files[i];
            String desc = file.getDesc();
            DescElement descElement = new DescElement();
            try {
                descElement = SimpleJSONUtil.descToDescElement(desc);
                if (StringUtils.isEmpty((String)descElement.getName())) {
                    continue;
                }
            }
            catch (Throwable t) {
                MsgBox.showDetailAndOK(null, (String)"\u4e91\u7aef\u65b9\u6848\u89e3\u6790\u5931\u8d25\u3002", (String)t.getMessage(), (int)1);
                return;
            }
            if (!this.filt(filter, descElement)) continue;
            this.addRow(file.getUri(), descElement);
        }
    }

    private boolean filt(DescElement filter, DescElement descElement) {
        String name = filter.getName();
        String srcsysname = filter.getSrcsysname();
        String srcsysversion = filter.getSrcsysversion();
        String srcsycbillname = filter.getSrcsycbillname();
        String destsysname = filter.getDestsysname();
        String destsysversion = filter.getDestsysversion();
        String destsysbillname = filter.getDestsysbillname();
        String memory = filter.getMemory();
        boolean bingo = true;
        if (!StringUtils.isEmpty((String)name)) {
            bingo &= descElement.getName().indexOf(name) != -1;
        }
        if (!StringUtils.isEmpty((String)srcsysname)) {
            bingo &= descElement.getSrcsysname().indexOf(srcsysname) != -1;
        }
        if (!StringUtils.isEmpty((String)srcsysversion)) {
            bingo &= descElement.getSrcsysversion().indexOf(srcsysversion) != -1;
        }
        if (!StringUtils.isEmpty((String)srcsycbillname)) {
            bingo &= descElement.getSrcsycbillname().indexOf(srcsycbillname) != -1;
        }
        if (!StringUtils.isEmpty((String)destsysname)) {
            bingo &= descElement.getDestsysname().indexOf(destsysname) != -1;
        }
        if (!StringUtils.isEmpty((String)destsysversion)) {
            bingo &= descElement.getDestsysversion().indexOf(destsysversion) != -1;
        }
        if (!StringUtils.isEmpty((String)destsysbillname)) {
            bingo &= descElement.getDestsysbillname().indexOf(destsysbillname) != -1;
        }
        if (!StringUtils.isEmpty((String)memory)) {
            bingo &= descElement.getMemory().indexOf(memory) != -1;
        }
        return bingo;
    }

    private void addRow(String uri, DescElement descElement) {
        IRow row = this.table.addRow();
        ICell cell = row.getCell("id");
        cell.setValue((Object)uri);
        cell = row.getCell("srcsysname");
        cell.setValue((Object)descElement.getSrcsysname());
        cell = row.getCell("srcsysversion");
        cell.setValue((Object)descElement.getSrcsysversion());
        cell = row.getCell("srcsycbillname");
        cell.setValue((Object)descElement.getSrcsycbillname());
        cell = row.getCell("destsysname");
        cell.setValue((Object)descElement.getDestsysname());
        cell = row.getCell("destsysversion");
        cell.setValue((Object)descElement.getDestsysversion());
        cell = row.getCell("destsysbillname");
        cell.setValue((Object)descElement.getDestsysbillname());
        cell = row.getCell("memory");
        cell.setValue((Object)descElement.getMemory());
        cell = row.getCell("name");
        cell.setValue((Object)descElement.getName());
    }
}

