/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.planmanagergroup.download.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.csinterface.cloud.CloudParser;
import com.kingdee.eas.csinterface.cloud.DescElement;
import com.kingdee.eas.csinterface.cloud.FileElement;
import com.kingdee.eas.csinterface.cloud.SimpleJSONUtil;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupFacadeFactory;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupInfo;
import com.kingdee.eas.csinterface.planmanagergroup.download.client.AbstractPlanManagerGroupDownloadUI;
import com.kingdee.eas.csinterface.planmanagergroup.download.client.PlanManagerGroupDownloadFilterUI;
import com.kingdee.eas.csinterface.util.PlanManagerGroupHelper;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PlanManagerGroupDownloadUI
extends AbstractPlanManagerGroupDownloadUI {
    private static final Logger logger = CoreUIObject.getLogger(PlanManagerGroupDownloadUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)UIModelDialogFactory.class.getName());
        HashMap uiContext = new HashMap();
        HashMap dataObjects = new HashMap();
        IUIWindow uiWindow = uiFactory.create(PlanManagerGroupDownloadFilterUI.class.getName(), uiContext, dataObjects);
        uiWindow.show();
        PlanManagerGroupDownloadFilterUI filterUI = (PlanManagerGroupDownloadFilterUI)uiWindow.getUIObject();
        if (filterUI.isOK()) {
            this.fillTable(filterUI.getFilter());
        }
    }

    @Override
    public void actionDownload_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.table.getSelectManager().getBlocks();
        if (0 == blocks.size()) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u4e2d\u9700\u8981\u4e0b\u8f7d\u7684\u65b9\u6848\u7ec4\u5408.");
            return;
        }
        KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
        int rowIndex = block.getTop();
        IRow row = this.table.getRow(rowIndex);
        ICell cell = row.getCell("id");
        String uri = (String)cell.getValue();
        try {
            String fileContent = PlanManagerGroupHelper.downloadFileFromURI2StrUTF8(uri);
            PlanManagerGroupInfo info = PlanManagerGroupHelper.convertXMLToPlan(fileContent);
            PlanManagerGroupFacadeFactory.getRemoteInstance().saveImportPlanGroup(info);
            MsgBox.showInfo((String)"\u4e0b\u8f7d\u6210\u529f.");
        }
        catch (Exception exception) {
            MsgBox.showDetailAndOK(null, (String)"\u65b9\u6848\u7ec4\u5408\u4e0b\u8f7d\u529f\u80fd\u65e0\u6cd5\u6b63\u5e38\u5b8c\u6210\u3002", (String)exception.getMessage(), (int)1);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.table.checkParsed();
        this.table.getSelectManager().setSelectMode(2);
        DescElement fileter = new DescElement();
        this.fillTable(fileter);
    }

    public void fillTable(DescElement filter) throws BOSException {
        this.table.removeRows();
        String resoureXML = null;
        try {
            resoureXML = PlanManagerGroupHelper.queryPlanResource();
        }
        catch (Exception exception) {
            MsgBox.showDetailAndOK(null, (String)"\u65e0\u6cd5\u83b7\u5f97\u4e91\u7aef\u65b9\u6848\u7ec4\u5408\u3002", (String)exception.getMessage(), (int)1);
            return;
        }
        FileElement[] files = CloudParser.parseFile(resoureXML);
        for (int i = 0; i < files.length; ++i) {
            FileElement file = files[i];
            String desc = file.getDesc();
            DescElement descElement = new DescElement();
            try {
                descElement = SimpleJSONUtil.descToDescElement(desc);
                if (StringUtils.isEmpty((String)descElement.getName())) {
                    continue;
                }
            }
            catch (Throwable t) {
                MsgBox.showDetailAndOK(null, (String)"\u4e91\u7aef\u65b9\u6848\u7ec4\u5408\u4fe1\u606f\u89e3\u6790\u5931\u8d25\u3002", (String)t.getMessage(), (int)1);
                return;
            }
            if (!this.filt(filter, descElement)) continue;
            this.addRow(file.getUri(), descElement);
        }
    }

    private boolean filt(DescElement filter, DescElement descElement) {
        String name = filter.getName();
        String srcsysname = filter.getSrcsysname();
        String srcsysversion = filter.getSrcsysversion();
        String srcsycbillname = filter.getSrcsycbillname();
        String destsysname = filter.getDestsysname();
        String destsysversion = filter.getDestsysversion();
        String destsysbillname = filter.getDestsysbillname();
        String memory = filter.getMemory();
        boolean bingo = true;
        if (!StringUtils.isEmpty((String)name)) {
            bingo &= descElement.getName().indexOf(name) != -1;
        }
        if (!StringUtils.isEmpty((String)srcsysname)) {
            bingo &= descElement.getSrcsysname().indexOf(srcsysname) != -1;
        }
        if (!StringUtils.isEmpty((String)srcsysversion)) {
            bingo &= descElement.getSrcsysversion().indexOf(srcsysversion) != -1;
        }
        if (!StringUtils.isEmpty((String)srcsycbillname)) {
            bingo &= descElement.getSrcsycbillname().indexOf(srcsycbillname) != -1;
        }
        if (!StringUtils.isEmpty((String)destsysname)) {
            bingo &= descElement.getDestsysname().indexOf(destsysname) != -1;
        }
        if (!StringUtils.isEmpty((String)destsysversion)) {
            bingo &= descElement.getDestsysversion().indexOf(destsysversion) != -1;
        }
        if (!StringUtils.isEmpty((String)destsysbillname)) {
            bingo &= descElement.getDestsysbillname().indexOf(destsysbillname) != -1;
        }
        if (!StringUtils.isEmpty((String)memory)) {
            bingo &= descElement.getMemory().indexOf(memory) != -1;
        }
        return bingo;
    }

    private void addRow(String uri, DescElement descElement) {
        IRow row = this.table.addRow();
        ICell cell = row.getCell("id");
        cell.setValue((Object)uri);
        cell = row.getCell("srcsysname");
        cell.setValue((Object)descElement.getSrcsysname());
        cell = row.getCell("srcsysversion");
        cell.setValue((Object)descElement.getSrcsysversion());
        cell = row.getCell("srcsycbillname");
        cell.setValue((Object)descElement.getSrcsycbillname());
        cell = row.getCell("destsysname");
        cell.setValue((Object)descElement.getDestsysname());
        cell = row.getCell("destsysversion");
        cell.setValue((Object)descElement.getDestsysversion());
        cell = row.getCell("destsysbillname");
        cell.setValue((Object)descElement.getDestsysbillname());
        cell = row.getCell("memory");
        cell.setValue((Object)descElement.getMemory());
        cell = row.getCell("name");
        cell.setValue((Object)descElement.getName());
    }
}

